/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wV4T
 */

package
{
	import com.bit101.components.PushButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import frocessing.math.Random;
	import jp.progression.commands.Func;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.Prop;
	import jp.progression.commands.Wait;
	
	public class Main extends Sprite
	{
		private var data:Array;
		private var SIZE:int = 5;
		private var num:int = 80;
		private var list:SerialList = new SerialList();
		
		public function Main()
		{
			graphics.beginFill(0xF0F0F0);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			data = new Array(num);
			for (var i:int = 0; i < data.length; i++)
			{
				var rect:Rect = new Rect(SIZE);
				rect.x = i * SIZE;
				rect.y = i * SIZE;
				addChild(rect);
				data[i] = rect;
			}
			init();

			new PushButton(this, 185, 400, "execute", execute);
		}
		
		private function execute(event:Event):void
		{
			if (list.state == 2) return;
			list = new SerialList();
			
			init();
			sort();
			list.execute();
		}
		
		private function init():void
		{
			var random:Array = Random.shakedIntegers(num);
			for (var i:int = 0; i < data.length; i++)
			{
				data[i].x = random[i] * SIZE;
			}
		}
		
		private function sort():void
		{
			var copy:Array = new Array(num);
			for (var i:int = 0; i < data.length; i++)
			{
				copy[i] = data[i].x;
			}
			
			for (i = 1; i < data.length; i++)
			{
				var temp:int = copy[i];
				for (var j:int = i - 1; j >= 0 && copy[j] > temp; j--)
				{
					list.addCommand(new Func(function(j:int):void { data[j + 1].x = data[j].x; }, [j]));
					list.addCommand(new Wait(10 / 1000.0));
					copy[j + 1] = copy[j];
				}
				list.addCommand(new Func(function(j:int, temp:int):void { data[j + 1].x = temp; }, [j, temp]));
				list.addCommand(new Wait(10 / 1000.0));
				copy[j + 1] = temp;
			}
		}
	}
}

import flash.display.Sprite;
import flash.filters.DropShadowFilter;

class Rect extends Sprite
{
	public function Rect(size:int)
	{
		graphics.beginFill(0x0);
		graphics.drawRect(0, 0, size, size);
		graphics.endFill();
		
		this.filters = [new DropShadowFilter(2)];
	}
}