/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wV0x
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class Base extends Sprite
    {
        private var reviewBuffer :ReviewBuffer;
        
        public function Base()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        private function addedToStage($e:*): void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            reviewBuffer = new ReviewBuffer();
            
            init();
        }
        
        private function init() :void
        {
            addChild(reviewBuffer);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.text.*;

class ReviewBuffer extends Sprite
{
    private var bufferOutput :Output;
    
    public function ReviewBuffer()
    {
        bufferOutput = new Output("bufferOutput");
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    private function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(bufferOutput);
        
        init();
    }
    
    private function init() :void
    {
        //init review/comment object (probably a full-canvas dialog)
    }
}

class ReviewWindow extends Sprite
{
    public function ReviewWindow()
    {
        
    }
    
    private function addedToStage($e:*) :void
    {
        
    }

    private function init() :void
    {
        
    }
}

class Button extends Sprite
{
    private var _x :Number;
    private var _y :Number;
    private var _action :String;
    
    public function Button($x :Number, $y :Number, $action :String)
    {
        _x = $x;
        _y = $y;
        _action = $action;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }

    private function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
    
        //add button texture
        
        init();
    }

    private function init() :void
    {
        graphics.clear();
        graphics.lineStyle(1);
        graphics.beginFill(0xFFFFFF);
        graphics.drawRect(_x, _y, 160, 60);
        graphics.endFill();
    }
    
    private function action($action :String) :void
    {
        //parse action string, custom code struct:
        
        /*
        example = "openURL()|closeWindow()|hideButton();"
        
        $string = custom action
        |       = separator or end of action
        ;       = end of code string
        
        */
    }
    
    private function openURL($url :String) :void
    {
        
    }
    
    private function closeWindow($window :int) :void
    {
        
    }
    
    private function hideButton() :void
    {
    }
    
    private function showButton() :void
    {    
    }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
        
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 2, $y:Number = 1, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
            
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        init(); 
    }
        
    public function init() :void
    {
        x = _x;
        y = _y;
        text = _content;
            
        textFormat = new TextFormat(_font, null, 0);
        setTextFormat(textFormat);
    }   
        
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
        
    public function set font($:String) :void
    { _font = $; init() }
    public function set content($:String) :void
    { _content += ("\n> " + $); init() }
}