/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wUL1
 */

// forked from Karl94's Disk
package{
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.GraphicsPath;
    import flash.display.IGraphicsData;
    import flash.display.GraphicsSolidFill;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    public class Disk extends Sprite{
    
        private var mySound:Sound = new Sound();
        private var sound:Sound = new Sound();
        private var speed:Number = 1;
        
        private var last:Number = 0;
        
        private var disk:Shape = new Shape();
        
        private const SAMPLE_SIZE:uint = 2048;
    
        public function Disk(){
            disk.graphics.drawGraphicsData(Vector.<IGraphicsData>([
                new GraphicsSolidFill(0x000000),
                new GraphicsPath(Vector.<int>([1, 3, 3, 3, 2, 3, 3, 3,
                    1, 3, 3, 3, 2, 3, 3, 3    
                ]), Vector.<Number>([
                    Math.sin(Math.PI/4)*50, Math.sin(Math.PI/4)*50,
                    Math.tan(Math.PI/8)*50, 50, 0, 50,
                    -Math.tan(Math.PI/8)*50, 50, -Math.sin(Math.PI/4)*50, Math.sin(Math.PI/4)*50,
                    -50, Math.tan(Math.PI/8)*50, -50, 0,
                    -10, 0,
                    -10, Math.tan(Math.PI/8)*10, -Math.sin(Math.PI/4)*10, Math.sin(Math.PI/4)*10,
                    -Math.tan(Math.PI/8)*10, 10, 0, 10,
                    Math.tan(Math.PI/8)*10, 10, Math.sin(Math.PI/4)*10, Math.sin(Math.PI/4)*10,
                    
                    -Math.sin(Math.PI/4)*50, -Math.sin(Math.PI/4)*50,
                    -Math.tan(Math.PI/8)*50, -50, 0, -50,
                    Math.tan(Math.PI/8)*50, -50, Math.sin(Math.PI/4)*50, -Math.sin(Math.PI/4)*50,
                    50, -Math.tan(Math.PI/8)*50, 50, 0,
                    10, 0,
                    10, -Math.tan(Math.PI/8)*10, Math.sin(Math.PI/4)*10, -Math.sin(Math.PI/4)*10,
                    Math.tan(Math.PI/8)*10, -10, 0, -10,
                    -Math.tan(Math.PI/8)*10, -10, -Math.sin(Math.PI/4)*10, -Math.sin(Math.PI/4)*10
                ])),
                new GraphicsSolidFill(0x333333),
                new GraphicsPath(Vector.<int>([1, 3, 2, 3,
                    1, 3, 2, 3
                ]), Vector.<Number>([50, 0,
                    50, Math.tan(Math.PI/8)*50, Math.sin(Math.PI/4)*50, Math.sin(Math.PI/4)*50,
                    Math.sin(Math.PI/4)*10, Math.sin(Math.PI/4)*10,
                    10, Math.tan(Math.PI/8)*10, 10, 0,

                    -50, 0,
                    -50, -Math.tan(Math.PI/8)*50, -Math.sin(Math.PI/4)*50, -Math.sin(Math.PI/4)*50,
                    -Math.sin(Math.PI/4)*10, -Math.sin(Math.PI/4)*10,
                    -10, -Math.tan(Math.PI/8)*10, -10, 0
                ]))
            ]));
            
            disk.x = stage.stageWidth/2;
            disk.y = stage.stageHeight/2;
            
            addChild(disk);
            
            sound.addEventListener(Event.COMPLETE, onComplete);
            sound.load(new URLRequest("http://labs.makemachine.net/files/flying_lotus_sample.mp3"));
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, onMouseWheel);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onComplete(event:Event):void{ 
            mySound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSampleData);
            mySound.play();
        }
        
        private function onMouseWheel(e:MouseEvent):void{
      this.speed += Math.abs(0.005*(e.delta/3));
      trace(this.speed+" - "+e.delta);
        }
        
        private function onEnterFrame(e:Event):void{
            disk.rotation += this.speed*5;
            //this.opaqueBackground = ;
        }
        
        private function onSampleData(e:SampleDataEvent):void{
            this.speed -= 44100/SAMPLE_SIZE/2000;
      if(this.speed < 0.0000001){
                this.speed = 0;
            }
            var bytes:ByteArray = new ByteArray();
            sound.extract(bytes, this.speed!=0 ? Math.ceil(SAMPLE_SIZE*this.speed) : 1, this.last);
            //trace("Extracted length: "+bytes.length+" ("+bytes.length/8+" samples).");
            //trace("Speed: "+this.speed+" ("+(this.speed!=0 ? Math.ceil(SAMPLE_SIZE*this.speed) : 1)+" samples loaded).");
            this.last += Math.round(SAMPLE_SIZE*this.speed);
            bytes.position = 0;
            for(var i:uint = 0; i < SAMPLE_SIZE; i++){
                bytes.position = 8*Math.floor(bytes.length/8*i/SAMPLE_SIZE);
                e.data.writeFloat(bytes.readFloat());
                e.data.writeFloat(bytes.readFloat());
            }
        }
    }
}