/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wTgB
 */

/*
* via shapevent`s Connect The Dots
* http://wonderfl.net/c/wvdi
*/
package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.ui.*;
	import flash.utils.Timer;
	
	[SWF(backgroundColor=0x0)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private var num:int = 20;
		private var balls:Array = new Array();
		private var radius:Number = 200;
		private var target:int = 0;
		private var timer:Timer;
		
		public function Main():void 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.LOW;
			
			for (var i:int = 0; i < num; i++) 
			{
				var ball:Sprite = new Sprite();
				ball.graphics.beginFill(0xFFFFFF);
				ball.graphics.drawCircle(0, 0, 3);
				ball.graphics.endFill();
				balls.push(ball);
				ball.x=stage.stageWidth/2;
				ball.y=stage.stageHeight/2;
				addChild(ball);
			}
			timer = new Timer(1000);
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			timer.start();
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function onTimer(e:TimerEvent):void 
		{
			target++;
			num--;
			if(num < 2) num=20;
		}
		
		private function update(e:Event):void 
		{	
			graphics.clear();
			graphics.beginFill(0x0);
			graphics.drawRect(0,0,465,465);
			for (var i:int = 0; i < num; i++) 
			{
				var b:Sprite = balls[i] as Sprite;
				var tx:Number = (stage.stageWidth / 2) + Math.cos((Math.PI * 2 / num) * (i + target)) * radius;
				var ty:Number = (stage.stageHeight / 2) + Math.sin((Math.PI * 2 / num) * (i + target)) * radius;
				b.x += (tx - b.x) * 0.2;
				b.y += (ty - b.y) * 0.2;
				for (var j:int = i + 1; j < num; j++)
				{
					var b2:Sprite = balls[j] as Sprite;
					graphics.lineStyle(0, 0xFFFFFF);
					graphics.moveTo(b.x, b.y);
					graphics.lineTo(b2.x, b2.y);
				}
				
			}
		}
	}
}