/**
 * Copyright AKI9 ( http://wonderfl.net/user/AKI9 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wTPZ
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.StageScaleMode;
    import flash.utils.getTimer;
    //import flash.filters.BlurFilter;
    //import net.hires.debug.Stats;

    import frocessing.color.ColorHSV;
    
    public class Test1 extends Sprite {
        public var pmouseX:Number = 0.0;
        public var pmouseY:Number = 0.0;
        
        public var balls:Vector.<Ball>;
        public var hue:Number = 0.0;
        
        public var time:Number;
        
        public function Test1() {
            //addChild(new Stats());
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.frameRate = 24;
            balls = new Vector.<Ball>();
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            
            time = getTimer();
        }
        
        public function onMouseDown(event:MouseEvent):void {
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            pmouseX = mouseX;
            pmouseY = mouseY;
        }
        
        public function onMouseUp(event:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            pmouseX = mouseX;
            pmouseY = mouseY;
        }
        
        public function onMouseMove(event:MouseEvent):void {
            //trace(pmouseX, pmouseY, mouseX, mouseY);
            //var vx:Number = mouseX - pmouseX;
            //var vy:Number = mouseY - pmouseY;
            //var speed:Number = Math.sqrt(vx*vx + vy*vy);
            //trace(speed);
            
            hue += 1;
            if (hue > 360.0) {
                hue -= 360.0;
            }
            var xx:Number = randrange(-30, 30) + mouseX;
            var yy:Number = randrange(-30, 30) + mouseY;
            var rad:Number = randrange(10, 30);

            var satu:Number = Math.random();
            var valu:Number = Math.random();
            var color:ColorHSV = new ColorHSV(hue, satu, valu);
            var ball:Ball = new Ball(xx, yy, rad, color.value, randrange(0.5, 1.5));
            
            var vxBase:Number = randrange(-20, 20);
            var vyBase:Number = randrange(-20, 20);

            var mouseVx:Number = mouseX - pmouseX;
            var mouseVy:Number = mouseY - pmouseY;
            
            ball.setVelocity(vxBase + mouseVx*3, vyBase + mouseVy*3);
            balls.push(ball);
            addChild(ball);
            
            pmouseX = mouseX;
            pmouseY = mouseY;
        }

        
        public function onEnterFrame(event:Event):void {
            var newTime:Number = getTimer();
            var elapsedTime:Number = newTime  - time;
            time = newTime;
            
            for (var i:int = 0; i < balls.length; i++) {
                var ball:Ball = balls[i]
                ball.update(elapsedTime/1000.0);
                if (ball.isDead()) {
                    
                    removeBall(ball);
                    i--;
                }
            }
            
        }
        
        public function removeBall(ball:Ball):void {
            var index:int = balls.indexOf(ball);
            balls.splice(index, 1);
            removeChild(ball);
        }
    }
}

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BlendMode;
import flash.filters.BlurFilter;

class Ball extends Shape {
    private var _lifetime:Number;
    private var _maxLifeTime:Number;
    private var _regist:Number = 0.5;
    
    public var vx:Number;
    public var vy:Number;
    
    public static var blurFilter:BlurFilter = new BlurFilter();

    public function Ball(x:Number, y:Number, rad:Number, color:uint, lifetime:Number) {
        blendMode = BlendMode.MULTIPLY;
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, rad);
        graphics.endFill();
        this.x = x;
        this.y = y;
        _lifetime = lifetime;
        _maxLifeTime = lifetime;
        
        filters = [blurFilter];
        
    }
    
    public function update(dt:Number = 1.0):void {
        vx += (-vx) * _regist * dt;
        vy += (-vy) * _regist * dt;
        
        x += vx * dt;
        y += vy * dt;
        
        var eltr:Number = elapsedLifetimeRatio();
        alpha = eltr;
        scaleX = 2.0 - eltr;
        scaleY = 2.0 - eltr;
        _lifetime -= dt;

    }
    
    public function setVelocity(vx:Number, vy:Number):void {
        this.vx = vx;
        this.vy = vy;
    }
    
    public function isDead():Boolean {
        return _lifetime < 0;
    }
    
    public function elapsedLifetimeRatio():Number {
        return linmap(_lifetime, 0, _maxLifeTime,   0.0, 1.0);
    }
        
    
}

function randrange(_min:Number, _max:Number):Number {
    return (_max - _min) * Math.random() + _min;
}

function linmap(value:Number, min1:Number, max1:Number, min2:Number, max2:Number):Number {
    return (value - min1)/(max1 - min1) * (max2 - min2) + min2;
}
    