/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wSqE
 */

// forked from greentec's Simple Random Texture
package 
{
    import com.bit101.components.CheckBox;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.getTimer;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = 465, height = 465, backgroundColor = "#292929")]
    public class Main extends Sprite 
    {
        public var perlinBitmapData:BitmapData;
        public var randomSeed:int = Math.random() * int.MAX_VALUE;
        public var numOctaves:int = 6;
        public var offsets:Array;
        public var speeds:Array;
        public var _scale:int;
        public var _threshold:int;
        
        public var screen:Bitmap;
        public var screenBitmapData:BitmapData;
        
        
        public var colT:ColorTransform;
        public var startTime:uint;
        
        public var _width:int = 465;
        public var _height:int = 465;
        public var label:Label;
        public var checkbox:CheckBox;
        public var resetButton:PushButton;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = "noScale";
            stage.frameRate = 30;
            
            
            perlinBitmapData = new BitmapData(_width / 2, _height / 2, false);
            //screenBitmapData = new BitmapData(465, 465, true, 0x00ffffff);
            screenBitmapData = new BitmapData(_width, _height, false);
            
            screen = new Bitmap(screenBitmapData);
            addChild(screen);
            
            label = new Label(this, 380, 10);
            label.transform.colorTransform = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
            
            checkbox = new CheckBox(this, label.x, label.y + label.height + 15, "threshold");
            
            resetButton = new PushButton(this, checkbox.x, checkbox.y + checkbox.height + 10, "Reset", onReset);
            resetButton.width = 465 - 380 - 20;
            resetButton.alpha = 0.5;
            
            onReset();
            
           
            addEventListener(Event.ENTER_FRAME, onLoop);
            
        }

        private function onReset(e:Event = null):void
        {
            var i:int;
            
            offsets = [];
            speeds = [];
            
            for (i = 0; i < numOctaves; i += 1)
            {
                offsets.push(new Point());
                speeds.push(new Point(Math.random() * 8 - 4, Math.random() * 8 - 4));
            }
            
            colT = new ColorTransform(Math.random(), 
                                      Math.random(), 
                                      Math.random(), 
                                      1, 
                                      Math.random() * 255,
                                      Math.random() * 255,
                                      Math.random() * 255,
                                      0);
                                      
            
            //colT = new ColorTransform();
            _scale = Math.random() * 10 + 2;
            _threshold = Math.random() * 100 + 50;
            
            label.text = "scale:\t" + String(_scale) + "\nthreshold:\t" + String(_threshold);
        }
        
        private function onLoop(e:Event):void
        {
            //startTime = getTimer();
            
            var i:int;
            for (i = 0; i < numOctaves; i += 1)
            {
                offsets[i].x += speeds[i].x;
                offsets[i].y += speeds[i].y;
            }
            
            perlinBitmapData.perlinNoise(465/_scale, 465/_scale, numOctaves, randomSeed, false, false, 7, false, offsets);
            
            var j:int;
            var x:Number;
            var y:Number;
            var num:Number;
            var color:uint;
            var r:uint;
            var g:uint;
            var b:uint;
            
            screenBitmapData.lock();
            //screenBitmapData.fillRect(screenBitmapData.rect, 0xff000000);
            
            //for (i = 0; i < _width; i += 1)
            for (i = 0; i < 233; i += 1)
            {
                //for (j = 0; j < _height; j += 1)
                for (j = 0; j < 233; j += 1)
                {
                    //x = i / _width * 1.0;
                    x = i / 233 * 1.0;
                    color = perlinBitmapData.getPixel(i, j);
                    y = (color & 0xff) / 255;
                    
                    num = (1 + Math.sin((x + y / 2) * 50)) / 2;
                    num = num < 0 ? 0 : num;
                    
                    //color = num * 255;
                    b = num * 255;
                    
                    y = ((color >> 8) & 0xff) / 255;
                    
                    num = (1 + Math.sin((x + y / 2) * 50)) / 2;
                    num = num < 0 ? 0 : num;
                    
                    g = num * 255;
                    
                    
                    y = ((color >> 16) & 0xff) / 255;
                    
                    num = (1 + Math.sin((x + y / 2) * 50)) / 2;
                    num = num < 0 ? 0 : num;
                    
                    r = num * 255;
                    
                    if (checkbox.selected == true)
                    {
                        if (r + g + b < _threshold * 3)
                        {
                            continue;
                        }
                    }
                    
                    //screenBitmapData.setPixel(i, j, 0xff << 24 | color << 16 | color << 8 | color);
                    //screenBitmapData.setPixel(i, j, r << 16 | g << 8 | b);
                    screenBitmapData.fillRect(new Rectangle(i * 2, j * 2, 2, 2), r << 16 | g << 8 | b);
                    
                }
            }
            
            screenBitmapData.colorTransform(screenBitmapData.rect, colT);
            screenBitmapData.unlock();
            
            
            //perlinBitmapData = new BitmapData(465, 465, false);
            
            
            //trace(getTimer() - startTime);
            
        }
       
   }
}