/**
 * Copyright buccchi ( http://wonderfl.net/user/buccchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wSpE
 */

package {
    import flash.events.*;
    import flash.display.*;
    import flash.text.TextField;
    import flash.net.*;
    //import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="#000000", frameRate="30")] 
    
    public class FontTest extends MovieClip {
        
        public function FontTest():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            
            // 外部フォントの読み込み
            TfFactory.getInstance().loadFont();
            TfFactory.getInstance().addEventListener(Event.COMPLETE, onFontLoaded);
        }
        
        // フォント読み込み完了
        private function onFontLoaded(e:Event):void {
            var tf:TextField = TfFactory.getInstance().createKozukaBTF(20);
            tf.text = "123456789";
            tf.textColor = 0xFFCC33;
            addChild(tf);
            
            var tf2:TextField = TfFactory.getInstance().createKozukaMTF(20);
            tf2.text = "123456789";
            tf2.textColor = 0xFFCC33;
            tf2.y = 20;
            addChild(tf2);
        }
    }
}



import flash.events.*;
import flash.display.*;
import flash.text.TextField;
import flash.utils.Timer;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.net.*;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.text.*;
import flash.system.ApplicationDomain;
import flash.system.SecurityDomain;
import flash.system.Security;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.events.TweenEvent;



/* フォント読み込み、TextField生成 */
class TfFactory extends Sprite {
    static private var instance:TfFactory;
    public function TfFactory(singletonEnforcer:SingletonEnforcer) {}
    private var _loader:Loader;
    
    public static function getInstance():TfFactory {
        if(TfFactory.instance == null) {
            TfFactory.instance = new TfFactory(new SingletonEnforcer());
        }
        return TfFactory.instance;    
    }
    
    public function loadFont():void {
        //Security.loadPolicyFile("http://buccchi.jp/crossdomain.xml");
        //Security.allowDomain("buccchi.jp");
        _loader = new Loader();
        var req :URLRequest = new URLRequest("http://buccchi.jp/wonderfl/201104/font.swf");
        // Loaderの設定に関する注意点 - LoaderContext
        // http://level0.kayac.com/2009/10/loader_-_loadercontext.php
        var context :LoaderContext = new LoaderContext();
        context.checkPolicyFile = true;
        context.securityDomain = SecurityDomain.currentDomain;
        context.applicationDomain = ApplicationDomain.currentDomain;
        _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoadComplete );
        _loader.load( req, context );
    }
        
    private function onLoadComplete(e:Event):void {
        _loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onLoadComplete );
        
        var KozukaB:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition( "KozukaGothicB" ) as Class;
        Font.registerFont( KozukaB );
        var KozukaM:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition( "KozukaGothicM" ) as Class;
        Font.registerFont( KozukaM );
        dispatchEvent(new Event(Event.COMPLETE));
    }
    
    public function createKozukaBTF(size:Number=12):TextField {
        return getTF( new TextFormat("Kozuka Gothic Pro B", size) );
    }
    public function createKozukaMTF(size:Number=12):TextField {
        return getTF( new TextFormat("Kozuka Gothic Pro M", size) );
    }
    private function getTF(fmt:TextFormat):TextField {
        var tf:TextField = new TextField();
        tf.defaultTextFormat = fmt;
        tf.embedFonts = true;
        tf.selectable = false;
        tf.autoSize = "left";
        return tf;
    }
}
class SingletonEnforcer {}