/**
 * Copyright zsp ( http://wonderfl.net/user/zsp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wSp2
 */

//------------------------------------------------------------
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;

    [ SWF( width = "465" , height = "465" , backgroundColor = "0x000000" , frameRate = "60" ) ]  
    public class FlashTest extends Sprite {
        private var game:Game;
        public function FlashTest() {
            addChild(new Bitmap(screen));
            game = new Game01();
            addEventListener(Event.ENTER_FRAME,onEnterFrame); 
        }

        public function onEnterFrame(e:Event):void{
            game.mainloop();
        }
    }
}

import flash.display.Sprite; 
import flash.display.Bitmap;
import flash.display.BitmapData; 

const WND_W:int = 465;
const WND_H:int = 465;
var screen:BitmapData = new BitmapData(465,465,false,0x00000000); 

class Game{
    public function Game(){ setup();}
    public function setup():void{}
    public function mainloop():void{}
}

//------------------------------------------------------------

import flash.geom.Point;
import flash.geom.Matrix;

class Game01 extends Game{
    override public function setup():void{
            Bullet01.preRender();
            Bullet02.preRender();
            new Stage01();
    }

    override public function mainloop():void{
            screen.lock();

            screen.fillRect(screen.rect, 0x000000); 
            Actor.actAll();

            screen.unlock();
    }
}


class Actor{
    protected static var actors:Vector.<Actor> = new Vector.<Actor>();  
    
    protected var dead:Boolean = false; 
    protected var t:int = 0;
        
    public static function actAll():void{
            var i:int = actors.length;
            while(i--){
                actors[i]._act();
                if (actors[i].dead) actors.splice(i,1);
            }
    }
        
    public function Actor(){
        actors.push(this);
    }
    public function _act():void{
        t++;
        act();
    }
    
    public function act():void{}
}

class Stage01 extends Actor{
    override public function act():void{
        if (t%10==0) new Bullet01(233,233,Math.random()*2*Math.PI,3);
        if (t%200==5) circle(Bullet01, 40, 233,233,3);
        if (t%12==0) new Bullet02(233,100,Math.random() * Math.PI/2+Math.PI/4, 2);
    }
    
    public function circle(b:Class, n:int, x:Number, y:Number,spd:Number):void{
        for(var i:int=0; i<n; i++){
            new b(x,y, i*2*Math.PI/n, spd);
        }
    }
    
}

class Bullet extends Actor{
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    
    public function Bullet(tx:Number, ty:Number, deg: Number, spd:Number){ 
        super();
        x = tx;
        y = ty;
        vx = Math.cos(deg)*spd;
        vy = Math.sin(deg)*spd;
    } 

    override public function act():void{ 
        x+= vx; 
        y+= vy; 

        if((x<-20) ||(465<x)||(y<-20) ||(465<y)) { 
            dead = true; 
        }
        
        draw();
    }
    
    public function draw():void{}
}


class Bullet02 extends Bullet{
    public function Bullet02(tx:Number, ty:Number, deg: Number, spd:Number){
        super(tx,ty,deg,spd);
    }
    
    private static var img:BitmapData;
    
    public static function preRender():void{
        var s:Sprite = new Sprite();
        s.graphics.lineStyle(1,0xFF00FF);
        s.graphics.drawCircle(8,8,5);
        img = new BitmapData(16,16,true,0x00000000);
        img.draw(s);
    }
    
    override public function draw():void{
        screen.copyPixels(img,img.rect, new Point(x,y),null,null,true);                   
    }
 }

class Bullet01 extends Bullet{
    protected var rot:int =0;   

    private static const ROT_STEPS:int = 40;
    private static  var images:Vector.<BitmapData> = new Vector.<BitmapData>(ROT_STEPS, true); 

    private static function CreateRotatedImage(sp:Sprite, size:int):void{
            var g_hsz:int = size/2;
            sp.x = g_hsz;
            sp.y = g_hsz;

            var base :Sprite = new Sprite();

            base.addChild(sp); 

            var source:BitmapData = new BitmapData(g_hsz*2, g_hsz*2, true, 0x00000000);  
            source.draw(base); 

            var i:int; 
            for (i= 0; i<ROT_STEPS; i++){
                 
                var matrix:Matrix;  
                matrix = new Matrix();  
                matrix.translate( -g_hsz, -g_hsz); 
                matrix.rotate(i *2*Math.PI/ ROT_STEPS) 
                matrix.translate( g_hsz,g_hsz); 

                images[i] = new BitmapData(g_hsz*2,g_hsz*2, true, 0x0000000); 
                images[i].draw(source,matrix, null, null, null, true); 
            } 
    }
    
    public static function preRender():void{
               
            var sz: int = 5;
            var graph:Sprite = new Sprite();
            graph.graphics.lineStyle(1, 0x00FFFF); 
            graph.graphics.moveTo(-sz,-sz); 
            graph.graphics.lineTo(-sz,sz); 
            graph.graphics.lineTo(sz,0); 
            graph.graphics.lineTo(-sz,-sz);
            
            CreateRotatedImage(graph,16);
    }

    public function Bullet01(tx:Number, ty:Number, deg: Number, spd:Number){ 
        super(tx,tx,deg,spd);
        rot = ((deg*ROT_STEPS  /(2*Math.PI)) +ROT_STEPS)%ROT_STEPS;
    } 

    protected function calcRot():void{
        var r:Number  = Math.atan2(vy, vx);
        this.rot = ((r*ROT_STEPS  /(2*Math.PI)) +ROT_STEPS)%ROT_STEPS;
    } 

    override public function draw():void{
        screen.copyPixels(images[rot],images[rot].rect, new Point(x,y),null,null,true);           
    }
}
   

