/**
 * Copyright kappaLab ( http://wonderfl.net/user/kappaLab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wSRr
 */

// forked from k3lab's RainbowSphere
// forked from nengafl's nengafl
//===================================================
/*radianの値やradiusの値を変更したりして、いい感じの形を探りまませんか？
 * 
 * 値を変更するだけでもおもしろい感じになったりするかもしれません。
*/
//===================================================
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.VectorShapeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.special.Graphics3D;
	import org.papervision3d.objects.special.VectorShape3D;
	import org.papervision3d.view.BasicView;
	import flash.utils.getTimer;
	/**
	 * ...
	 * @author k3lab
	 */
	[SWF(width="465", height="465", backgroundColor="0x000000")] 
	public class Main extends BasicView 
	{
		//==========================↓ココの値を変更したりしてみませんか============================
		private var radian:Number = 0.01745;
		private var radius:Number = 150;
		//====================================
		private var _arr:Array = [];
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			camera.focus = 100;
			camera.zoom = 11;
			//======================================================
			for (var i:int = 0; i <360; i++) 
			{
				//=============================↓ココの値を変更したりしてみませんか=============================
				var epsi:Number = i * radian * 46384;
				var gamm:Number = i * radian * 0.5;
				//=========================
				//例(ヒント)
				//radius = Math.abs(2 * Math.sin(gamm)) * 100；
				//=========================
				var material :VectorShapeMaterial = new VectorShapeMaterial();
				var shape:VectorShape3D = new VectorShape3D(material);
				_arr[i] = shape;
				scene.addChild(shape);		
				var gg :Graphics3D = shape.graphics;
				var r:int = 128 + 127 * Math.cos(i / 20) << 16;
                var g:int = 128 + 127 * Math.cos(i / 30) << 8;
                var b:int = 128 + 127 * Math.cos(i / 40);
                var color:uint = r | g | b;
				shape.graphics.beginFill(color);
				shape.graphics.lineStyle(15, 0xFF0000, 0.2);
				shape.graphics.drawCircle(0, 0, 10);
				shape.x = radius * Math.sin(gamm)*Math.cos(epsi)
				shape.y = radius * Math.sin(gamm)*Math.sin(epsi)
				shape.z = radius * Math.cos(gamm);
				
			}
			startRendering();
		}
		//==================================================
		//例(ヒント)
		//private var cnt:Number = 0;
		//private var speed:Number = 0.00018
		//==================================================
		override protected function onRenderTick(event:Event = null):void 
		{
			for (var i:int = 0; i < 360; i++) 
			{
				_arr[i].lookAt(camera)
				//=========================
				//例(ヒント)
				/* cnt+=speed;
				(cnt<0||cnt > 2000)?speed = -speed:speed;
				var epsi:Number = i * radian *cnt
				var gamm:Number = i * radian * 0.5;
				_arr[i].x = radius * Math.sin(gamm)*Math.cos(epsi)
				_arr[i].y = radius * Math.sin(gamm)*Math.sin(epsi)
				_arr[i].z = radius * Math.cos(gamm);
				*/
				//=========================
			}
			camera.x = Math.cos(getTimer() / 1000) * 1000;
			camera.z = Math.sin(getTimer() / 1000) * 1000;
			super.onRenderTick(event);
		}
	}
}