/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wQDe
 */

// forked from narutohyper's 東京てら子11 Alternativa3Dについて その10
package
{
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.primitives.Plane;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import alternativ7.engine3d.containers.ConflictContainer
    import alternativ7.engine3d.core.View
    import alternativ7.engine3d.core.Camera3D
    import alternativ7.engine3d.controllers.SimpleObjectController
    import alternativ7.engine3d.primitives.Box
    import alternativ7.engine3d.materials.FillMaterial
    import alternativ7.engine3d.loaders.MaterialLoader;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.core.Vertex;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    
    
    /**
     * TokyoTeraco11 その10
     * オリジナルのMeshを作成してみる
     * 三角形のプレーンを作ってみよう！
     * 
     * @author narutohyper
     */
    [SWF(backgroundColor="#000000", frameRate="60")]
    public class Main extends Sprite
    {
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            //ルートオブジェクト（Root Object）
            var container:ConflictContainer = new ConflictContainer();

            //ビューを作る
            var view:View = new View(stage.stageWidth, stage.stageHeight);
            addChild(view);

            //カメラを作る
            var camera:Camera3D = new Camera3D();

            //カメラとビューを関連付ける
            camera.view = view;

            //カメラを撮影する3D空間に配置する
            container.addChild(camera);

            //カメラの位置を調整
            camera.x = 0;
            camera.y = -500;
            camera.z = 0;

            //カメラをコントローラ
            var cameraController:SimpleObjectController = new SimpleObjectController(stage, camera, 10);
            cameraController.mouseSensitivity = 0;
            cameraController.unbindAll();
            cameraController.lookAtXYZ(0, 0, 0);
            
            //1.ジオメトリ（Geometry）の作成
            var geo:Mesh = new Mesh();
            
            //2.ジオメトリへ頂点（Vertex）の登録
            var MAX_VERTEX_NUM:uint = 3;
            var RADIAN:Number = Math.PI / 180;
            var radius:Number = 100;
            
            var vertices:Vector.<Vertex> = new Vector.<Vertex>(MAX_VERTEX_NUM);
            for (var i:int; i < MAX_VERTEX_NUM; i++ ) {
                var sx:Number = Math.cos((i * (360 / MAX_VERTEX_NUM)-90) * RADIAN) * radius;
                var sy:Number = Math.sin((i * (360 / MAX_VERTEX_NUM)-90) * RADIAN) * radius;
                vertices[i]=geo.addVertex(sx, sy, 0, 0, 0, "vertex" + i);
            }
            
            //3.面（Face）の登録

            //表面
            geo.addTriFace(vertices[0], vertices[1], vertices[2], null, 'face_front' + 0);
            
            //裏面
            geo.addTriFace(vertices[0], vertices[2], vertices[1], null, 'face_back' + 0);
            
            //4.メッシュ（Mesh）の作成
            //var triangle:Mesh = new Mesh();
            
            //5.メッシュとジオメトリを関連付ける
            //triangle.geo);
            
            //triangle.rotationX = -90 * RADIAN;
            
            //container.addChild(triangle);
            geo.calculateNormals();
            container.addChild(geo);
            
            //オブジェクトにマテリアルを設定
            var material:FillMaterial = new FillMaterial(0x666666, 1, 0,0x0);
            //triangle.setMaterialToAllFaces(material);
            geo.setMaterialToAllFaces(material);
            
            
            //オブジェクトコントローラを追加
            var objectController:SimpleObjectController = new SimpleObjectController(stage, geo, 10);
            objectController.mouseSensitivity = 1;
            objectController.unbindAll();
            
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);

            
    
            
            function onEnterFrame(e:Event):void
            {
                //カメラコントローラの操作をコントロールオブジェクトに反映
                cameraController.update();
                
                //オブジェクトコントローラの操作をコントロールオブジェクトに反映
                objectController.update();
                
                //レンダリング
                camera.render();
            }
                    
            
        }
        

        
    }
    
}