/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wPjN
 */

package
{ 
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    [SWF(frameRate = 60, width = 460, height = 345)]
    public class Main extends Sprite
    {
        public var colliders :Array = [new Collider, new Collider, new Collider];
        internal var collidee :Collidee = new Collidee(this);
        
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _init();
        }
        
        public function _init($value:Number = 0) :void
        {
            for (var i:Number = 0; i < colliders.length; i++)
                {addChild(colliders[i])}   
                      
            addChild(collidee);
            
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.5);
            graphics.drawRect  (0, 0, 459, 344);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.net.*;

//collider can move, collidee cannot

class Collider extends Sprite
{
    protected var _c:Number;
    protected var _a:Number;
    protected var _x:Number;
    protected var _y:Number;
    protected var _r:Number;
    
    public function Collider($c:Number = 0, $a:Number = 0.5, $x:Number = 17, $y:Number = 17, $r:Number = 16)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        
        _c = $c;
        _a = $a;
        _x = $x;
        _y = $y;
        _r = $r;
        
        _init();
    }

    public function _init() :void
    {
        graphics.clear      ();
        graphics.beginFill  (_c, _a);
        graphics.drawCircle (_x, _y, _r);
        graphics.endFill    ();
    }
    
    internal var oldPt :Point = new Point();
    internal var currentPt :Point = new Point();
    internal var calcPt :Point = new Point();
    
    public function addedToStage($e:Event) :void
    {
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        
        oldPt = new Point($e.stageX, $e.stageY);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        currentPt = new Point($e.stageX, $e.stageY);
        calcPt = Point(currentPt.subtract(oldPt));
        
        x = (x + calcPt.x);
        y = (y + calcPt.y);
        
        oldPt = currentPt;
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    public function get color() :Number
    { return _c }
    
    public override function get alpha() :Number
    { return _a }
    
    public override function get x() :Number
    { return _x }
    
    public override function get y() :Number
    { return _y }
    
    public function get radius() :Number
    { return _r }
    
    public function set color($value:Number) :void
    { _c = $value; _init(); }
    
    public override function set alpha($value:Number) :void
    { _a = $value; _init(); }
    
    public override function set x($value:Number) :void
    { _x = $value; _init(); }
    
    public override function set y($value:Number) :void
    { _y = $value; _init(); }
    
    public function set radius($value:Number) :void
    { _r = $value; _init(); }
}

class Collidee extends Sprite
{
    internal var _main: Object;
    
    protected var _c:Number;
    protected var _a:Number;
    protected var _x:Number;
    protected var _y:Number;
    protected var _w:Number;
    protected var _h:Number;
    
    public function Collidee($main:Object, $c:Number = 0, $a:Number = 0.5, $x:Number = 230, $y:Number = 90, $w:Number = 50, $h:Number = 50)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        
        _main = $main;
        
        _c = $c;
        _a = $a;
        _x = $x;
        _y = $y;
        _w = $w;
        _h = $h;
        
        _init();
    }
    
    public function _init() :void
    {
        graphics.clear         ();
        graphics.beginFill     (_c, _a);
        graphics.drawRoundRect (_x, _y, _w, _h, 12, 12);
        graphics.endFill       ();
    }
    
    public function addedToStage($e:Event) :void
    {
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    public function testCollision($list:Array) :void
    {
        for (var i:Number = 0; i < $list.length; i++)
        {
            if (hitTestObject($list[i])) { $list[i].color = 0x00FF00 }
            else                         { $list[i].color = 0 }
        }
    }

    public function onEnterFrame($e:Event) :void
    {
        testCollision(_main.colliders);
    }
  
    public function get color() :Number
    { return _c }
    
    public override function get alpha() :Number
    { return _a }
    
    public override function get x() :Number
    { return _x }
    
    public override function get y() :Number
    { return _y }
    
    public override function get width() :Number
    { return _w }
    
    public override function get height() :Number
    { return _h }
    
    public function set color($value:Number) :void
    { _c = $value; _init(); }
    
    public override function set alpha($value:Number) :void
    { _a = $value; _init(); }
    
    public override function set x($value:Number) :void
    { _x = $value; _init(); }
    
    public override function set y($value:Number) :void
    { _y = $value; _init(); }
    
    public override function set width($value:Number) :void
    { _w = $value; _init(); }
    
    public override function set height($value:Number) :void
    { _h = $value; _init(); }
}
