/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wPZm
 */

//カヤックさんの記事を読んで四角を転がす実験
//
//参考：getBounds + Matrixで、もう基準点にはこだわらない。
//http://level0.kayac.com/2009/11/matrix_with_getbounds.php
//
//ループの処理の挙動がイマイチ。。。

package  {
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * ...
	 * @author 393

	 */
	public class KoroKoro extends Sprite{
		
		public function KoroKoro() {
			//100個転がす
			for (var i:uint = 0; i < 100;i++){
			    //第一引数：表示リスト
			    //第二引数：x座標
			    //第三引数：y座標
			    //第四引数：幅
			    //第五引数：高さ
			    //第六引数：スピード
				addChild(new Koro(this,Math.random()*300,Math.random()*300,Math.random()*50+1,Math.random()*100+1,Math.random()*5+5) );
			}
		}
	}

}

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Matrix;
import flash.geom.Rectangle;

class Koro extends Sprite {
	private var _degree:Number = 0;
	private var _w:Number;
	private var _h:Number;
	private var _rect:Rectangle;
	private var _matrix:Matrix
	private var _speed:Number;
	private var _container:KoroKoro;
	private var _countNumber:Number;
	public function Koro(container:KoroKoro,posX:Number = 10, posY:Number = 100, w:Number = 100, h:Number = 50,speed:Number = 10) {
		//四角を作る
		graphics.beginFill(Math.floor(0xFFFFFF * Math.random()));
		graphics.drawRect(posX, posY, w, h);
		graphics.endFill();
		//速度定義
		_speed = speed;
		//親コンテナ
		_container = container
		addEventListener(Event.ADDED_TO_STAGE , init);
	}
	//初期設定
	private function init(e:Event):void {
		removeEventListener(Event.ADDED_TO_STAGE, init);
		_matrix=this.transform.matrix;
		_rect = this.getBounds(_container);
		_w=this.width;
		_h=this.height;
		_degree=0;
		_countNumber = 0;
		
		this.addEventListener(Event.ENTER_FRAME , enterFrameHandler);
	}
	
	private function enterFrameHandler(e:Event):void {
		roll();
		_degree += _speed;
		if (_degree >= 90) {
			var max:Number = Math.max(width, height);
			if (x >= stage.stageWidth+ max*2){
				_matrix.tx = -width;
				_matrix.ty = Math.random() * 200;
				this.transform.matrix=_matrix;
			}
			setProp();
		}
	}
	
	private function roll():void{
		_matrix.translate(-(_rect.left + _rect.width),-(_rect.top + _rect.height));
		_matrix.rotate(_speed*Math.PI/180);
		_matrix.translate((_rect.left + _rect.width), (_rect.top + _rect.height));
		this.transform.matrix=_matrix;
	}
	
	private function setProp():void{
		_w=this.width;
		_h=this.height;
		_degree=0;
		_rect=this.getBounds(_container);
	}
}