/**
 * Copyright arumajirou ( http://wonderfl.net/user/arumajirou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wPM3
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.*;

    	[SWF( backgroundColor="0x0" )]

    public class FlashTest extends Sprite {
    	static public var W : int = 1024;
    	static public var H : int = 1024;
    	static public var NUM : int = 1024;

    	private var ref : cReferencePosition = null;
    	private var bg : cBg = null;

    	private var ppos : Vector3D = null;
    	private var moves : Vector3D = null;
    	    	
        public function FlashTest() {
            // write as3 code here..
            graphics.clear();
            
            ref = new cReferencePosition();
			bg = new cBg( parent );
            
            parent.addEventListener( MouseEvent.MOUSE_MOVE, move );
            parent.addEventListener( Event.ENTER_FRAME, onEnterFrame );
            
            ppos = new Vector3D( 0, 0, 0, 1 );
            moves = new Vector3D( 0, 0, 0, 1 );
        }
        
        private function move( e : MouseEvent ) : void
        {
	        	var np : Vector3D = new Vector3D( 232, 232, 0, 1 );
		    var m : Vector3D = new Vector3D( e.stageX, e.stageY, 0, 1 );
		    moves = m.subtract( np );
		    moves.normalize();
        }
        
        private function onEnterFrame( e : Event ) : void
        {
        		ppos = ppos.add( moves );
        		var rect : Rectangle = bg.getRegion();
        		ppos.x = ( ppos.x - rect.left + rect.width ) % rect.width + rect.left;
        		ppos.y = ( ppos.y - rect.top + rect.height ) % rect.height + rect.top;
        		ref.update( ppos );

        		bg.process();
        		bg.draw( ref.getter() );
        }
    }
}

import flash.display.*;
import flash.geom.*;
class cReferencePosition
{
	private var position : Vector3D;
	
	public function cReferencePosition()
	{
		position = new Vector3D( 0, 0, 0, 1 );
	}
	public function setter( v : Vector3D ) : void
	{
		position = v.clone();
	}
	public function getter() : Vector3D
	{
		return position.clone();
	}
	public function update( v : Vector3D ) : Vector3D
	{
		return ( position = ( v.clone() ).subtract( new Vector3D( 0, 0, 0, 1 ) ) );
	}
}

interface iCharacter
{
	function process() : void;
	function draw( v : Vector3D ) : void;
}

class cCharacter implements iCharacter
{
	protected var _stage : DisplayObjectContainer = null;
	protected var _visual : Sprite = null;
	protected var _pos : Vector3D = null;
	public function cCharacter( d : DisplayObjectContainer = null )
	{
		_stage = d;
		_pos = new Vector3D( 0, 0, 0, 1 );
	}
	public function process() : void
	{
	}
	public function draw( v : Vector3D ) : void
	{
	}
}

class cBg extends cCharacter
{
	public static var W : int = 1024;
	public static var H : int = 1024;

	private var parts : Vector.<Sprite>;
	private var region : Rectangle;
	
	public function cBg( d : DisplayObjectContainer = null )
	{
		parts = new Vector.<Sprite>();
		region = new Rectangle( 0, 0, 1024, 1024 );
		_visual = new Sprite();
    		_visual.graphics.clear();
    		var temp : Sprite = new Sprite();
    		temp.graphics.lineStyle( 1, 0xffffffff );        		
    		for( var i : int = 0 ; i < 24 ; i++ )
    		{
    			temp.graphics.drawCircle( Math.random() * 128 , Math.random() * 128, 1 );
    		}
    		_visual.addChild( temp );
    		parts.push( temp );
    		var tempSprite : Sprite = null;
    		for( i = 1 ; i < 128 ; i++ )
    		{
    			tempSprite = new Sprite();
    			tempSprite.graphics.copyFrom( temp.graphics );
    			tempSprite.x = ( i % 5 ) * 128;
    			tempSprite.y = Math.floor( i / 5 ) * 128;
	    		parts.push( tempSprite );
	    		_visual.addChild( tempSprite );
    		}
    		d.addChild( _visual );
	}
	public override function draw( v : Vector3D ) : void
	{
		var p : Vector3D = new Vector3D( region.left, region.top, 0, 1 );
		p = p.subtract( v );
		_visual.x = ( p.x ) % 128;
		_visual.y = ( p.y ) % 128;
		
	}
	public function update( m : Vector3D ) : void
	{
	}
	public function getRegion() : Rectangle
	{
		return region.clone();
	}
}
