/**
 * Copyright barimi ( http://wonderfl.net/user/barimi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wO32
 */

// forked from tktr90755's 軌跡 forked from: nengafl
/*

マウスに追従する動きで、下記のモノより面白そうな動きを作っていただけるとうれしいです。
Homingクラスの引数の値を変えたり、「シェイプ生成」の箇所を書き換えたりすると、また違った動きが作れるかもしれません。

使っている式は三つあります

--------

・古いマウス位置に対し新しいマウス位置への方向をもとめる式
参考文献 http://wonderfl.net/code/387527e7d537bfaa1b07c2b314cc2d457f2bf965

	var radian:Number = Math.atan2((古いマウスのY座標 - 新しいマウスのY座標), (古いマウスのX座標 - 新しいマウスのX座標));
	パーティクル.rotation = radian * 180 / Math.PI;
	
・古いマウス位置と新しいマウス位置の距離間をもとめる式
参考文献 http://www.procreo.jp/tutorial02.html

	var 距離:int = Math.sqrt ((新しいマウスのY座標 - 古いマウスのY座標) * (新しいマウスのY座標 - 古いマウスのY座標) + (新しいマウスのX座標 - 古いマウスのX座標) * (新しいマウスのX座標 - 古いマウスのX座標));
	
・イージングの式
参考文献 http://blog.bonkura.jp/formula05.html

	現在の値 += (目標値 - 現在の値) / スピード;
	
--------


何かバグってたらすいません・・。

*/
package  
{
	import flash.display.MovieClip;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	[SWF(backgroundColor = 0xFFFF00, frameRate = 60)]
	
	public class Index extends Sprite
	{
		private var isTrue:Boolean = true;
		public function Index() 
		{
			var textField:TextField = new TextField();
			textField.textColor = 0x000000;
			textField.text = "クリックしながらドラッグしてね";
			textField.width = 200;
			addChild(textField);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		private function mouseDownHandler(e:MouseEvent):void 
		{
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			//切り替えスイッチ
			isTrue = !isTrue;
		}
		private function mouseUpHandler(e:MouseEvent):void 
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
		private function mouseMoveHandler(e:MouseEvent):void 
		{
			//四角か丸を生成
			if (isTrue === true) 	{ Homing.to(stage); } 
			else 		{ Homing.to(stage, 0xffffff * Math.random (), "circle", 1, 8); };
		}
	}
}

import flash.display.DisplayObjectContainer;
import flash.display.Shape;
import flash.events.Event;
class Homing
{
	public function Homing() 
	{
		//newしちゃだめ
		throw new Error("Homing is class only of static method");
	}
	
	private static var oldMouseX:Number;
	private static var oldMouseY:Number;
	private static var currentMouseX:Number;
	private static var currentMouseY:Number;
	
	/**
	 * @param container 		ターゲットコンテナ
	 * @param color 			色
	 * @param type 			四角か丸か "square" or "circle"
	 * @param minSize 		パーティクルの最小サイズ
	 * @param maxSize 		パーティクルの最大サイズ
	 * @param disperse 		パーティクルの散らばり具合
	 * @param speed 			パーティクルの進行方向へのスピード
	 */
	
	public static function to(container:DisplayObjectContainer, color:int = 0xFFFFFF, type:String = "square", minSize:int = 2, maxSize:int = 15, disperse:int = 15, speed:int = 50):void
	{
		//移動前のマウスポジション
		oldMouseX = currentMouseX;
		oldMouseY = currentMouseY;
		//移動後のマウスポジション
		currentMouseX = container.stage.mouseX;
		currentMouseY = container.stage.mouseY;
		//一回で出るパーティクルの数
		var createInterval:int = 1;
		//移動前に対して移動後への方向をもとめる
		var angle:Number = Math.atan2 (currentMouseY - oldMouseY, currentMouseX - oldMouseX);
		var distanceX:Number = Math.cos (angle);
		var distanceY:Number = Math.sin (angle);
		//移動前と移動後との距離をもとめる
		var distance:int = int(Math.sqrt ((currentMouseY - oldMouseY) * (currentMouseY - oldMouseY) + (currentMouseX - oldMouseX) * (currentMouseX - oldMouseX)));
		//古いマウスポジションと新しいマウスポジションとの距離間が10以上ならばパーティクルを出す（マウスをシャッとしたら出す）
		if (distance >= 5)
		{
			for (var i:int = 1; i <= createInterval; ++i)
			{
				//大きさ
				var radius:int = int(Math.random () * (maxSize - minSize)) + minSize;
				//散りぐあい
				var disperse:int;
				if ((Math.random() * 2 >> 0) == 1) { disperse = int(Math.random () * disperse) * ( -1); } else { disperse = int(Math.random () * disperse) * 1; };
				//目的地
				var targetX:int = currentMouseX + disperse + speed * distanceX;
				var targetY:int = currentMouseY + disperse + speed * distanceY;
				//最初の目標値(登場の目標値)
				var targetScaleX:int = 1;
				var targetScaleY:int = 1;
				var targetAlpha:int = 1;
				//速度(2～5)
				var speed:int = (Math.random() * 4 >> 0) + 5;
				//登退退場切り替えジャッジ
				var judge:int = 1;
				//登場済みかどうか
				var isEmerged:Boolean = false;
				//シェイプ生成
				var shape:Shape = new Shape();
				shape.x = currentMouseX;
				shape.y = currentMouseY;
				shape.graphics.beginFill(color, 1);
				//四角か丸を描画する
				if (type === "circle") 
				{ 
					shape.graphics.drawCircle( 0, 0, radius); 
				} 
				else if (type === "square") 
				{ 
					shape.graphics.drawRect( -radius / 2, -radius / 2, radius, radius); 
				};
				//初期プロパティ
				shape.scaleX = 0;
				shape.scaleY = 0;
				shape.alpha = 0;
				//addする
				container.addChild(shape);
				//個々のshapeに対しエンターフレームを設置
				shape.addEventListener
				(
					Event.ENTER_FRAME,
					function(e:Event):void 
					{ 
						//rotation(マウスが上に行ったら右回転、下に行ったら左回転)
						shape.rotation -= ((targetY - shape.y) * speed) / 5;
						//x(横方向)
						if (int(Math.abs(targetX - shape.x)) > judge) { shape.x += (targetX - shape.x) / 10; } else { shape.x = targetX; };
						//y(縦方向)
						if (int(Math.abs(targetY - shape.y)) > judge) { shape.y += (targetY - shape.y) / 10; } else { shape.y = targetY; };
						//alpha(透明度)
						if (Math.abs(targetAlpha - shape.alpha) * 100 > judge) { shape.alpha += (targetAlpha - shape.alpha) / speed; } else { shape.alpha = targetAlpha; };
						//scale(大きさ)
						if (Math.abs(targetScaleX - shape.scaleX) * 100 > judge && Math.abs(targetScaleY - shape.scaleY) * 100 > judge)
						{
							shape.scaleX += (targetScaleX - shape.scaleX) / speed;
							shape.scaleY += (targetScaleY - shape.scaleY) / speed;
						}
						else
						{
							shape.scaleX = targetScaleX;
							shape.scaleY = targetScaleY;
							//退場アニメーションへ移行
							isEmerged = true;
						};
						//退場アニメーションへ
						if (isEmerged === true)
						{
							//消えるときの目標値(退場の目標値)
							targetAlpha = 0;
							targetScaleY = 0;
							targetScaleX = 0;
						};
						//登場済みで透明になる処理が終わっていたら終了処理
						if (isEmerged === true && targetAlpha === shape.alpha)
						{
							//匿名エンターフレームを消す処理
							e.target.removeEventListener(Event.ENTER_FRAME, arguments.callee);
							//removeする
							shape.graphics.clear();
							container.removeChild(shape);
						};
					}
				);
			};
		};
	};
}