/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wMoD
 */

package 
{
    import com.bit101.components.*;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * ...
     * @author nagai
     * 画像ファイルをアップロードするだけ
     * クリックしてゴゴゴゴってなるだけ
     */
     
    public class Main extends Sprite 
    {
        private var _btn:PushButton;
        private var _fileloader:FileLoader;
        private var _bmp:Bitmap;
        private var yure:Yureru;
        
        public function Main() 
        {
            _btn = new PushButton(stage, 0, 0, "LOAD", init);
        }
        
        private function init(e:MouseEvent):void 
        {
            
            _fileloader = new FileLoader();
            addChild(_fileloader);
            _fileloader.addEventListener("select", onSelect);
            _fileloader.addEventListener("cancel", onCancel);
            _fileloader.addEventListener("click", onComp);
        }
        
        private function onSelect(e:Event):void 
        {
            _btn.visible = false;
        }
        
        private function onCancel(e:Event):void 
        {
            _btn.visible = true;
        }
        
        private function onComp(e:MouseEvent):void 
        {
            var _bmpd:BitmapData = new BitmapData(_fileloader.width, _fileloader.height, false, 0xFFFFFF);
            
            _bmpd.draw(_fileloader);
            
            
            _bmp = new Bitmap(_bmpd);
            addChild(_bmp);
            
            yure = new Yureru(_bmp.x, _bmp.y);
            
            removeChild(_fileloader);
            
            var _label:Label = new Label(stage, 0, 0);
            _label.blendMode = "invert";
            _label.text = "gogogogo...";
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void 
        {
            yure.yureruAction(1, 1);
            _bmp.x = yure.x;
            _bmp.y = yure.y;
        }
        
    }
    
}

import flash.events.Event;
import flash.display.Sprite;
import flash.display.Loader;
import flash.net.*;
import flash.utils.ByteArray;

class FileLoader extends Sprite
{
    private var _loader:Loader;
    private var _selectFile:FileReference;
    
    public function FileLoader()
    {
        init();
    }
    
    private function init():void
    {
        _selectFile = new FileReference();
        var _fileFilter:FileFilter = new FileFilter("画像ファイル(*.jpg;*.gif;*.png)", "*.jpg;*.gif;*.png");
        _selectFile.addEventListener(Event.SELECT, SelectEventHandler);
        _selectFile.addEventListener(Event.CANCEL, CancelEventHandler);
        _selectFile.browse([_fileFilter]);
    }
    
    private function CancelEventHandler(e:Event):void 
    {
        dispatchEvent(new Event(Event.CANCEL));
    }
    
    private function SelectEventHandler(e:Event):void 
    {
        _selectFile.addEventListener(Event.COMPLETE, LoadConmpleted);
        _selectFile.load();
        dispatchEvent(new Event(Event.SELECT));
    }
    
    private function LoadConmpleted(e:Event):void
    {
        _loader = new Loader();
        _loader.loadBytes(_selectFile.data as ByteArray);
        addChild(_loader);
    }
    
}


class Yureru
{
    
    private var _x:Number ;
    private var _y:Number ;
    
    public function Yureru(x:Number,y:Number)
    {
        this._x = x;
        this._y = y;
    }
    
    public function yureruAction(directory_x:int, directoty_y:int):void
    {
        this._x += Math.random() * directory_x - directory_x / 2;
        this._y += Math.random() * directoty_y - directoty_y / 2;
    }
    
    public function get x():Number
    {
        return this._x;
    }
    
    public function get y():Number
    {
        return this._y;
    }
    
}