/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wMd5
 */





package 
{
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.events.MouseEvent;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    public class Main extends Sprite 
    {
        private var lightlayer:Sprite;
        private var lightcanvas:BitmapData;
        private var lightsp:Sprite;
        private var glasslayer:Sprite;
        private var glasscanvas:BitmapData;
        private var glass:Glass;
        private var lightlist:Array;
        private var blur:BlurFilter = new BlurFilter(8, 8, 2);
        private var blur2:BlurFilter = new BlurFilter(20, 20, 2);
        private var step:int = 0;
        private var effect:Boolean = false;
        private var mX:Number  = new Number( mouseX );
        private var mY:Number  = new Number( mouseY );

        public function Main():void  
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
        //  entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            lightlayer = new Sprite();
            addChild( lightlayer );  
            lightcanvas = new BitmapData( WIDTH, HEIGHT, true, 0xFFFFFF );
            lightlayer.addChild( new Bitmap( lightcanvas ) );
            lightsp = new Sprite();
            lightsp.blendMode = BlendMode.ADD;
            lightlayer.addChild( lightsp );
            lightlist = new Array();
            EraseLightLayer();
            
            glasslayer = new Sprite();
            addChild( glasslayer );
            
            glasscanvas = new BitmapData(WIDTH, HEIGHT, true, 0xFFFFFF);
            glasslayer.addChild( new Bitmap(glasscanvas) );
            
            glass = new Glass();
            glass.alpha = 0.3;
            glasslayer.addChild(glass);
            
            var mask:Glass = new Glass();
            glasslayer.mask = mask;
            glasslayer.addChild( mask );            
            stage.addEventListener(MouseEvent.CLICK, ChangeEffect );
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }

        private function EraseLightLayer() : void
        {
            var glass:Glass = new Glass();
            glass.blendMode = BlendMode.ERASE;
            lightlayer.blendMode = BlendMode.LAYER;
            lightlayer.addChild( glass );  
//            glass.x = mX;      
        }
        
        private function AddLight() : void
        {
            var light:LightParticle = new LightParticle();
            lightlist.push( light );    
        }
        
        private function ChangeEffect(e:MouseEvent) : void
        {
            effect = !effect;
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {
            lightsp.graphics.clear();
            var num:int = lightlist.length;
            for ( var i:int = num - 1; i >= 0; i-- )
            {
                lightlist[i].y += lightlist[i].my;
                if ( lightlist[i].y > HEIGHT + lightlist[i].size )
                {
                    lightlist.splice( i, 1 );
                }else
                {
                    lightlist[i].Draw( lightsp.graphics );
                }
            }
            
            lightcanvas.lock();
            lightcanvas.fillRect(lightcanvas.rect, 0);
            lightcanvas.draw(lightsp);
            lightcanvas.applyFilter( lightcanvas, lightcanvas.rect, new Point(), blur );
            lightcanvas.unlock();
            
            
            glasscanvas.lock();
            if( !effect )    glasscanvas.fillRect(glasscanvas.rect, 0xFFFFFF);
            glasscanvas.draw( lightcanvas );
            glasscanvas.applyFilter( glasscanvas, glasscanvas.rect, new Point(), blur2 );
            glasscanvas.unlock();
            
            step++;
            if( step % 10 == 0 )    AddLight();
        }        
    }
}

import flash.display.Shape;
import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;    
import flash.events.*;
import gs.*;
import gs.easing.*;
import frocessing.color.ColorHSV;
class Glass extends Sprite {
    public function Glass() 
    {
        this.graphics.beginFill(0xFFFFFF);
        this.graphics.drawRect(0,0,WIDTH, HEIGHT/2);
        this.graphics.endFill();
    }
}
//END CLASS

class LightParticle {
    public var my:Number = 0;
    public var size:Number;
    public var color:uint;
    
    public var x:Number;
    public var y:Number;
    
    public function LightParticle() {
        
        this.x = Math.random() * WIDTH;
        this.y = -20;
        size = Math.random() * 20 + 10;
        my = Math.random() * 5 + 1;
        
        colorhsv.h = Math.random() * 360;
        
        color = colorhsv.value;
    }

    public function Draw( g:Graphics ) : void
    {
        g.beginFill( color, 0.9);
        g.drawCircle( this.x, this.y, size );
        g.endFill();
    }
}

const WIDTH:int = 465;
const HEIGHT:int = 465;
var colorhsv:ColorHSV = new ColorHSV();