/**
 * Copyright Mae_ITR ( http://wonderfl.net/user/Mae_ITR )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wMJh
 */

package {
    import flash.display.Sprite;
    import flash.display.GradientType;
    import flash.geom.Matrix;
    public class FlashTest extends Sprite {
            private var bgLayer:ParticleLayer;
        public function FlashTest() {
            // write as3 code here..
            drawBackground();
            bgLayer = new ParticleLayer();
            addChild(bgLayer);
            bgLayer.init();           
        }
        private function drawBackground():void {
            this.graphics.clear();
            var acol:Array = new Array(0xFFFFFF,0x000000);
            var aalpha:Array = new Array(.06, .08);
            var aratio:Array = new Array(0, 255);
            var mt:Matrix = new Matrix();
            mt.createGradientBox(stage.stageWidth, stage.stageHeight, 0, 0, 0);
            this.graphics.beginGradientFill(GradientType.RADIAL, acol, aalpha, aratio,mt);
            this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
        }        
    }
}
import flash.display.Sprite;
import flash.events.Event;
class ParticleLayer extends Sprite
{
    private var markers:Array;
    private var num:uint = 50;
    private var fl:Number = 500;
    private var vpX:Number; 
    private var vpY:Number;
    
    private var vx:Number = 0;
	private var vy:Number = 0;
	private var friction:Number = 0.96;
	private var pmouseX:Number = 0;
	private var pmouseY:Number = 0;
    
    public function ParticleLayer() 
    {
        
    }
    
    public function init():void 
    {
        setupView();
        setupMarker();
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    public function setupView():void
    {
        this.vpX = stage.stageWidth / 2;
        this.vpY = stage.stageHeight / 2;            
    }
    
    public function setupMarker():void
    {
        markers = new Array();
        for(var i:uint = 0; i < num; i++)
        {
            var marker:Marker = new Marker(6);
            markers.push(marker);
            marker.xpos = Math.random() * 500 - 250;
            marker.ypos = Math.random() * 500 - 250;
            marker.vx = Math.random() * 2 - 1;
            marker.vy = Math.random() * 2 - 1;
            marker.setZpos = Math.random() * 500 - 250;
            addChild(marker);
        }
    }
    
    private function onEnterFrame(e:Event):void 
    {	
    		vx -= (stage.mouseX - pmouseX) / 50;
		vy -= (stage.mouseY - pmouseY) / 50;
        //var angleX:Number = (stage.mouseY - vpY) * .001;
        //var angleY:Number = (stage.mouseX - vpX) * .001;
        for(var i:uint = 0; i < num; i++)
        {
            var marker:Marker = markers[i];
            marker.xpos += marker.vx;
            marker.ypos += marker.vy;
            marker.xpos += vx;
            marker.ypos	+= vy;
            //rotateX(marker, angleX);
            //rotateY(marker, angleY);
            doPerspective(marker);
        }
        sortZ();
        vx *= friction;
		vy *= friction;			
		pmouseX = stage.mouseX;
		pmouseY = stage.mouseY;
    }
    private function rotateX(marker:Marker, angleX:Number):void
    {
        var cosX:Number = Math.cos(angleX);
        var sinX:Number = Math.sin(angleX);
        
        var y1:Number = marker.ypos * cosX - marker.getZpos * sinX;
        var z1:Number = marker.getZpos * cosX + marker.ypos * sinX;
        
        marker.ypos = y1;
         marker.setZpos = z1;
    }
    private function rotateY(marker:Marker, angleY:Number):void
    {
        var cosY:Number = Math.cos(angleY);
        var sinY:Number = Math.sin(angleY);
        
        var x1:Number = marker.xpos * cosY - marker.getZpos * sinY;
        var z1:Number = marker.getZpos * cosY + marker.xpos * sinY;
        
        marker.xpos = x1;
        marker.setZpos = z1;
    }
        
    private function doPerspective(marker:Marker):void
    {            
        if(marker.getZpos > -fl)
        {
            var scale:Number = fl / (fl + marker.getZpos);
            marker.scaleX = marker.scaleY = scale;
            marker.x = vpX + marker.xpos * scale;
            marker.y = vpY + marker.ypos * scale;
            marker.visible = true;
            if (marker.x + marker.width / 2 < 0 ) {
            		marker.x = stage.stageWidth + marker.width / 2;
				marker.xpos = (marker.x - vpX) / scale;
			}else if (marker.x - marker.width / 2 > stage.stageWidth ) {
				marker.x = 0 - marker.width / 2;
				marker.xpos = (marker.x - vpX) / scale;
			}
			
			if (marker.y + marker.height / 2 < 0 ) {
				marker.y = stage.stageHeight + marker.height / 2;
				marker.ypos = (marker.y - vpY) / scale;
			}else if (marker.y - marker.height / 2 > stage.stageHeight ) {
				marker.y = 0 - marker.height / 2;
				marker.ypos = (marker.y - vpY) / scale;
			}
        }
        else
        {
            marker.visible = false;
        }
    }
        
    private function sortZ():void
    {
        markers.sortOn("zpos", Array.DESCENDING | Array.NUMERIC);
        for(var i:uint = 0; i < num; i++)
        {
            var marker:Marker = markers[i];
            setChildIndex(marker, i);
        }
    }
}
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.events.MouseEvent;
import frocessing.color.FColor;
    
class Marker extends Sprite {
    public static var fogStart:Number = -100; 
    public static var fogEnd:Number = 250;
        
    public var radius:Number;
    public var xpos:Number = 0;
    public var ypos:Number = 0;
    public var zpos:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    public var mass:Number = 1;
    
    private var filter:DropShadowFilter;
    private var color:uint = 0xAAff33;
    private var filtercolor:uint = 0x99ff33;
    private var ct:FColor = new FColor();
    
    public function Marker(radius:Number=40) {
        this.radius = radius;
        init();
    }
    public function init():void {
        filter = new DropShadowFilter();
        this.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        this.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
    }
    
    public function set setZpos(z:Number):void {
        this.zpos = z;
        drawMarker();
    }
    
    public function get getZpos():Number {
        return this.zpos;
    }
    
    public function drawMarker():void {
        this.visible = true;
        this.alpha = 1;
        if (zpos<fogStart) {
            draw(color,filtercolor);
        }else if (zpos>=fogStart&&zpos<0) {
            draw(0xBBBBBB,0xBBBBBB);
        } else if(zpos>=0&&zpos<fogEnd){
            ct.value = 0xCCCCCC;
            ct.v /= (fogEnd - zpos) / fogEnd;
            if (ct.v > 0.8) ct.v = 0.8;
            this.alpha = (fogEnd - zpos) / fogEnd;
            draw(ct.value,ct.value);
        }else{
            this.graphics.clear();
        }
    }
        
    public function draw(c:uint,fc:uint):void {
        this.graphics.clear();            
        this.graphics.beginFill(0xFFFFF, 0);
        this.graphics.lineStyle(radius, c);
        this.graphics.drawCircle(0, 0, 1.5*radius);        
        this.graphics.endFill();
           
        filter.alpha = 0.8;
        filter.distance = 0;
        filter.blurX = 9;
        filter.blurY = 9;
        filter.color = fc;
        filter.quality = 3;
        this.filters = [filter];
    }
        
    private function onMouseOver(e:MouseEvent):void 
    {
        color = 0xFF33FF;
        filtercolor = 0xFF99FF;
        drawMarker();
    }
        
    private function onMouseOut(e:MouseEvent):void 
    {
        color = 0xAAff33;
        filtercolor = 0x99ff33;
        drawMarker();
    }
}




