/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wMFS
 */

package {
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _bulletArray:Array;
        private var _frame:uint;
        
        public function FlashTest() {
            _bulletArray = new Array();
            _frame = 0;
            this.addEventListener(Event.ENTER_FRAME, update);
        }
                
        private function update(e:Event):void {
            ++_frame;
            if (_frame % 1 == 0) {
                var deg:Number = _frame * 10 % 1080;
                var rad:Number = deg * Math.PI / 180.0;
                var color:uint = 0;
                if (deg > 720)      color = (((deg - 720) / 360 * 255) << 16) + (255 << 8);
                else if (deg > 360) color = (((deg - 360) / 360 * 255) << 8)  + (255 << 0);
                else                color = (((deg -   0) / 360 * 255) << 0)  + (255 << 16);

                var cos:Number = Math.cos(rad);
                var sin:Number = Math.sin(rad);
                var pos:Point = new Point(232.5, 82.5);
                var speed:Number = 3.0;
                var vel:Point = new Point(speed * cos, speed * sin - 2.0);
                var newBullet:Bullet = new Bullet(pos, vel, color);
                this.addChild(newBullet);
                _bulletArray.push(newBullet);
            }
            
            for each (var bullet:Bullet in _bulletArray) {
                bullet.update();
            }
            
            for (var index:uint = 0; index < _bulletArray.length; ++index) {
                if (_bulletArray[index].isDead) {
                    this.removeChild(_bulletArray[index]);
                    _bulletArray.splice(index, 1);
                    --index;
                    continue;
                }
            }
        } 
    }
}
import flash.geom.Point;
import flash.display.Sprite;

class Bullet extends Sprite {
    public function get isDead():Boolean { return _isDead; }
    
    private var _pastPos:Array;
    private var _vel:Point;
    private var _color:uint;
    private var _isDead:Boolean;

    private const RADIUS:Number = 2.0;
    
    public function Bullet(pos:Point, vel:Point, color:uint) {
        _pastPos = new Array();
        _vel = vel;
        _isDead = false;
        _color = color;
        this.x = pos.x;
        this.y = pos.y;
    }
    
    public function update():void {
        if (_isDead) return;
   
        var length:Number = _vel.length;
        _vel.x *= 0.99;
        _vel.y += 0.15;
        if (_vel.y > 3) _vel.y = 3;
        
        this.x += _vel.x;
        this.y += _vel.y;

        _pastPos.push(new Point(this.x, this.y));
        if (_pastPos.length > 20) {
            _pastPos.splice(0, 1);
        }
        this.graphics.clear();
        for (var index:uint = 0; index < _pastPos.length; ++index) {
            this.graphics.beginFill(_color, 1.0 - (index * 0.05));
            this.graphics.drawCircle(_pastPos[_pastPos.length - index - 1].x - x, _pastPos[_pastPos.length - index - 1].y - y, RADIUS);
            this.graphics.endFill();
        }
        
        var border:Number = 100;
        if ((this.x < -border)
            || (this.x > 456 + border)
            || (this.y < -border)
            || (this.y > 456 + border)
            ) {
            _isDead = true;
        }
    }
}
