/**
 * Copyright kappaLab ( http://wonderfl.net/user/kappaLab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wLzR
 */

package  
{
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;

    public class DrawCreature extends Sprite 
    {
        
        private var gr:Graphics
        private var sX:Number;
        private var sY:Number;
        private var mX:Number;
        private var mY:Number;
        private var eX:Number;
        private var eY:Number;
        
        private var posints:Vector.<Vector.<Number>>
        
        private var drawingEnable:Boolean = false;
        private var bmd:BitmapData;
        private var bm:Bitmap;
        
        private var canvas:Sprite
        
        public function DrawCreature() 
        {
            stage.scaleMode = "noScale";
            hitArea = new Sprite();
            hitArea.graphics.beginFill(0x000000);
            hitArea.graphics.drawRect(0, 0, 1000, 1000);
            addChild(hitArea)
            
            canvas = new Sprite()
            gr = Sprite(canvas.addChild(new Sprite())).graphics
            
            bmd = new BitmapData(800, 600,true,0x00000000);
            bm = new Bitmap(bmd);
            addChild(bm)
            
            mX = mY = 0
            
            addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown)
            addEventListener(MouseEvent.MOUSE_UP,  onMouseUp)
            addEventListener(Event.ENTER_FRAME,    addBlur)
            addEventListener(Event.ENTER_FRAME,    drawDitection)
            
        }
        
        private function drawDitection(e:Event = null):void
        {
            if (!drawingEnable) return;
            
            var mouseX:Number = this.mouseX
            var mouseY:Number = this.mouseY
            
            var dX:Number = (mouseX-mX)
            var dY:Number = (mouseY-mY)
            var distance:Number = Math.sqrt(dX*dX+dY*dY)
            
            if (distance < 10) return;
            
            
            
            var point:Vector.<Number> = new Vector.<Number>(2)
            point[0] = mX
            point[1] = mY
            posints.push(point);
            gr.moveTo(mX, mY);
            gr.lineTo(mouseX,  mouseY);
            
            mX = mouseX;
            mY = mouseY;
            
        }
        
        private function addBlur(e:Event = null):void
        {
            //bmd.colorTransform(bmd.rect, new ColorTransform(1, 1, 1, 1, 0x11, 0x11, 0x11, 0));
            bmd.draw(canvas);
            bmd.applyFilter(bmd, bmd.rect, new Point(0, 0), new BlurFilter());
        }
        
        private function onMouseUp(e:MouseEvent):void 
        {
            drawingEnable = false
            
            var point:Vector.<Number> = new Vector.<Number>(2)
            point[0] = mX
            point[1] = mY
            posints.push(point);
            
            gr.clear()
            
            if (posints.length < 2) return;
            canvas.addChild(new Creature(posints))
        }
        
        private function onMouseDown(e:MouseEvent):void 
        {
            drawingEnable = true;
            gr.beginFill(0xFF0000);
            gr.lineStyle(1, 0xFF0000);
            
            
            sX = mX = e.stageX
            sY = mY = e.stageY
            posints = new Vector.<Vector.<Number>>() 
        }
        
    }
    
}

import flash.display.*
import flash.events.Event;
class Creature extends Sprite
{
    public var points:Vector.<Vector.<Number>>
    private var gr:Graphics
    public function Creature(points:Vector.<Vector.<Number>>)
    {
        this.points = points
        gr = this.graphics
        gr.beginFill(0x00FF00)
        //gr.lineStyle(1,0x00FF00)
        addEventListener(Event.ENTER_FRAME,onEnterFrame)
        
        draw()
    }
    
    private function draw():void
    {
        gr.clear()
        gr.beginFill(0x00FF00)
        //gr.lineStyle(1,0x00FF00)
        gr.moveTo(points[0][0],points[0][1])
        var n:int = points.length
        for (var i:int = 1; i < n; i++) 
        {
            gr.lineTo(points[i][0],points[i][1])
        }
        gr.lineTo(points[0][0],points[0][1])

    }
    
    private function transformPoint():void
    {
        var n:int = points.length
        for (var i:int = 0; i < n; i++) 
        {
            points[i][0] += -2.5+Math.random()*5
            points[i][1] += -2+Math.random()*5
        }
    }
    
    private function onEnterFrame(e:Event):void 
    {
        if (Math.random() > .5) return;
        transformPoint()
        scaleX -= .01
        scaleY -= .01
        draw()
    }
}