/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wLlM
 */

package {

	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;

	public class Main extends Sprite {

		private var kuma:Kuma;

		private function atEveryFrame(e:Event):void {
			var t:Number = getTimer()*Math.PI/600;
			t -= Math.floor(t/Math.PI*2)*Math.PI*2;
			kuma.setArmAngle(1,15+45*(1+Math.cos(t))/2);
			kuma.setArmAngle(2,15+45*(1-Math.cos(t))/2);
			kuma.setLegRaise(2,12*Math.max(0,-Math.cos(t)));
			kuma.setLegRaise(1,12*Math.max(0,Math.cos(t)));
			kuma.x = 232.5 + 3*Math.cos(t);
		}

		private function initialize(e:Event):void {
			this.removeEventListener(Event.ADDED_TO_STAGE, initialize);
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			this.graphics.beginFill(0x0099ff);
			this.graphics.drawRect(0,0,465,320);
			this.graphics.endFill();
			this.graphics.beginFill(0x33cc66);
			this.graphics.drawRect(0,320,465,145);
			this.graphics.endFill();
			kuma = new Kuma();
			kuma.x = 232.5;
			kuma.y = 232.5;
			addChild(kuma);
			kuma.haveFlower(new Flower);
			addEventListener(Event.ENTER_FRAME, atEveryFrame);
		}

		public function Main():void {
			if ( stage != null ) {
				initialize(null);
			} else {
				this.addEventListener(Event.ADDED_TO_STAGE, initialize);
			}
		}

	} // end of class Main
} // end of package

import flash.display.*;
class Kuma extends Sprite {
	public static const pcolor:uint = 0x996600; // 塗り色
	public static const lcolor:uint = 0x000000; // 線の色
	public static const HEAD_Y:Number = -105;
	public static const HEAD_W:Number = 80;
	public static const HEAD_H:Number = 80;
	public static const TRUNK_H:Number = 160;
	public static const TRUNK_W:Number = 100;
	public static const ARM_T:Number = 40;
	public static const ARM_L:Number = 100;
	public static const LEG_T:Number = 44;
	public static const LEG_L:Number = 100;
	public static const ARM_JOINT_Y:Number = -TRUNK_H/4;
	public static const ARM_JOINT_X:Number = TRUNK_W/3-3;
	public static const LEG_JOINT_X:Number = 30;
	public static const LEG_JOINT_Y:Number = TRUNK_H*0.333;
	private var leftArm:Sprite;
	private var rightArm:Sprite;
	private var leftLeg:Sprite;
	private var rightLeg:Sprite;
	private var trunk:Sprite;
	private var head:KumaFace;
	public function regenerate():void {
		// 再描画する
		// 左腕
		leftArm.graphics.clear();
		leftArm.graphics.lineStyle(0,lcolor);
		leftArm.graphics.beginFill(pcolor);
		leftArm.graphics.drawEllipse(-3,-ARM_T/2,ARM_L,ARM_T);
		leftArm.graphics.endFill();
		leftArm.x = ARM_JOINT_X;
		leftArm.y = ARM_JOINT_Y;
		// 右腕
		rightArm.graphics.clear();
		rightArm.graphics.lineStyle(0,lcolor);
		rightArm.graphics.beginFill(pcolor);
		rightArm.graphics.drawEllipse(3,-ARM_T/2,-ARM_L,ARM_T);
		rightArm.graphics.endFill();
		rightArm.x = -ARM_JOINT_X;
		rightArm.y = ARM_JOINT_Y;
		// 胴体
		trunk.graphics.clear();
		trunk.graphics.lineStyle(0,lcolor);
		trunk.graphics.beginFill(pcolor);
		trunk.graphics.drawEllipse(-TRUNK_W/2,-TRUNK_H/2,TRUNK_W,TRUNK_H);
		trunk.graphics.endFill();
		trunk.x = 0;
		trunk.y = 0;
		// 左脚
		leftLeg.graphics.clear();
		leftLeg.graphics.lineStyle(0,lcolor);
		leftLeg.graphics.beginFill(pcolor);
		leftLeg.graphics.drawEllipse(-LEG_T/2,0,LEG_T,LEG_L);
		leftLeg.graphics.endFill();
		leftLeg.x = LEG_JOINT_X;
		leftLeg.y = LEG_JOINT_Y;
		// 右脚
		rightLeg.graphics.clear();
		rightLeg.graphics.lineStyle(0,lcolor);
		rightLeg.graphics.beginFill(pcolor);
		rightLeg.graphics.drawEllipse(-LEG_T/2,0,LEG_T,LEG_L);
		rightLeg.graphics.endFill();
		rightLeg.x = -LEG_JOINT_X;
		rightLeg.y = LEG_JOINT_Y;
		// 顔
		head.graphics.clear();
		head.scaleX = 3.3;
		head.scaleY = 3.0;
		head.redraw();
	}
	public function setArmAngle(which:int,angle:Number):void {
		if (which & 1) {
			leftArm.rotation = angle;
		}
		if (which & 2) {
			rightArm.rotation = -angle;
		}
	}
	public function setLegRaise(which:int,amount:Number):void {
		if (which & 1) {
			leftLeg.y = LEG_JOINT_Y - amount;
		}
		if (which & 2) {
			rightLeg.y = LEG_JOINT_Y - amount;
		}
	}
	public function haveFlower(flower:DisplayObject):void {
		if ( flower ) {
			flower.x = -ARM_L+15;
			flower.y = 0;
			rightArm.addChild(flower);
		}
	}
	public function discardFlower(flower:DisplayObject):void {
		rightArm.removeChild(flower);
	}
	public function Kuma():void {
		// 各部のスプライトを生成
		leftLeg = new Sprite;
		rightLeg = new Sprite;
		leftArm = new Sprite;
		rightArm = new Sprite;
		trunk = new Sprite;
		head = new KumaFace;
		// 必要なパラメータを設定
		leftArm.x = ARM_JOINT_X;
		leftArm.y = ARM_JOINT_Y;
		rightArm.x = -ARM_JOINT_X;
		rightArm.y = ARM_JOINT_Y;
		trunk.x = 0;
		trunk.y = 0;
		leftLeg.x = LEG_JOINT_X;
		leftLeg.y = LEG_JOINT_Y;
		rightLeg.x = -LEG_JOINT_X;
		rightLeg.y = LEG_JOINT_Y;
		head.x = 0;
		head.y = HEAD_Y;
		// 腕 胴 脚 顔 の順に表示リストに登録していく
		this.addChild(leftArm);
		this.addChild(rightArm);
		this.addChild(trunk);
		this.addChild(leftLeg);
		this.addChild(rightLeg);
		this.addChild(head);
		// 描画する
		regenerate();
	}
}


/* クマ顔のスプライト */
class KumaFace extends Sprite {
	private const pcolor:uint = Kuma.pcolor; // 塗り色
	private const lcolor:uint = Kuma.lcolor; // 線の色
	public function redraw():void {
		// クマ耳
		graphics.beginFill(pcolor);
		graphics.lineStyle(0,lcolor);
		graphics.drawCircle(-16,-13,9);
		graphics.drawCircle( 16,-13,9);
		graphics.endFill();
		// クマ顔面
		graphics.beginFill(pcolor);
		graphics.lineStyle(0,lcolor);
		graphics.drawCircle(0,0,20);
		graphics.endFill();
		// クマ口
		graphics.lineStyle(2,lcolor);
		graphics.moveTo(-7,11);
		graphics.lineTo( 0, 7);
		graphics.lineTo( 7,11);
		// クマ鼻
		graphics.lineStyle(0,lcolor);
		graphics.beginFill(lcolor);
		graphics.moveTo(-3, 2);
		graphics.lineTo( 3, 2);
		graphics.lineTo( 1, 6);
		graphics.lineTo(-1, 6);
		graphics.lineTo(-3, 2);
		graphics.endFill();
		// クマ目
		graphics.beginFill(lcolor);
		graphics.drawEllipse(-12.5, -2,3,4);
		graphics.drawEllipse(  9.5, -2,3,4);
		graphics.endFill();
	}
	public function KumaFace():void {
		redraw();
	}
}

// 花のスプライト
class Flower extends Sprite {
	private const Xc:Number = 0;
	private const Yc:Number = -20;
	private const X0:Number = -10;
	private const Y0:Number = -20-10*Math.sqrt(3);
	public function Flower():void {
		this.graphics.clear();
		this.graphics.lineStyle(4,0x008000);
		this.graphics.moveTo(0,0);
		this.graphics.curveTo(Xc,Yc,X0,Y0);
		this.graphics.lineStyle(NaN,0xff66cc);
		this.graphics.beginFill(0xff0000);
		this.graphics.drawCircle(X0-6,Y0,5);
		this.graphics.endFill();
		this.graphics.beginFill(0xff0000);
		this.graphics.drawCircle(X0,Y0-6,5);
		this.graphics.endFill();
		this.graphics.beginFill(0xff0000);
		this.graphics.drawCircle(X0+6,Y0,5);
		this.graphics.endFill();
		this.graphics.beginFill(0xff0000);
		this.graphics.drawCircle(X0,Y0+6,5);
		this.graphics.endFill();
		this.graphics.beginFill(0xffcc66);
		this.graphics.drawCircle(X0,Y0,6);
		this.graphics.endFill();
	}
}