/**
 * Copyright kimo0517 ( http://wonderfl.net/user/kimo0517 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wKps
 */

/*
 * @Author: kimo0517
 * works with Image to Base64 Encoder 
 * http://wonderfl.net/c/soNh
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.FocusEvent;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.desktop.Clipboard;
    import flash.desktop.ClipboardFormats;
    import com.bit101.components.PushButton;
    import flash.utils.ByteArray;
    
    import flash.net.FileReference;
    import flash.net.FileFilter;
    
    import mx.utils.Base64Decoder;
    
    [SWF(width=468, height=468, backgroundColor=0xAADDFF)]
    public class Base64ToImage extends Sprite 
    {
        private var imgBytesLoaded:ByteArray = null;
        private var bmd:Bitmap;
        private var tf:TextField;
        private var btnConvertToPic:PushButton;
        private var btnSavePic:PushButton;
        private var fr:FileReference;
        
        public function Base64ToImage():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            tf = new TextField;
            tf.textColor = 0x000000;
            tf.multiline = false;
            tf.background = true;
            tf.width = 450;
            tf.height = 20;
            tf.x = 5;
            tf.y = 5;
            tf.type = TextFieldType.INPUT; 
            tf.text = "Paste Base64 String here";
            tf.addEventListener(FocusEvent.FOCUS_IN, _selectTFText);
            addChild(tf);
            
            btnConvertToPic = new PushButton(this, 5, 25, "Convert To Photo", _btnConvertToPicClicked);
            btnSavePic = new PushButton(this, btnConvertToPic.x + btnConvertToPic.width, 25, "Save Photo", _btnSavePicClicked);
            
            bmd = new Bitmap;
            bmd.y = btnConvertToPic.y + btnConvertToPic.height + 5;
            bmd.smoothing = true;
            addChild(bmd);
        }
        
        private function _selectTFText(e:FocusEvent):void {
            tf.text = "";
        }
        
        private function _btnConvertToPicClicked(e:MouseEvent):void {
            if (tf.text == "") {
                tf.text = "Paste Base64 String here";
                return;
            }
            
            var base64Decoder:Base64Decoder = new Base64Decoder;
            try {
                base64Decoder.decode(tf.text);
                imgBytesLoaded = base64Decoder.toByteArray();
            } catch (e:Error) {
                tf.text = "input string is not photo!";
                return;
            }
            tf.text = "";
            
            if (bmd.bitmapData != null) {
                bmd.bitmapData.dispose();
                bmd = null;
            }
            
            var loader:Loader = new Loader;
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _loadBMDComplete);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, _loadBMDError);
            loader.loadBytes(imgBytesLoaded);
        }
        
        private function _loadBMDError(e:Event):void {
            tf.text = "input string is not photo!";
            imgBytesLoaded.clear();
            imgBytesLoaded = null;
        }
        
        private function _btnSavePicClicked(e:MouseEvent):void {
            if (imgBytesLoaded == null) {
                tf.text = "Load a photo first!";
                return;
            }
            
            fr = new FileReference();
            fr.save(imgBytesLoaded);
        }
        
        private function _loadBMDComplete(e:Event):void {
            if (bmd.bitmapData != null) {
                bmd.bitmapData.dispose();
            }
            bmd.bitmapData = e.target.content.bitmapData.clone();
            bmd.height = 468 - bmd.y;
            bmd.width = 468;
            if (bmd.scaleX < bmd.scaleY) {
                bmd.scaleY = bmd.scaleX;
            } else {
                bmd.scaleX = bmd.scaleY;
            }
            
            tf.text = "Photo loaded!";
        }
        
    }
    
}