/**
 * Copyright Hrundik ( http://wonderfl.net/user/Hrundik )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wKHS
 */

package {
    import flash.media.Microphone;
    import flash.utils.setInterval;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.text.TextFieldType;
    import flash.text.TextField;
    import flash.events.NetStatusEvent;
    import flash.net.NetStream;
    import flash.net.NetConnection;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var nc:NetConnection;
        private var ns:NetStream;
        
        private var tf:TextField;
        
        private var idTF:TextField;
        
        private var c:int = 0;
        
        public function FlashTest() {
           nc = new NetConnection();
           nc.connect("rtmfp://p2p.rtmfp.net/0e95aa45e82642032440fddb-86f8dbbeac93/");
           nc.addEventListener(NetStatusEvent.NET_STATUS, onStatus);      
           
           idTF = new TextField();
           idTF.border = true;
           idTF.type = TextFieldType.INPUT;
           idTF.height = 16;
           idTF.width = 400;
           idTF.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
           addChild(idTF);
           
           tf = new TextField();
           tf.y = 20;
           tf.width = 400;
           tf.height = 400;
           tf.border = true;
           addChild(tf);
        }
        
        private function onTimer():void
        {
            //tf.appendText("msg\n");
            ns.send("message", "Hello " + ++c);
        }

        
        private function onStatus(e:NetStatusEvent):void
        {
            tf.appendText(e.info.code + "\n" + nc.nearID + "\n");
            if (e.info.code == "NetConnection.Connect.Success")
               tf.appendText("Connected\n");
        }
        
        private function startPublishing():void
        {
           ns = new NetStream(nc, NetStream.DIRECT_CONNECTIONS); 
           //ns.attachAudio(Microphone.getMicrophone());
           ns.addEventListener(NetStatusEvent.NET_STATUS, onStatus);
           ns.publish("chat");
        }
        
        private function playStream(id:String):void
        {
            ns = new NetStream(nc, id);
            ns.addEventListener(NetStatusEvent.NET_STATUS, onStatus);
            ns.play("chat");
            ns.client = {message: function (msg:String):void {tf.appendText("<--" + msg + "\n");}};
        }


        
        private function onKeyDown(ke:KeyboardEvent):void
        {
            if (ke.keyCode == Keyboard.ENTER)
            {
                tf.text = "enter";
                if (idTF.text)
                {
                    playStream(idTF.text);
                }
                else
                {
                    startPublishing();
                    setInterval(onTimer, 1000);
                }
            }
        }


    }
}