/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wJv0
 */

package {
    import flash.net.URLLoader;
    import flash.utils.ByteArray;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLStream;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.*;
    import flash.geom.*;
    
    
    public class Jelly extends Sprite {
        public var loaderImg : Loader = new Loader;
        public var loaderShader:URLLoader = new URLLoader;
        public var shader:Shader = new Shader;
        public var bmp:Bitmap;
        public var sp:Sprite = new Sprite
        
        public function Jelly() {
            loaderImg.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoadedHandler);
            loaderImg.load(new URLRequest("http://www.bongiovi.tw/wonderfl/mood.jpg"), new LoaderContext(true));
            graphics.beginFill(0);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
        }
        
        public function onImageLoadedHandler(e:Event) : void {
            bmp = Bitmap(loaderImg.content);
            sp.addChild(bmp);
            addChild(sp);
            sp.y = (465 - sp.height) * .5;
            
            loaderShader.dataFormat = URLLoaderDataFormat.BINARY;
            loaderShader.addEventListener(Event.COMPLETE, onShaderLoadedHandler);
            loaderShader.load(new URLRequest("http://www.bongiovi.tw/wonderfl/RadiusDisplacement.pbj"));
        }
        
        
        public function onShaderLoadedHandler(e:Event) : void {
            shader.byteCode = loaderShader.data;
            sp.addEventListener(MouseEvent.CLICK, onClickHandler);
        }


        public function onClickHandler(e:MouseEvent) : void {
            var tx:Number = e.localX - RippleBlock.W*.5;
            var ty:Number = e.localY - RippleBlock.W*.5;
            var mtx:Matrix = new Matrix;
            mtx.translate(-tx, -ty);
            var bmpd:BitmapData = new BitmapData(RippleBlock.W, RippleBlock.W, true, 0);
            bmpd.draw(bmp, mtx);
            
            var block:RippleBlock = new RippleBlock(bmpd, shader);
            addChild(block);
            block.x = tx;
            block.y = ty + sp.y;
            block.start();
        }
    }
}


import caurina.transitions.Tweener;

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shader;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.filters.ShaderFilter;
import flash.geom.Point;
import flash.utils.ByteArray;


class RippleBlock extends Sprite {
    
    public static const W : int = 150;
    public var scale : Number = 100;
    public var radius : Number = W*.5;
    private var __shader : Shader;
    private var __bmp  : Bitmap;
    
    public function RippleBlock(bmpd:BitmapData, shader:Shader) : void {
        __shader = shader;
        __bmp = new Bitmap(bmpd);
        __bmp.smoothing = true;
        addChild(__bmp);
        
        __shader.data.center.value = [width*.5, height*.5];
        var bmpd:BitmapData = new BitmapData(width, height);
        bmpd.perlinNoise(width, height, 9, Math.random()*0xFFFF, false, true, 7);
        bmpd.applyFilter(bmpd, bmpd.rect, new Point, new BlurFilter(3, 3, 3));
        __shader.data.srcPerlin.input = bmpd;
        
        mouseChildren = false;
        mouseEnabled = false;
    }
    
    
    public function start() : void {
        Tweener.addTween(this, {time:1, transition:"easeOutSine", radius:W*.8});
        Tweener.addTween(this, {time:1, transition:"easeOutElastic", scale:0, onUpdate:render, onComplete:_onEnd});
    }
    
    
    public function render(e:Event=null) : void {
        __shader.data.scale.value = [scale];
        __shader.data.radius.value = [radius];
        filters = [new ShaderFilter(__shader)];
    }
    
    
    protected function _onEnd(e:Event=null) : void {
        dispatchEvent(new Event(Event.COMPLETE));
        release();
    }
    
    
    public function release() : void {
        filters = null;
        parent.removeChild(this);
    }
}



/* RadiusDisplacement.pbk

<languageVersion : 1.0;>

kernel RadiusDisplacement
<   namespace : "bongiovi.tw";
    vendor : "bongiovi";
    version : 1;
    description : "RadiusDisplacement";
>
{
    input image4 src;
    input image4 srcPerlin;
    output pixel4 dst;
    
    parameter float2 center
    <
        minValue:float2(0.0, 0.0);
        maxValue:float2(2000.0, 2000.0);
        defaultValue:float2(300.0, 200.0);
    >;
    
    
    parameter float radius
    <
        minValue:0.0;
        maxValue:1000.0;
        defaultValue:300.0;
    >;
    
    
    parameter float scale
    <
        minValue:0.0;
        maxValue:1000.0;
        defaultValue:10.0;
    >;
    
    
    
    void
    evaluatePixel()
    {
        float2 pos = outCoord();
        float4 perlin = sampleLinear(srcPerlin, pos);
        float offset = 1.0 - distance(pos, center) / radius;
        if(offset < 0.0) offset = 0.0;
        float2 temp = float2( (perlin.r-0.5) * offset, (perlin.g-0.5) * offset);
        dst = sampleLinear(src, pos+temp*scale);
        
    }
}


*/