/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wI8l
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;

	public class ThrowingDocument extends Sprite {
		private var _ball:Ball;
		private var _vx:Number = 0;
		private var _vy:Number = 0;
		private var _bounce:Number = -0.7;
		private var _gravity:Number = .5;
		private var _oldX:Number;
		private var _oldY:Number;
		
		private var _velText:TextField;
		public function ThrowingDocument() {
			init();
		}

		private function init():void {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var tex:TextField = new TextField  ;
			addChild(tex);
			tex.width = 450;
			tex.x = tex.y = 10;
			tex.multiline = true;
			tex.textColor = 0xffffff;
			tex.text = 'ボールを投げる事ができます。摩擦や重力などの係数も設定してあります。\n';
			
			addChild(_velText = new TextField);
			_velText.width = 200;
			_velText.height = 16;
			_velText.x = stage.stageWidth - (_velText.width + 10)
			_velText.y = 30;
			_velText.textColor = 0xffffff;
			_velText.borderColor = 0x333333;


			// 背景を黒で塗りつぶします。
			graphics.beginFill(0x000000);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			// ステージ上にスプライトを配置します。
			addChild(_ball = new Ball);
			_ball.x = stage.stageWidth / 2;
			_ball.y = stage.stageHeight / 2;
			//
			_vx = Math.random() * 10 -5 ;
			_vy = -10;
			// イベントハンドルを設定します。
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			_ball.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			
		}
		private function enterFrameHandler($event:Event):void {
			_vy += _gravity;
			_ball.x += _vx;
			_ball.y += _vy;
			//
			var left:Number = 0;
			var right:Number = stage.stageWidth;
			var top:Number = 0;
			var bottom:Number = stage.stageHeight;
			// ステージ内にスプライトを保つ処理を入れます。
			
			
			if(_ball.x + _ball.radius > right){
				_ball.x = right - _ball.radius;
				_vx *= _bounce;
			}else if(_ball.x - _ball.radius < left){
				_ball.x = left + _ball.radius;
				_vx *= _bounce
			}
			
			if(_ball.y + _ball.radius > bottom){
				_ball.y = bottom - _ball.radius;
				_vy *= _bounce;
			}else if(_ball.y - _ball.radius < top){
				_ball.y = top + _ball.radius;
				_vy *= _bounce;
			}
			_velText.text = 'velocity: x = ' + (_vx | 0) + ', y = ' + (_vy | 0) + ' px / frame'; 
		}

		private function mouseDownHandler($event:MouseEvent):void{
			_oldX = _ball.x;
			_oldY = _ball.y;
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			_ball.startDrag();
			removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			addEventListener(Event.ENTER_FRAME, trackVelocity);
			
			_velText.text = 'velocity: x = ' + '-' + ', y = ' + '-' + ' px / frame'; 
		}
		
		private function mouseUpHandler($event:MouseEvent):void{
			stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			_ball.stopDrag();
			removeEventListener(Event.ENTER_FRAME, trackVelocity);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function trackVelocity($event:Event):void{
			_vx = _ball.x - _oldX;
			_vy = _ball.y - _oldY;
			_oldX = _ball.x;
			_oldY = _ball.y;
		}
	}
}

import flash.display.Sprite;
class Ball extends Sprite {
	private var _radius:Number = 10;
	function Ball(){
		init();
	}
	
	private function init():void{
		graphics.beginFill(0x000000);
		graphics.lineStyle(0, 0x999999);
		graphics.drawCircle(0, 0, _radius);
	}
	
	public function get radius():Number{
		return _radius;
	}
}