/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wI6P
 */

// 自分用
// 
package {
	import flash.display.BitmapData;
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
		private var g:Graphics;
		private var bmpdata:BitmapData;
		private var sp:Sprite;
        public function FlashTest() {
			stage.quality = StageQuality.LOW;
			
            sp = new Sprite();
			addChild(sp);
			g = sp.graphics;
			sp.x = stage.stageWidth * .5;
			sp.y = stage.stageHeight * .5;
			
			drawFractal(2);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mousedownHandler);
        }
		
		private var drawNum:int = 2;
		private function mousedownHandler(e:MouseEvent):void 
		{
			g.clear();
			drawFractal(++drawNum);
			if (drawNum >= 5) drawNum = 0;
		}
		
		private var firstn:int = -1;
		private function drawFractal(n:int = 0, x:Number = 0, y:Number = 0, r:Number = 80, angle:Number = 0):void
		{
			if (--n < 0)
			{
				return;
			}
			if (firstn == -1)
			{
				firstn = n;
				g.beginFill(0x80C0C0);
			}
			var a:Number = angle;
			g.moveTo(x + Math.cos(angle) * r, y + Math.sin(angle) * r);
			for (var i:int = 0; i < 5; i++)
			{
				a += 60 / 180 * Math.PI;
				g.lineTo(x + Math.cos(a) * r, y + Math.sin(a) * r);
			}
			
			a = (a - 30 / 180 * Math.PI) % (Math.PI * 2);
			for (i = 0; i < 2; i++)
			{
				a += 60 / 180 * Math.PI;
				drawFractal(n, x + Math.cos(a) * r, y + Math.sin(a) * r, r * .75, a);
			}
			if (firstn == n)
			{
				firstn = -2;
				drawFractal(n + 1, 0, 0, 80, angle + Math.PI*2/3);
				drawFractal(n + 1, 0, 0, 80, angle - Math.PI*2/3);
				firstn = -1;
				g.endFill();
			}
		}
    }
}