/**
 * Copyright tama ( http://wonderfl.net/user/tama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wHyJ
 */

// forked from tama's forked from: Alternativa3D Hello World 2
// forked from designquest's Alternativa3D Hello World 2
// forked from designquest's flash on 2009-8-15
// add one more box2
// shift box2 to right

package {
	import alternativ5.engine3d.controllers.CameraController;
	import alternativ5.engine3d.core.Camera3D;
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.engine3d.core.Scene3D;
	import alternativ5.engine3d.display.View;
	import alternativ5.engine3d.materials.WireMaterial;
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.utils.FPS;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;

	[SWF(backgroundColor="#000000", frameRate="100")]

	public class HelloAlternativa3D extends Sprite	{
		
		private var scene:Scene3D;
		private var view:View;
		private var camera:Camera3D;
		private var cameraController:CameraController;
		private var box1:Box;
		private var box2:Box;
		private var box3:Box;
		
		public function HelloAlternativa3D()	{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}

		public function init(e:Event): void {
			removeEventListener(Event.ADDED_TO_STAGE, init);

			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			// Creating scene
			scene = new Scene3D();
			scene.root = new Object3D();

			// Box 1
			box1 = new Box(100, 100, 100, 1, 1, 1);
			box1.cloneMaterialToAllSurfaces(new WireMaterial(1, 0x0000FF));
			scene.root.addChild(box1);

			// Box 2
			box2 = new Box(100, 100, 100, 1, 1, 1);
			box2.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFF0000));
			scene.root.addChild(box2);
			box2.x = 110;

			// Box 3
			box3 = new Box(100, 100, 100, 1, 1, 1);
			box3.cloneMaterialToAllSurfaces(new WireMaterial(1, 0x00FF00));
			scene.root.addChild(box3);
			box3.x = 55;
			box3.y = 110;
			
			// Adding camera and view
			camera = new Camera3D();
			camera.x = 100;
			camera.y = -150;
			camera.z = 100;
			scene.root.addChild(camera);
			
			view = new View();
			addChild(view);
			view.camera = camera;

			// Connecting camera controller
			cameraController = new CameraController(stage);
			cameraController.camera = camera;
			cameraController.setDefaultBindings();
			cameraController.checkCollisions = true;
			cameraController.collisionRadius = 20;
			cameraController.lookAt(box2.coords);
			cameraController.controlsEnabled = true;

			// FPS display launch
			FPS.init(stage);

			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			onResize(null);
		}
		
		private function onResize(e:Event):void {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}
		
		private function onEnterFrame(e:Event):void {
 			// Move Box
 			box1.rotationX += 0.01;
  			box2.rotationX += 0.01;
  			box3.rotationX += 0.01;
			// User input processing
			cameraController.processInput();
			// Scene calculating
			scene.calculate();
		}
	}
}