/**
 * Copyright 110100110101101 ( http://wonderfl.net/user/110100110101101 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wHPR
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    public class FlashTest
    extends Sprite 
    {
        public function FlashTest()
        {
            addEventListener( Event.ADDED_TO_STAGE, onAddedToStage );
        }
        private function onAddedToStage( event:Event ):void
        {
            addChild( new Test() );
        }
    }
}

    import flash.display.Sprite;
    import flash.events.Event;
    class Test
    extends Sprite
    {
        public function Test()
        {
            addChild( new Game() );
        }
    }
    
    
    //////////////////////////////
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    class Game
    extends Sprite
    {
        public function Game()
        {
            addEventListener( Event.ADDED_TO_STAGE, onAddedToStage );
        }
        public function onAddedToStage( event:Event ):void
        {
            new GameSceneInitialize( this );
        }
    }
    
    
    /////////////////////////////////////////////////////////////////////
    interface IGameScene
    {
        function open():void
        function close():void
    }
    /////////////////////
    import flash.display.Sprite;
    import flash.events.Event;
    class GameScene
    extends Sprite
    {
        public function GameScene( game:Game )
        {
            super();
            game.addChild( this );
        }
        public function dispatchEventOpen():void
        {
            super.dispatchEvent( new Event( Event.OPEN ) );
        }
        public function dispatchEventClose():void
        {
            super.dispatchEvent( new Event( Event.CLOSE ) );
        }
        public var game:Game;
    }
    
    ////////////////////
    // prepare
    class GameScenePrepare
    extends GameScene
    implements IGameScene
    {
        public function GameScenePrepare( game:Game )
        {
            super( game );
        }
        public function open():void
        {
            dispatchEventOpen();
        }
        public function close():void
        {
            dispatchEventClose();
        }
    }
    /////////////////////
    // initialize
    class GameSceneInitialize
    extends GameScene
    implements IGameScene
    {
        public function GameSceneInitialize( game:Game )
        {
            super( game );
            open();
        }
        public function open():void
        {
            new WidgetText( this, 0,0, "text"  )
            new WidgetTextDice( this, 0,20 )
            dispatchEventOpen();
        }
        public function close():void
        {
            dispatchEventClose();
            game.removeChild( this );
        }
        
    }
    
    
    
    
    /////////////////////////////////////////////////////////
    class Widget
    {
        public function initialize():void
        {
        }
        public var base:WidgetBase;
        public var text:WidgetText;
        public var textSlider:WidgetTextNumberSlider;
        public var rectangle:WidgetRectangle;
        public var dice:WidgetTextDice;
        public var exText:WidgetExText;
    }
    
    ////////////////////////////////////
    import flash.display.Sprite;
    class WidgetBase
    extends Sprite
    {
        public function WidgetBase( _displayObjectContainer:DisplayObjectContainer = undefined, _x:Number = 0, _y:Number = 0, _onAddedToStage:Function = null )
        {
            super();
            
            if( _onAddedToStage != null )
            {
                addEventListener( Event.ADDED_TO_STAGE, _onAddedToStage );
            }
            
            if( _displayObjectContainer )
            {
                _displayObjectContainer.addChild( this );
            }
            
            super.x = _x;
            super.y = _y;
            
        }
        public function addDragPuller( _puller:DisplayObject ):void
        {
            _puller.addEventListener( MouseEvent.MOUSE_DOWN, _onDragStart );
            _puller.addEventListener( MouseEvent.MOUSE_UP, _onDragStop );
        }
        public function removeDragPuller( _puller:DisplayObject ):void
        {
            _puller.removeEventListener( MouseEvent.MOUSE_DOWN, _onDragStart );
            _puller.removeEventListener( MouseEvent.MOUSE_UP, _onDragStop );
        }
        private function _onDragStart( event:MouseEvent ):void
        {
            startDrag();
        }
        private function _onDragStop( event:MouseEvent ):void
        {
            stopDrag();
        }
        public function doubleClickEnable():void
        {
            doubleClickEnabled = true;
            mouseChildren = false;
        }
        public function doubleClickDisable():void
        {
            doubleClickEnabled = false;
            mouseChildren = true;
        }
        public function setParent( displayObjectContainer:DisplayObjectContainer = undefined ):void
        {
            if( displayObjectContainer )
            {
                displayObjectContainer.addChild( this );
            }
        }
    }
    
    
    /////////////////////////////////////////////////////////
    import flash.display.DisplayObject;
    import flash.display.DisplayObjectContainer;
    import flash.events.Event;
    class WidgetTextNumberSlider
    extends WidgetBase
    {
        public function WidgetTextNumberSlider
            ( _displayObjectContainer:DisplayObjectContainer = undefined
            , _x:Number = 0
            , _y:Number = 0
            , _value:Number = 0
            , _min:Number = 0
            , _max:Number = 100
            , _xTick:Number = 1
            , _yTick:Number = 10 )
        {
            super( _displayObjectContainer, _x, _y, onAddedToStage );
            
            core = new WidgetTextNumberSliderCore();
            core.value = _value;
            core.min = _min;
            core.max = _max;
            core.xTick = _xTick;
            core.yTick = _yTick;
            
            view = new WidgetTextNumberSliderView();
            
            view.number = new WidgetText( this, 0, 0, core.value.toString() );
            view.number.textField.selectable = false;
            view.number.addEventListener( MouseEvent.MOUSE_DOWN, onMouseDown );
            
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
        }
        // private function
        private function onAddedToStage( event:Event ):void
        {
            stage.addEventListener( MouseEvent.MOUSE_UP, onMouseUp );
        }
        private function onMouseDown( event:MouseEvent ):void
        {
            core.originX = mouseX;
            core.originY = mouseY;
            core.oldValue = core.value;
            seeking = true;
        }
        private function onMouseUp( event:MouseEvent ):void
        {
            seeking = false;
        }
        private function onEnterFrame( event:Event ):void
        {
            core.value = Number( view.number.textField.text )
            if( seeking )
            {
                core.diffX = ( mouseX - core.originX ) >> 2;
                core.diffY = ( mouseY - core.originY ) >> 4;
                core.value =  core.oldValue + ( core.diffX * core.xTick ) + ( core.diffY * core.yTick );
                if( core.value < core.min ) core.value = core.min;
                if( core.max < core.value ) core.value = core.max;
                core.value = int( core.value * Number(10000000) ) / 10000000;
                view.number.textField.text = core.value.toString();
            }
        }
        // public function
        // public var
        public var seeking:Boolean = false;
        public var core:WidgetTextNumberSliderCore;
        public var view:WidgetTextNumberSliderView;
    }
    // core
    class WidgetTextNumberSliderCore
    {
        public var value:Number = 0;
        public var oldValue:Number = 0;
        public var originX:Number = 0;
        public var originY:Number = 0;
        public var diffX:Number = 0;
        public var diffY:Number = 0;
        public var min:Number = 0;
        public var max:Number = 100;
        public var xTick:Number = 1;
        public var yTick:Number = 1;
    }
    // view
    class WidgetTextNumberSliderView
    {
        public var number:WidgetText;
    }
    
    ////////////////////////////////////////
    import flash.display.DisplayObjectContainer;
    import flash.events.MouseEvent;
    class WidgetTextDice
    extends WidgetBase
    {
        public function WidgetTextDice( displayObjectContainer:DisplayObjectContainer = undefined, x:Number = 0, y:Number = 0 )
        {
            
            super( displayObjectContainer, x, y );
            
            core = new WidgetTextDiceCore();
            view = new WidgetTextDiceView();
            
            
            view.value = new WidgetText( this, 0, 0, core.value.toString() );
            view.value.textField.selectable = false;
            view.value.textFormat.bold = false;
            view.value.textFormat.font = "_明朝";
            view.value.textFormat.size = 30;
            view.value.textField.scaleX = 1;
            view.value.textField.scaleY = 1;
            view.value.blurFilter.blurX = 1.0;
            view.value.blurFilter.blurY = 1.0;
            view.value.formatApply();
            
            view.title = new WidgetText( this, 0, 0, "d", 0xCCCCCC );
            view.title.selectDisable();
            
            view.diceCount = new WidgetTextNumberSlider( this, 0, view.value.y + view.value.height, core.diceCount, 1, 100 );
            view.diceCount.view.number.setVisualOnMouseOver( 1.0, 0xFFFFFF, true, 0x000000 );
            
            view.diceMax = new WidgetTextNumberSlider( this,  0, 0, core.diceMax, 1, 100 );
            view.diceMax.view.number.setVisualOnMouseOver( 1.0, 0xFFFFFF, true, 0x000000 );
            
            
            addEventListener( Event.ADDED_TO_STAGE, onAddedToStage )
            addEventListener( Event.ENTER_FRAME, onEnterFrame )
            
            addDragPuller( view.value );
            
            view.roll = new WidgetText( this, 0, 0, "roll()", 0xAAAAAA );
            view.roll.setVisualOnDefault( 1.0, 0xAAAAAA )
            view.roll.setVisualOnMouseOver( 1.0, 0xFFFFFF, true, 0x000000 )
            view.roll.setVisualOnMousePress( 1.0, 0x000000, false, 0x555555 )
            
            view.more = new WidgetText( this, 0, 58, "+more", 0xAAAAAA );
            view.more.setVisualOnDefault( 0.0, 0x000000 )
            view.more.setVisualOnMouseOver( 1.0, 0xFFFFFF, true, 0x000000 )
        }
        // private function
        private function onAddedToStage( event:Event ):void
        {
            addRollPuller( view.roll );
        }
        private function onEnterFrame( event:Event ):void
        {
            view.diceCount.y = view.value.y + view.value.height - 2;
            
            view.title.x = view.diceCount.width - 4;
            view.title.y = view.diceCount.y;
            
            view.diceMax.x = view.title.x + view.title.width - 4;
            view.diceMax.y = view.diceCount.y;
            
            view.roll.y = view.title.y + view.title.height - 2;
            
            view.average.y = view.roll.y + view.roll.height - 2;
            
            core.diceCount = view.diceCount.core.value;
            core.diceMax = view.diceMax.core.value;
            
            view.value.textField.text = core.value.toString();
        }
        //
        private function onRollKeyDown( event:MouseEvent ):void
        {
            view.rolling = true;
            view.value.textField.text = "?";
            core.roll();
        }
        private function onRollKeyUp( event:MouseEvent ):void
        {
            if( view.rolling ){
                view.rolling = false;
                view.roll.textField.background = false;
                view.value.textField.text = core.value.toString();
            }
        }
        //
        private function onAverageKeyDown( event:MouseEvent ):void
        {
            view.average.textField.background = true;
            view.average.textField.backgroundColor = 0x555555;
            core.value = core.getAverage();
        } 
        private function onAverageKeyUp( event:MouseEvent ):void
        {
        } 
        // public function
        public function addRollPuller( widget:WidgetBase ):void
        {
            widget.addEventListener( MouseEvent.MOUSE_DOWN, onRollKeyDown );
            stage.addEventListener( MouseEvent.MOUSE_UP, onRollKeyUp );
        }
        public function addAveragePuller( widget:WidgetBase ):void
        {
            widget.addEventListener( MouseEvent.MOUSE_DOWN, onAverageKeyDown );
            stage.addEventListener( MouseEvent.MOUSE_UP, onAverageKeyUp );
        }
        public var core:WidgetTextDiceCore;
        public var view:WidgetTextDiceView;
    }
    class WidgetTextDiceCore
    {
        public function WidgetTextDiceCore()
        {
            log = new WidgetTextDiceCoreLog()
        }
        public function roll():Number
        {
            value = 0;
            
            var i:int,iMax:int = diceCount;
            for(i=1; i<=iMax; ++i )
            {
                value = value + uint( ( Math.random() * diceMax ) + 1 );
            }
            
            log.add( value, diceCount, diceMax );
            
            average = getAverage();
            return value;
        }
        public function getAverage():Number
        {
            return( ( diceCount * diceMax ) / 2 );
        }
        public var average:Number = 1;
        public var diceMax:Number = 6;
        public var diceCount:uint = 1;
        public var value:Number = 1;
        public var log:WidgetTextDiceCoreLog;
    }
    class WidgetTextDiceCoreLog
    {
        public function add( _value:Number = 0, _diceCount:uint = 0, _diceMax:Number = 0 ):void
        {
            list[list.length] = new WidgetTextDiceCoreLogItem( _value, _diceCount, _diceMax )
            if( max < list.length )
            {
                list.pop();
            }
        }
        public var list:Array = [];
        public var max:uint = 10;
    }
    class WidgetTextDiceCoreLogItem
    {
        public function WidgetTextDiceCoreLogItem( _value:Number = 0, _diceCount:uint = 0, _diceMax:Number = 0 ):void
        {
            value = _value;
            diceCount = _diceCount;
            diceMax = _diceMax;
        }
        public var diceCount:uint = 0;
        public var diceMax:Number = 0;
        public var value:Number = 0;
    }
    class WidgetTextDiceView
    {
        public var value:WidgetText;
        public var title:WidgetText;
        public var diceCount:WidgetTextNumberSlider;
        public var diceMax:WidgetTextNumberSlider;
        public var roll:WidgetText;
        public var rolling:Boolean = false;
        public var more:WidgetText;
        public var average:WidgetText;
    }
    
    
    //////////////////////////////////////////
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    class WidgetExText
    extends Sprite
    {
        public function WidgetExText()
        {
            initialize();
        }
        public function initialize():void
        {
        
            textView = new WidgetText( this, 10, 0, "text" );
            textView.inputEnable();
            textView.textFormat.size = 100;
            
            box = new WidgetRectangle( this, 0, 0, 10, 15, 0x000000 );
            box.doubleClickEnable();
            box.alpha = 0.0;
            
            configBox = new WidgetRectangle( this, 10, -14, 0, 0, 0x000000 );
            configBox.alpha = 1.0;
            configBox.visible = false;
            
            
            textSizeBackView = new WidgetText( configBox, -25, -14,  "size:0.0 ~ 100.0");
            textSizeBackView.textField.selectable = false;
            textSizeBackView.textField.textColor = 0xE0E0E0;
            textSizeView = new WidgetText( configBox, 0, -14, "10" );
            textSizeView.inputEnable();
            
            textFontBackView = new WidgetText( configBox, -25, 0, "font:_typewriter _serif _sans _等幅 _ゴシック _明朝 " );
            textFontBackView.textField.selectable = false;
            textFontBackView.textField.textColor = 0xE0E0E0;
            textFontView = new WidgetText( configBox, 0, 0, "_等幅" );
            textFontView.inputEnable();
            
            
            box.addEventListener( MouseEvent.MOUSE_OVER, onMouseOver );
            box.addEventListener( MouseEvent.MOUSE_OUT, onMouseOut );
            box.addEventListener( MouseEvent.MOUSE_DOWN, onMouseDown );
            box.addEventListener( MouseEvent.MOUSE_UP, onMouseUp );
            box.addEventListener( MouseEvent.DOUBLE_CLICK, onMouseDoubleClick );
        }
        public function onMouseDown( event:MouseEvent ):void
        {
            startDrag();
        }
        public function onMouseUp( event:MouseEvent ):void
        {
            stopDrag();
        }
        public function onMouseOver( event:MouseEvent ):void
        {
            box.alpha = 1.0;
        }
        public function onMouseOut( event:MouseEvent ):void
        {
            box.alpha = 0.0;
        }
        public function onMouseDoubleClick( event:MouseEvent ):void
        {
            if( configBox.visible == true )
            {
                
                switch( textFontView.textField.text )
                {
                    default:
                        textFontView.textField.text = "_等幅";
                        break;
                    case "_sans":
                    case "_serif":
                    case "_ゴシック":
                    case "_等幅":
                    case "_明朝":
                    case "_typewriter":
                        break;
                }
                textView.textFormat.size = Number( textSizeView.textField.text );
                textView.textFormat.font = textFontView.textField.text;
                textView.formatApply();
                configBox.visible = false;
            }
            else
            {
                configBox.visible = true;
            }
        }
        public var textView:WidgetText;
        public var box:WidgetRectangle;
        public var configBox:WidgetRectangle;
        public var textFontView:WidgetText;
        public var textFontBackView:WidgetText;
        public var textSizeView:WidgetText;
        public var textSizeBackView:WidgetText;
    }
    
    
    
    
    
    ///////////////////////////////////////////////////
    import flash.display.Sprite;
    class WidgetRectangle
    extends WidgetBase
    {
        public function WidgetRectangle( displayObjectContainer:DisplayObjectContainer = undefined, x:Number = 0, y:Number = 0, width:Number = 16, height:Number = 16, color:uint = 0 )
        {
            super( displayObjectContainer, x,y );
            
            shape = new Shape();
            shape.graphics.beginFill( color );
            shape.graphics.drawRect( 0,0,1,1 );
            shape.graphics.endFill();
            
            shape.width = width;
            shape.height = height;
            
            addChild( shape );
            
            setParent( displayObjectContainer );
        }
        public function resize( _width:Number = NaN, _height:Number = NaN ):void
        {
            shape.width = _width;
            shape.height = _height;
        }
        public var shape:Shape;
    }
    
    ///////////////////////////////////////////////////
    import flash.display.Sprite;
    class WidgetCircle
    extends WidgetBase
    {
        public function WidgetCircle( _displayObjectContainer:DisplayObjectContainer = undefined, _x:Number = 0, _y:Number = 0, _radius:Number = 16, _color:uint = 0 )
        {
            super( _displayObjectContainer, _x, _y );
            
            core = new WidgetCircleCore();
            view = new WidgetCircleView();
            
            redraw( 0,0,_radius,_color );
        }
        
        public function redraw( _x:Number = 0, _y:Number = 0, _radius:Number = 0, _color:uint = 0x00000000 ):void
        {
            core.position.x = _x;
            core.position.y = _y;
            core.radius = _radius;
            view.shape.graphics.beginFill( _color );
            view.shape.graphics.drawCircle( 0,0,_radius );
            view.shape.graphics.endFill();
        }
        public function alignCenter():void
        {
            
        }
        public function resize( _width:Number = NaN, _height:Number = NaN ):void
        {
            view.shape.width = _width;
            view.shape.height = _height;
        }
        public var core:WidgetCircleCore;
        public var view:WidgetCircleView;
    }
    import flash.geom.Point;
    class WidgetCircleCore
    {
        public function WidgetCircleCore()
        {
            offset = new Point();
            position = new Point();
            radius = 0;
        }
        public var position:Point;
        public var radius:Number;
        public var offset:Point;
    }
    import flash.display.Shape;
    class WidgetCircleView
    {
        public function WidgetCircleView()
        {
            shape = new Shape();
        }
        public var shape:Shape;
    }
    //////////////////////////////////////////////////
    //FIXME
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    class WidgetSlider
    extends WidgetBase
    {
        public function WidgetSlider
            ( _displayObjectContainer:DisplayObjectContainer = undefined
            , _x:Number = 0
            , _y:Number = 0
            , _width:Number = 10
            , _length:Number =100 )
        {
            super( _displayObjectContainer, _x, _y, onAddedToStage );
            
            core = new WidgetSliderCore();
            view = new WidgetSliderView();
            
            view.width = _width;
            view.length = _length;
            
            view.cartLength = 10;
            
            view.min = 0;
            view.max = view.length - view.cartLength;
            
            view.tick = core.tick / core.max - core.min;
            view.value = core.value * core.tick;
            
            view.rail = new WidgetRectangle( this, _width, _length, 0xE0E0E0 );
            view.cart = new WidgetRectangle( this, _width, _width, 0x808080 );
            
            addDragPuller( view.rail );
            
            view.cart.addEventListener( MouseEvent.MOUSE_DOWN, onCartDragStart );
        }
        // private function
        private function onAddedToStage( event:Event ):void
        {
            stage.addEventListener( MouseEvent.MOUSE_UP, onCartDragStop );
            stage.addEventListener( MouseEvent.MOUSE_MOVE, onCartDragMove );
        }
        private function onCartDragStart( event:MouseEvent ):void
        {
            view.cart.y = this.y - event.stageY;
        }
        public function onCartDragStop( event:MouseEvent ):void
        {
            view.cart.y = this.y - event.stageY;
        }
        public function onCartDragMove( event:MouseEvent ):void
        {
            view.cart.y = this.y - event.stageY;
        }
        // public function
        public function followXm():void
        {
            rotation = -90;
        }
        public function followYm():void
        {
            rotation = 0;
        }
        public var core:WidgetSliderCore;
        public var view:WidgetSliderView;
    }
    class WidgetSliderCore
    {
        public function seek( _value:Number):void
        {
            if( _value < min )
            {
                _value = min;
            }
            if( max < _value )
            {
                _value = max;
            }
        }
        public var min:Number = 0;
        public var max:Number = 10;
        public var tick:Number = 1;
        public var value:Number = 0;
    }
    class WidgetSliderView
    {
        public var value:Number = 0;
        public var width:Number;
        public var tick:Number;
        public var min:Number;
        public var max:Number = 10;
        public var length:Number;
        public var cartLength:Number;
        public var cartDragging:Boolean;
        public var rail:WidgetRectangle;
        public var cart:WidgetRectangle;
    }
    
    /////////////////////////////////////////////////////
    import flash.display.DisplayObjectContainer;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.text.TextField;
    import flash.text.TextFormat;
    class WidgetText
    extends WidgetBase
    {
        public function WidgetText( _displayObjectContainer:DisplayObjectContainer = undefined, _x:Number = 0, _y:Number = 0, _text:String = " ", _textColor:uint = 0x000000, _backgroundColor:uint = 0x000000 )
        {
            super( _displayObjectContainer, _x, _y );
            
            //text = " ";
            core = new WidgetTextCore();
            
            textFormat = new TextFormat();
            textFormat.leftMargin = -4;
            textFormat.rightMargin = -1;
            textFormat.align = "left";
            textFormat.font = "_等幅";     //EXAMPLE  "_等幅"  "_ゴシック"  "_明朝 "  "_typewriter"  "_serif"  "_sans"
            textFormat.size = 10;
            textFormat.color = _textColor;
            
            textField = new TextField();
            textField.background = false;
            textField.backgroundColor = 0xFFFFFF;
            textField.border = false;
            textField.borderColor = 0x000000;
            textField.textColor = _textColor;
            textField.autoSize = "left";
            textField.selectable = false;
            textField.multiline = true;
            textField.defaultTextFormat = textFormat;
            
            textField.text = _text;
            
            addChild( textField );
            
            addEventListener( MouseEvent.MOUSE_OVER, onMouseOver );
            addEventListener( MouseEvent.MOUSE_OUT, onMouseOut );
            addEventListener( MouseEvent.MOUSE_DOWN, onMouseKeyDown );
            addEventListener( MouseEvent.MOUSE_UP, onMouseKeyUp );
            
            blurFilter = new BlurFilter( 1,1 );
            
            core.onDefault.alpha = 1.0;
            core.onDefault.textColor = _textColor;
            core.onDefault.backgroundEnabled = false;
            core.onDefault.backgroundColor = 0x000000;
            core.onDefault.borderEnabled = false;
            core.onDefault.borderColor = 0x000000;
            
            changeVisual( core.onDefault );
            
            formatApply();
        }
        // private function
        private function onMouseOver( event:MouseEvent ):void
        {
            changeVisual( core.onMouseOver );
        }
        private function onMouseOut( event:MouseEvent ):void
        {
            changeVisual( core.onDefault );
        }
        private function onMouseKeyDown( event:MouseEvent ):void
        {
            changeVisual( core.onMousePress );
        }
        private function onMouseKeyUp( event:MouseEvent ):void
        {
            changeVisual( core.onDefault );
        }
        private function changeVisual( item:WidgetTextCoreVisual ):void
        {
            textField.alpha = item.alpha
            textField.textColor = item.textColor;
            textField.background = item.backgroundEnabled;
            textField.backgroundColor = item.backgroundColor;
        }
        // public function
        public function restrict( value:String ):void
        {
            textField.restrict = value;
        }
        public function inputOnlyNumber():void
        {
            textField.restrict = "0-9" + ".";
        }
        public function inputOnlyInt():void
        {
            textField.restrict = "0-9" + "\\-";
        }
        public function inputOnlyUint():void
        {
            textField.restrict = "0-9";
        }
        public function inputEnable():void
        {
            textField.type = "input";
        }
        public function inputDisable():void
        {
            textField.type = "Dynamic";
        }
        public function setVisualOnDefault( _alpha:Number = 1.0, _textColor:uint = 0x000000, _backgroundEnabled:Boolean = false, _backgroundColor:uint = 0x000000 ):void
        {
            var item:WidgetTextCoreVisual = core.onDefault;
            item.enabled = true;
            item.alpha = _alpha;
            item.textColor = _textColor;
            item.backgroundEnabled = _backgroundEnabled;
            item.backgroundColor = _backgroundColor;
        }
        public function setVisualOnMouseOver( _alpha:Number = 1.0, _textColor:uint = 0x000000, _backgroundEnabled:Boolean = false, _backgroundColor:uint = 0x000000 ):void
        {
            var item:WidgetTextCoreVisual = core.onMouseOver;
            item.enabled = true;
            item.alpha = _alpha;
            item.textColor = _textColor;
            item.backgroundEnabled = _backgroundEnabled;
            item.backgroundColor = _backgroundColor;
        }
        public function setVisualOnMousePress( _alpha:Number = 1.0, _textColor:uint = 0x000000, _backgroundEnabled:Boolean = false, _backgroundColor:uint = 0x000000 ):void
        {
            var item:WidgetTextCoreVisual = core.onMousePress;
            item.enabled = true;
            item.alpha = _alpha;
            item.textColor = _textColor;
            item.backgroundEnabled = _backgroundEnabled;
            item.backgroundColor = _backgroundColor;
        }
        //FIXME
        public function embedFontEnable( _fontName:String ):void
        {
            textFormat.font = _fontName;
            textField.embedFonts = true;
            textField.antiAliasType = "advanced";
            formatApply();
        }
        public function embedFontDisable( _fontName:String = "_等幅" ):void
        {
            textFormat.font = _fontName;
            textField.embedFonts = false;
            formatApply();
        }
        public function selectDisable():void
        {
            textField.selectable = false;
        }
        public function formatApply():void
        {
            text = textField.text;
            textField.defaultTextFormat = textFormat;
            textField.filters = [blurFilter];
            textField.text = text;
            
        }
        public var blurFilter:BlurFilter;
        public var text:String;
        public var textField:TextField;
        public var textFormat:TextFormat;
        public var core:WidgetTextCore;
    }
    class WidgetTextCore
    {
        public function WidgetTextCore()
        {
            onDefault = new WidgetTextCoreVisual();
            onMouseOver = new WidgetTextCoreVisual();
            onMousePress = new WidgetTextCoreVisual();
        }
        public var onDefault:WidgetTextCoreVisual
        public var onMouseOver:WidgetTextCoreVisual
        public var onMousePress:WidgetTextCoreVisual
    }
    class WidgetTextCoreVisual
    {
        public function clone():WidgetTextCoreVisual
        {
            var result:WidgetTextCoreVisual = new WidgetTextCoreVisual();
            result.enabled = enabled;
            result.alpha = alpha;
            result.textColor = textColor;
            result.backgroundEnabled = backgroundEnabled;
            result.backgroundColor = backgroundColor;
            result.borderEnabled = borderEnabled;
            result.borderColor = borderColor;
            return result;
        }
        public var enabled:Boolean = false;
        public var alpha:Number = 1.0;
        public var textColor:uint = 0x000000;
        public var backgroundEnabled:Boolean = false;
        public var backgroundColor:uint = 0x000000;
        public var borderEnabled:Boolean = false;
        public var borderColor:uint = 0x000000;
    }