/**
 * Copyright esabear ( http://wonderfl.net/user/esabear )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wH4J
 */

package {
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.InterpolationMethod;
    
    public class FlashTest extends Sprite {
        public var fillColor:int = 0x0000FF;
        public function FlashTest() {
            // write as3 code here..
            stage.addEventListener (MouseEvent.MOUSE_MOVE, redraw);
            stage.addEventListener (MouseEvent.CLICK, changeColor);
            changeColor ();
            redraw ();
        }
        
        private function redraw (e:MouseEvent=null):void {
	    var mouse:Point = new Point (mouseX, mouseY);
	    var center:Point = new Point (stage.stageWidth  * 0.5, stage.stageHeight * 0.5);
	    var matrix:Matrix = new Matrix();
		matrix.createGradientBox (stage.stageWidth * 2, stage.stageHeight * 2, Math.atan2 (mouseY-center.y, mouseX-center.x), -center.x, -center.y);
	
	    graphics.clear ();
	    graphics.beginGradientFill (
		GradientType.RADIAL,
		[fillColor, 0x000000],
		[1, 1],
		[0x00, 0xFF],
		matrix,
		SpreadMethod.PAD,
		InterpolationMethod.RGB,
		Point.distance(mouse, center) / stage.stageWidth
	    );
	    graphics.drawRect (0, 0, stage.stageWidth, stage.stageHeight);
	    graphics.endFill ();
        }

        private function changeColor (e:MouseEvent=null):void {
	        fillColor = 0xFFFFFF * Math.random();
        }
    }
}