/**
 * Copyright siny ( http://wonderfl.net/user/siny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wGmI
 */

// forked from esabear's 3D tag cloud
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.text.*;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.materials.special.BitmapParticleMaterial;
    import org.papervision3d.core.geom.Particles;
    import org.papervision3d.core.geom.renderables.Particle;
    import org.papervision3d.events.InteractiveScene3DEvent;

    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
    
    public class FlashTest extends Sprite {
    	
        private var scale:Number = 5;
        private var radius:Number = 350;
        private var smoothing:Boolean = true;
        private var minAlpha:Number = 0.3;
        private var glow:GlowFilter;
        private var tags:Array;
        private var tag_num:uint;
        private var bv:BasicView;
        private var tagArray:Array;
        private var tagContainer:DisplayObject3D;

        public function FlashTest() {
            init ();
        }
        
        private function init ():void {
        		//(color:uint = 0xFF0000, alpha:Number = 1.0, blurX:Number = 6.0, blurY:Number = 6.0, strength:Number = 2, quality:int = 1, inner:Boolean = false, knockout:Boolean = false)
            glow = new GlowFilter (0xffffff, 1, 24, 24, 1, 2, false, false);
            tags = ["Ricoh GX200","Nikon D90","Mac","Apple","RX78-2","FC3S","Anne","PSP","PS3","SH-04A","Flash","AS3"];
            tag_num = tags.length;
            tagArray = [];
            tagContainer = new DisplayObject3D();
            tagContainer.x = -radius * 0.15;
            tagContainer.y =  radius * 0.15;
            
            bv = new BasicView (stage.stageWidth, stage.stageHeight, true, true);
            bv.viewport.interactive = true;
            bv.scene.addChild (tagContainer);
            bv.camera.z = -1.5 * radius;
            bv.camera.zoom = 30;
            bv.startRendering ();
            
            addChild (bv);
            
            buildTags ();
            
            addEventListener (Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function buildTags ():void {
            var i:uint;
            for (i = 0; i < tag_num; i++) {
                // 2D
                var txt:TextField = new TextField ();
                txt.defaultTextFormat = new TextFormat('_ゴシック', 12, 0xffffff, false);
                txt.text = tags[i];
                //txt.filters = [new BlurFilter(1.1, 1.1)];
                var txtW:Number = txt.textWidth + 4;
                var txtH:Number = txt.textHeight + 4;
                var bitmap:BitmapData = new BitmapData (txtW, txtH, true, 0x01FFFFFF);
                    bitmap.draw (txt);

                var phi:Number = Math.acos((2 * (i + 1) - 1) / tag_num - 1);
                var theta:Number = Math.sqrt(tag_num * Math.PI) * phi;

                // 3D
                var material:BitmapParticleMaterial = new BitmapParticleMaterial (bitmap);
                    material.interactive = true;
                    material.smooth = false;
                var tag:Particle = new Particle (material, scale, 0, 0, 0);
                var tagHolder:Particles = new Particles ();
                    tagHolder.addParticle (tag);
                    tagHolder.x = radius * Math.cos (theta) * Math.sin (phi);
                    tagHolder.y = radius * Math.sin (theta) * Math.sin (phi);
                    tagHolder.z = radius * Math.cos (phi);
                    tagHolder.useOwnContainer = true;
                    tagHolder.autoCalcScreenCoords = true;
                    tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OVER, objectOverHandler);
                    tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OUT, objectOutHandler);
                    //tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_PRESS, objectPressHandler);

                tagContainer.addChild (tagHolder);
                tagArray.push (tagHolder);
            }
        }
        
        private function objectOverHandler (e:InteractiveScene3DEvent):void {
	    bv.viewport.buttonMode = true;
            e.target.filters = [glow];
        }

        private function objectOutHandler (e:InteractiveScene3DEvent):void {
	    bv.viewport.buttonMode = false;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray [j].filters = [];
            }
        }
        
        private function enterFrameHandler (e:Event):void {
            tagContainer.rotationX += (mouseY - stage.stageHeight * 0.5) * 0.005;
            tagContainer.rotationY += (mouseX - stage.stageWidth * 0.5) * 0.005;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray[j].alpha = minAlpha + (1 - minAlpha) * (1 - (tagArray[j].screen.z - radius) / (2 * radius));
            }
        }
    }
}