/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wGNi
 */

// forked from sake's PV3Dその8 Pixels使ってみる
/*
	以下を参考にさせて頂きました。
	PV3Dその5 Planeを球体っぽく並べるのをPV3Dで。 http://wonderfl.kayac.com/code/8967e3b45baea801deac174fabea02453fc94164
	PV3Dその8 Pixels使ってみる http://wonderfl.kayac.com/code/834affa8c7b8c668f2de620b62fa61c217df2805
*/

package
{
	import flash.events.Event;
	import flash.filters.BlurFilter;
	
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	public class Saturn extends BasicView
	{
		private var _pixels:Pixels;
		
		
		public function Saturn()
		{
			graphics.beginFill(0x000000);
			graphics.drawRect(0, 0, 465, 465);
			var layer:BitmapEffectLayer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, BitmapClearMode.CLEAR_PRE, true); 
			viewport.containerSprite.addLayer(layer);
			layer.addEffect(new BitmapLayerEffect(new BlurFilter(8, 8, 4), false));
			_pixels = new Pixels(layer);
			scene.addChild(_pixels);
			
			globe();
			ring();
			dust();
			
			_pixels.rotationZ = 30;
			camera.y = -150;
			
			startRendering();
		}
		
		private function globe():void
		{
			var radius:int = 250;
			var H:int=(2 * radius * Math.PI) / 2 / 30;
			var theta1:Number;
			var theta2:Number=90;
			var color:uint;
			
			for(var i:int=0; i < H; i++)
			{
				(i%2 == 0)? color=0xFFFCBD5C : color=0xFFC68A2F;
				theta1=0;
				var pn:int=Math.floor((2 * radius * Math.cos(theta2 * Math.PI / 180) * Math.PI) / 20);
				for(var j:int=0; j < pn; j++)
				{
					var xx:int=radius * Math.cos(theta2 * Math.PI / 180) * Math.sin(theta1 * Math.PI / 180);
					var yy:int=radius * Math.sin(theta2 * Math.PI / 180);
					var zz:int=radius * Math.cos(theta2 * Math.PI / 180) * Math.cos(theta1 * Math.PI / 180);
					var p:Pixel3D=new Pixel3D((color), xx, yy, zz);
					_pixels.addPixel3D(p);
					theta1+=360 / pn;
				}
				theta2-=180 / H;
			}
		}
		
		private function ring():void
		{
			var radius:int = 450;
			for (var i:uint=0; i<3000; i++)
			{
				var theta:Number=360 * Math.random() * Math.PI / 180;
				var xx:Number=radius * Math.sin(theta) + Math.random()*100 - 50;
				var yy:Number=0;
				var zz:Number=radius * Math.cos(theta) + Math.random()*100 - 50;
				var p:Pixel3D=new Pixel3D((0xFF8E6F53), xx, yy, zz);
				_pixels.addPixel3D(p);
			}
		}
		
		private function dust():void
		{
			for (var i:uint=0; i<100; i++)
			{
				var xx:Number=Math.random()*930-465;
				var yy:Number=Math.random()*930-465;
				var zz:Number=Math.random()*930-465;
				var p:Pixel3D=new Pixel3D(((Math.random()*0x80 + 0x60) << 24 | 0xFF << 16 | 0xFF << 8 | 0xFF), xx, yy, zz);
				_pixels.addPixel3D(p);
			}
		}
		
		override protected function onRenderTick(e:Event=null):void
		{
			_pixels.yaw(0.3);
			renderer.renderScene(scene, camera, viewport);
		}
	}
}