/**
 * Copyright nipx ( http://wonderfl.net/user/nipx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wGEu
 */

package {
    
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.utils.*;
    import net.wonderfl.utils.FontLoader;
    
    [SWF(backgroundColor="#FFFFFF", frameRate="30", width="475", height="475")] 
    
    public class FlashTest extends Sprite {
        
        private var fontName:String       = "VLGothic";
        
        public function FlashTest() {
            var fontLoader:FontLoader = new FontLoader();
            fontLoader.load( fontName );
            fontLoader.addEventListener( Event.COMPLETE, onComplete );
        }
        
        
        
        private function onComplete(e:Event):void{
            
            var container:Sprite = new Sprite();
            container.x = 138;
            container.y = 138;
            addChild( container );
            
            var format:TextFormat   = new TextFormat( fontName, 120, 0x666666 );
            var field:TextField     = new TextField();
            field.defaultTextFormat = format;
            field.width             = 0;
            field.x                 = 100;
            field.y                 = 38;
            field.autoSize          = TextFieldAutoSize.CENTER;
            field.multiline         = false;
            field.wordWrap          = false;
            field.embedFonts        = true;
            field.maxChars          = 1;
            field.type              = TextFieldType.INPUT;
            field.text = "aaa";
            container.addChild( field );
            
            var rect:Rectangle        = new Rectangle( 0, 0, 200, 200 );
            var master:BitmapData     = new BitmapData( rect.width, rect.height, true, 0x00000000 );
            var outline:BitmapData    = new BitmapData( rect.width, rect.height, true, 0x000000 );
            var bmp:Bitmap            = new Bitmap( outline );
            bmp.x = container.x;
            bmp.y = container.y;
            addChild( bmp );
            
            
            var convolution:ConvolutionFilter    = new ConvolutionFilter( 3,3,
                [
                    1, 1, 1,
                    1, 1, 1,
                    1, 1, 1
                ], 9, 0, false );
            
            var b:uint    = 0xFF000000;
            var pattern:BitmapData    = new BitmapData( 6,6, true, 0x00000000 );
            pattern.setVector( new Rectangle( 0,0,6,6 ),
                Vector.<uint>([
                    0,0,0,b,b,b,
                    0,0,b,b,b,0,
                    0,b,b,b,0,0,
                    b,b,b,0,0,0,
                    b,b,0,0,0,b,
                    b,0,0,0,b,b
                ])
            );
            
            var shape:Shape    = new Shape();
            var g:Graphics    = shape.graphics;
            var matrix:Matrix    = new Matrix();
            addEventListener( Event.ENTER_FRAME, function(e:Event):void{
                matrix.tx = ( matrix.tx + 1 ) % 6;
                g.clear();
                g.beginBitmapFill( pattern, matrix );
                g.drawRect( 0,0, rect.width, rect.height );
                outline.fillRect( rect, 0 );
                outline.draw( master );
                outline.draw( shape, null, null, BlendMode.ALPHA );
            });
            
            
            function setup():void{
                field.selectable = false;
                var pt:Point    = new Point();
                master.fillRect( rect, 0 );
                master.draw( container );
                master.threshold( master, rect, pt,">",0x00000000, 0xFF000000, 0xFFFFFFFF, false );
                var clone:BitmapData    = master.clone();
                master.applyFilter( master, rect, pt, convolution );
                master.draw( clone );
                master.threshold( master, rect, pt,"==",0xFF000000, 0x00000000, 0xFFFFFFFF, false );
                master.threshold( master, rect, pt,">" ,0x00000000, 0xFF000000, 0xFFFFFFFF, false );
                field.selectable = true;
            }
            
            
            var copy:String    = "いろはにほへとちりぬるをわかよたれそつねならむうゐのおくやまけふこえてあさきゆめみしゑひもせす";
            var loop:uint;
            function doLoop():void{
                var str:String    = copy.charAt(0);
                field.text = str;
                copy = copy.substr( 1 );
                copy += str;
                setup();
            }
            
            
            field.addEventListener( FocusEvent.FOCUS_IN, function(e:FocusEvent):void{
                clearInterval( loop );
            });
            
            field.addEventListener( FocusEvent.FOCUS_OUT, function(e:FocusEvent):void{
                loop = setInterval( doLoop, 1500 );
            });
            
            field.addEventListener( Event.CHANGE, function(e:Event):void{
                setup();
            });
            
            
            doLoop();
            loop = setInterval( doLoop, 1500 );
        }

        
        
        
        
    }
}