/**
 * Copyright kinoppy ( http://wonderfl.net/user/kinoppy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wFZ7
 */

// forked from Murai's #PrayForJapan
package {

    import flash.events.IOErrorEvent;
    import caurina.transitions.Tweener;

    import com.adobe.serialization.json.JSON;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DropShadowFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;

    /**
     * @author Takashi Murai (KAYAC)
     * @see http://twitter.com/search?q=%23prayforjapan
     * @see http://prayforjapan.jp/
     * @see http://www.youtube.com/watch?v=O8x6_JHDkhI&feature=player_embedded
     */
    [SWF(backgroundColor="#000000", frameRate="60", width="465", height="465")]
    public class PrayForJapan extends Sprite {

        private var l:URLLoader;
        private var ytl:Loader;
        private var grid:Grid;
        
        //powerdby @sugyan thanks alot : )
        private var proxy:String = "http://crossdomain-proxy.appspot.com/?url=";
        private var api:String = "https://api.instagram.com/v1/tags/prayforjapan/media/recent?client_id=1072b2e2cf524f9197582075b2aa8abf";
        
        private var yt:Object;
        private var bmd:BitmapData;
        private var message:Bitmap;
        private var fmt:TextFormat;
        private var txt:TextField;
        private var layer:Sprite;
        private var max:int = 6;
        private var count:int = 0;


        public function PrayForJapan() {
            stage.fullScreenSourceRect = new Rectangle(0, 0, 465, 465);

            Security.allowDomain("*");

            ytl = new Loader();
            ytl.contentLoaderInfo.addEventListener(Event.INIT, ytInitialized);
            ytl.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));

            l = new URLLoader();
            l.addEventListener(Event.COMPLETE, loaded);
            l.addEventListener(IOErrorEvent.IO_ERROR, rewind);
            
            
            var background:Sprite = new Sprite();
            background.graphics.beginFill(0x000000, 1);
            background.graphics.drawRect(0, 0, 465, 465);
            background.graphics.endFill();
            addChild(background);
            

            layer = new Sprite();

            grid = new Grid(47, 47, 40);
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                var box:Sprite = grid.create();
                if (box.y > 465) {
                    l.load(new URLRequest(proxy + api));
                    removeEventListener(Event.ENTER_FRAME, arguments.callee);
                }
                layer.addChild(box);
            });

            fmt = new TextFormat();
            fmt.color = 0xFFFFFF;
            fmt.size = 24;
            fmt.font = 'Trebuchet MS';
            txt = new TextField();
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.defaultTextFormat = fmt;
            txt.text = 'Wonderfl #playforjapan PhotoStream.';
            txt.alpha = .8;

            bmd = new BitmapData(txt.textWidth, txt.textHeight + 10, true, 0);
            bmd.draw(txt);
            bmd.applyFilter(bmd, bmd.rect, new Point(), new DropShadowFilter(0, 0, 0, 1, 4, 4, 2, 2));
            message = new Bitmap(bmd);
            message.x = (465 - message.width) / 2;
            message.y = (465 - message.height) / 2;

            Tweener.addTween(message, {alpha:0, time:1, delay:12, transition:"easeOutSine", useFrames:false});

            addChild(background);
            addChild(layer);
            addChild(message);
        }

        private function ytInitialized(e:Event):void {
            ytl.content.addEventListener("onReady", ytReady);
        }

        private function ytReady(event:Event):void {
            yt = ytl.content;
            yt.setSize(320, 240);
            yt.loadVideoById("O8x6_JHDkhI", 0, "small");
        }
        
        private function rewind(e:IOErrorEvent):void {
            Tweener.addTween(this, {time:0, delay:3, onComplete:function():void {
                l.load(new URLRequest(proxy + api));
            }, useFrames:false});
        }

        private function loaded(e:Event):void {
            var json:Object = JSON.decode(e.target.data);
            build(json);

            if (count++ < max) {
                l.load(new URLRequest(proxy + api + "&max_id=" + json.pagination.next_max_id));
            } else {
                Tweener.addTween(this, {time:0, delay:5, onComplete:function():void {
                    l.load(new URLRequest(proxy + api + "&max_id=" + json.pagination.next_max_id));
                }, useFrames:false});
            }
        }

        private function build(json:Object):void {

            var len:int = json.data.length;
            var nodes:Array = json.data;

            for (var i:int = 0; i < len; i++) {
                grid.nextLoad(nodes[i].images.low_resolution.url);
            }
        }

    }
}

import flash.events.IOErrorEvent;
import caurina.transitions.Tweener;

import flash.display.*;
import flash.events.Event;
import flash.net.URLRequest;

internal class Grid {

    private var _map:Array = [];
    private var gW:int;
    private var gH:int;
    private var max:int;
    private var scale:int;

    public var emptyPos:int = 0;
    private var loaders:Array = [];
    private var q:int = 0;

    public function Grid(w:int, h:int, max:int):void {
        this.gW = w;
        this.gH = h;
        this.max = max;
        this.scale = 10;
    }

    public function create():Sprite {
        var pointer:int = -1;
        var emptyWidth:int = 0;

        for ( var i:int = emptyPos; i < emptyPos + 500 ; i++ ) {
            if ( !_map[i] && pointer == -1 ) {
                pointer = i;
                emptyWidth++;
            } else if ( emptyWidth >= max ) {
                break;
            } else if ( !_map[i] && !( i % gW == 0 && i != emptyPos ) ) {
                emptyWidth++;
            } else if ( pointer != -1 ) {
                break;
            }
        }

        var ww:int = int(Math.random() * emptyWidth) + 1;

        var p:int = pointer;
        for ( var yy:int = 0; yy < ww; yy++ ) {
            for ( var xx:int = 0; xx < ww; xx++ ) {
                _map[p] = 1;
                p++;
            }
            p += gW - ww;
        }
        emptyPos = pointer + ww;

        var px:int = pointer % gW * scale;
        var py:int = pointer == 0 ? 0 : int(pointer / gW) * scale;

        var sW:Number = ww * scale;
        var s:Sprite = new Sprite();

        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void {
            loader.width = sW;
            loader.height = sW;
            Tweener.addTween(loader, {alpha:1, time:1, delay:0, transition:"easeOutSine", useFrames:false});
        });
        loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, function(e:IOErrorEvent):void{
        });
        loader.alpha = 0;
        loaders.push(loader);

        s.x = px;
        s.y = py;
        s.graphics.lineStyle(1, 0xCCCCCC, 0.5, true, "none");
        s.graphics.drawRect(0, 0, sW, sW);
        s.graphics.moveTo(0, 0);
        s.graphics.lineTo(sW, sW);
        s.graphics.moveTo(sW, 0);
        s.graphics.lineTo(0, sW);

        s.addChild(loader);

        return s;
    }

    public function nextLoad(url:String):void {
        var loader:Loader = loaders[q++ % loaders.length];
        Tweener.addTween(loader, {alpha:0, time:1, delay:Math.random(), transition:"easeOutSine", useFrames:false, onComplete:function():void {
            loader.load(new URLRequest(url));
        }});
    }
}
