/**
 * Copyright rfkrocktk ( http://wonderfl.net/user/rfkrocktk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wF1w
 */

// forked from rfkrocktk's Rotate With Mouse Around (0,0)
package {
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.events.MouseEvent;    
    
    public class FlashTest extends Sprite {
        
        private var box:Sprite = new Sprite();
        
        private var tf:TextField = new TextField();
        
        private var downPoint:Point;
        
        private var registrationPoint:Point = new Point(50, 50);
        
        private var targetRotation:Number = 0;
        
        public function FlashTest() {
            this.box.graphics.beginFill(0x00000);
            this.box.graphics.drawRect(0, 0, 100, 100);
            this.box.graphics.endFill();
            
            this.box.x = 100;
            this.box.y = 100;
            
            this.tf.width = stage.stageWidth;
            this.tf.y = 300;
            this.tf.defaultTextFormat = new TextFormat("_sans");
            
            this.addChild(box); 
            this.addChild(tf);     
            
            this.box.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        private function onMouseDown(e:MouseEvent):void {
            this.downPoint = new Point(stage.mouseX, stage.mouseY);
            
            this.stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            this.stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function onMouseMove(e:MouseEvent):void {
            var mouse:Point = new Point(stage.mouseX, stage.mouseY);
            
            var d1:Point = new Point(downPoint.x - this.box.localToGlobal(registrationPoint).x,
                    downPoint.y - this.box.localToGlobal(registrationPoint).y); 
            
            var angle1:Number = (Math.atan2(d1.y, d1.x) * 180) / Math.PI;
            
            var d2:Point = new Point(mouse.x - this.box.localToGlobal(registrationPoint).x,
                    mouse.y - this.box.localToGlobal(registrationPoint).y);  
            
            var angle2:Number = ((Math.atan2(d2.y, d2.x) * 180) / Math.PI);
            
            var angle:Number = angle2 - angle1;
            
            this.tf.text = "Angle of change: " + angle;
                  
            var matrix:Matrix = this.box.transform.matrix;
            var center:Point = new Point(box.transform.pixelBounds.width/2, box.transform.pixelBounds.height/2);
            var transformPoint:Point = matrix.transformPoint(center);
            
            matrix.translate(-transformPoint.x, -transformPoint.y);
            matrix.rotate(1.5 * Math.PI / 180);
            matrix.translate(transformPoint.x, transformPoint.y);
            
            this.box.transform.matrix = matrix;
        }

        private function onMouseUp(e:MouseEvent):void {
            this.stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            this.stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
    }
}