/**
 * Copyright milchreis ( http://wonderfl.net/user/milchreis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wEGH
 */

package 
{
    import flash.display.Shape;
    import flash.display.Sprite;
    
    import flash.geom.Point;
    
    public class Main extends Sprite 
    {
        public function Main() 
        {
            var distribution:EvenDistribution2DTriangleBoundary = new EvenDistribution2DTriangleBoundary(new Point(100, 100), new Point(400, 50), new Point(250, 350));
            
            for (var i:int = 0; i < 1000; ++i)
            {
                // create an object in each iteration of the loop
                var circle:Shape = new Shape();
                
                //add some graphics (this is unnecessary if you use a library symbol)
                circle.graphics.beginFill(0xff0000, .6);
                circle.graphics.drawCircle(0, 0, 3);
                circle.graphics.endFill();
                
                // add it to the display list
                addChild(circle);
                
                // reposition it with the help of the distribution object
                distribution.positionDisplayObject(circle);
            }
        }
    }
}

import flash.display.DisplayObject;

import flash.geom.Point;

internal class EvenDistribution2DTriangleBoundary
{
    private var u:Point;
    private var v:Point;
    private var position:Point;
    
    public function EvenDistribution2DTriangleBoundary(a:Point, b:Point, c:Point)
    {
        // consider corner "a" as the position of the triangle, this is arbitrary decision, but has to be consistent with the rest of this constructor
        position = a;
        
        // create two vectors from the corner that is the position to the other two corners respectively
        u = b.subtract(a);
        v = c.subtract(a);
    }

    public function getRandomPosition():Point
    {
        // random position formula with two random variables: position + (u + (v-u) * random1) * sqrt(random2)

        var r1:Number = Math.random();
        
        // the sqrt transforms the probability density function of the even distribution f(x) = 1 into a triangle g(y) = 2y
        var r2:Number = Math.sqrt(Math.random());

        // applying the above formula to create an evenly distributed random position within the triangle
        return position.add(new Point((u.x + (v.x - u.x) * r1) * r2, (u.y + (v.y - u.y) * r1) * r2));
    }
    
    // convenience function to position a display object at a random position in the triangle
    public function positionDisplayObject(object:DisplayObject):void
    {
        var position:Point = getRandomPosition();
        
        object.x = position.x;
        object.y = position.y;
    }
}
