/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wD8k
 */

// forked from Jacky.Riawan's nunchucks
package  
{
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2MouseJoint;
    import Box2D.Dynamics.Joints.b2MouseJointDef;
    import Box2D.Dynamics.Joints.b2RevoluteJointDef;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.text.TextFormat;

    /**
     * ...
     * @author Jacky Riawan
     */
    [SWF(backgroundColor=0, width=465, height=465, frameRate=30)]
    public class Main extends Sprite
    {
        private var world:b2World
        private var myAABB:b2AABB
        private const ratio:int = 20
        private var joint:b2RevoluteJointDef = new b2RevoluteJointDef()
        private var prevBody:b2Body
        private var mouseJoint:b2MouseJoint;
        private var boxBody:b2Body;
        private var isHold:Boolean=false
        private var lightHandle:b2PolygonDef;
        private var heavyHandle:b2PolygonDef;
        private var bodyToDestroyList:Vector.<b2Body>=new Vector.<b2Body>()
        private var timer:int=0;
        private var tx:TextField
        
        public function Main() 
        {
            tx = new TextField();
            tx.defaultTextFormat = new TextFormat("_typewriter", 24, 0xFFFFFF, null, null, null, null, null, "center");
            tx.width = 465;
            tx.y = 220;
            tx.selectable = false;
            tx.text = "Click Start!"
            addChild(tx);
            
            graphics.beginFill(0);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            initVideo()
            stage.addEventListener(MouseEvent.CLICK, go);
        }
        
        private function go(e:MouseEvent):void
        {
            setupHeavyAndLightDef();
            setupWorld();
            setupDebugDraw();
            createNunchuck();
            addEventListener(Event.ENTER_FRAME, render);
            removeChild(tx)
        }
        
        private function setupHeavyAndLightDef():void
        {
            heavyHandle = new b2PolygonDef()
            heavyHandle.SetAsBox(20 / ratio, 2.5 / ratio)
            heavyHandle.density = 2000
            heavyHandle.filter.groupIndex = -1
            lightHandle = new b2PolygonDef()
            lightHandle.SetAsBox(20 / ratio, 2.5 / ratio)
            lightHandle.density = 10
            lightHandle.filter.groupIndex=-1
        }
        private function createObject():void {
            var shape:b2PolygonDef = new b2PolygonDef()
            shape.SetAsBox((Math.random() * 20 + 5) / ratio, (Math.random() * 15 + 5) / ratio)
            shape.filter.categoryBits=1
            shape.density=Math.random()/3+.1
            var bodyDef:b2BodyDef = new b2BodyDef()
            bodyDef.position.Set((Math.random() * 400) / ratio, 0)
            var body:b2Body = world.CreateBody(bodyDef)
            body.CreateShape(shape)
            body.SetMassFromShapes()
            bodyToDestroyList.push(body)
        }
        
        private function createNunchuck():void
        {
            //part1
            var boxSD:b2PolygonDef = new b2PolygonDef()
            boxSD.SetAsBox(20 / ratio, 2.5 / ratio)
            boxSD.density = 10
            boxSD.filter.groupIndex=-1
            var boxBD:b2BodyDef = new b2BodyDef()
            boxBD.position.Set(_px / ratio, _py / ratio)
            boxBody = world.CreateBody(boxBD)
            boxBody.CreateShape(lightHandle)
            boxBody.SetMassFromShapes()
            prevBody=boxBody
            //part 2
            
            var boxBD2:b2BodyDef = new b2BodyDef()
            boxBD2.position.Set((_px+75) / ratio, _py / ratio)
            var boxBody2:b2Body = world.CreateBody(boxBD2)
            boxBody2.SetBullet(true)
            boxBody2.CreateShape(boxSD)
            boxBody2.SetMassFromShapes()
            //chain
            var chainBodyShape:b2PolygonDef = new b2PolygonDef()
            chainBodyShape.SetAsBox(2.5 / ratio, .25 / ratio)
            
            chainBodyShape.filter.groupIndex = -1
            chainBodyShape.filter.categoryBits=1
            for (var i:int = 0; i < 7; i++) {
                var chainSD:b2BodyDef = new b2BodyDef()
                chainBodyShape.density = 1000-i*50
                chainSD.position.Set((_px+22.5 + i * 5) / ratio, _py / ratio)
                var chainBody:b2Body = world.CreateBody(chainSD)
                chainBody.CreateShape(chainBodyShape)
                chainBody.SetMassFromShapes()
                joint.Initialize(prevBody, chainBody, new b2Vec2(((_px+22.5 + i * 5) - 2.5) / ratio, _py/ratio))
                world.CreateJoint(joint)
                prevBody=chainBody
            }
            
            joint.Initialize(prevBody, boxBody2, new b2Vec2(((_px+22.5 + 7 * 5) - 2.5) / ratio, _py / ratio))
            world.CreateJoint(joint)
            var mouseJointDef:b2MouseJointDef = new b2MouseJointDef()
            mouseJointDef.body2 = boxBody
            mouseJointDef.body1 = world.GetGroundBody()
            mouseJointDef.target.Set(_px / ratio, _py / ratio)
            mouseJointDef.maxForce = 10000000
            mouseJointDef.timeStep = 1 / 80
            mouseJoint=world.CreateJoint(mouseJointDef) as b2MouseJoint
        }
        
        private function render(e:Event):void 
        {
            _tracker.track();
            _px = _tracker.px * (465 /320);
            _py = _tracker.py *  (465 /240);
            //
            //if (isHold) {
                boxBody.SetAngularVelocity(0);//m_angularVelocity=0
            //}
            timer++
            if (timer % 5 == 0) {
                createObject();
            }
            world.Step(1 / 40, 20);
            mouseJoint.SetTarget(new b2Vec2(_px / ratio, _py / ratio));
            for (var i:int = 0; i < bodyToDestroyList.length; i++) {
                var myBody:b2Body = bodyToDestroyList[i];
                var body_y:Number = myBody.GetPosition().y;
                var body_x:Number = myBody.GetPosition().x;
                if (body_x<0||body_x>400/ratio||body_y<0||body_y > 400 / ratio) {
                    world.DestroyBody(myBody);
                    bodyToDestroyList.splice(i,1);
                }
            }
        }
        
        private function setupDebugDraw():void
        {
            var sprite:Sprite = new Sprite();
            addChild(sprite);
            var debugMode:b2DebugDraw = new b2DebugDraw();
            debugMode.SetFlags(b2DebugDraw.e_shapeBit);
            debugMode.m_sprite=sprite;
            debugMode.m_drawScale = ratio;
            debugMode.m_fillAlpha = .3;
            world.SetDebugDraw(debugMode);
            
        }
        
        private function setupWorld():void
        {
            myAABB=new b2AABB();
            myAABB.lowerBound.Set(-1000/ratio, -1000/ratio);
            myAABB.upperBound.Set(1000/ratio,1000/ratio);
            world=new b2World(myAABB,new b2Vec2(0,10),true);
        }
        
        //
        private var _cam:Camera;
        private var _tracker:Tracker;
        private var _px:Number = 465 * .5
        private var _py:Number = 465 * .5
        
        private function initVideo():void 
        {
            var video:Video = new Video();
            _cam = Camera.getCamera();
            _cam.setMode(video.width, video.height, 25);
            video.attachCamera(_cam);
            //
            _tracker = new Tracker(video);
            
            // Check Tracking
            addChild(_tracker)
        }
        
    }

}


// Motion Tracker : http://wonderfl.net/c/bcRe

import flash.display.BlendMode;
import flash.filters.BlurFilter;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.media.Video;
import flash.display.Bitmap;
import flash.display.Sprite;

class Tracker extends Sprite{
    
    public var _previous:BitmapData;
    public var _current:BitmapData;
    public var px:Number;
    public var py:Number;
    
    private var _blur:BlurFilter = new BlurFilter(64, 64);
    private var _vid:Video;
    private var _mirror:Matrix;
    private var _point:Point = new Point();
    private var _area:Rectangle;
    private var _isMotion:Boolean = false;
    
    public function Tracker(vid:Video) {
        _vid = vid;
        _mirror = new Matrix();
        _mirror.scale( -1, 1);
        _mirror.translate(_vid.width, 0);
        
        _current = new BitmapData(_vid.width, _vid.height, false, 0x000000);
        _previous = _current.clone();
        
        //addChild(new Bitmap(_current))
        //addChild(new Bitmap(_previous))
    }
    
    public function track():void {
        _current.draw(_vid, _mirror);
        _current.draw(_previous, null, null, BlendMode.DIFFERENCE);
        _current.applyFilter(_current, _current.rect, _point, _blur);
        _current.threshold(_current, _current.rect, _point, ">",  0xFF333333, 0xFFFFFFFF);
        _previous.draw(_vid, _mirror);
        
        _area = _current.getColorBoundsRect(0xFFFFFFFF, 0xFFFFFFFF, true);
        _isMotion = ( _area.width > ( _vid.width / 100) * 10 || _area.height > (_vid.height / 100) * 10 );
            
        if ( _isMotion ) {
            px = _area.x;
            py = _area.y;
            
            graphics.clear();
            graphics.lineStyle(1, 0xFF0000, .5);
            graphics.drawRect(_area.x, _area.y, _area.width * 465 / 320, _area.height * 465 / 240);
        }
    }
}