/**
 * Copyright pedude ( http://wonderfl.net/user/pedude )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wBqv
 */

package 
{
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    
    public class JugBalance extends Sprite 
    {
        public var jug1:Jug;
        public var jug2:Jug;
        public var bgColor:Shape;
        private var txt:TextField;
        
        public function JugBalance() 
        {
            addGpks();
            jug1 = new Jug(stage.stageWidth/2-200,stage.stageHeight/2+100);
            
            jug2 = new Jug(stage.stageWidth/2-50,stage.stageHeight/2+100);
            addChild(jug1);
            addChild(jug2);
            
            txt = new TextField();
            addChild(txt);
            txt.x = stage.stageWidth/2;
            txt.y = stage.stageHeight/2-100;
            
            stage.addEventListener(Event.ENTER_FRAME, update);
            
        
        }
        
        public function addGpks():void
        {
            bgColor = new Shape();
            addChild(bgColor);
            bgColor.graphics.beginFill(0x8FA880);
            bgColor.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bgColor.graphics.endFill();
        }
        
        public function update(evt:Event):void
        {
            
            txt.text = "FPS:"+stage.frameRate;
        }


    }
    
    
}

import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.geom.*;

class Jug extends MovieClip
{
    private var jBord:Shape;
    private var liq:BitmapData;
    private var liqBM:Bitmap;
    private var jCont:MovieClip;
    private var _x:Number;
    private var _y:Number;
    private const jugWidth:Number = 75;
    private const jugHeight:Number = 90;
    private var bmc:ByteArray;
    private var jugDim:Rectangle;
    private var jugCbg:Shape;
    private var bl:Bubbles;
   // private var bub:Array;
    
    
    public function Jug(ex:Number, ey:Number):void
    {
        _x = ex;
        _y = ey;
        initGrafiks();      
        this.addEventListener(MouseEvent.MOUSE_OVER, moJug);  
        this.addEventListener(MouseEvent.CLICK, mcJug);  
        addEventListener(Event.ENTER_FRAME, update);
    }
    
    public function moJug(evt:MouseEvent):void
    {
        buttonMode = true;
    }
    
    public function mcJug(evt:MouseEvent):void
    {
        
    }

    public function getX():Number
    {
        return _x;
    }
    
    public function getY():Number
    {
        return _y;
    }
    
    public function initGrafiks():void
    {
        
        
        liq = new BitmapData(jugWidth, jugHeight-15, false, 0x0099CC);
        jugDim = new Rectangle(this.getX(), this.getY()-jugHeight, jugWidth, jugHeight);
        //bmc = liq.getPixels(jugDim);
        liq.setPixels(jugDim, liq.getPixels(jugDim));
        liqBM = new Bitmap(liq);
        liqBM.x = this.getX();
        liqBM.y = this.getY()-jugHeight+15;
        addChild(liqBM);
        
        jCont = new MovieClip();
        jBord = new Shape();
        jCont.addChild(jBord);
        addChild(jCont);
        jBord.graphics.lineStyle(4, 0x0000FF);
        jBord.graphics.moveTo(this.getX(), this.getY());
        jBord.graphics.lineTo(this.getX(), this.getY()-jugHeight);
        jBord.graphics.lineTo(this.getX()+jugWidth, this.getY()-jugHeight);
        jBord.graphics.lineTo(this.getX()+jugWidth, this.getY());
        jBord.graphics.lineTo(this.getX(), this.getY());
                
        bl = new Bubbles(new Array(2,3));
        addChild(bl);
        bl.setPos([30, 230]);
        
        bl.riseTo(3);
        
    }
    
    public function update(evt:Event):void
    {
        jugCbg.graphics.lineStyle(1, 0x0099CC);
        jugCbg.graphics.beginFill(0x0099CC);
        
        jugCbg.graphics.endFill();
        
    }

    

}


import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.geom.*;

class Bubbles extends Sprite
{
    private var bub:Sprite;
    private var loc:Array;
    private var smooth:int;
    private var oldY:int;
    
    public function Bubbles(_loc:Array, _smooth:int=0.7):void
    {
        loc = _loc;
        smooth = _smooth;    
        
        bub = new Sprite();   
        bub.graphics.beginFill(0x00688B);
        bub.graphics.drawCircle(0, 0, 5);
        bub.graphics.endFill();
        addChild(bub);
        bub.x = 0;
        bub.y = 0;       
        
        
       // stage.addEventListener(Event.ENTER_FRAME, update);
    }
        
    public function getLoc():Array
    {
        return loc;
    }
    
    public function setPos(arr:Array):void
    {
        bub.x = arr[0]
        bub.y = arr[1];
        oldY = bub.y;
    }
    
    public function riseTo(_destY:int):void
    {
        
        var destY:int = _destY;
        
        
        for (var i:int=0; i < (-destY+oldY)/smooth; i += smooth)
        {
            bub.y -= smooth;
        }
        
    }
        
    public function getSmooth():int
    {
        return smooth;
    }

    public function percUp():void
    {
     //   for (var i:int=0; i< smooth; i++)
     //   {
          //  bub.y = stage.stageHeight/2;
     //   }

        
    }
    
    public function update(evt:Event):void
    {
        //percUp();
    }


}

/*

import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.geom.*;

class UTILS extends MovieClip
{
    private static var fps:int;
    private var oldT:Number;
    private var oneT:Boolean = false;

    
    public function UTILS():void
    {
        stage.addEventListener(Event.ENTER_FRAME, update);
    }
        
    public static function getFPS():int
    {
        return fps;
    }
    
    public function update(evt:Event):void
    {
        //fps = (oneT) ? getTimer : ;
        

        if (oneT)
            fps = getTimer();  
        else
        {
            fps = (getTimer() - fps)/1000;
            stage.removeEventListener(Event.ENTER_FRAME, update);
        }
    }
    
}
*/



