/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wBh6
 */

package 
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    
    /**
     * ...
     * @author rettuce
     * 
     */
    public class Main extends Sprite
    {
        private var MAX:Number = 10;
        private var _arrow:Sprite;
        private var NUM:uint = 50;    //長さ
        
        private var _speed:Number  = 1;
        private var _radius:Number;
        private var pointArr:Array = [];
        private var pointParamArr:Array = [];
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }
        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();

            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void {
                removeEventListener(Event.ENTER_FRAME, enterframeHandler);
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
            
            _radius = stage.stageHeight/2
            
            var arrowMouse = new ArrowMouse(this, 15, 15, 0xFFFF00);
            addChild(arrowMouse);
            
            for(var i:int=0; i<=MAX; i++){
                var _targetPoint:Sprite = new Sprite();
                pointArr[i] = _targetPoint;
                pointParamArr[i] = new Object();
                pointParamArr[i]["radius"] = _radius*Math.random()+50; 
                pointParamArr[i]["speed"]  = _speed*Math.random()+0.5;
                pointParamArr[i]["angle"]  = 2*Math.random()-1;
                _arrow = new Arrow(this, _targetPoint, 50*Math.random()+20, 15*Math.random()+10, 0xFFFFFF*Math.random());
                addChild(_arrow);
            }    
            addEventListener(Event.ENTER_FRAME, enterframeHandler);
        }
        
        private function enterframeHandler(e:Event):void
        {
            for(var i:int=0; i<=MAX; i++){
                var rad:Number = pointParamArr[i]["radius"]; 
                var spe:Number = pointParamArr[i]["speed"];
                pointParamArr[i]["angle"] += spe;
                var ang:Number = pointParamArr[i]["angle"];
                pointArr[i].x = Math.cos(ang*Math.PI/180)*rad + stage.stageWidth/2;
                pointArr[i].y = Math.sin(ang*Math.PI/180)*rad + stage.stageHeight/2;
            }                        
        }
        
        
        /********* stage set ************/
        
        private function setStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void {
            resizeHandler();
        }        
        public function resizeHandler():void {
            
        }
        
    }
}


    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    class Arrow extends Sprite
    {
        private var _root;
        private var _point;
        private var _arrow:Sprite;
        private var _angle:Number;
        private var _speed:Number;        
        private var NUM:uint;    //長さ
        private var BOLD:uint;    //太さ
        private var COLOR:uint;    //線色        
        private var pointArrL:Array = [];
        private var pointArrR:Array = [];
        
        public function Arrow(target, targetPoint, long:Number=50 , bold:Number=15, color:Number = 0xFFFF00)
        {
            _root  = target;
            _point = targetPoint;
            NUM  = long;
            BOLD = bold;
            COLOR = color; 
            init();
        }
        
        public function init():void
        {
            _arrow = new Sprite();
            addEventListener(Event.ENTER_FRAME, mousemoveHandler);
        }

        private function mousemoveHandler(e:Event):void
        {
            if(pointArrL.length >= NUM && pointArrR.length >= NUM)
            {
                var dx:Number   = _arrow.x - _point.x;
                var dy:Number   = _arrow.y - _point.y;
                if(Math.sqrt(dx*dx + dy*dy)<=15) return;
                
                pointArrL.shift();
                pointArrR.shift();
            };
            
            /* 角度 */
            var tx:Number = _point.x - _arrow.x;
            var ty:Number = _point.y - _arrow.y;
            _angle = Math.atan2(ty, tx);
            
            /* 速度 */
            var sx:Number   = _arrow.x - _point.x;
            var sy:Number   = _arrow.y - _point.y;
            var dist:Number = Math.sqrt(sx*sx + sy*sy);
            _speed = 200*dist/Math.sqrt(stage.stageWidth*stage.stageWidth + stage.stageHeight*stage.stageHeight);
            
            _arrow.x += Math.cos(_angle)*_speed;
            _arrow.y += Math.sin(_angle)*_speed;
            
            var zureL:Point = new Point(Math.cos(_angle-1.57)*BOLD, Math.sin(_angle-1.57)*BOLD);
            var zureR:Point = new Point(Math.cos(_angle+1.57)*BOLD, Math.sin(_angle+1.57)*BOLD);
            
            pointArrL.push(new Point(zureL.x+_point.x, zureL.y+_point.y));
            pointArrR.push(new Point(zureR.x+_point.x, zureR.y+_point.y));

            graphics.clear();
            graphics.lineStyle(1, COLOR, 1);
            
            graphics.moveTo(pointArrL[0].x, pointArrL[0].y);            
            for(var i:int=0; i<pointArrL.length-1; i+=1){
                var px:Number = (pointArrL[i].x + pointArrL[i+1].x)/2;
                var py:Number = (pointArrL[i].y + pointArrL[i+1].y)/2;                
                graphics.curveTo(pointArrL[i].x, pointArrL[i].y, px, py);
            }
            
            /* head */
            if(pointArrL.length <= 2) return;
            graphics.lineTo(pointArrL[pointArrL.length-1].x, pointArrL[pointArrL.length-1].y);
            graphics.lineTo(zureL.x*2+_point.x,  zureL.y*2+_point.y);
            graphics.lineTo(Math.cos(_angle)*BOLD*3+_point.x, Math.sin(_angle)*BOLD*3+_point.y);
            graphics.lineTo(zureR.x*2+_point.x,  zureR.y*2+_point.y);
            graphics.lineTo(pointArrR[pointArrR.length-1].x, pointArrR[pointArrR.length-1].y);            
            graphics.lineTo(pointArrR[pointArrR.length-2].x, pointArrR[pointArrR.length-2].y);            
            
            for(i=pointArrR.length-1; i>1; i-=1){
                px = (pointArrR[i-1].x + pointArrR[i].x)/2;
                py = (pointArrR[i-1].y + pointArrR[i].y)/2;                
                graphics.curveTo(pointArrR[i].x, pointArrR[i].y, px, py);
            }
            graphics.lineTo(pointArrL[0].x, pointArrL[0].y);                        
            graphics.endFill();            
        }
        
    }


    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    class ArrowMouse extends Sprite
    {
        private var _root;
        private var _arrow:Sprite;
        private var _angle:Number;
        private var _speed:Number;        
        private var NUM:uint;    //長さ
        private var BOLD:uint;    //太さ
        private var COLOR:uint;    //線色        
        private var pointArrL:Array = [];
        private var pointArrR:Array = [];
        
        public function ArrowMouse(target, long:Number=50 , bold:Number=15, color:Number = 0xFFFF00)
        {
            _root = target;
            NUM  = long;
            BOLD = bold;
            COLOR = color; 
            init();
        }
        
        public function init():void
        {
            _arrow = new Sprite();
            _root.stage.addEventListener(MouseEvent.MOUSE_MOVE, mousemoveHandler);
        }

        /* マウスポイントをCurveTo座標として配列で使用 */
        private function mousemoveHandler(e:Event):void
        {
            if(pointArrL.length >= NUM && pointArrR.length >= NUM)
            {
                var dx:Number   = _arrow.x - mouseX;
                var dy:Number   = _arrow.y - mouseY;
                if(Math.sqrt(dx*dx + dy*dy)<=15) return;
                
                pointArrL.shift();
                pointArrR.shift();
            };
            
            /* 角度 */
            var tx:Number = mouseX - _arrow.x;
            var ty:Number = mouseY - _arrow.y;
            _angle = Math.atan2(ty, tx);
            
            /* 速度 */
            var sx:Number   = _arrow.x - mouseX;
            var sy:Number   = _arrow.y - mouseY;
            var dist:Number = Math.sqrt(sx*sx + sy*sy);
            _speed = 200*dist/Math.sqrt(stage.stageWidth*stage.stageWidth + stage.stageHeight*stage.stageHeight);
            
            _arrow.x += Math.cos(_angle)*_speed;
            _arrow.y += Math.sin(_angle)*_speed;
            
            var zureL:Point = new Point(Math.cos(_angle-1.57)*BOLD, Math.sin(_angle-1.57)*BOLD);
            var zureR:Point = new Point(Math.cos(_angle+1.57)*BOLD, Math.sin(_angle+1.57)*BOLD);
            
            pointArrL.push(new Point(zureL.x+mouseX, zureL.y+mouseY));
            pointArrR.push(new Point(zureR.x+mouseX, zureR.y+mouseY));

            graphics.clear();
            graphics.lineStyle(1, COLOR, 1);
            
            graphics.moveTo(pointArrL[0].x, pointArrL[0].y);            
            for(var i:int=0; i<pointArrL.length-1; i+=4){
                var px:Number = (pointArrL[i].x + pointArrL[i+1].x)/2;
                var py:Number = (pointArrL[i].y + pointArrL[i+1].y)/2;                
                graphics.curveTo(pointArrL[i].x, pointArrL[i].y, px, py);
            }
            
            /* head */
            if(pointArrL.length <= 2) return;
            graphics.lineTo(pointArrL[pointArrL.length-1].x, pointArrL[pointArrL.length-1].y);
            graphics.lineTo(zureL.x*2+mouseX,  zureL.y*2+mouseY);
            graphics.lineTo(Math.cos(_angle)*BOLD*3+mouseX, Math.sin(_angle)*BOLD*3+mouseY);
            graphics.lineTo(zureR.x*2+mouseX,  zureR.y*2+mouseY);
            graphics.lineTo(pointArrR[pointArrR.length-1].x, pointArrR[pointArrR.length-1].y);            
            
            for(i=pointArrR.length-1; i>1; i-=4){
                px = (pointArrR[i-1].x + pointArrR[i].x)/2;
                py = (pointArrR[i-1].y + pointArrR[i].y)/2;                
                graphics.curveTo(pointArrR[i].x, pointArrR[i].y, px, py);
            }
            graphics.lineTo(pointArrL[0].x, pointArrL[0].y);                        
            graphics.endFill();            
        }
        
    }
