/**
 * Copyright butr0s ( http://wonderfl.net/user/butr0s )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wBca
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.*;

	[SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="24")]
	public class Bezier extends Sprite {
		public var points:Array = new Array();

		public function Bezier():void {
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouse_down);
			addEventListener(Event.ENTER_FRAME, update)
			
			var tf:TextFormat = new TextFormat();
		    tf.font = "_typewriter"; 
			tf.bold = true; 
			tf.size = 18; 
			tf.color = 0x000000; 
			tf.align = TextFormatAlign.CENTER;
			
			var msg:TextField = new TextField();
			msg.text = 'Click to create control points\nfor a Bezier curve';
			msg.x = (465 - msg.width) / 2;
			msg.y = (465 - msg.height) / 2;
			msg.autoSize = "center";
			msg.setTextFormat(tf);
			addChild(msg);
		}
		
		public function update(e:Event):void {
			graphics.clear();
			
			// Draw control points
			for each(var p:Object in points) {
				graphics.lineStyle(3 , 0x0000ff);
				graphics.drawCircle(p.x, p.y, 1)
			}
			
			// Draw points on the bezier curve
			if( points.length == 4 ) {
				var bezier_point:Object;
				graphics.lineStyle(1 , 0x00ff00);
				for( var t:Number = 0; t < 1; t += 0.01 ) {
					bezier_point = bezier(t);
					graphics.drawCircle(bezier_point.x, bezier_point.y, 1)
				}
			}
		}
		
		public function linear_interpolation(a:Object, b:Object, t:Number):Object {
			var result:Object = new Object();
			result.x = a.x + ( b.x - a.x ) * t;
			result.y = a.y + ( b.y - a.y ) * t;
			return result;
		}
		
		public function bezier(t:Number):Object {
			var ab:Object, bc:Object, cd:Object, abbc:Object, bccd:Object;
			ab = linear_interpolation(points[0], points[1], t);
			bc = linear_interpolation(points[1], points[2], t);
			cd = linear_interpolation(points[2], points[3], t);
			abbc = linear_interpolation(ab, bc, t);
			bccd = linear_interpolation(bc, cd, t);
			return linear_interpolation(abbc, bccd, t);
		}
		
		public function mouse_down(e:MouseEvent):void {
			points.push({ x: mouseX, y: mouseY });
			
			if(points.length > 4) 
				points.shift();
		}
	}
}