/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wAw1
 */

// forked from phi16's Box(Test)
package 
{
    import flash.geom.Utils3D;
    import flash.text.TextField;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.GlowFilter;

    public class Box3D extends Sprite 
    {
        public  var spr:Sprite=new Sprite();
        private var rad:Number=0;
        private var dirx:Number=0,diry:Number=0;
        private var colR:int, colG:int, colB:int;
        public  var dotPoint:Point = new Point( 0,0 );
        
        public function Box3D() 
        {
            spr.x = spr.y = 235;
            this.addChild(spr);
            this.addEventListener( Event.ENTER_FRAME,this.Draw );
            this.addEventListener( Event.ENTER_FRAME,realtimeRender );
        }
        
        public function realtimeRender():void
        {                        
            colR = (Math.sin(rad*Math.PI/180)+1)*255/2;
            colG = (Math.sin((rad+120)*Math.PI/180)+1)*255/2;
            colB = (Math.sin((rad-120)*Math.PI/180)+1)*255/2;            
        }

             
        private function Draw(e:Event):void
        {
            var realtimeColor:uint = new uint( colR*256*256+colG*256+colB );
            var gloww:GlowFilter = new GlowFilter( realtimeColor, 1,16,16, 3,3, true,true );           
            this.filters = [ gloww ];            
    
            spr.graphics.clear();
                                   
            var vertexs:Array = new Array
            (
                -1,  -1,  -1,
                -1,   1,  -1,
                -1,   1,   1,
                -1,  -1,   1,
                
                 1,  -1,  -1,
                 1,   1,  -1,
                 1,   1,   1,
                 1,  -1,   1
            );
            
            colR = (Math.sin(rad*Math.PI/180)+1)*255/2;
            colG = (Math.sin((rad+120)*Math.PI/180)+1)*255/2;
            colB = (Math.sin((rad-120)*Math.PI/180)+1)*255/2;


            for(var i:int=0;i<8;i++)
            {
                var x:Number,y:Number,z:Number,x2:Number,y2:Number,z2:Number;
                
                x = vertexs[ i*3   ];
                y = vertexs[ i*3+1 ];
                z = vertexs[ i*3+2 ];
                
                x2 = x*Math.cos(diry*Math.PI/180)+z*Math.sin(diry*Math.PI/180);
                y2 = y;
                z2 = -x*Math.sin(diry*Math.PI/180)+z*Math.cos(diry*Math.PI/180);
                
                x = x2,
                y = y2,
                z = z2;
                
                x2 = x;
                y2 = y*Math.cos(dirx*Math.PI/180)-z*Math.sin(dirx*Math.PI/180);
                z2 = y*Math.sin(dirx*Math.PI/180)+z*Math.cos(dirx*Math.PI/180);
                
                vertexs[ i*3   ]  =  x2*4/(4+z2);
                vertexs[ i*3+1 ]  =  y2*4/(4+z2);
                vertexs[ i*3+2 ]  =  z2;
            }
            
            for(i=0;i<16;i++)
            {
                spr.graphics.lineStyle(20.0,colR*256*256+colG*256+colB ); //  0.5, 0x131413);/FFFFFF); //  10.0,colR*256*256+colG*256+colB );
                spr.graphics.moveTo(vertexs[i*3]*100,vertexs[i*3+1]*100);
                    spr.graphics.curveTo( 0,0,  vertexs[i*3]*100,vertexs[i*3+1]*100  );
                spr.graphics.lineTo(vertexs[(i+1)%4*3]*100,vertexs[(i+1)%4*3+1]*100);
                spr.graphics.lineStyle(20.0,colR*256*256+colG*256+colB ); //   0.5, 0xFFFFFF); //  0.0,colR*256*256+colG*256+colB );
                spr.graphics.moveTo(vertexs[(i+4)*3]*100,vertexs[(i+4)*3+1]*100);
                    spr.graphics.curveTo( 0,0, vertexs[(i+4)*3]*100,vertexs[(i+4)*3+1]*100 );
                spr.graphics.lineTo(vertexs[((i+1)%4+4)*3]*100,vertexs[((i+1)%4+4)*3+1]*100);
                spr.graphics.lineStyle(20.0,colR*256*256+colG*256+colB ); //   0.5, 0xFFFFFF); // (colR*-256) + (colG*-256) + (colB) );
                spr.graphics.moveTo(vertexs[i*3]*100,vertexs[i*3+1]*100);
                    spr.graphics.curveTo( 0,0, vertexs[i*3]*100,vertexs[i*3+1]*100 );
                spr.graphics.lineTo(vertexs[(i+4)*3]*100,vertexs[(i+4)*3+1]*100);
            }
             
            rad  += 3;
            diry += 2;
            dirx += 2;
        }
    }
}