/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wA6B
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=101
    public class Euler101 extends Sprite {
        private var _tf : TextField;
  
        public function Euler101() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            tr(solve());
            var g : int = getTimer();
            tr((g - s) + " ms");
        }

        private function solve() : Number
        {
            var i : int, j : int, k : int;
            var ret : Number = 0.0;
            for(i = 1;i <= 10;i++){
                var a : Array = new Array(i * i);
                for(j = 0;j < i;j++){
                    for(k = 0;k < i;k++){
                        a[j * i + k] = Math.pow(j + 1, k);
                    }
                }
                
                var b : Array = new Array(i); 
                for(j = 0;j < i;j++){
                    b[j] = u(j + 1);
                }
                
                var x : Array = gaussEliminate(a, b);
                var sum : Number = 0.0;
                for(j = 0;j < i;j++){
                    sum += x[j] * Math.pow(i + 1, j);
                }
                tr(i, sum);
                ret += sum;
            }
            return ret;
        }
        
        private function u(n : int) : Number
        {
            var ret : Number = 1;
            for(var i : int = 1;i <= 10;i++){
                ret = 1 - n * ret;
            }
            return ret;
        }
        
        private function gaussEliminate(a : Array, b : Array) : Array
        {
            var n : int = b.length;
            if(n == 0 || a.length != n * n)return null;
            
            var i : int, j : int, k : int;
            for(i = 0;i < n;i++){
                var pmin : Number = Number.MAX_VALUE;
                var p : int = -1;
                for(j = i;j < n;j++){
                    var aji : Number = a[j * n + i];
                    if(aji != 0.0 && Math.abs(aji) < pmin){
                        pmin = aji;
                        p = j;
                    }
                }
                if(p == -1)return null;
                
                if(p != i){
                    var d : Number;
                    for(j = 0;j < n;j++){
                        d = a[i * n + j];
                        a[i * n + j] = a[p * n + j];
                        a[p * n + j] = d;
                    }
                    d = b[i];
                    b[i] = b[p];
                    b[p] = d;
                }
                
                for(j = i + 1;j < n;j++){
                    var m : Number = a[j * n + i] / a[i * n + i];
                    a[j * n + i] = 0;
                    for(k = i + 1;k < n;k++){
                        a[j * n + k] -= a[i * n + k] * m;
                    }
                    b[j] -= b[i] * m;
                }
            }
                
            if(a[n * n - 1] == 0.0)return null;
            var x : Array = new Array(n);
            x[n - 1] = b[n - 1] / a[n * n - 1];
            for(i = n - 2;i >= 0;i--){
                x[i] = b[i];
                for(j = i + 1;j < n;j++){
                    x[i] -= a[i * n + j] * x[j];
                }
                x[i] /= a[i * n + i];
            }
            return x;
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}