/**
 * Copyright aomoriringo ( http://wonderfl.net/user/aomoriringo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w9yk
 */

// forked from uwi's 2010にちなんだ問題
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    
    // @fastneet's problem
    // 2010を含む単調増加な自然数列{a_n}は、
    // a_{n+2} = a_n + a_{n+1} を満たしている。
    // a_1, a_2は何通りあるか。ただし、a_1, a_2≠2010とする。
    // @see http://d.hatena.ne.jp/aomori-ringo2/20100102
    public class Test extends Sprite {
        private var _tf : TextField;
  
        public function Test() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            
            tr(solve(7110) + "通り");
            
            var g : int = getTimer();
            tr((g - s) + " ms");
        }
        
        // フィボナッチ数列を{F_n}とすると、あるnについて
        // xF_n+yF_{n+1}=2010 を満たす(x, y)がa_1, a_2となる。
        // このときa_{n+2}=2010.
        private function solve(N : uint) : uint
        {
            var a : uint = 1;
            var b : uint = 1;
            var c : uint;
            var ct : uint = 0;
            var n : uint = 3;
            for(;a + b <= N;c = a, a = b, b = c + b, n++){
                for(var x : uint = 1;x < N / (a + b);x++){
                    var y : Number = (N - a * x) / b;
                    if(int(y) == y){
                        ct++;
                        tr(n, x, y);
                    }
                }
            }
            return ct;
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}