/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w9tj
 */

// forked from 0xABCDEF's stage3d study - lighting
// forked from codeonwort's stage3d study - shadow on plane
// forked from codeonwort's stage3d study - the tetrahedron
package {
    
    import flash.display.Sprite
        import flash.events.Event
        
        public class Study3D extends Sprite {
            
            public function Study3D() {
                stage.scaleMode = "noScale"
                stage.align = "LT"
                
                stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, initStage3D)
                stage.stage3Ds[0].requestContext3D()
            }
            
            private function initStage3D(e:Event):void {
                new Study_ShadowOnPlane(this, e.target.context3D)
            }
            
        }
        
}
import com.adobe.utils.AGALMiniAssembler;
import com.adobe.utils.PerspectiveMatrix3D;

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.Sprite;
import flash.display.Stage;
import flash.display3D.Context3D;
import flash.display3D.Context3DTriangleFace;
import flash.display3D.IndexBuffer3D;
import flash.display3D.Program3D;
import flash.display3D.VertexBuffer3D;
import flash.events.Event;
import flash.geom.Matrix3D;
import flash.net.URLRequest;
import flash.system.LoaderContext;
/**
 * ...
 * @author codeonwort
 */
internal class Study_Base 
{
    
    protected var document:Sprite, stage:Stage, context:Context3D
    //protected var antiAlias:int = 4, enableDepthAndStencil:Boolean = false
    
    protected var perspectiveTransform:PerspectiveMatrix3D
    
    //protected var vertBuf:VertexBuffer3D
    //protected var idxBuf:IndexBuffer3D
    
    protected var vsAsm:AGALMiniAssembler
    protected var fsAsm:AGALMiniAssembler
    protected var program:Program3D
    
    public function Study_Base(document:Sprite, context:Context3D) 
    {
        this.document = document
        stage = document.stage
        this.context = context
        
        stage.addEventListener("resize", resize)
        
        vsAsm = new AGALMiniAssembler
        fsAsm = new AGALMiniAssembler
        perspectiveTransform = new PerspectiveMatrix3D
        perspectiveTransform.perspectiveFieldOfViewLH(45, stage.stageWidth / stage.stageHeight, 0.1, 100)
        program = context.createProgram()
        
        setupContext()
    }
    
    protected function resize(e:Event = null):void {
        setupContext()
    }
    
    protected function setupContext():void {
        context.configureBackBuffer(stage.stageWidth, stage.stageHeight, 4, false)
    }
    
    // 셰이더 코드에 \n + 붙이기 귀찮아서
    protected function unify(...commands):String {
        var str:String = ""
        for each(var cmd:String in commands) {
            str += cmd + "\n"
        }
        return str
    }
    
}

//}

//package  
//{
import flash.geom.Matrix3D;
import flash.geom.Vector3D;
/**
 * ...
 * @author ...
 */
internal class Geometry 
{
    private static const xAxis:Vector3D = new Vector3D(1, 0, 0)
    private static const yAxis:Vector3D = new Vector3D(0, 1, 0)
    private static const zAxis:Vector3D = new Vector3D(0, 0, 1)
    
    private var _transform:Matrix3D
    public var vbuf:Vector.<Number> // data for vertex buffer. position
    public var nbuf:Vector.<Number> // normal
    public var cbuf:Vector.<Number> // color
    public var tbuf:Vector.<Number> // texture coord
    public var ibuf:Vector.<uint> // data for index buffer
    
    public function Geometry() 
    {
        _transform = new Matrix3D
        vbuf = new Vector.<Number>
        nbuf = new Vector.<Number>
        cbuf = new Vector.<Number>
        tbuf = new Vector.<Number>
        ibuf = new Vector.<uint>
    }
    
    // append
    public function move(x:Number, y:Number, z:Number):void {
        _transform.appendTranslation(x, y, z)
    }
    public function spin(degrees:Number, axis:Vector3D, pivot:Vector3D=null):void {
        _transform.appendRotation(degrees, axis, pivot)
    }
    public function spinX(degrees:Number, pivot:Vector3D = null):void {
        _transform.appendRotation(degrees, xAxis, pivot)
    }
    public function spinY(degrees:Number, pivot:Vector3D = null):void {
        _transform.appendRotation(degrees, yAxis, pivot)
    }
    public function spinZ(degrees:Number, pivot:Vector3D = null):void {
        _transform.appendRotation(degrees, zAxis, pivot)
    }
    public function zoom(x:Number, y:Number, z:Number):void {
        _transform.appendScale(x, y, z)
    }
    
    // prepend
    public function premove(x:Number, y:Number, z:Number):void {
        _transform.prependTranslation(x, y, z)
    }
    public function prespin(degrees:Number, axis:Vector3D, pivot:Vector3D=null):void {
        _transform.prependRotation(degrees, axis, pivot)
    }
    public function prespinX(degrees:Number, pivot:Vector3D = null):void {
        _transform.prependRotation(degrees, xAxis, pivot)
    }
    public function prespinY(degrees:Number, pivot:Vector3D = null):void {
        _transform.prependRotation(degrees, yAxis, pivot)
    }
    public function prespinZ(degrees:Number, pivot:Vector3D = null):void {
        _transform.prependRotation(degrees, zAxis, pivot)
    }
    public function prezoom(x:Number, y:Number, z:Number):void {
        _transform.prependScale(x, y, z)
    }
    
    public function get transform():Matrix3D { return _transform }
    public function get deltaTransform():Matrix3D {
        var d:Vector.<Number> = _transform.rawData
        d[12] = d[13] = d[14] = 0
        return new Matrix3D(d)
    }
}

//}

//package  
//{
/**
 * ...
 * @author ...
 */
internal class Model extends Geometry 
{
    
    public function Model() 
    {
        vbuf = Vector.<Number>([0.25, 3.786098, -0.336728, 0.095491, 3.786098, -0.448985, 0.475528, 3.928138, -0.500584, 0.475528, 3.928138, -0.500584, 0.095491, 3.786098, -0.448985, 0.181636, 3.928138, -0.71411, 0.095491, 3.786098, -0.448985, -0.095492, 3.786098, -0.448985, 0.181636, 3.928138, -0.71411, 0.181636, 3.928138, -0.71411, -0.095492, 3.786098, -0.448985, -0.181636, 3.928138, -0.71411, -0.095492, 3.786098, -0.448985, -0.25, 3.786098, -0.336728, -0.181636, 3.928138, -0.71411, -0.181636, 3.928138, -0.71411, -0.25, 3.786098, -0.336728, -0.475528, 3.928138, -0.500584, -0.25, 3.786098, -0.336728, -0.309017, 3.786098, -0.155093, -0.475528, 3.928138, -0.500584, -0.475528, 3.928138, -0.500584, -0.309017, 3.786098, -0.155093, -0.587785, 3.928138, -0.155093, -0.309017, 3.786098, -0.155093, -0.25, 3.786098, 0.026543, -0.587785, 3.928138, -0.155093, -0.587785, 3.928138, -0.155093, -0.25, 3.786098, 0.026543, -0.422427, 3.915709, 0.223133, -0.25, 3.786098, 0.026543, -0.111373, 3.768411, 0.137338, -0.422427, 3.915709, 0.223133, -0.422427, 3.915709, 0.223133, -0.111373, 3.768411, 0.137338, -0.117944, 3.839431, 0.401857, 0.25, 3.786098, 0.026543, 0.422427, 3.915709, 0.223133, 0.111373, 3.768411, 0.137338, 0.111373, 3.768411, 0.137338, 0.422427, 3.915709, 0.223133, 0.117944, 3.839431, 0.401857, 0.309017, 3.786098, -0.155093, 0.587785, 3.928138, -0.155093, 0.25, 3.786098, 0.026543, 0.25, 3.786098, 0.026543, 0.587785, 3.928138, -0.155093, 0.422427, 3.915709, 0.223133, 0.309017, 3.786098, -0.155093, 0.25, 3.786098, -0.336728, 0.587785, 3.928138, -0.155093, 0.587785, 3.928138, -0.155093, 0.25, 3.786098, -0.336728, 0.475528, 3.928138, -0.500584, 0.475528, 3.928138, -0.500584, 0.181636, 3.928138, -0.71411, 0.654509, 4.14937, -0.630621, 0.654509, 4.14937, -0.630621, 0.181636, 3.928138, -0.71411, 0.25, 4.14937, -0.924514, 0.181636, 3.928138, -0.71411, -0.181636, 3.928138, -0.71411, 0.25, 4.14937, -0.924514, 0.25, 4.14937, -0.924514, -0.181636, 3.928138, -0.71411, -0.25, 4.14937, -0.924514, -0.181636, 3.928138, -0.71411, -0.475528, 3.928138, -0.500584, -0.25, 4.14937, -0.924514, -0.25, 4.14937, -0.924514, -0.475528, 3.928138, -0.500584, -0.654509, 4.14937, -0.630621, -0.475528, 3.928138, -0.500584, -0.587785, 3.928138, -0.155093, -0.654509, 4.14937, -0.630621, -0.654509, 4.14937, -0.630621, -0.587785, 3.928138, -0.155093, -0.809017, 4.14937, -0.155093, -0.422427, 3.915709, 0.223133, -0.608856, 4.110299, 0.320436, -0.587785, 3.928138, -0.155093, -0.587785, 3.928138, -0.155093, -0.608856, 4.110299, 0.320436, -0.809017, 4.14937, -0.155093, -0.117944, 3.839431, 0.401857, -0.220355, 4.067378, 0.598615, -0.422427, 3.915709, 0.223133, -0.422427, 3.915709, 0.223133, -0.220355, 4.067378, 0.598615, -0.608856, 4.110299, 0.320436, -0.117944, 3.839431, 0.401857, 0.117944, 3.839431, 0.401857, -0.220355, 4.067378, 0.598615, -0.220355, 4.067378, 0.598615, 0.117944, 3.839431, 0.401857, 0.220355, 4.067378, 0.598614, 0.117944, 3.839431, 0.401857, 0.422427, 3.915709, 0.223133, 0.220355, 4.067378, 0.598614, 0.220355, 4.067378, 0.598614, 0.422427, 3.915709, 0.223133, 0.608856, 4.110299, 0.320435, 0.422427, 3.915709, 0.223133, 0.587785, 3.928138, -0.155093, 0.608856, 4.110299, 0.320435, 0.608856, 4.110299, 0.320435, 0.587785, 3.928138, -0.155093, 0.809017, 4.14937, -0.155093, 0.587785, 3.928138, -0.155093, 0.475528, 3.928138, -0.500584, 0.809017, 4.14937, -0.155093, 0.809017, 4.14937, -0.155093, 0.475528, 3.928138, -0.500584, 0.654509, 4.14937, -0.630621, 0.654509, 4.14937, -0.630621, 0.25, 4.14937, -0.924514, 0.769421, 4.428138, -0.71411, 0.769421, 4.428138, -0.71411, 0.25, 4.14937, -0.924514, 0.293893, 4.428138, -1.059602, 0.25, 4.14937, -0.924514, -0.25, 4.14937, -0.924514, 0.293893, 4.428138, -1.059602, 0.293893, 4.428138, -1.059602, -0.25, 4.14937, -0.924514, -0.293893, 4.428138, -1.059601, -0.25, 4.14937, -0.924514, -0.654509, 4.14937, -0.630621, -0.293893, 4.428138, -1.059601, -0.293893, 4.428138, -1.059601, -0.654509, 4.14937, -0.630621, -0.769421, 4.428138, -0.71411, -0.654509, 4.14937, -0.630621, -0.809017, 4.14937, -0.155093, -0.769421, 4.428138, -0.71411, -0.769421, 4.428138, -0.71411, -0.809017, 4.14937, -0.155093, -0.951057, 4.428138, -0.155093, -0.608856, 4.110299, 0.320436, -0.769421, 4.428138, 0.403924, -0.809017, 4.14937, -0.155093, -0.809017, 4.14937, -0.155093, -0.769421, 4.428138, 0.403924, -0.951057, 4.428138, -0.155093, -0.220355, 4.067378, 0.598615, -0.293893, 4.428138, 0.749416, -0.608856, 4.110299, 0.320436, -0.608856, 4.110299, 0.320436, -0.293893, 4.428138, 0.749416, -0.769421, 4.428138, 0.403924, -0.220355, 4.067378, 0.598615, 0.220355, 4.067378, 0.598614, -0.293893, 4.428138, 0.749416, -0.293893, 4.428138, 0.749416, 0.220355, 4.067378, 0.598614, 0.293893, 4.428138, 0.749416, 0.220355, 4.067378, 0.598614, 0.608856, 4.110299, 0.320435, 0.293893, 4.428138, 0.749416, 0.293893, 4.428138, 0.749416, 0.608856, 4.110299, 0.320435, 0.769421, 4.428138, 0.403924, 0.608856, 4.110299, 0.320435, 0.809017, 4.14937, -0.155093, 0.769421, 4.428138, 0.403924, 0.769421, 4.428138, 0.403924, 0.809017, 4.14937, -0.155093, 0.951057, 4.428138, -0.155093, 0.809017, 4.14937, -0.155093, 0.654509, 4.14937, -0.630621, 0.951057, 4.428138, -0.155093, 0.951057, 4.428138, -0.155093, 0.654509, 4.14937, -0.630621, 0.769421, 4.428138, -0.71411, 0.769421, 4.428138, -0.71411, 0.293893, 4.428138, -1.059602, 0.809017, 4.737155, -0.742878, 0.809017, 4.737155, -0.742878, 0.293893, 4.428138, -1.059602, 0.309017, 4.737155, -1.106149, 0.293893, 4.428138, -1.059602, -0.293893, 4.428138, -1.059601, 0.309017, 4.737155, -1.106149, 0.309017, 4.737155, -1.106149, -0.293893, 4.428138, -1.059601, -0.309017, 4.737155, -1.106149, -0.293893, 4.428138, -1.059601, -0.769421, 4.428138, -0.71411, -0.309017, 4.737155, -1.106149, -0.309017, 4.737155, -1.106149, -0.769421, 4.428138, -0.71411, -0.809017, 4.737155, -0.742878, -0.769421, 4.428138, -0.71411, -0.951057, 4.428138, -0.155093, -0.809017, 4.737155, -0.742878, -0.809017, 4.737155, -0.742878, -0.951057, 4.428138, -0.155093, -1, 4.737155, -0.155093, -0.951057, 4.428138, -0.155093, -0.769421, 4.428138, 0.403924, -1, 4.737155, -0.155093, -1, 4.737155, -0.155093, -0.769421, 4.428138, 0.403924, -0.809017, 4.737155, 0.432693, -0.769421, 4.428138, 0.403924, -0.293893, 4.428138, 0.749416, -0.809017, 4.737155, 0.432693, -0.809017, 4.737155, 0.432693, -0.293893, 4.428138, 0.749416, -0.309017, 4.737155, 0.795964, -0.293893, 4.428138, 0.749416, 0.293893, 4.428138, 0.749416, -0.309017, 4.737155, 0.795964, -0.309017, 4.737155, 0.795964, 0.293893, 4.428138, 0.749416, 0.309017, 4.737155, 0.795964, 0.293893, 4.428138, 0.749416, 0.769421, 4.428138, 0.403924, 0.309017, 4.737155, 0.795964, 0.309017, 4.737155, 0.795964, 0.769421, 4.428138, 0.403924, 0.809017, 4.737155, 0.432692, 0.769421, 4.428138, 0.403924, 0.951057, 4.428138, -0.155093, 0.809017, 4.737155, 0.432692, 0.809017, 4.737155, 0.432692, 0.951057, 4.428138, -0.155093, 1, 4.737155, -0.155093, 0.951057, 4.428138, -0.155093, 0.769421, 4.428138, -0.71411, 1, 4.737155, -0.155093, 1, 4.737155, -0.155093, 0.769421, 4.428138, -0.71411, 0.809017, 4.737155, -0.742878, 0.809017, 4.737155, -0.742878, 0.309017, 4.737155, -1.106149, 0.769421, 5.046173, -0.71411, 0.769421, 5.046173, -0.71411, 0.309017, 4.737155, -1.106149, 0.293893, 5.046173, -1.059602, 0.309017, 4.737155, -1.106149, -0.309017, 4.737155, -1.106149, 0.293893, 5.046173, -1.059602, 0.293893, 5.046173, -1.059602, -0.309017, 4.737155, -1.106149, -0.293893, 5.046173, -1.059601, -0.309017, 4.737155, -1.106149, -0.809017, 4.737155, -0.742878, -0.293893, 5.046173, -1.059601, -0.293893, 5.046173, -1.059601, -0.809017, 4.737155, -0.742878, -0.769421, 5.046173, -0.71411, -0.809017, 4.737155, -0.742878, -1, 4.737155, -0.155093, -0.769421, 5.046173, -0.71411, -0.769421, 5.046173, -0.71411, -1, 4.737155, -0.155093, -0.951057, 5.046173, -0.155093, -1, 4.737155, -0.155093, -0.809017, 4.737155, 0.432693, -0.951057, 5.046173, -0.155093, -0.951057, 5.046173, -0.155093, -0.809017, 4.737155, 0.432693, -0.769421, 5.046173, 0.403924, -0.809017, 4.737155, 0.432693, -0.309017, 4.737155, 0.795964, -0.769421, 5.046173, 0.403924, -0.769421, 5.046173, 0.403924, -0.309017, 4.737155, 0.795964, -0.293893, 5.046173, 0.749416, -0.309017, 4.737155, 0.795964, 0.309017, 4.737155, 0.795964, -0.293893, 5.046173, 0.749416, -0.293893, 5.046173, 0.749416, 0.309017, 4.737155, 0.795964, 0.293893, 5.046173, 0.749416, 0.309017, 4.737155, 0.795964, 0.809017, 4.737155, 0.432692, 0.293893, 5.046173, 0.749416, 0.293893, 5.046173, 0.749416, 0.809017, 4.737155, 0.432692, 0.769421, 5.046173, 0.403924, 0.809017, 4.737155, 0.432692, 1, 4.737155, -0.155093, 0.769421, 5.046173, 0.403924, 0.769421, 5.046173, 0.403924, 1, 4.737155, -0.155093, 0.951057, 5.046173, -0.155093, 1, 4.737155, -0.155093, 0.809017, 4.737155, -0.742878, 0.951057, 5.046173, -0.155093, 0.951057, 5.046173, -0.155093, 0.809017, 4.737155, -0.742878, 0.769421, 5.046173, -0.71411, 0.769421, 5.046173, -0.71411, 0.293893, 5.046173, -1.059602, 0.654509, 5.32494, -0.630621, 0.654509, 5.32494, -0.630621, 0.293893, 5.046173, -1.059602, 0.25, 5.32494, -0.924514, 0.293893, 5.046173, -1.059602, -0.293893, 5.046173, -1.059601, 0.25, 5.32494, -0.924514, 0.25, 5.32494, -0.924514, -0.293893, 5.046173, -1.059601, -0.25, 5.32494, -0.924514, -0.293893, 5.046173, -1.059601, -0.769421, 5.046173, -0.71411, -0.25, 5.32494, -0.924514, -0.25, 5.32494, -0.924514, -0.769421, 5.046173, -0.71411, -0.654509, 5.32494, -0.630621, -0.769421, 5.046173, -0.71411, -0.951057, 5.046173, -0.155093, -0.654509, 5.32494, -0.630621, -0.654509, 5.32494, -0.630621, -0.951057, 5.046173, -0.155093, -0.809017, 5.32494, -0.155093, -0.951057, 5.046173, -0.155093, -0.769421, 5.046173, 0.403924, -0.809017, 5.32494, -0.155093, -0.809017, 5.32494, -0.155093, -0.769421, 5.046173, 0.403924, -0.654509, 5.32494, 0.320436, -0.769421, 5.046173, 0.403924, -0.293893, 5.046173, 0.749416, -0.654509, 5.32494, 0.320436, -0.654509, 5.32494, 0.320436, -0.293893, 5.046173, 0.749416, -0.25, 5.32494, 0.614328, -0.293893, 5.046173, 0.749416, 0.293893, 5.046173, 0.749416, -0.25, 5.32494, 0.614328, -0.25, 5.32494, 0.614328, 0.293893, 5.046173, 0.749416, 0.25, 5.32494, 0.614328, 0.293893, 5.046173, 0.749416, 0.769421, 5.046173, 0.403924, 0.25, 5.32494, 0.614328, 0.25, 5.32494, 0.614328, 0.769421, 5.046173, 0.403924, 0.654509, 5.32494, 0.320435, 0.769421, 5.046173, 0.403924, 0.951057, 5.046173, -0.155093, 0.654509, 5.32494, 0.320435, 0.654509, 5.32494, 0.320435, 0.951057, 5.046173, -0.155093, 0.809017, 5.32494, -0.155093, 0.951057, 5.046173, -0.155093, 0.769421, 5.046173, -0.71411, 0.809017, 5.32494, -0.155093, 0.809017, 5.32494, -0.155093, 0.769421, 5.046173, -0.71411, 0.654509, 5.32494, -0.630621, 0.25, 5.32494, -0.924514, 0.181636, 5.546173, -0.71411, 0.654509, 5.32494, -0.630621, 0.654509, 5.32494, -0.630621, 0.181636, 5.546173, -0.71411, 0.606805, 5.546173, -0.474751, 0.25, 5.32494, -0.924514, -0.25, 5.32494, -0.924514, 0.181636, 5.546173, -0.71411, 0.181636, 5.546173, -0.71411, -0.25, 5.32494, -0.924514, -0.181636, 5.546173, -0.71411, -0.25, 5.32494, -0.924514, -0.654509, 5.32494, -0.630621, -0.181636, 5.546173, -0.71411, -0.181636, 5.546173, -0.71411, -0.654509, 5.32494, -0.630621, -0.606805, 5.546173, -0.474751, -0.654509, 5.32494, -0.630621, -0.809017, 5.32494, -0.155093, -0.606805, 5.546173, -0.474751, -0.606805, 5.546173, -0.474751, -0.809017, 5.32494, -0.155093, -0.695686, 5.546173, -0.155093, -0.809017, 5.32494, -0.155093, -0.654509, 5.32494, 0.320436, -0.695686, 5.546173, -0.155093, -0.695686, 5.546173, -0.155093, -0.654509, 5.32494, 0.320436, -0.475528, 5.546173, 0.190399, -0.654509, 5.32494, 0.320436, -0.25, 5.32494, 0.614328, -0.475528, 5.546173, 0.190399, -0.475528, 5.546173, 0.190399, -0.25, 5.32494, 0.614328, -0.181636, 5.546173, 0.403924, -0.25, 5.32494, 0.614328, 0.25, 5.32494, 0.614328, -0.181636, 5.546173, 0.403924, -0.181636, 5.546173, 0.403924, 0.25, 5.32494, 0.614328, 0.181636, 5.546173, 0.403924, 0.25, 5.32494, 0.614328, 0.654509, 5.32494, 0.320435, 0.181636, 5.546173, 0.403924, 0.181636, 5.546173, 0.403924, 0.654509, 5.32494, 0.320435, 0.475528, 5.546173, 0.190399, 0.809017, 5.32494, -0.155093, 0.695686, 5.546173, -0.155093, 0.654509, 5.32494, 0.320435, 0.654509, 5.32494, 0.320435, 0.695686, 5.546173, -0.155093, 0.475528, 5.546173, 0.190399, 0.654509, 5.32494, -0.630621, 0.606805, 5.546173, -0.474751, 0.809017, 5.32494, -0.155093, 0.809017, 5.32494, -0.155093, 0.606805, 5.546173, -0.474751, 0.695686, 5.546173, -0.155093, 0.606805, 5.546173, -0.474751, 0.181636, 5.546173, -0.71411, 0.378391, 5.688212, -0.391052, 0.378391, 5.688212, -0.391052, 0.181636, 5.546173, -0.71411, 0.095491, 5.688212, -0.448985, 0.181636, 5.546173, -0.71411, -0.181636, 5.546173, -0.71411, 0.095491, 5.688212, -0.448985, 0.095491, 5.688212, -0.448985, -0.181636, 5.546173, -0.71411, -0.095492, 5.688212, -0.448985, -0.606805, 5.546173, -0.474751, -0.378391, 5.688212, -0.391052, -0.181636, 5.546173, -0.71411, -0.181636, 5.546173, -0.71411, -0.378391, 5.688212, -0.391052, -0.095492, 5.688212, -0.448985, -0.695686, 5.546173, -0.155093, -0.475528, 5.546173, 0.190399, -0.467717, 5.688212, -0.10077, -0.467717, 5.688212, -0.10077, -0.475528, 5.546173, 0.190399, -0.25, 5.688212, 0.026543, -0.475528, 5.546173, 0.190399, -0.181636, 5.546173, 0.403924, -0.25, 5.688212, 0.026543, -0.25, 5.688212, 0.026543, -0.181636, 5.546173, 0.403924, -0.095491, 5.688212, 0.1388, -0.181636, 5.546173, 0.403924, 0.181636, 5.546173, 0.403924, -0.095491, 5.688212, 0.1388, -0.095491, 5.688212, 0.1388, 0.181636, 5.546173, 0.403924, 0.095492, 5.688212, 0.1388, 0.181636, 5.546173, 0.403924, 0.475528, 5.546173, 0.190399, 0.095492, 5.688212, 0.1388, 0.095492, 5.688212, 0.1388, 0.475528, 5.546173, 0.190399, 0.25, 5.688212, 0.026543, 0.695686, 5.546173, -0.155093, 0.467717, 5.688212, -0.10077, 0.475528, 5.546173, 0.190399, 0.475528, 5.546173, 0.190399, 0.467717, 5.688212, -0.10077, 0.25, 5.688212, 0.026543, 0.095491, 3.786098, -0.448985, 0.25, 3.786098, -0.336728, 0, 3.737155, -0.155093, -0.095492, 3.786098, -0.448985, 0.095491, 3.786098, -0.448985, 0, 3.737155, -0.155093, -0.25, 3.786098, -0.336728, -0.095492, 3.786098, -0.448985, 0, 3.737155, -0.155093, -0.309017, 3.786098, -0.155093, -0.25, 3.786098, -0.336728, 0, 3.737155, -0.155093, -0.25, 3.786098, 0.026543, -0.309017, 3.786098, -0.155093, 0, 3.737155, -0.155093, -0.111373, 3.768411, 0.137338, -0.25, 3.786098, 0.026543, 0, 3.737155, -0.155093, 0.111373, 3.768411, 0.137338, -0.111373, 3.768411, 0.137338, 0, 3.737155, -0.155093, 0.25, 3.786098, 0.026543, 0.111373, 3.768411, 0.137338, 0, 3.737155, -0.155093, 0.309017, 3.786098, -0.155093, 0.25, 3.786098, 0.026543, 0, 3.737155, -0.155093, 0.25, 3.786098, -0.336728, 0.309017, 3.786098, -0.155093, 0, 3.737155, -0.155093, 0.378391, 5.688212, -0.391052, 0.095491, 5.688212, -0.448985, 0, 5.737155, -0.155093, 0.095491, 5.688212, -0.448985, -0.095492, 5.688212, -0.448985, 0, 5.737155, -0.155093, -0.095492, 5.688212, -0.448985, -0.378391, 5.688212, -0.391052, 0, 5.737155, -0.155093, -0.378391, 5.688212, -0.391052, -0.467717, 5.688212, -0.10077, 0, 5.737155, -0.155093, -0.467717, 5.688212, -0.10077, -0.25, 5.688212, 0.026543, 0, 5.737155, -0.155093, -0.25, 5.688212, 0.026543, -0.095491, 5.688212, 0.1388, 0, 5.737155, -0.155093, -0.095491, 5.688212, 0.1388, 0.095492, 5.688212, 0.1388, 0, 5.737155, -0.155093, 0.095492, 5.688212, 0.1388, 0.25, 5.688212, 0.026543, 0, 5.737155, -0.155093, 0.25, 5.688212, 0.026543, 0.467717, 5.688212, -0.10077, 0, 5.737155, -0.155093, 0.467717, 5.688212, -0.10077, 0.378391, 5.688212, -0.391052, 0, 5.737155, -0.155093, -0.171565, 1.817217, 0.796843, -0.210252, 2.15998, 0.802215, -0.53191, 1.7819, 0.536913, -0.53191, 1.7819, 0.536913, -0.210252, 2.15998, 0.802215, -0.6159, 2.149882, 0.510469, 0.192573, 1.817217, 0.796843, 0.53191, 1.7819, 0.536913, 0.210252, 2.15998, 0.802215, 0.210252, 2.15998, 0.802215, 0.53191, 1.7819, 0.536913, 0.6159, 2.149882, 0.510469, -0.6159, 2.149882, 0.510469, -0.210252, 2.15998, 0.802215, -0.57522, 2.617895, 0.456948, -0.57522, 2.617895, 0.456948, -0.210252, 2.15998, 0.802215, -0.19174, 2.617895, 0.764118, -0.210252, 2.15998, 0.802215, 0.210252, 2.15998, 0.802215, -0.19174, 2.617895, 0.764118, -0.19174, 2.617895, 0.764118, 0.210252, 2.15998, 0.802215, 0.19174, 2.617895, 0.749676, 0.210252, 2.15998, 0.802215, 0.6159, 2.149882, 0.510469, 0.19174, 2.617895, 0.749676, 0.19174, 2.617895, 0.749676, 0.6159, 2.149882, 0.510469, 0.57522, 2.617895, 0.456948, -0.57522, 2.617895, 0.456948, -0.19174, 2.617895, 0.764118, -0.433055, 3.049706, 0.410744, -0.433055, 3.049706, 0.410744, -0.19174, 2.617895, 0.764118, -0.159968, 3.049706, 0.647897, -0.19174, 2.617895, 0.764118, 0.19174, 2.617895, 0.749676, -0.159968, 3.049706, 0.647897, -0.159968, 3.049706, 0.647897, 0.19174, 2.617895, 0.749676, 0.159968, 3.049706, 0.647897, 0.57522, 2.617895, 0.456948, 0.433055, 3.049706, 0.410744, 0.19174, 2.617895, 0.749676, 0.19174, 2.617895, 0.749676, 0.433055, 3.049706, 0.410744, 0.159968, 3.049706, 0.647897, -0.159968, 3.049706, 0.647897, -0.153604, 3.40346, 0.54068, -0.433055, 3.049706, 0.410744, -0.433055, 3.049706, 0.410744, -0.153604, 3.40346, 0.54068, -0.305742, 3.445872, 0.378327, -0.159968, 3.049706, 0.647897, 0.159968, 3.049706, 0.647897, -0.153604, 3.40346, 0.54068, -0.153604, 3.40346, 0.54068, 0.159968, 3.049706, 0.647897, 0.153604, 3.40346, 0.54068, 0.159968, 3.049706, 0.647897, 0.433055, 3.049706, 0.410744, 0.153604, 3.40346, 0.54068, 0.153604, 3.40346, 0.54068, 0.433055, 3.049706, 0.410744, 0.305742, 3.445872, 0.378327, -0.305742, 3.445872, 0.378327, -0.153604, 3.40346, 0.54068, -0.265119, 3.597068, 0.370343, -0.265119, 3.597068, 0.370343, -0.153604, 3.40346, 0.54068, -0.157858, 3.70635, 0.435882, -0.153604, 3.40346, 0.54068, 0.153604, 3.40346, 0.54068, -0.157858, 3.70635, 0.435882, -0.157858, 3.70635, 0.435882, 0.153604, 3.40346, 0.54068, 0.157858, 3.70635, 0.435882, 0.305742, 3.445872, 0.378327, 0.265119, 3.597068, 0.370343, 0.153604, 3.40346, 0.54068, 0.153604, 3.40346, 0.54068, 0.265119, 3.597068, 0.370343, 0.157858, 3.70635, 0.435882, -0.265119, 3.597068, 0.370343, -0.157858, 3.70635, 0.435882, -0.265119, 3.597068, 0.235533, -0.265119, 3.597068, 0.235533, -0.157858, 3.70635, 0.435882, -0.136217, 3.70635, 0.152262, 0.265119, 3.597068, 0.370343, 0.265119, 3.597068, 0.235533, 0.157858, 3.70635, 0.435882, 0.157858, 3.70635, 0.435882, 0.265119, 3.597068, 0.235533, 0.136217, 3.70635, 0.152262, -0.136217, 3.70635, 0.152262, -0.139454, 3.442234, 0.071393, -0.265119, 3.597068, 0.235533, -0.265119, 3.597068, 0.235533, -0.139454, 3.442234, 0.071393, -0.305742, 3.445872, 0.196811, -0.136217, 3.70635, 0.152262, 0.136217, 3.70635, 0.152262, -0.139454, 3.442234, 0.071393, -0.139454, 3.442234, 0.071393, 0.136217, 3.70635, 0.152262, 0.139454, 3.442234, 0.071393, 0.136217, 3.70635, 0.152262, 0.265119, 3.597068, 0.235533, 0.139454, 3.442234, 0.071393, 0.139454, 3.442234, 0.071393, 0.265119, 3.597068, 0.235533, 0.305742, 3.445872, 0.196811, -0.305742, 3.445872, 0.196811, -0.139454, 3.442234, 0.071393, -0.445053, 3.049706, 0.104664, -0.445053, 3.049706, 0.104664, -0.139454, 3.442234, 0.071393, -0.148732, 3.049706, -0.107922, -0.139454, 3.442234, 0.071393, 0.139454, 3.442234, 0.071393, -0.148732, 3.049706, -0.107922, -0.148732, 3.049706, -0.107922, 0.139454, 3.442234, 0.071393, 0.148732, 3.049706, -0.107922, 0.305742, 3.445872, 0.196811, 0.445053, 3.049706, 0.104664, 0.139454, 3.442234, 0.071393, 0.139454, 3.442234, 0.071393, 0.445053, 3.049706, 0.104664, 0.148732, 3.049706, -0.107922, -0.148732, 3.049706, -0.107922, -0.19174, 2.617895, -0.23414, -0.445053, 3.049706, 0.104664, -0.445053, 3.049706, 0.104664, -0.19174, 2.617895, -0.23414, -0.57522, 2.617895, 0.043159, -0.148732, 3.049706, -0.107922, 0.148732, 3.049706, -0.107922, -0.19174, 2.617895, -0.23414, -0.19174, 2.617895, -0.23414, 0.148732, 3.049706, -0.107922, 0.19174, 2.617895, -0.23414, 0.148732, 3.049706, -0.107922, 0.445053, 3.049706, 0.104664, 0.19174, 2.617895, -0.23414, 0.19174, 2.617895, -0.23414, 0.445053, 3.049706, 0.104664, 0.57522, 2.617895, 0.043159, -0.19174, 2.617895, -0.23414, -0.2053, 2.149882, -0.260431, -0.57522, 2.617895, 0.043159, -0.57522, 2.617895, 0.043159, -0.2053, 2.149882, -0.260431, -0.6159, 2.149882, 0.044771, -0.19174, 2.617895, -0.23414, 0.19174, 2.617895, -0.23414, -0.2053, 2.149882, -0.260431, -0.2053, 2.149882, -0.260431, 0.19174, 2.617895, -0.23414, 0.2053, 2.149882, -0.260431, 0.19174, 2.617895, -0.23414, 0.57522, 2.617895, 0.043159, 0.2053, 2.149882, -0.260431, 0.2053, 2.149882, -0.260431, 0.57522, 2.617895, 0.043159, 0.6159, 2.149882, 0.044771, -0.2053, 2.149882, -0.260431, -0.192573, 1.802284, -0.143604, -0.6159, 2.149882, 0.044771, -0.6159, 2.149882, 0.044771, -0.192573, 1.802284, -0.143604, -0.548436, 1.7819, 0.112683, -0.2053, 2.149882, -0.260431, 0.2053, 2.149882, -0.260431, -0.192573, 1.802284, -0.143604, -0.192573, 1.802284, -0.143604, 0.2053, 2.149882, -0.260431, 0.192573, 1.802284, -0.143604, 0.2053, 2.149882, -0.260431, 0.6159, 2.149882, 0.044771, 0.192573, 1.802284, -0.143604, 0.192573, 1.802284, -0.143604, 0.6159, 2.149882, 0.044771, 0.548436, 1.7819, 0.112682, -0.591214, 0, 0.129317, -0.149426, 0, 0.114427, -0.577264, 0, 0.547375, -0.577264, 0, 0.547375, -0.149426, 0, 0.114427, -0.14318, 0, 0.555285, 0.591214, 0, 0.129318, 0.577264, 0, 0.547375, 0.149426, 0, 0.114427, 0.149426, 0, 0.114427, 0.577264, 0, 0.547375, 0.14318, 0, 0.555285, 0.53191, 1.7819, 0.536913, 0.548436, 1.7819, 0.112682, 0.6159, 2.149882, 0.510469, 0.6159, 2.149882, 0.510469, 0.548436, 1.7819, 0.112682, 0.6159, 2.149882, 0.044771, 0.6159, 2.149882, 0.510469, 0.6159, 2.149882, 0.044771, 0.57522, 2.617895, 0.456948, 0.57522, 2.617895, 0.456948, 0.6159, 2.149882, 0.044771, 0.57522, 2.617895, 0.043159, 0.57522, 2.617895, 0.043159, 0.445053, 3.049706, 0.104664, 0.57522, 2.617895, 0.456948, 0.57522, 2.617895, 0.456948, 0.445053, 3.049706, 0.104664, 0.433055, 3.049706, 0.410744, 0.445053, 3.049706, 0.104664, 0.305742, 3.445872, 0.196811, 0.433055, 3.049706, 0.410744, 0.433055, 3.049706, 0.410744, 0.305742, 3.445872, 0.196811, 0.305742, 3.445872, 0.378327, 1.770551, 3.342976, 0.173459, 1.819058, 3.598383, 0.171682, 1.770551, 3.342976, 0.395785, 1.770551, 3.342976, 0.395785, 1.819058, 3.598383, 0.171682, 1.819058, 3.598383, 0.413876, -0.53191, 1.7819, 0.536913, -0.6159, 2.149882, 0.510469, -0.548436, 1.7819, 0.112683, -0.548436, 1.7819, 0.112683, -0.6159, 2.149882, 0.510469, -0.6159, 2.149882, 0.044771, -0.6159, 2.149882, 0.510469, -0.57522, 2.617895, 0.456948, -0.6159, 2.149882, 0.044771, -0.6159, 2.149882, 0.044771, -0.57522, 2.617895, 0.456948, -0.57522, 2.617895, 0.043159, -0.57522, 2.617895, 0.043159, -0.57522, 2.617895, 0.456948, -0.445053, 3.049706, 0.104664, -0.445053, 3.049706, 0.104664, -0.57522, 2.617895, 0.456948, -0.433055, 3.049706, 0.410744, -0.445053, 3.049706, 0.104664, -0.433055, 3.049706, 0.410744, -0.305742, 3.445872, 0.196811, -0.305742, 3.445872, 0.196811, -0.433055, 3.049706, 0.410744, -0.305742, 3.445872, 0.378327, -1.770551, 3.342976, 0.173459, -1.770551, 3.342976, 0.395785, -1.819058, 3.598383, 0.171682, -1.819058, 3.598383, 0.171682, -1.770551, 3.342976, 0.395785, -1.819058, 3.598383, 0.413876, -0.157858, 3.70635, 0.435882, 0.157858, 3.70635, 0.435882, -0.117944, 3.839431, 0.401857, -0.117944, 3.839431, 0.401857, 0.157858, 3.70635, 0.435882, 0.117944, 3.839431, 0.401857, 0.157858, 3.70635, 0.435882, 0.136217, 3.70635, 0.152262, 0.117944, 3.839431, 0.401857, 0.117944, 3.839431, 0.401857, 0.136217, 3.70635, 0.152262, 0.111373, 3.768411, 0.137338, 0.136217, 3.70635, 0.152262, -0.136217, 3.70635, 0.152262, 0.111373, 3.768411, 0.137338, 0.111373, 3.768411, 0.137338, -0.136217, 3.70635, 0.152262, -0.111373, 3.768411, 0.137338, -0.157858, 3.70635, 0.435882, -0.117944, 3.839431, 0.401857, -0.136217, 3.70635, 0.152262, -0.136217, 3.70635, 0.152262, -0.117944, 3.839431, 0.401857, -0.111373, 3.768411, 0.137338, 0.305742, 3.445872, 0.196811, 0.580005, 3.393497, 0.199693, 0.305742, 3.445872, 0.378327, 0.305742, 3.445872, 0.378327, 0.580005, 3.393497, 0.199693, 0.580005, 3.393497, 0.419204, 0.265119, 3.597068, 0.235533, 0.610045, 3.598429, 0.193259, 0.305742, 3.445872, 0.196811, 0.305742, 3.445872, 0.196811, 0.610045, 3.598429, 0.193259, 0.580005, 3.393497, 0.199693, 0.265119, 3.597068, 0.235533, 0.265119, 3.597068, 0.370343, 0.610045, 3.598429, 0.193259, 0.610045, 3.598429, 0.193259, 0.265119, 3.597068, 0.370343, 0.610045, 3.598429, 0.432388, 0.265119, 3.597068, 0.370343, 0.305742, 3.445872, 0.378327, 0.610045, 3.598429, 0.432388, 0.610045, 3.598429, 0.432388, 0.305742, 3.445872, 0.378327, 0.580005, 3.393497, 0.419204, -0.305742, 3.445872, 0.196811, -0.305742, 3.445872, 0.378327, -0.580005, 3.393497, 0.199693, -0.580005, 3.393497, 0.199693, -0.305742, 3.445872, 0.378327, -0.580005, 3.393497, 0.419204, -0.265119, 3.597068, 0.370343, -0.610045, 3.598429, 0.432388, -0.305742, 3.445872, 0.378327, -0.305742, 3.445872, 0.378327, -0.610045, 3.598429, 0.432388, -0.580005, 3.393497, 0.419204, -0.265119, 3.597068, 0.235533, -0.610045, 3.598429, 0.193259, -0.265119, 3.597068, 0.370343, -0.265119, 3.597068, 0.370343, -0.610045, 3.598429, 0.193259, -0.610045, 3.598429, 0.432388, -0.265119, 3.597068, 0.235533, -0.305742, 3.445872, 0.196811, -0.610045, 3.598429, 0.193259, -0.610045, 3.598429, 0.193259, -0.305742, 3.445872, 0.196811, -0.580005, 3.393497, 0.199693, 0.580005, 3.393497, 0.419204, 0.580005, 3.393497, 0.199693, 0.912338, 3.324297, 0.4268, 0.912338, 3.324297, 0.4268, 0.580005, 3.393497, 0.199693, 0.912338, 3.324297, 0.188779, 0.580005, 3.393497, 0.199693, 0.610045, 3.598429, 0.193259, 0.912338, 3.324297, 0.188779, 0.912338, 3.324297, 0.188779, 0.610045, 3.598429, 0.193259, 0.947241, 3.604049, 0.183042, 0.610045, 3.598429, 0.193259, 0.610045, 3.598429, 0.432388, 0.947241, 3.604049, 0.183042, 0.947241, 3.604049, 0.183042, 0.610045, 3.598429, 0.432388, 0.947241, 3.604049, 0.442334, 0.580005, 3.393497, 0.419204, 0.912338, 3.324297, 0.4268, 0.610045, 3.598429, 0.432388, 0.610045, 3.598429, 0.432388, 0.912338, 3.324297, 0.4268, 0.947241, 3.604049, 0.442334, -0.580005, 3.393497, 0.419204, -0.912338, 3.324297, 0.4268, -0.580005, 3.393497, 0.199693, -0.580005, 3.393497, 0.199693, -0.912338, 3.324297, 0.4268, -0.912338, 3.324297, 0.188779, -0.580005, 3.393497, 0.419204, -0.610045, 3.598429, 0.432388, -0.912338, 3.324297, 0.4268, -0.912338, 3.324297, 0.4268, -0.610045, 3.598429, 0.432388, -0.947241, 3.604049, 0.442334, -0.610045, 3.598429, 0.432388, -0.610045, 3.598429, 0.193259, -0.947241, 3.604049, 0.442334, -0.947241, 3.604049, 0.442334, -0.610045, 3.598429, 0.193259, -0.947241, 3.604049, 0.183042, -0.580005, 3.393497, 0.199693, -0.912338, 3.324297, 0.188779, -0.610045, 3.598429, 0.193259, -0.610045, 3.598429, 0.193259, -0.912338, 3.324297, 0.188779, -0.947241, 3.604049, 0.183042, 0.912338, 3.324297, 0.4268, 0.912338, 3.324297, 0.188779, 1.225867, 3.245269, 0.451957, 1.225867, 3.245269, 0.451957, 0.912338, 3.324297, 0.188779, 1.225867, 3.245269, 0.15972, 0.912338, 3.324297, 0.188779, 0.947241, 3.604049, 0.183042, 1.225867, 3.245269, 0.15972, 1.225867, 3.245269, 0.15972, 0.947241, 3.604049, 0.183042, 1.283388, 3.609186, 0.157384, 0.947241, 3.604049, 0.183042, 0.947241, 3.604049, 0.442334, 1.283388, 3.609186, 0.157384, 1.283388, 3.609186, 0.157384, 0.947241, 3.604049, 0.442334, 1.283388, 3.609186, 0.475737, 0.912338, 3.324297, 0.4268, 1.225867, 3.245269, 0.451957, 0.947241, 3.604049, 0.442334, 0.947241, 3.604049, 0.442334, 1.225867, 3.245269, 0.451957, 1.283388, 3.609186, 0.475737, -0.912338, 3.324297, 0.4268, -1.175735, 3.245269, 0.451957, -0.912338, 3.324297, 0.188779, -0.912338, 3.324297, 0.188779, -1.175735, 3.245269, 0.451957, -1.225867, 3.245269, 0.15972, -0.912338, 3.324297, 0.4268, -0.947241, 3.604049, 0.442334, -1.175735, 3.245269, 0.451957, -1.175735, 3.245269, 0.451957, -0.947241, 3.604049, 0.442334, -1.283388, 3.609186, 0.475737, -0.947241, 3.604049, 0.183042, -1.283388, 3.609186, 0.157384, -0.947241, 3.604049, 0.442334, -0.947241, 3.604049, 0.442334, -1.283388, 3.609186, 0.157384, -1.283388, 3.609186, 0.475737, -0.912338, 3.324297, 0.188779, -1.225867, 3.245269, 0.15972, -0.947241, 3.604049, 0.183042, -0.947241, 3.604049, 0.183042, -1.225867, 3.245269, 0.15972, -1.283388, 3.609186, 0.157384, 1.225867, 3.245269, 0.451957, 1.225867, 3.245269, 0.15972, 1.552759, 3.169208, 0.47107, 1.552759, 3.169208, 0.47107, 1.225867, 3.245269, 0.15972, 1.552759, 3.169208, 0.137581, 1.225867, 3.245269, 0.15972, 1.283388, 3.609186, 0.157384, 1.552759, 3.169208, 0.137581, 1.552759, 3.169208, 0.137581, 1.283388, 3.609186, 0.157384, 1.63858, 3.607229, 0.134915, 1.283388, 3.609186, 0.157384, 1.283388, 3.609186, 0.475737, 1.63858, 3.607229, 0.134915, 1.63858, 3.607229, 0.134915, 1.283388, 3.609186, 0.475737, 1.63858, 3.607229, 0.498206, 1.225867, 3.245269, 0.451957, 1.552759, 3.169208, 0.47107, 1.283388, 3.609186, 0.475737, 1.283388, 3.609186, 0.475737, 1.552759, 3.169208, 0.47107, 1.63858, 3.607229, 0.498206, -1.175735, 3.245269, 0.451957, -1.552759, 3.169208, 0.47107, -1.225867, 3.245269, 0.15972, -1.225867, 3.245269, 0.15972, -1.552759, 3.169208, 0.47107, -1.552759, 3.169208, 0.137581, -1.175735, 3.245269, 0.451957, -1.283388, 3.609186, 0.475737, -1.552759, 3.169208, 0.47107, -1.552759, 3.169208, 0.47107, -1.283388, 3.609186, 0.475737, -1.63858, 3.607229, 0.498206, -1.283388, 3.609186, 0.475737, -1.283388, 3.609186, 0.157384, -1.63858, 3.607229, 0.498206, -1.63858, 3.607229, 0.498206, -1.283388, 3.609186, 0.157384, -1.63858, 3.607229, 0.134915, -1.225867, 3.245269, 0.15972, -1.552759, 3.169208, 0.137581, -1.283388, 3.609186, 0.157384, -1.283388, 3.609186, 0.157384, -1.552759, 3.169208, 0.137581, -1.63858, 3.607229, 0.134915, 1.552759, 3.169208, 0.47107, 1.552759, 3.169208, 0.137581, 1.770551, 3.342976, 0.395785, 1.770551, 3.342976, 0.395785, 1.552759, 3.169208, 0.137581, 1.770551, 3.342976, 0.173459, 1.552759, 3.169208, 0.137581, 1.63858, 3.607229, 0.134915, 1.770551, 3.342976, 0.173459, 1.770551, 3.342976, 0.173459, 1.63858, 3.607229, 0.134915, 1.819058, 3.598383, 0.171682, 1.63858, 3.607229, 0.498206, 1.819058, 3.598383, 0.413876, 1.63858, 3.607229, 0.134915, 1.63858, 3.607229, 0.134915, 1.819058, 3.598383, 0.413876, 1.819058, 3.598383, 0.171682, 1.552759, 3.169208, 0.47107, 1.770551, 3.342976, 0.395785, 1.63858, 3.607229, 0.498206, 1.63858, 3.607229, 0.498206, 1.770551, 3.342976, 0.395785, 1.819058, 3.598383, 0.413876, -1.552759, 3.169208, 0.47107, -1.770551, 3.342976, 0.395785, -1.552759, 3.169208, 0.137581, -1.552759, 3.169208, 0.137581, -1.770551, 3.342976, 0.395785, -1.770551, 3.342976, 0.173459, -1.552759, 3.169208, 0.47107, -1.63858, 3.607229, 0.498206, -1.770551, 3.342976, 0.395785, -1.770551, 3.342976, 0.395785, -1.63858, 3.607229, 0.498206, -1.819058, 3.598383, 0.413876, -1.63858, 3.607229, 0.498206, -1.63858, 3.607229, 0.134915, -1.819058, 3.598383, 0.413876, -1.819058, 3.598383, 0.413876, -1.63858, 3.607229, 0.134915, -1.819058, 3.598383, 0.171682, -1.552759, 3.169208, 0.137581, -1.770551, 3.342976, 0.173459, -1.63858, 3.607229, 0.134915, -1.63858, 3.607229, 0.134915, -1.770551, 3.342976, 0.173459, -1.819058, 3.598383, 0.171682, -0.192573, 1.802284, -0.143604, -0.166198, 1.655506, 0.080379, -0.548436, 1.7819, 0.112683, -0.548436, 1.7819, 0.112683, -0.166198, 1.655506, 0.080379, -0.487882, 1.576912, 0.152374, -0.171565, 1.817217, 0.796843, -0.53191, 1.7819, 0.536913, -0.166198, 1.655506, 0.590056, -0.166198, 1.655506, 0.590056, -0.53191, 1.7819, 0.536913, -0.487882, 1.576912, 0.475834, -0.53191, 1.7819, 0.536913, -0.548436, 1.7819, 0.112683, -0.487882, 1.576912, 0.475834, -0.487882, 1.576912, 0.475834, -0.548436, 1.7819, 0.112683, -0.487882, 1.576912, 0.152374, 0.192573, 1.802284, -0.143604, 0.548436, 1.7819, 0.112682, 0.165529, 1.655506, 0.080379, 0.165529, 1.655506, 0.080379, 0.548436, 1.7819, 0.112682, 0.487882, 1.576912, 0.152374, 0.53191, 1.7819, 0.536913, 0.487882, 1.576912, 0.475834, 0.548436, 1.7819, 0.112682, 0.548436, 1.7819, 0.112682, 0.487882, 1.576912, 0.475834, 0.487882, 1.576912, 0.152374, 0.192573, 1.817217, 0.796843, 0.165529, 1.655506, 0.590056, 0.53191, 1.7819, 0.536913, 0.53191, 1.7819, 0.536913, 0.165529, 1.655506, 0.590056, 0.487882, 1.576912, 0.475834, -0.166198, 1.655506, 0.080379, -0.206713, 1.32813, 0.149637, -0.487882, 1.576912, 0.152374, -0.487882, 1.576912, 0.152374, -0.206713, 1.32813, 0.149637, -0.477529, 1.32991, 0.14587, -0.166198, 1.655506, 0.590056, -0.206713, 1.32813, 0.4439, -0.166198, 1.655506, 0.080379, -0.166198, 1.655506, 0.080379, -0.206713, 1.32813, 0.4439, -0.206713, 1.32813, 0.149637, -0.166198, 1.655506, 0.590056, -0.487882, 1.576912, 0.475834, -0.206713, 1.32813, 0.4439, -0.206713, 1.32813, 0.4439, -0.487882, 1.576912, 0.475834, -0.477529, 1.32991, 0.452245, -0.487882, 1.576912, 0.475834, -0.487882, 1.576912, 0.152374, -0.477529, 1.32991, 0.452245, -0.477529, 1.32991, 0.452245, -0.487882, 1.576912, 0.152374, -0.477529, 1.32991, 0.14587, 0.165529, 1.655506, 0.080379, 0.487882, 1.576912, 0.152374, 0.206713, 1.32813, 0.149637, 0.206713, 1.32813, 0.149637, 0.487882, 1.576912, 0.152374, 0.477529, 1.32991, 0.14587, 0.487882, 1.576912, 0.475834, 0.477529, 1.32991, 0.452245, 0.487882, 1.576912, 0.152374, 0.487882, 1.576912, 0.152374, 0.477529, 1.32991, 0.452245, 0.477529, 1.32991, 0.14587, 0.165529, 1.655506, 0.590056, 0.206713, 1.32813, 0.4439, 0.487882, 1.576912, 0.475834, 0.487882, 1.576912, 0.475834, 0.206713, 1.32813, 0.4439, 0.477529, 1.32991, 0.452245, 0.165529, 1.655506, 0.590056, 0.165529, 1.655506, 0.080379, 0.206713, 1.32813, 0.4439, 0.206713, 1.32813, 0.4439, 0.165529, 1.655506, 0.080379, 0.206713, 1.32813, 0.149637, -0.166198, 1.655506, 0.590056, 0.165529, 1.655506, 0.590056, -0.171565, 1.817217, 0.796843, -0.171565, 1.817217, 0.796843, 0.165529, 1.655506, 0.590056, 0.192573, 1.817217, 0.796843, -0.166198, 1.655506, 0.080379, -0.192573, 1.802284, -0.143604, 0.165529, 1.655506, 0.080379, 0.165529, 1.655506, 0.080379, -0.192573, 1.802284, -0.143604, 0.192573, 1.802284, -0.143604, -0.166198, 1.655506, 0.590056, -0.166198, 1.655506, 0.080379, 0.165529, 1.655506, 0.590056, 0.165529, 1.655506, 0.590056, -0.166198, 1.655506, 0.080379, 0.165529, 1.655506, 0.080379, -0.206713, 1.32813, 0.149637, -0.20993, 1.030829, 0.139273, -0.477529, 1.32991, 0.14587, -0.477529, 1.32991, 0.14587, -0.20993, 1.030829, 0.139273, -0.492932, 1.032668, 0.150986, -0.206713, 1.32813, 0.4439, -0.20993, 1.030829, 0.448787, -0.206713, 1.32813, 0.149637, -0.206713, 1.32813, 0.149637, -0.20993, 1.030829, 0.448787, -0.20993, 1.030829, 0.139273, -0.206713, 1.32813, 0.4439, -0.477529, 1.32991, 0.452245, -0.20993, 1.030829, 0.448787, -0.20993, 1.030829, 0.448787, -0.477529, 1.32991, 0.452245, -0.492933, 1.032668, 0.442565, -0.477529, 1.32991, 0.452245, -0.477529, 1.32991, 0.14587, -0.492933, 1.032668, 0.442565, -0.492933, 1.032668, 0.442565, -0.477529, 1.32991, 0.14587, -0.492932, 1.032668, 0.150986, 0.206713, 1.32813, 0.149637, 0.477529, 1.32991, 0.14587, 0.20993, 1.030829, 0.139273, 0.20993, 1.030829, 0.139273, 0.477529, 1.32991, 0.14587, 0.492932, 1.032668, 0.150986, 0.477529, 1.32991, 0.452245, 0.492932, 1.032668, 0.442565, 0.477529, 1.32991, 0.14587, 0.477529, 1.32991, 0.14587, 0.492932, 1.032668, 0.442565, 0.492932, 1.032668, 0.150986, 0.206713, 1.32813, 0.4439, 0.20993, 1.030829, 0.448787, 0.477529, 1.32991, 0.452245, 0.477529, 1.32991, 0.452245, 0.20993, 1.030829, 0.448787, 0.492932, 1.032668, 0.442565, 0.206713, 1.32813, 0.4439, 0.206713, 1.32813, 0.149637, 0.20993, 1.030829, 0.448787, 0.20993, 1.030829, 0.448787, 0.206713, 1.32813, 0.149637, 0.20993, 1.030829, 0.139273, -0.20993, 1.030829, 0.139273, -0.207023, 0.763274, 0.147208, -0.492932, 1.032668, 0.150986, -0.492932, 1.032668, 0.150986, -0.207023, 0.763274, 0.147208, -0.520434, 0.76545, 0.165673, -0.20993, 1.030829, 0.139273, -0.20993, 1.030829, 0.448787, -0.207023, 0.763274, 0.147208, -0.207023, 0.763274, 0.147208, -0.20993, 1.030829, 0.448787, -0.207023, 0.763274, 0.45828, -0.20993, 1.030829, 0.448787, -0.492933, 1.032668, 0.442565, -0.207023, 0.763274, 0.45828, -0.207023, 0.763274, 0.45828, -0.492933, 1.032668, 0.442565, -0.520434, 0.76545, 0.457477, -0.492932, 1.032668, 0.150986, -0.520434, 0.76545, 0.165673, -0.492933, 1.032668, 0.442565, -0.492933, 1.032668, 0.442565, -0.520434, 0.76545, 0.165673, -0.520434, 0.76545, 0.457477, 0.20993, 1.030829, 0.139273, 0.492932, 1.032668, 0.150986, 0.207023, 0.763274, 0.147208, 0.207023, 0.763274, 0.147208, 0.492932, 1.032668, 0.150986, 0.520434, 0.76545, 0.165673, 0.492932, 1.032668, 0.150986, 0.492932, 1.032668, 0.442565, 0.520434, 0.76545, 0.165673, 0.520434, 0.76545, 0.165673, 0.492932, 1.032668, 0.442565, 0.520434, 0.76545, 0.457477, 0.20993, 1.030829, 0.448787, 0.207023, 0.763274, 0.45828, 0.492932, 1.032668, 0.442565, 0.492932, 1.032668, 0.442565, 0.207023, 0.763274, 0.45828, 0.520434, 0.76545, 0.457477, 0.20993, 1.030829, 0.139273, 0.207023, 0.763274, 0.147208, 0.20993, 1.030829, 0.448787, 0.20993, 1.030829, 0.448787, 0.207023, 0.763274, 0.147208, 0.207023, 0.763274, 0.45828, -0.207023, 0.763274, 0.147208, -0.187566, 0.454515, 0.159627, -0.520434, 0.76545, 0.165673, -0.520434, 0.76545, 0.165673, -0.187566, 0.454515, 0.159627, -0.55265, 0.45709, 0.174518, -0.207023, 0.763274, 0.147208, -0.207023, 0.763274, 0.45828, -0.187566, 0.454515, 0.159627, -0.187566, 0.454515, 0.159627, -0.207023, 0.763274, 0.45828, -0.187566, 0.454515, 0.514442, -0.207023, 0.763274, 0.45828, -0.520434, 0.76545, 0.457477, -0.187566, 0.454515, 0.514442, -0.187566, 0.454515, 0.514442, -0.520434, 0.76545, 0.457477, -0.55265, 0.45709, 0.506532, -0.520434, 0.76545, 0.165673, -0.55265, 0.45709, 0.174518, -0.520434, 0.76545, 0.457477, -0.520434, 0.76545, 0.457477, -0.55265, 0.45709, 0.174518, -0.55265, 0.45709, 0.506532, 0.207023, 0.763274, 0.147208, 0.520434, 0.76545, 0.165673, 0.187566, 0.454515, 0.159627, 0.187566, 0.454515, 0.159627, 0.520434, 0.76545, 0.165673, 0.55265, 0.45709, 0.174518, 0.520434, 0.76545, 0.165673, 0.520434, 0.76545, 0.457477, 0.55265, 0.45709, 0.174518, 0.55265, 0.45709, 0.174518, 0.520434, 0.76545, 0.457477, 0.55265, 0.45709, 0.506532, 0.207023, 0.763274, 0.45828, 0.187566, 0.454515, 0.514442, 0.520434, 0.76545, 0.457477, 0.520434, 0.76545, 0.457477, 0.187566, 0.454515, 0.514442, 0.55265, 0.45709, 0.506532, 0.207023, 0.763274, 0.147208, 0.187566, 0.454515, 0.159627, 0.207023, 0.763274, 0.45828, 0.207023, 0.763274, 0.45828, 0.187566, 0.454515, 0.159627, 0.187566, 0.454515, 0.514442, -0.55265, 0.45709, 0.174518, -0.187566, 0.454515, 0.159627, -0.576621, 0.126275, 0.181601, -0.576621, 0.126275, 0.181601, -0.187566, 0.454515, 0.159627, -0.161041, 0.123699, 0.166711, -0.187566, 0.454515, 0.159627, -0.187566, 0.454515, 0.514442, -0.161041, 0.123699, 0.166711, -0.161041, 0.123699, 0.166711, -0.187566, 0.454515, 0.514442, -0.161041, 0.123699, 0.555285, -0.55265, 0.45709, 0.506532, -0.576621, 0.126275, 0.547375, -0.187566, 0.454515, 0.514442, -0.187566, 0.454515, 0.514442, -0.576621, 0.126275, 0.547375, -0.161041, 0.123699, 0.555285, -0.55265, 0.45709, 0.174518, -0.576621, 0.126275, 0.181601, -0.55265, 0.45709, 0.506532, -0.55265, 0.45709, 0.506532, -0.576621, 0.126275, 0.181601, -0.576621, 0.126275, 0.547375, 0.55265, 0.45709, 0.174518, 0.576621, 0.126274, 0.181601, 0.187566, 0.454515, 0.159627, 0.187566, 0.454515, 0.159627, 0.576621, 0.126274, 0.181601, 0.161042, 0.123699, 0.166711, 0.55265, 0.45709, 0.174518, 0.55265, 0.45709, 0.506532, 0.576621, 0.126274, 0.181601, 0.576621, 0.126274, 0.181601, 0.55265, 0.45709, 0.506532, 0.576621, 0.126274, 0.547375, 0.55265, 0.45709, 0.506532, 0.187566, 0.454515, 0.514442, 0.576621, 0.126274, 0.547375, 0.576621, 0.126274, 0.547375, 0.187566, 0.454515, 0.514442, 0.161042, 0.123699, 0.555285, 0.187566, 0.454515, 0.159627, 0.161042, 0.123699, 0.166711, 0.187566, 0.454515, 0.514442, 0.187566, 0.454515, 0.514442, 0.161042, 0.123699, 0.166711, 0.161042, 0.123699, 0.555285, -0.576621, 0.126275, 0.181601, -0.161041, 0.123699, 0.166711, -0.591214, 0, 0.129317, -0.591214, 0, 0.129317, -0.161041, 0.123699, 0.166711, -0.149426, 0, 0.114427, -0.161041, 0.123699, 0.555285, -0.14318, 0, 0.555285, -0.161041, 0.123699, 0.166711, -0.161041, 0.123699, 0.166711, -0.14318, 0, 0.555285, -0.149426, 0, 0.114427, -0.576621, 0.126275, 0.547375, -0.577264, 0, 0.547375, -0.161041, 0.123699, 0.555285, -0.161041, 0.123699, 0.555285, -0.577264, 0, 0.547375, -0.14318, 0, 0.555285, -0.576621, 0.126275, 0.547375, -0.576621, 0.126275, 0.181601, -0.577264, 0, 0.547375, -0.577264, 0, 0.547375, -0.576621, 0.126275, 0.181601, -0.591214, 0, 0.129317, 0.576621, 0.126274, 0.181601, 0.591214, 0, 0.129318, 0.161042, 0.123699, 0.166711, 0.161042, 0.123699, 0.166711, 0.591214, 0, 0.129318, 0.149426, 0, 0.114427, 0.576621, 0.126274, 0.547375, 0.577264, 0, 0.547375, 0.576621, 0.126274, 0.181601, 0.576621, 0.126274, 0.181601, 0.577264, 0, 0.547375, 0.591214, 0, 0.129318, 0.576621, 0.126274, 0.547375, 0.161042, 0.123699, 0.555285, 0.577264, 0, 0.547375, 0.577264, 0, 0.547375, 0.161042, 0.123699, 0.555285, 0.14318, 0, 0.555285, 0.161042, 0.123699, 0.555285, 0.161042, 0.123699, 0.166711, 0.14318, 0, 0.555285, 0.14318, 0, 0.555285, 0.161042, 0.123699, 0.166711, 0.149426, 0, 0.114427, -0.695686, 5.546173, -0.155093, -0.757201, 5.84287, -0.244346, -0.606805, 5.546173, -0.474751, -0.606805, 5.546173, -0.474751, -0.757201, 5.84287, -0.244346, -0.698675, 5.84287, -0.454833, -0.695686, 5.546173, -0.155093, -0.467717, 5.688212, -0.10077, -0.757201, 5.84287, -0.244346, -0.757201, 5.84287, -0.244346, -0.467717, 5.688212, -0.10077, -0.607089, 5.936401, -0.208575, -0.467717, 5.688212, -0.10077, -0.378391, 5.688212, -0.391052, -0.607089, 5.936401, -0.208575, -0.607089, 5.936401, -0.208575, -0.378391, 5.688212, -0.391052, -0.54827, 5.936401, -0.399719, -0.606805, 5.546173, -0.474751, -0.698675, 5.84287, -0.454833, -0.378391, 5.688212, -0.391052, -0.378391, 5.688212, -0.391052, -0.698675, 5.84287, -0.454833, -0.54827, 5.936401, -0.399719, 0.695686, 5.546173, -0.155093, 0.606805, 5.546173, -0.474751, 0.757201, 5.84287, -0.244346, 0.757201, 5.84287, -0.244346, 0.606805, 5.546173, -0.474751, 0.698675, 5.84287, -0.454833, 0.606805, 5.546173, -0.474751, 0.378391, 5.688212, -0.391052, 0.698675, 5.84287, -0.454833, 0.698675, 5.84287, -0.454833, 0.378391, 5.688212, -0.391052, 0.54827, 5.936401, -0.399719, 0.467717, 5.688212, -0.10077, 0.607089, 5.936401, -0.208575, 0.378391, 5.688212, -0.391052, 0.378391, 5.688212, -0.391052, 0.607089, 5.936401, -0.208575, 0.54827, 5.936401, -0.399719, 0.695686, 5.546173, -0.155093, 0.757201, 5.84287, -0.244346, 0.467717, 5.688212, -0.10077, 0.467717, 5.688212, -0.10077, 0.757201, 5.84287, -0.244346, 0.607089, 5.936401, -0.208575, -0.698675, 5.84287, -0.454833, -0.757201, 5.84287, -0.244346, -0.792427, 6.206368, -0.380862, -0.757201, 5.84287, -0.244346, -0.607089, 5.936401, -0.208575, -0.792427, 6.206368, -0.380862, -0.607089, 5.936401, -0.208575, -0.54827, 5.936401, -0.399719, -0.792427, 6.206368, -0.380862, -0.54827, 5.936401, -0.399719, -0.698675, 5.84287, -0.454833, -0.792427, 6.206368, -0.380862, 0.757201, 5.84287, -0.244346, 0.698675, 5.84287, -0.454833, 0.792427, 6.206368, -0.380862, 0.698675, 5.84287, -0.454833, 0.54827, 5.936401, -0.399719, 0.792427, 6.206368, -0.380862, 0.54827, 5.936401, -0.399719, 0.607089, 5.936401, -0.208575, 0.792427, 6.206368, -0.380862, 0.607089, 5.936401, -0.208575, 0.757201, 5.84287, -0.244346, 0.792427, 6.206368, -0.380862, 0.192573, 1.817217, 0.796843, 0.049882, 1.84864, 0.864447, -0.171565, 1.817217, 0.796843, -0.171565, 1.817217, 0.796843, 0.049882, 1.84864, 0.864447, -0.040033, 1.84864, 0.864447, 0.210252, 2.15998, 0.802215, 0.054248, 1.94582, 0.86597, 0.192573, 1.817217, 0.796843, 0.192573, 1.817217, 0.796843, 0.054248, 1.94582, 0.86597, 0.049882, 1.84864, 0.864447, -0.210252, 2.15998, 0.802215, -0.049586, 1.94582, 0.86597, 0.210252, 2.15998, 0.802215, 0.210252, 2.15998, 0.802215, -0.049586, 1.94582, 0.86597, 0.054248, 1.94582, 0.86597, -0.210252, 2.15998, 0.802215, -0.171565, 1.817217, 0.796843, -0.049586, 1.94582, 0.86597, -0.049586, 1.94582, 0.86597, -0.171565, 1.817217, 0.796843, -0.040033, 1.84864, 0.864447, 0.049882, 1.84864, 0.864447, 0.039068, 1.856531, 1.110447, -0.040033, 1.84864, 0.864447, -0.040033, 1.84864, 0.864447, 0.039068, 1.856531, 1.110447, -0.029867, 1.856531, 1.110447, 0.049882, 1.84864, 0.864447, 0.054248, 1.94582, 0.86597, 0.039068, 1.856531, 1.110447, 0.039068, 1.856531, 1.110447, 0.054248, 1.94582, 0.86597, 0.042415, 1.931036, 1.111615, -0.049586, 1.94582, 0.86597, -0.037191, 1.931036, 1.111615, 0.054248, 1.94582, 0.86597, 0.054248, 1.94582, 0.86597, -0.037191, 1.931036, 1.111615, 0.042415, 1.931036, 1.111615, -0.049586, 1.94582, 0.86597, -0.040033, 1.84864, 0.864447, -0.037191, 1.931036, 1.111615, -0.037191, 1.931036, 1.111615, -0.040033, 1.84864, 0.864447, -0.029867, 1.856531, 1.110447, -0.029867, 1.856531, 1.110447, 0.039068, 1.856531, 1.110447, -0.029144, 1.853868, 1.333744, -0.029144, 1.853868, 1.333744, 0.039068, 1.856531, 1.110447, 0.038298, 1.853868, 1.333744, -0.029144, 1.853868, 1.333744, 0.038298, 1.853868, 1.333744, -0.02842, 1.851205, 1.557042, -0.02842, 1.851205, 1.557042, 0.038298, 1.853868, 1.333744, 0.037528, 1.851205, 1.557042, -0.02842, 1.851205, 1.557042, 0.037528, 1.851205, 1.557042, -0.027696, 1.848542, 1.780339, -0.027696, 1.848542, 1.780339, 0.037528, 1.851205, 1.557042, 0.036758, 1.848542, 1.780339, -0.027696, 1.848542, 1.780339, 0.036758, 1.848542, 1.780339, -0.026973, 1.845879, 2.003637, -0.026973, 1.845879, 2.003637, 0.036758, 1.848542, 1.780339, 0.035988, 1.845879, 2.003637, -0.026973, 1.845879, 2.003637, 0.035988, 1.845879, 2.003637, -0.026249, 1.843216, 2.226934, -0.026249, 1.843216, 2.226934, 0.035988, 1.845879, 2.003637, 0.035219, 1.843216, 2.226934, -0.026249, 1.843216, 2.226934, 0.035219, 1.843216, 2.226934, -0.025525, 1.840553, 2.450232, -0.025525, 1.840553, 2.450232, 0.035219, 1.843216, 2.226934, 0.034449, 1.840553, 2.450232, -0.025525, 1.840553, 2.450232, 0.034449, 1.840553, 2.450232, -0.024801, 1.83789, 2.673529, -0.024801, 1.83789, 2.673529, 0.034449, 1.840553, 2.450232, 0.033679, 1.83789, 2.673529, -0.024801, 1.83789, 2.673529, 0.033679, 1.83789, 2.673529, -0.024078, 1.835227, 2.896827, -0.024078, 1.835227, 2.896827, 0.033679, 1.83789, 2.673529, 0.032909, 1.835227, 2.896827, -0.024078, 1.835227, 2.896827, 0.032909, 1.835227, 2.896827, -0.023354, 1.832564, 3.120124, -0.023354, 1.832564, 3.120124, 0.032909, 1.835227, 2.896827, 0.032139, 1.832564, 3.120124, -0.023354, 1.832564, 3.120124, 0.032139, 1.832564, 3.120124, -0.02263, 1.829901, 3.343421, -0.02263, 1.829901, 3.343421, 0.032139, 1.832564, 3.120124, 0.031369, 1.829901, 3.343421, 0.039068, 1.856531, 1.110447, 0.042415, 1.931036, 1.111615, 0.038298, 1.853868, 1.333744, 0.038298, 1.853868, 1.333744, 0.042415, 1.931036, 1.111615, 0.041572, 1.926759, 1.334887, 0.038298, 1.853868, 1.333744, 0.041572, 1.926759, 1.334887, 0.037528, 1.851205, 1.557042, 0.037528, 1.851205, 1.557042, 0.041572, 1.926759, 1.334887, 0.04073, 1.922482, 1.558159, 0.037528, 1.851205, 1.557042, 0.04073, 1.922482, 1.558159, 0.036758, 1.848542, 1.780339, 0.036758, 1.848542, 1.780339, 0.04073, 1.922482, 1.558159, 0.039887, 1.918204, 1.781431, 0.036758, 1.848542, 1.780339, 0.039887, 1.918204, 1.781431, 0.035988, 1.845879, 2.003637, 0.035988, 1.845879, 2.003637, 0.039887, 1.918204, 1.781431, 0.039045, 1.913927, 2.004703, 0.035988, 1.845879, 2.003637, 0.039045, 1.913927, 2.004703, 0.035219, 1.843216, 2.226934, 0.035219, 1.843216, 2.226934, 0.039045, 1.913927, 2.004703, 0.038203, 1.90965, 2.227975, 0.035219, 1.843216, 2.226934, 0.038203, 1.90965, 2.227975, 0.034449, 1.840553, 2.450232, 0.034449, 1.840553, 2.450232, 0.038203, 1.90965, 2.227975, 0.03736, 1.905373, 2.451247, 0.034449, 1.840553, 2.450232, 0.03736, 1.905373, 2.451247, 0.033679, 1.83789, 2.673529, 0.033679, 1.83789, 2.673529, 0.03736, 1.905373, 2.451247, 0.036518, 1.901095, 2.67452, 0.033679, 1.83789, 2.673529, 0.036518, 1.901095, 2.67452, 0.032909, 1.835227, 2.896827, 0.032909, 1.835227, 2.896827, 0.036518, 1.901095, 2.67452, 0.035676, 1.896818, 2.897791, 0.032909, 1.835227, 2.896827, 0.035676, 1.896818, 2.897791, 0.032139, 1.832564, 3.120124, 0.032139, 1.832564, 3.120124, 0.035676, 1.896818, 2.897791, 0.034833, 1.892541, 3.121064, 0.032139, 1.832564, 3.120124, 0.034833, 1.892541, 3.121064, 0.031369, 1.829901, 3.343421, 0.031369, 1.829901, 3.343421, 0.034833, 1.892541, 3.121064, 0.033991, 1.888264, 3.344336, 0.042415, 1.931036, 1.111615, -0.037191, 1.931036, 1.111615, 0.041572, 1.926759, 1.334887, 0.041572, 1.926759, 1.334887, -0.037191, 1.931036, 1.111615, -0.036309, 1.926759, 1.334887, 0.041572, 1.926759, 1.334887, -0.036309, 1.926759, 1.334887, 0.04073, 1.922482, 1.558159, 0.04073, 1.922482, 1.558159, -0.036309, 1.926759, 1.334887, -0.035427, 1.922482, 1.558159, 0.04073, 1.922482, 1.558159, -0.035427, 1.922482, 1.558159, 0.039887, 1.918204, 1.781431, 0.039887, 1.918204, 1.781431, -0.035427, 1.922482, 1.558159, -0.034544, 1.918204, 1.781431, 0.039887, 1.918204, 1.781431, -0.034544, 1.918204, 1.781431, 0.039045, 1.913927, 2.004703, 0.039045, 1.913927, 2.004703, -0.034544, 1.918204, 1.781431, -0.033662, 1.913927, 2.004703, 0.039045, 1.913927, 2.004703, -0.033662, 1.913927, 2.004703, 0.038203, 1.90965, 2.227975, 0.038203, 1.90965, 2.227975, -0.033662, 1.913927, 2.004703, -0.032779, 1.90965, 2.227975, 0.038203, 1.90965, 2.227975, -0.032779, 1.90965, 2.227975, 0.03736, 1.905373, 2.451247, 0.03736, 1.905373, 2.451247, -0.032779, 1.90965, 2.227975, -0.031897, 1.905373, 2.451247, 0.03736, 1.905373, 2.451247, -0.031897, 1.905373, 2.451247, 0.036518, 1.901095, 2.67452, 0.036518, 1.901095, 2.67452, -0.031897, 1.905373, 2.451247, -0.031015, 1.901095, 2.67452, 0.036518, 1.901095, 2.67452, -0.031015, 1.901095, 2.67452, 0.035676, 1.896818, 2.897791, 0.035676, 1.896818, 2.897791, -0.031015, 1.901095, 2.67452, -0.030132, 1.896818, 2.897791, 0.035676, 1.896818, 2.897791, -0.030132, 1.896818, 2.897791, 0.034833, 1.892541, 3.121064, 0.034833, 1.892541, 3.121064, -0.030132, 1.896818, 2.897791, -0.02925, 1.892541, 3.121064, 0.034833, 1.892541, 3.121064, -0.02925, 1.892541, 3.121064, 0.033991, 1.888264, 3.344336, 0.033991, 1.888264, 3.344336, -0.02925, 1.892541, 3.121064, -0.028367, 1.888264, 3.344336, -0.037191, 1.931036, 1.111615, -0.029867, 1.856531, 1.110447, -0.036309, 1.926759, 1.334887, -0.036309, 1.926759, 1.334887, -0.029867, 1.856531, 1.110447, -0.029144, 1.853868, 1.333744, -0.036309, 1.926759, 1.334887, -0.029144, 1.853868, 1.333744, -0.035427, 1.922482, 1.558159, -0.035427, 1.922482, 1.558159, -0.029144, 1.853868, 1.333744, -0.02842, 1.851205, 1.557042, -0.035427, 1.922482, 1.558159, -0.02842, 1.851205, 1.557042, -0.034544, 1.918204, 1.781431, -0.034544, 1.918204, 1.781431, -0.02842, 1.851205, 1.557042, -0.027696, 1.848542, 1.780339, -0.034544, 1.918204, 1.781431, -0.027696, 1.848542, 1.780339, -0.033662, 1.913927, 2.004703, -0.033662, 1.913927, 2.004703, -0.027696, 1.848542, 1.780339, -0.026973, 1.845879, 2.003637, -0.033662, 1.913927, 2.004703, -0.026973, 1.845879, 2.003637, -0.032779, 1.90965, 2.227975, -0.032779, 1.90965, 2.227975, -0.026973, 1.845879, 2.003637, -0.026249, 1.843216, 2.226934, -0.032779, 1.90965, 2.227975, -0.026249, 1.843216, 2.226934, -0.031897, 1.905373, 2.451247, -0.031897, 1.905373, 2.451247, -0.026249, 1.843216, 2.226934, -0.025525, 1.840553, 2.450232, -0.031897, 1.905373, 2.451247, -0.025525, 1.840553, 2.450232, -0.031015, 1.901095, 2.67452, -0.031015, 1.901095, 2.67452, -0.025525, 1.840553, 2.450232, -0.024801, 1.83789, 2.673529, -0.031015, 1.901095, 2.67452, -0.024801, 1.83789, 2.673529, -0.030132, 1.896818, 2.897791, -0.030132, 1.896818, 2.897791, -0.024801, 1.83789, 2.673529, -0.024078, 1.835227, 2.896827, -0.030132, 1.896818, 2.897791, -0.024078, 1.835227, 2.896827, -0.02925, 1.892541, 3.121064, -0.02925, 1.892541, 3.121064, -0.024078, 1.835227, 2.896827, -0.023354, 1.832564, 3.120124, -0.02925, 1.892541, 3.121064, -0.023354, 1.832564, 3.120124, -0.028367, 1.888264, 3.344336, -0.028367, 1.888264, 3.344336, -0.023354, 1.832564, 3.120124, -0.02263, 1.829901, 3.343421, -0.02263, 1.829901, 3.343421, 0.031369, 1.829901, 3.343421, -0.10154, 1.737756, 3.405142, -0.10154, 1.737756, 3.405142, 0.031369, 1.829901, 3.343421, 0.115313, 1.737756, 3.405142, 0.031369, 1.829901, 3.343421, 0.033991, 1.888264, 3.344336, 0.115313, 1.737756, 3.405142, 0.115313, 1.737756, 3.405142, 0.033991, 1.888264, 3.344336, 0.12584, 1.972129, 3.408815, 0.033991, 1.888264, 3.344336, -0.028367, 1.888264, 3.344336, 0.12584, 1.972129, 3.408815, 0.12584, 1.972129, 3.408815, -0.028367, 1.888264, 3.344336, -0.124579, 1.972129, 3.408815, -0.02263, 1.829901, 3.343421, -0.10154, 1.737756, 3.405142, -0.028367, 1.888264, 3.344336, -0.028367, 1.888264, 3.344336, -0.10154, 1.737756, 3.405142, -0.124579, 1.972129, 3.408815, -0.10154, 1.737756, 3.405142, 0.115313, 1.737756, 3.405142, 0.003758, 1.849526, 3.752653, 0.115313, 1.737756, 3.405142, 0.12584, 1.972129, 3.408815, 0.003758, 1.849526, 3.752653, 0.12584, 1.972129, 3.408815, -0.124579, 1.972129, 3.408815, 0.003758, 1.849526, 3.752653, -0.124579, 1.972129, 3.408815, -0.10154, 1.737756, 3.405142, 0.003758, 1.849526, 3.752653])
        tbuf = Vector.<Number>([0.072187, 0.728384, 0.058781, 0.746836, 0.052619, 0.701451, 0.052619, 0.701451, 0.058781, 0.746836, 0.027119, 0.736548, 0.058781, 0.746836, 0.058781, 0.769643, 0.027119, 0.736548, 0.027119, 0.736548, 0.058781, 0.769643, 0.027119, 0.779931, 0.058781, 0.769643, 0.072187, 0.788095, 0.027119, 0.779931, 0.027119, 0.779931, 0.072187, 0.788095, 0.052619, 0.815028, 0.072187, 0.788095, 0.093878, 0.795143, 0.052619, 0.815028, 0.052619, 0.815028, 0.093878, 0.795143, 0.093878, 0.828434, 0.093878, 0.795143, 0.115569, 0.788095, 0.093878, 0.828434, 0.093878, 0.828434, 0.115569, 0.788095, 0.139047, 0.808687, 0.115569, 0.788095, 0.128801, 0.77154, 0.139047, 0.808687, 0.139047, 0.808687, 0.128801, 0.77154, 0.16039, 0.772325, 0.115569, 0.728384, 0.139047, 0.707792, 0.128801, 0.744939, 0.128801, 0.744939, 0.139047, 0.707792, 0.16039, 0.744154, 0.093878, 0.721336, 0.093878, 0.688045, 0.115569, 0.728384, 0.115569, 0.728384, 0.093878, 0.688045, 0.139047, 0.707792, 0.093878, 0.721336, 0.072187, 0.728384, 0.093878, 0.688045, 0.093878, 0.688045, 0.072187, 0.728384, 0.052619, 0.701451, 0.052619, 0.701451, 0.027119, 0.736548, 0.037089, 0.680077, 0.037089, 0.680077, 0.027119, 0.736548, 0.001992, 0.728384, 0.027119, 0.736548, 0.027119, 0.779931, 0.001992, 0.728384, 0.001992, 0.728384, 0.027119, 0.779931, 0.001992, 0.788095, 0.027119, 0.779931, 0.052619, 0.815028, 0.001992, 0.788095, 0.001992, 0.788095, 0.052619, 0.815028, 0.037089, 0.836403, 0.052619, 0.815028, 0.093878, 0.828434, 0.037089, 0.836403, 0.037089, 0.836403, 0.093878, 0.828434, 0.093878, 0.854854, 0.139047, 0.808687, 0.150667, 0.830951, 0.093878, 0.828434, 0.093878, 0.828434, 0.150667, 0.830951, 0.093878, 0.854854, 0.16039, 0.772325, 0.183888, 0.784555, 0.139047, 0.808687, 0.139047, 0.808687, 0.183888, 0.784555, 0.150667, 0.830951, 0.16039, 0.772325, 0.16039, 0.744154, 0.183888, 0.784555, 0.183888, 0.784555, 0.16039, 0.744154, 0.183888, 0.731924, 0.16039, 0.744154, 0.139047, 0.707792, 0.183888, 0.731924, 0.183888, 0.731924, 0.139047, 0.707792, 0.150667, 0.685529, 0.139047, 0.707792, 0.093878, 0.688045, 0.150667, 0.685529, 0.150667, 0.685529, 0.093878, 0.688045, 0.093878, 0.661625, 0.093878, 0.688045, 0.052619, 0.701451, 0.093878, 0.661625, 0.093878, 0.661625, 0.052619, 0.701451, 0.037089, 0.680077, 0.30731, 0.482856, 0.30731, 0.531163, 0.274019, 0.469133, 0.274019, 0.469133, 0.30731, 0.531163, 0.274019, 0.525921, 0.30731, 0.531163, 0.30731, 0.590874, 0.274019, 0.525921, 0.274019, 0.525921, 0.30731, 0.590874, 0.274019, 0.596116, 0.30731, 0.590874, 0.30731, 0.639182, 0.274019, 0.596116, 0.274019, 0.596116, 0.30731, 0.639182, 0.274019, 0.652905, 0.60738, 0.465714, 0.664169, 0.465714, 0.59741, 0.499006, 0.59741, 0.499006, 0.664169, 0.465714, 0.664169, 0.499006, 0.720958, 0.461048, 0.730928, 0.499006, 0.664169, 0.465714, 0.664169, 0.465714, 0.730928, 0.499006, 0.664169, 0.499006, 0.754178, 0.455923, 0.772187, 0.499006, 0.720958, 0.461048, 0.720958, 0.461048, 0.772187, 0.499006, 0.730928, 0.499006, 0.484753, 0.715357, 0.537384, 0.715357, 0.475971, 0.75844, 0.475971, 0.75844, 0.537384, 0.715357, 0.546166, 0.75844, 0.537384, 0.715357, 0.583779, 0.720483, 0.546166, 0.75844, 0.546166, 0.75844, 0.583779, 0.720483, 0.602954, 0.75844, 0.460855, 0.455923, 0.517644, 0.460589, 0.450885, 0.49388, 0.450885, 0.49388, 0.517644, 0.460589, 0.517644, 0.49388, 0.517644, 0.460589, 0.574433, 0.460589, 0.517644, 0.49388, 0.517644, 0.49388, 0.574433, 0.460589, 0.584403, 0.49388, 0.274019, 0.469133, 0.274019, 0.525921, 0.237115, 0.464404, 0.237115, 0.464404, 0.274019, 0.525921, 0.237115, 0.524115, 0.274019, 0.525921, 0.274019, 0.596116, 0.237115, 0.524115, 0.237115, 0.524115, 0.274019, 0.596116, 0.237115, 0.597922, 0.274019, 0.596116, 0.274019, 0.652905, 0.237115, 0.597922, 0.237115, 0.597922, 0.274019, 0.652905, 0.237115, 0.657633, 0.59741, 0.499006, 0.664169, 0.499006, 0.593974, 0.535909, 0.593974, 0.535909, 0.664169, 0.499006, 0.664169, 0.535909, 0.664169, 0.499006, 0.730928, 0.499006, 0.664169, 0.535909, 0.664169, 0.535909, 0.730928, 0.499006, 0.734364, 0.535909, 0.730928, 0.499006, 0.772187, 0.499006, 0.734364, 0.535909, 0.734364, 0.535909, 0.772187, 0.499006, 0.777746, 0.535909, 0.475971, 0.75844, 0.546166, 0.75844, 0.474165, 0.795344, 0.474165, 0.795344, 0.546166, 0.75844, 0.547972, 0.795344, 0.546166, 0.75844, 0.602954, 0.75844, 0.547972, 0.795344, 0.547972, 0.795344, 0.602954, 0.75844, 0.607683, 0.795344, 0.450885, 0.49388, 0.517644, 0.49388, 0.447449, 0.530783, 0.447449, 0.530783, 0.517644, 0.49388, 0.517644, 0.530783, 0.517644, 0.49388, 0.584403, 0.49388, 0.517644, 0.530783, 0.517644, 0.530783, 0.584403, 0.49388, 0.587839, 0.530783, 0.237115, 0.464404, 0.237115, 0.524115, 0.200212, 0.469133, 0.200212, 0.469133, 0.237115, 0.524115, 0.200212, 0.525921, 0.237115, 0.524115, 0.237115, 0.597922, 0.200212, 0.525921, 0.200212, 0.525921, 0.237115, 0.597922, 0.200212, 0.596116, 0.237115, 0.597922, 0.237115, 0.657633, 0.200212, 0.596116, 0.200212, 0.596116, 0.237115, 0.657633, 0.200212, 0.652905, 0.593974, 0.535909, 0.664169, 0.535909, 0.59741, 0.572813, 0.59741, 0.572813, 0.664169, 0.535909, 0.664169, 0.572813, 0.664169, 0.535909, 0.734364, 0.535909, 0.664169, 0.572813, 0.664169, 0.572813, 0.734364, 0.535909, 0.730928, 0.572813, 0.734364, 0.535909, 0.777746, 0.535909, 0.730928, 0.572813, 0.730928, 0.572813, 0.777746, 0.535909, 0.772187, 0.572813, 0.474165, 0.795344, 0.547972, 0.795344, 0.475971, 0.832247, 0.475971, 0.832247, 0.547972, 0.795344, 0.546166, 0.832247, 0.547972, 0.795344, 0.607683, 0.795344, 0.546166, 0.832247, 0.546166, 0.832247, 0.607683, 0.795344, 0.602954, 0.832247, 0.447449, 0.530783, 0.517644, 0.530783, 0.450885, 0.567687, 0.450885, 0.567687, 0.517644, 0.530783, 0.517644, 0.567687, 0.517644, 0.530783, 0.587839, 0.530783, 0.517644, 0.567687, 0.517644, 0.567687, 0.587839, 0.530783, 0.584403, 0.567687, 0.200212, 0.469133, 0.200212, 0.525921, 0.16692, 0.482856, 0.16692, 0.482856, 0.200212, 0.525921, 0.16692, 0.531163, 0.200212, 0.525921, 0.200212, 0.596116, 0.16692, 0.531163, 0.16692, 0.531163, 0.200212, 0.596116, 0.16692, 0.590874, 0.200212, 0.596116, 0.200212, 0.652905, 0.16692, 0.590874, 0.16692, 0.590874, 0.200212, 0.652905, 0.16692, 0.639182, 0.59741, 0.572813, 0.664169, 0.572813, 0.60738, 0.606104, 0.60738, 0.606104, 0.664169, 0.572813, 0.664169, 0.606104, 0.664169, 0.572813, 0.730928, 0.572813, 0.664169, 0.606104, 0.664169, 0.606104, 0.730928, 0.572813, 0.720958, 0.606104, 0.730928, 0.572813, 0.772187, 0.572813, 0.720958, 0.606104, 0.720958, 0.606104, 0.772187, 0.572813, 0.756055, 0.606104, 0.475971, 0.832247, 0.546166, 0.832247, 0.481213, 0.865538, 0.481213, 0.865538, 0.546166, 0.832247, 0.540924, 0.865538, 0.546166, 0.832247, 0.602954, 0.832247, 0.540924, 0.865538, 0.540924, 0.865538, 0.602954, 0.832247, 0.589231, 0.865538, 0.450885, 0.567687, 0.517644, 0.567687, 0.460855, 0.600978, 0.460855, 0.600978, 0.517644, 0.567687, 0.517644, 0.600978, 0.517644, 0.567687, 0.584403, 0.567687, 0.517644, 0.600978, 0.517644, 0.600978, 0.584403, 0.567687, 0.574433, 0.600978, 0.16692, 0.531163, 0.1405, 0.539327, 0.16692, 0.482856, 0.16692, 0.482856, 0.1405, 0.539327, 0.1405, 0.488553, 0.16692, 0.531163, 0.16692, 0.590874, 0.1405, 0.539327, 0.1405, 0.539327, 0.16692, 0.590874, 0.1405, 0.58271, 0.16692, 0.590874, 0.16692, 0.639182, 0.1405, 0.58271, 0.1405, 0.58271, 0.16692, 0.639182, 0.1405, 0.633485, 0.60738, 0.606104, 0.664169, 0.606104, 0.625995, 0.632524, 0.625995, 0.632524, 0.664169, 0.606104, 0.664169, 0.632524, 0.664169, 0.606104, 0.720958, 0.606104, 0.664169, 0.632524, 0.664169, 0.632524, 0.720958, 0.606104, 0.705428, 0.632524, 0.432905, 0.865538, 0.481213, 0.865538, 0.45428, 0.891959, 0.45428, 0.891959, 0.481213, 0.865538, 0.489377, 0.891959, 0.481213, 0.865538, 0.540924, 0.865538, 0.489377, 0.891959, 0.489377, 0.891959, 0.540924, 0.865538, 0.53276, 0.891959, 0.540924, 0.865538, 0.589231, 0.865538, 0.53276, 0.891959, 0.53276, 0.891959, 0.589231, 0.865538, 0.567857, 0.891959, 0.517644, 0.600978, 0.517644, 0.627398, 0.460855, 0.600978, 0.460855, 0.600978, 0.517644, 0.627398, 0.476385, 0.627398, 0.574433, 0.600978, 0.555818, 0.627398, 0.517644, 0.600978, 0.517644, 0.600978, 0.555818, 0.627398, 0.517644, 0.627398, 0.296169, 0.688267, 0.324754, 0.739042, 0.286173, 0.715545, 0.286173, 0.715545, 0.324754, 0.739042, 0.293092, 0.74933, 0.324754, 0.739042, 0.324754, 0.782425, 0.293092, 0.74933, 0.293092, 0.74933, 0.324754, 0.782425, 0.293092, 0.772137, 0.296169, 0.833199, 0.286173, 0.805922, 0.324754, 0.782425, 0.324754, 0.782425, 0.286173, 0.805922, 0.293092, 0.772137, 0.257994, 0.843814, 0.216735, 0.817522, 0.251507, 0.816589, 0.251507, 0.816589, 0.216735, 0.817522, 0.236303, 0.790589, 0.216735, 0.817522, 0.191235, 0.782425, 0.236303, 0.790589, 0.236303, 0.790589, 0.191235, 0.782425, 0.222897, 0.772137, 0.191235, 0.782425, 0.191235, 0.739042, 0.222897, 0.772137, 0.222897, 0.772137, 0.191235, 0.739042, 0.222897, 0.74933, 0.191235, 0.739042, 0.216735, 0.703945, 0.222897, 0.74933, 0.222897, 0.74933, 0.216735, 0.703945, 0.236303, 0.730878, 0.257994, 0.677653, 0.251507, 0.704877, 0.216735, 0.703945, 0.216735, 0.703945, 0.251507, 0.704877, 0.236303, 0.730878, 0.058781, 0.746836, 0.072187, 0.728384, 0.093878, 0.75824, 0.058781, 0.769643, 0.058781, 0.746836, 0.093878, 0.75824, 0.072187, 0.788095, 0.058781, 0.769643, 0.093878, 0.75824, 0.093878, 0.795143, 0.072187, 0.788095, 0.093878, 0.75824, 0.115569, 0.788095, 0.093878, 0.795143, 0.093878, 0.75824, 0.128801, 0.77154, 0.115569, 0.788095, 0.093878, 0.75824, 0.128801, 0.744939, 0.128801, 0.77154, 0.093878, 0.75824, 0.115569, 0.728384, 0.128801, 0.744939, 0.093878, 0.75824, 0.093878, 0.721336, 0.115569, 0.728384, 0.093878, 0.75824, 0.072187, 0.728384, 0.093878, 0.721336, 0.093878, 0.75824, 0.286173, 0.715545, 0.293092, 0.74933, 0.257994, 0.760733, 0.293092, 0.74933, 0.293092, 0.772137, 0.257994, 0.760733, 0.293092, 0.772137, 0.286173, 0.805922, 0.257994, 0.760733, 0.286173, 0.805922, 0.251507, 0.816589, 0.257994, 0.760733, 0.251507, 0.816589, 0.236303, 0.790589, 0.257994, 0.760733, 0.236303, 0.790589, 0.222897, 0.772137, 0.257994, 0.760733, 0.222897, 0.772137, 0.222897, 0.74933, 0.257994, 0.760733, 0.222897, 0.74933, 0.236303, 0.730878, 0.257994, 0.760733, 0.236303, 0.730878, 0.251507, 0.704877, 0.257994, 0.760733, 0.251507, 0.704877, 0.286173, 0.715545, 0.257994, 0.760733, 0.19874, 0.218915, 0.194119, 0.259849, 0.155706, 0.214697, 0.155706, 0.214697, 0.194119, 0.259849, 0.145676, 0.258643, 0.242226, 0.218915, 0.28275, 0.214697, 0.244337, 0.259849, 0.244337, 0.259849, 0.28275, 0.214697, 0.29278, 0.258643, 0.145676, 0.258643, 0.194119, 0.259849, 0.150534, 0.314534, 0.150534, 0.314534, 0.194119, 0.259849, 0.19633, 0.314534, 0.194119, 0.259849, 0.244337, 0.259849, 0.19633, 0.314534, 0.19633, 0.314534, 0.244337, 0.259849, 0.242126, 0.314534, 0.244337, 0.259849, 0.29278, 0.258643, 0.242126, 0.314534, 0.242126, 0.314534, 0.29278, 0.258643, 0.287922, 0.314534, 0.150534, 0.314534, 0.19633, 0.314534, 0.167512, 0.366102, 0.167512, 0.366102, 0.19633, 0.314534, 0.200124, 0.366102, 0.19633, 0.314534, 0.242126, 0.314534, 0.200124, 0.366102, 0.200124, 0.366102, 0.242126, 0.314534, 0.238332, 0.366102, 0.287922, 0.314534, 0.270945, 0.366102, 0.242126, 0.314534, 0.242126, 0.314534, 0.270945, 0.366102, 0.238332, 0.366102, 0.200124, 0.366102, 0.200884, 0.408348, 0.167512, 0.366102, 0.167512, 0.366102, 0.200884, 0.408348, 0.182716, 0.413413, 0.200124, 0.366102, 0.238332, 0.366102, 0.200884, 0.408348, 0.200884, 0.408348, 0.238332, 0.366102, 0.237572, 0.408348, 0.238332, 0.366102, 0.270945, 0.366102, 0.237572, 0.408348, 0.237572, 0.408348, 0.270945, 0.366102, 0.255741, 0.413413, 0.182716, 0.413413, 0.200884, 0.408348, 0.187567, 0.431469, 0.187567, 0.431469, 0.200884, 0.408348, 0.200376, 0.44452, 0.200884, 0.408348, 0.237572, 0.408348, 0.200376, 0.44452, 0.200376, 0.44452, 0.237572, 0.408348, 0.23808, 0.44452, 0.255741, 0.413413, 0.250889, 0.431469, 0.237572, 0.408348, 0.237572, 0.408348, 0.250889, 0.431469, 0.23808, 0.44452, 0.759575, 0.895309, 0.772625, 0.887482, 0.759575, 0.911408, 0.759575, 0.911408, 0.772625, 0.887482, 0.772625, 0.921353, 0.724496, 0.915308, 0.724496, 0.899209, 0.737547, 0.923135, 0.737547, 0.923135, 0.724496, 0.899209, 0.737547, 0.889264, 0.643619, 0.00931, 0.643232, 0.040852, 0.628225, 0.022361, 0.628225, 0.022361, 0.643232, 0.040852, 0.623374, 0.040417, 0.643619, 0.00931, 0.676154, 0.00931, 0.643232, 0.040852, 0.643232, 0.040852, 0.676154, 0.00931, 0.67654, 0.040852, 0.676154, 0.00931, 0.691547, 0.022361, 0.67654, 0.040852, 0.67654, 0.040852, 0.691547, 0.022361, 0.696399, 0.040417, 0.623374, 0.040417, 0.643232, 0.040852, 0.606737, 0.087728, 0.606737, 0.087728, 0.643232, 0.040852, 0.642124, 0.087728, 0.643232, 0.040852, 0.67654, 0.040852, 0.642124, 0.087728, 0.642124, 0.087728, 0.67654, 0.040852, 0.677648, 0.087728, 0.696399, 0.040417, 0.713036, 0.087728, 0.67654, 0.040852, 0.67654, 0.040852, 0.713036, 0.087728, 0.677648, 0.087728, 0.642124, 0.087728, 0.636988, 0.139296, 0.606737, 0.087728, 0.606737, 0.087728, 0.636988, 0.139296, 0.591192, 0.139296, 0.642124, 0.087728, 0.677648, 0.087728, 0.636988, 0.139296, 0.636988, 0.139296, 0.677648, 0.087728, 0.682784, 0.139296, 0.677648, 0.087728, 0.713036, 0.087728, 0.682784, 0.139296, 0.682784, 0.139296, 0.713036, 0.087728, 0.728581, 0.139296, 0.636988, 0.139296, 0.635369, 0.195187, 0.591192, 0.139296, 0.591192, 0.139296, 0.635369, 0.195187, 0.586334, 0.195187, 0.636988, 0.139296, 0.682784, 0.139296, 0.635369, 0.195187, 0.635369, 0.195187, 0.682784, 0.139296, 0.684404, 0.195187, 0.682784, 0.139296, 0.728581, 0.139296, 0.684404, 0.195187, 0.684404, 0.195187, 0.728581, 0.139296, 0.733439, 0.195187, 0.635369, 0.195187, 0.636889, 0.236698, 0.586334, 0.195187, 0.586334, 0.195187, 0.636889, 0.236698, 0.594391, 0.239133, 0.635369, 0.195187, 0.684404, 0.195187, 0.636889, 0.236698, 0.636889, 0.236698, 0.684404, 0.195187, 0.682884, 0.236698, 0.684404, 0.195187, 0.733439, 0.195187, 0.682884, 0.236698, 0.682884, 0.236698, 0.733439, 0.195187, 0.725382, 0.239133, 0.947138, 0.951273, 0.94536, 0.898514, 0.997063, 0.949607, 0.997063, 0.949607, 0.94536, 0.898514, 0.998008, 0.897768, 0.888355, 0.897768, 0.93828, 0.899434, 0.886576, 0.950527, 0.886576, 0.950527, 0.93828, 0.899434, 0.939225, 0.951273, 0.886312, 0.214697, 0.936974, 0.214697, 0.88947, 0.258643, 0.88947, 0.258643, 0.936974, 0.214697, 0.945085, 0.258643, 0.88947, 0.258643, 0.945085, 0.258643, 0.895861, 0.314534, 0.895861, 0.314534, 0.945085, 0.258643, 0.945277, 0.314534, 0.945277, 0.314534, 0.937932, 0.366102, 0.895861, 0.314534, 0.895861, 0.314534, 0.937932, 0.366102, 0.901379, 0.366102, 0.937932, 0.366102, 0.926928, 0.413413, 0.901379, 0.366102, 0.901379, 0.366102, 0.926928, 0.413413, 0.90525, 0.413413, 0.876156, 0.908416, 0.876368, 0.938917, 0.849606, 0.908416, 0.849606, 0.908416, 0.876368, 0.938917, 0.847445, 0.938917, 0.996759, 0.630203, 0.993601, 0.674148, 0.946096, 0.630203, 0.946096, 0.630203, 0.993601, 0.674148, 0.937986, 0.674148, 0.993601, 0.674148, 0.987209, 0.730039, 0.937986, 0.674148, 0.937986, 0.674148, 0.987209, 0.730039, 0.937794, 0.730039, 0.937794, 0.730039, 0.987209, 0.730039, 0.945139, 0.781607, 0.945139, 0.781607, 0.987209, 0.730039, 0.981691, 0.781607, 0.945139, 0.781607, 0.981691, 0.781607, 0.956143, 0.828918, 0.956143, 0.828918, 0.981691, 0.781607, 0.97782, 0.828918, 0.798938, 0.908416, 0.825489, 0.908416, 0.798726, 0.938917, 0.798726, 0.938917, 0.825489, 0.908416, 0.827649, 0.938917, 0.200376, 0.44452, 0.23808, 0.44452, 0.205143, 0.460413, 0.205143, 0.460413, 0.23808, 0.44452, 0.233313, 0.460413, 0.737547, 0.923135, 0.737547, 0.889264, 0.753439, 0.919072, 0.753439, 0.919072, 0.737547, 0.889264, 0.744958, 0.887482, 0.676154, 0.00931, 0.643619, 0.00931, 0.673187, 0.001899, 0.673187, 0.001899, 0.643619, 0.00931, 0.646586, 0.001899, 0.772625, 0.887482, 0.788518, 0.891546, 0.772625, 0.921353, 0.772625, 0.921353, 0.788518, 0.891546, 0.780037, 0.923135, 0.668006, 0.864279, 0.66835, 0.831526, 0.689683, 0.864279, 0.689683, 0.864279, 0.66835, 0.831526, 0.694565, 0.831526, 0.691547, 0.022361, 0.732739, 0.022198, 0.696399, 0.040417, 0.696399, 0.040417, 0.732739, 0.022198, 0.729152, 0.046672, 0.413602, 0.851675, 0.397502, 0.851675, 0.41865, 0.810483, 0.41865, 0.810483, 0.397502, 0.851675, 0.390093, 0.810483, 0.250889, 0.431469, 0.255741, 0.413413, 0.292081, 0.431632, 0.292081, 0.431632, 0.255741, 0.413413, 0.288494, 0.407158, 0.621231, 0.715357, 0.642909, 0.715357, 0.621576, 0.74811, 0.621576, 0.74811, 0.642909, 0.715357, 0.64779, 0.74811, 0.187567, 0.431469, 0.146375, 0.431632, 0.182716, 0.413413, 0.182716, 0.413413, 0.146375, 0.431632, 0.149963, 0.407158, 0.362929, 0.6661, 0.367977, 0.707292, 0.34683, 0.6661, 0.34683, 0.6661, 0.367977, 0.707292, 0.33942, 0.707292, 0.628225, 0.022361, 0.623374, 0.040417, 0.587033, 0.022198, 0.587033, 0.022198, 0.623374, 0.040417, 0.590621, 0.046672, 0.694565, 0.831526, 0.66835, 0.831526, 0.695472, 0.791838, 0.695472, 0.791838, 0.66835, 0.831526, 0.667047, 0.791838, 0.729152, 0.046672, 0.732739, 0.022198, 0.76884, 0.054936, 0.76884, 0.054936, 0.732739, 0.022198, 0.773008, 0.021527, 0.41865, 0.810483, 0.390093, 0.810483, 0.41987, 0.770214, 0.41987, 0.770214, 0.390093, 0.810483, 0.388905, 0.770214, 0.288494, 0.407158, 0.328182, 0.398894, 0.292081, 0.431632, 0.292081, 0.431632, 0.328182, 0.398894, 0.33235, 0.432303, 0.64779, 0.74811, 0.648697, 0.787798, 0.621576, 0.74811, 0.621576, 0.74811, 0.648697, 0.787798, 0.620272, 0.787798, 0.149963, 0.407158, 0.146375, 0.431632, 0.110275, 0.398894, 0.110275, 0.398894, 0.146375, 0.431632, 0.106107, 0.432303, 0.33942, 0.707292, 0.367977, 0.707292, 0.338232, 0.74756, 0.338232, 0.74756, 0.367977, 0.707292, 0.369198, 0.74756, 0.590621, 0.046672, 0.550933, 0.054936, 0.587033, 0.022198, 0.587033, 0.022198, 0.550933, 0.054936, 0.546765, 0.021527, 0.695472, 0.791838, 0.667047, 0.791838, 0.698476, 0.754396, 0.698476, 0.754396, 0.667047, 0.791838, 0.663577, 0.754396, 0.76884, 0.054936, 0.773008, 0.021527, 0.806282, 0.064374, 0.806282, 0.064374, 0.773008, 0.021527, 0.813152, 0.020914, 0.41987, 0.770214, 0.388905, 0.770214, 0.422934, 0.730071, 0.422934, 0.730071, 0.388905, 0.770214, 0.384916, 0.730071, 0.328182, 0.398894, 0.365624, 0.389456, 0.33235, 0.432303, 0.33235, 0.432303, 0.365624, 0.389456, 0.372493, 0.432916, 0.648697, 0.787798, 0.651702, 0.819254, 0.620272, 0.787798, 0.620272, 0.787798, 0.651702, 0.819254, 0.616802, 0.825241, 0.110275, 0.398894, 0.106107, 0.432303, 0.078819, 0.389456, 0.078819, 0.389456, 0.106107, 0.432303, 0.065963, 0.432916, 0.369198, 0.74756, 0.372262, 0.787704, 0.338232, 0.74756, 0.338232, 0.74756, 0.372262, 0.787704, 0.334243, 0.787704, 0.550933, 0.054936, 0.51349, 0.064374, 0.546765, 0.021527, 0.546765, 0.021527, 0.51349, 0.064374, 0.506621, 0.020914, 0.698476, 0.754396, 0.663577, 0.754396, 0.700759, 0.715357, 0.700759, 0.715357, 0.663577, 0.754396, 0.660933, 0.715357, 0.806282, 0.064374, 0.813152, 0.020914, 0.84532, 0.073457, 0.84532, 0.073457, 0.813152, 0.020914, 0.855569, 0.021147, 0.422934, 0.730071, 0.384916, 0.730071, 0.425618, 0.687653, 0.425618, 0.687653, 0.384916, 0.730071, 0.382233, 0.687653, 0.365624, 0.389456, 0.404662, 0.380373, 0.372493, 0.432916, 0.372493, 0.432916, 0.404662, 0.380373, 0.414911, 0.432682, 0.651702, 0.819254, 0.653984, 0.864279, 0.616802, 0.825241, 0.616802, 0.825241, 0.653984, 0.864279, 0.614158, 0.864279, 0.078819, 0.389456, 0.065963, 0.432916, 0.033794, 0.380373, 0.033794, 0.380373, 0.065963, 0.432916, 0.023545, 0.432682, 0.334243, 0.787704, 0.372262, 0.787704, 0.33156, 0.830122, 0.33156, 0.830122, 0.372262, 0.787704, 0.374945, 0.830122, 0.51349, 0.064374, 0.474452, 0.073457, 0.506621, 0.020914, 0.506621, 0.020914, 0.474452, 0.073457, 0.464203, 0.021147, 0.840615, 0.887664, 0.880441, 0.887664, 0.849606, 0.908416, 0.849606, 0.908416, 0.880441, 0.887664, 0.876156, 0.908416, 0.84532, 0.073457, 0.855569, 0.021147, 0.87133, 0.052705, 0.87133, 0.052705, 0.855569, 0.021147, 0.877122, 0.022204, 0.382233, 0.687653, 0.392304, 0.6661, 0.425618, 0.687653, 0.425618, 0.687653, 0.392304, 0.6661, 0.421227, 0.6661, 0.404662, 0.380373, 0.430672, 0.401125, 0.414911, 0.432682, 0.414911, 0.432682, 0.430672, 0.401125, 0.436464, 0.431626, 0.83448, 0.887664, 0.825489, 0.908416, 0.794654, 0.887664, 0.794654, 0.887664, 0.825489, 0.908416, 0.798938, 0.908416, 0.033794, 0.380373, 0.023545, 0.432682, 0.007785, 0.401125, 0.007785, 0.401125, 0.023545, 0.432682, 0.001992, 0.431626, 0.33156, 0.830122, 0.374945, 0.830122, 0.341631, 0.851675, 0.341631, 0.851675, 0.374945, 0.830122, 0.370554, 0.851675, 0.474452, 0.073457, 0.448443, 0.052705, 0.464203, 0.021147, 0.464203, 0.021147, 0.448443, 0.052705, 0.44265, 0.022204, 0.636889, 0.236698, 0.640039, 0.254227, 0.594391, 0.239133, 0.594391, 0.239133, 0.640039, 0.254227, 0.601622, 0.263613, 0.19874, 0.218915, 0.155706, 0.214697, 0.19938, 0.199603, 0.19938, 0.199603, 0.155706, 0.214697, 0.160964, 0.190217, 0.996759, 0.630203, 0.946096, 0.630203, 0.989465, 0.605723, 0.989465, 0.605723, 0.946096, 0.630203, 0.950836, 0.605723, 0.682884, 0.236698, 0.725382, 0.239133, 0.679654, 0.254227, 0.679654, 0.254227, 0.725382, 0.239133, 0.71815, 0.263613, 0.886312, 0.214697, 0.893606, 0.190217, 0.936974, 0.214697, 0.936974, 0.214697, 0.893606, 0.190217, 0.932234, 0.190217, 0.242226, 0.218915, 0.238996, 0.199603, 0.28275, 0.214697, 0.28275, 0.214697, 0.238996, 0.199603, 0.277492, 0.190217, 0.640039, 0.254227, 0.6352, 0.293323, 0.601622, 0.263613, 0.601622, 0.263613, 0.6352, 0.293323, 0.602859, 0.29311, 0.380447, 0.662108, 0.397902, 0.623012, 0.441314, 0.662108, 0.441314, 0.662108, 0.397902, 0.623012, 0.433043, 0.623012, 0.19938, 0.199603, 0.160964, 0.190217, 0.194542, 0.160507, 0.194542, 0.160507, 0.160964, 0.190217, 0.162201, 0.16072, 0.989465, 0.605723, 0.950836, 0.605723, 0.986648, 0.576225, 0.986648, 0.576225, 0.950836, 0.605723, 0.950059, 0.576225, 0.679654, 0.254227, 0.71815, 0.263613, 0.684572, 0.293323, 0.684572, 0.293323, 0.71815, 0.263613, 0.716914, 0.29311, 0.893606, 0.190217, 0.896423, 0.16072, 0.932234, 0.190217, 0.932234, 0.190217, 0.896423, 0.16072, 0.933011, 0.16072, 0.238996, 0.199603, 0.243914, 0.160507, 0.277492, 0.190217, 0.277492, 0.190217, 0.243914, 0.160507, 0.276256, 0.16072, 0.374312, 0.662108, 0.313445, 0.662108, 0.356858, 0.623012, 0.356858, 0.623012, 0.313445, 0.662108, 0.321716, 0.623012, 0.19938, 0.199603, 0.238996, 0.199603, 0.19874, 0.218915, 0.19874, 0.218915, 0.238996, 0.199603, 0.242226, 0.218915, 0.640039, 0.254227, 0.636889, 0.236698, 0.679654, 0.254227, 0.679654, 0.254227, 0.636889, 0.236698, 0.682884, 0.236698, 0.914297, 0.893777, 0.914297, 0.83291, 0.953912, 0.893777, 0.953912, 0.893777, 0.914297, 0.83291, 0.953912, 0.83291, 0.6352, 0.293323, 0.634816, 0.328827, 0.602859, 0.29311, 0.602859, 0.29311, 0.634816, 0.328827, 0.601019, 0.328608, 0.397902, 0.623012, 0.397318, 0.587508, 0.433043, 0.623012, 0.433043, 0.623012, 0.397318, 0.587508, 0.434281, 0.587508, 0.194542, 0.160507, 0.162201, 0.16072, 0.194158, 0.125003, 0.194158, 0.125003, 0.162201, 0.16072, 0.160361, 0.125222, 0.986648, 0.576225, 0.950059, 0.576225, 0.985491, 0.540728, 0.985491, 0.540728, 0.950059, 0.576225, 0.95067, 0.540728, 0.684572, 0.293323, 0.716914, 0.29311, 0.684957, 0.328827, 0.684957, 0.328827, 0.716914, 0.29311, 0.718753, 0.328608, 0.896423, 0.16072, 0.897579, 0.125222, 0.933011, 0.16072, 0.933011, 0.16072, 0.897579, 0.125222, 0.9324, 0.125222, 0.243914, 0.160507, 0.244298, 0.125003, 0.276256, 0.16072, 0.276256, 0.16072, 0.244298, 0.125003, 0.278095, 0.125222, 0.356858, 0.623012, 0.321716, 0.623012, 0.357441, 0.587508, 0.357441, 0.587508, 0.321716, 0.623012, 0.320478, 0.587508, 0.634816, 0.328827, 0.635163, 0.360779, 0.601019, 0.328608, 0.601019, 0.328608, 0.635163, 0.360779, 0.597735, 0.360519, 0.434281, 0.587508, 0.397318, 0.587508, 0.433333, 0.555556, 0.433333, 0.555556, 0.397318, 0.587508, 0.396184, 0.555556, 0.194158, 0.125003, 0.160361, 0.125222, 0.194505, 0.093051, 0.194505, 0.093051, 0.160361, 0.125222, 0.157077, 0.093311, 0.95067, 0.540728, 0.952424, 0.508816, 0.985491, 0.540728, 0.985491, 0.540728, 0.952424, 0.508816, 0.987272, 0.508816, 0.684957, 0.328827, 0.718753, 0.328608, 0.68461, 0.360779, 0.68461, 0.360779, 0.718753, 0.328608, 0.722038, 0.360519, 0.9324, 0.125222, 0.897579, 0.125222, 0.930646, 0.093311, 0.930646, 0.093311, 0.897579, 0.125222, 0.895798, 0.093311, 0.244298, 0.125003, 0.243951, 0.093051, 0.278095, 0.125222, 0.278095, 0.125222, 0.243951, 0.093051, 0.28138, 0.093311, 0.320478, 0.587508, 0.321426, 0.555556, 0.357441, 0.587508, 0.357441, 0.587508, 0.321426, 0.555556, 0.358575, 0.555556, 0.635163, 0.360779, 0.637487, 0.397652, 0.597735, 0.360519, 0.597735, 0.360519, 0.637487, 0.397652, 0.593888, 0.397344, 0.433333, 0.555556, 0.396184, 0.555556, 0.43185, 0.518683, 0.43185, 0.518683, 0.396184, 0.555556, 0.389477, 0.518683, 0.194505, 0.093051, 0.157077, 0.093311, 0.196829, 0.056178, 0.196829, 0.056178, 0.157077, 0.093311, 0.153229, 0.056486, 0.952424, 0.508816, 0.953481, 0.471991, 0.987272, 0.508816, 0.987272, 0.508816, 0.953481, 0.471991, 0.993131, 0.471991, 0.68461, 0.360779, 0.722038, 0.360519, 0.682286, 0.397652, 0.682286, 0.397652, 0.722038, 0.360519, 0.725885, 0.397344, 0.930646, 0.093311, 0.895798, 0.093311, 0.92959, 0.056485, 0.92959, 0.056485, 0.895798, 0.093311, 0.88994, 0.056485, 0.243951, 0.093051, 0.241628, 0.056178, 0.28138, 0.093311, 0.28138, 0.093311, 0.241628, 0.056178, 0.285227, 0.056485, 0.321426, 0.555556, 0.322909, 0.518683, 0.358575, 0.555556, 0.358575, 0.555556, 0.322909, 0.518683, 0.365282, 0.518683, 0.593888, 0.397344, 0.637487, 0.397652, 0.591025, 0.436851, 0.591025, 0.436851, 0.637487, 0.397652, 0.640654, 0.437159, 0.43185, 0.518683, 0.389477, 0.518683, 0.431004, 0.479176, 0.431004, 0.479176, 0.389477, 0.518683, 0.3846, 0.479176, 0.153229, 0.056486, 0.150367, 0.016979, 0.196829, 0.056178, 0.196829, 0.056178, 0.150367, 0.016979, 0.199996, 0.016671, 0.953481, 0.471991, 0.954327, 0.432484, 0.993131, 0.471991, 0.993131, 0.471991, 0.954327, 0.432484, 0.998008, 0.432484, 0.725885, 0.397344, 0.728748, 0.436851, 0.682286, 0.397652, 0.682286, 0.397652, 0.728748, 0.436851, 0.679118, 0.437159, 0.92959, 0.056485, 0.88994, 0.056485, 0.928744, 0.016979, 0.928744, 0.016979, 0.88994, 0.056485, 0.885062, 0.016979, 0.285227, 0.056485, 0.241628, 0.056178, 0.28809, 0.016979, 0.28809, 0.016979, 0.241628, 0.056178, 0.23846, 0.016671, 0.322909, 0.518683, 0.323755, 0.479176, 0.365282, 0.518683, 0.365282, 0.518683, 0.323755, 0.479176, 0.370159, 0.479176, 0.591025, 0.436851, 0.640654, 0.437159, 0.589282, 0.451931, 0.589282, 0.451931, 0.640654, 0.437159, 0.642042, 0.451931, 0.3846, 0.479176, 0.3846, 0.464404, 0.431004, 0.479176, 0.431004, 0.479176, 0.3846, 0.464404, 0.437248, 0.464404, 0.150367, 0.016979, 0.15029, 0.001899, 0.199996, 0.016671, 0.199996, 0.016671, 0.15029, 0.001899, 0.202129, 0.001899, 0.998008, 0.432484, 0.954327, 0.432484, 0.998008, 0.417404, 0.998008, 0.417404, 0.954327, 0.432484, 0.948083, 0.417404, 0.728748, 0.436851, 0.730491, 0.451931, 0.679118, 0.437159, 0.679118, 0.437159, 0.730491, 0.451931, 0.677731, 0.451931, 0.885062, 0.016979, 0.885062, 0.001899, 0.928744, 0.016979, 0.928744, 0.016979, 0.885062, 0.001899, 0.934988, 0.001899, 0.28809, 0.016979, 0.23846, 0.016671, 0.288166, 0.001899, 0.288166, 0.001899, 0.23846, 0.016671, 0.236327, 0.001899, 0.370159, 0.479176, 0.323755, 0.479176, 0.370159, 0.464404, 0.370159, 0.464404, 0.323755, 0.479176, 0.317511, 0.464404, 0.664169, 0.632524, 0.65351, 0.667956, 0.625995, 0.632524, 0.625995, 0.632524, 0.65351, 0.667956, 0.628373, 0.667956, 0.719261, 0.715357, 0.746485, 0.73232, 0.711914, 0.75079, 0.711914, 0.75079, 0.746485, 0.73232, 0.729841, 0.761959, 0.251507, 0.816589, 0.286173, 0.805922, 0.264381, 0.833233, 0.264381, 0.833233, 0.286173, 0.805922, 0.287208, 0.826209, 0.77665, 0.883491, 0.765679, 0.848058, 0.803928, 0.866528, 0.803928, 0.866528, 0.765679, 0.848058, 0.78364, 0.836889, 0.517644, 0.627398, 0.555818, 0.627398, 0.528303, 0.66283, 0.528303, 0.66283, 0.555818, 0.627398, 0.55344, 0.66283, 0.83828, 0.883673, 0.811002, 0.86671, 0.849251, 0.84824, 0.849251, 0.84824, 0.811002, 0.86671, 0.831289, 0.837071, 0.251507, 0.704877, 0.264381, 0.688233, 0.286173, 0.715545, 0.286173, 0.715545, 0.264381, 0.688233, 0.287208, 0.695258, 0.894746, 0.80483, 0.902093, 0.840263, 0.867522, 0.821793, 0.867522, 0.821793, 0.902093, 0.840263, 0.884166, 0.851432, 0.628373, 0.667956, 0.65351, 0.667956, 0.637207, 0.711366, 0.711914, 0.75079, 0.729841, 0.761959, 0.707708, 0.7942, 0.264381, 0.833233, 0.287208, 0.826209, 0.284956, 0.855367, 0.78364, 0.836889, 0.765679, 0.848058, 0.754483, 0.804649, 0.528303, 0.66283, 0.55344, 0.66283, 0.544606, 0.70624, 0.849251, 0.84824, 0.831289, 0.837071, 0.860447, 0.80483, 0.287208, 0.695258, 0.264381, 0.688233, 0.284956, 0.6661, 0.884166, 0.851432, 0.902093, 0.840263, 0.906299, 0.883673, 0.931658, 0.417404, 0.914618, 0.425478, 0.888172, 0.417404, 0.888172, 0.417404, 0.914618, 0.425478, 0.90388, 0.425478, 0.244337, 0.259849, 0.225707, 0.234273, 0.242226, 0.218915, 0.242226, 0.218915, 0.225707, 0.234273, 0.225185, 0.222668, 0.194119, 0.259849, 0.213306, 0.234273, 0.244337, 0.259849, 0.244337, 0.259849, 0.213306, 0.234273, 0.225707, 0.234273, 0.194119, 0.259849, 0.19874, 0.218915, 0.213306, 0.234273, 0.213306, 0.234273, 0.19874, 0.218915, 0.214447, 0.222668, 0.914618, 0.425478, 0.913326, 0.454856, 0.90388, 0.425478, 0.90388, 0.425478, 0.913326, 0.454856, 0.905094, 0.454856, 0.867289, 0.455923, 0.878895, 0.456104, 0.868232, 0.485301, 0.868232, 0.485301, 0.878895, 0.456104, 0.877129, 0.48544, 0.792837, 0.800657, 0.794318, 0.771322, 0.805237, 0.800657, 0.805237, 0.800657, 0.794318, 0.771322, 0.803824, 0.771322, 0.84477, 0.800657, 0.833165, 0.800839, 0.843005, 0.771322, 0.843005, 0.771322, 0.833165, 0.800839, 0.834107, 0.771461, 0.905094, 0.454856, 0.913326, 0.454856, 0.90518, 0.481522, 0.90518, 0.481522, 0.913326, 0.454856, 0.913234, 0.481522, 0.90518, 0.481522, 0.913234, 0.481522, 0.905267, 0.508189, 0.905267, 0.508189, 0.913234, 0.481522, 0.913142, 0.508189, 0.905267, 0.508189, 0.913142, 0.508189, 0.905353, 0.534856, 0.905353, 0.534856, 0.913142, 0.508189, 0.91305, 0.534856, 0.905353, 0.534856, 0.91305, 0.534856, 0.905439, 0.561522, 0.905439, 0.561522, 0.91305, 0.534856, 0.912958, 0.561522, 0.905439, 0.561522, 0.912958, 0.561522, 0.905526, 0.588189, 0.905526, 0.588189, 0.912958, 0.561522, 0.912867, 0.588189, 0.905526, 0.588189, 0.912867, 0.588189, 0.905612, 0.614856, 0.905612, 0.614856, 0.912867, 0.588189, 0.912775, 0.614856, 0.905612, 0.614856, 0.912775, 0.614856, 0.905699, 0.641523, 0.905699, 0.641523, 0.912775, 0.614856, 0.912683, 0.641523, 0.905699, 0.641523, 0.912683, 0.641523, 0.905785, 0.668189, 0.905785, 0.668189, 0.912683, 0.641523, 0.912591, 0.668189, 0.905785, 0.668189, 0.912591, 0.668189, 0.905872, 0.694856, 0.905872, 0.694856, 0.912591, 0.668189, 0.912499, 0.694856, 0.905872, 0.694856, 0.912499, 0.694856, 0.905958, 0.721523, 0.905958, 0.721523, 0.912499, 0.694856, 0.912407, 0.721523, 0.868232, 0.485301, 0.877129, 0.48544, 0.867914, 0.511967, 0.867914, 0.511967, 0.877129, 0.48544, 0.876619, 0.512104, 0.867914, 0.511967, 0.876619, 0.512104, 0.867596, 0.538634, 0.867596, 0.538634, 0.876619, 0.512104, 0.876108, 0.538767, 0.867596, 0.538634, 0.876108, 0.538767, 0.867278, 0.565301, 0.867278, 0.565301, 0.876108, 0.538767, 0.875597, 0.565431, 0.867278, 0.565301, 0.875597, 0.565431, 0.86696, 0.591967, 0.86696, 0.591967, 0.875597, 0.565431, 0.875086, 0.592095, 0.86696, 0.591967, 0.875086, 0.592095, 0.866642, 0.618634, 0.866642, 0.618634, 0.875086, 0.592095, 0.874575, 0.618758, 0.866642, 0.618634, 0.874575, 0.618758, 0.866324, 0.645301, 0.866324, 0.645301, 0.874575, 0.618758, 0.874065, 0.645422, 0.866324, 0.645301, 0.874065, 0.645422, 0.866006, 0.671967, 0.866006, 0.671967, 0.874065, 0.645422, 0.873554, 0.672086, 0.866006, 0.671967, 0.873554, 0.672086, 0.865688, 0.698634, 0.865688, 0.698634, 0.873554, 0.672086, 0.873043, 0.698749, 0.865688, 0.698634, 0.873043, 0.698749, 0.86537, 0.725301, 0.86537, 0.725301, 0.873043, 0.698749, 0.872532, 0.725413, 0.86537, 0.725301, 0.872532, 0.725413, 0.865052, 0.751967, 0.865052, 0.751967, 0.872532, 0.725413, 0.872021, 0.752077, 0.803824, 0.771322, 0.794318, 0.771322, 0.803724, 0.744658, 0.803724, 0.744658, 0.794318, 0.771322, 0.794423, 0.744658, 0.803724, 0.744658, 0.794423, 0.744658, 0.803623, 0.717994, 0.803623, 0.717994, 0.794423, 0.744658, 0.794528, 0.717994, 0.803623, 0.717994, 0.794528, 0.717994, 0.803523, 0.691331, 0.803523, 0.691331, 0.794528, 0.717994, 0.794634, 0.691331, 0.803523, 0.691331, 0.794634, 0.691331, 0.803422, 0.664667, 0.803422, 0.664667, 0.794634, 0.691331, 0.794739, 0.664667, 0.803422, 0.664667, 0.794739, 0.664667, 0.803321, 0.638003, 0.803321, 0.638003, 0.794739, 0.664667, 0.794845, 0.638003, 0.803321, 0.638003, 0.794845, 0.638003, 0.803221, 0.61134, 0.803221, 0.61134, 0.794845, 0.638003, 0.79495, 0.61134, 0.803221, 0.61134, 0.79495, 0.61134, 0.80312, 0.584676, 0.80312, 0.584676, 0.79495, 0.61134, 0.795055, 0.584676, 0.80312, 0.584676, 0.795055, 0.584676, 0.80302, 0.558012, 0.80302, 0.558012, 0.795055, 0.584676, 0.795161, 0.558012, 0.80302, 0.558012, 0.795161, 0.558012, 0.802919, 0.531349, 0.802919, 0.531349, 0.795161, 0.558012, 0.795266, 0.531349, 0.802919, 0.531349, 0.795266, 0.531349, 0.802818, 0.504685, 0.802818, 0.504685, 0.795266, 0.531349, 0.795371, 0.504685, 0.843005, 0.771322, 0.834107, 0.771461, 0.842494, 0.744658, 0.842494, 0.744658, 0.834107, 0.771461, 0.833789, 0.744794, 0.842494, 0.744658, 0.833789, 0.744794, 0.841983, 0.717994, 0.841983, 0.717994, 0.833789, 0.744794, 0.833471, 0.718128, 0.841983, 0.717994, 0.833471, 0.718128, 0.841472, 0.691331, 0.841472, 0.691331, 0.833471, 0.718128, 0.833153, 0.691461, 0.841472, 0.691331, 0.833153, 0.691461, 0.840961, 0.664667, 0.840961, 0.664667, 0.833153, 0.691461, 0.832835, 0.664794, 0.840961, 0.664667, 0.832835, 0.664794, 0.840451, 0.638003, 0.840451, 0.638003, 0.832835, 0.664794, 0.832517, 0.638128, 0.840451, 0.638003, 0.832517, 0.638128, 0.83994, 0.61134, 0.83994, 0.61134, 0.832517, 0.638128, 0.832199, 0.611461, 0.83994, 0.61134, 0.832199, 0.611461, 0.839429, 0.584676, 0.839429, 0.584676, 0.832199, 0.611461, 0.831881, 0.584794, 0.839429, 0.584676, 0.831881, 0.584794, 0.838918, 0.558012, 0.838918, 0.558012, 0.831881, 0.584794, 0.831563, 0.558127, 0.838918, 0.558012, 0.831563, 0.558127, 0.838407, 0.531349, 0.838407, 0.531349, 0.831563, 0.558127, 0.831245, 0.531461, 0.838407, 0.531349, 0.831245, 0.531461, 0.837897, 0.504685, 0.837897, 0.504685, 0.831245, 0.531461, 0.830927, 0.504794, 0.905958, 0.721523, 0.912407, 0.721523, 0.896534, 0.728894, 0.896534, 0.728894, 0.912407, 0.721523, 0.922432, 0.728894, 0.865052, 0.751967, 0.872021, 0.752077, 0.854047, 0.759338, 0.854047, 0.759338, 0.872021, 0.752077, 0.882037, 0.759777, 0.802818, 0.504685, 0.795371, 0.504685, 0.813787, 0.496985, 0.813787, 0.496985, 0.795371, 0.504685, 0.783882, 0.496985, 0.830927, 0.504794, 0.819923, 0.497423, 0.837897, 0.504685, 0.837897, 0.504685, 0.819923, 0.497423, 0.847912, 0.496985, 0.896534, 0.728894, 0.922432, 0.728894, 0.909109, 0.770394, 0.854047, 0.759338, 0.882037, 0.759777, 0.867395, 0.800839, 0.813787, 0.496985, 0.783882, 0.496985, 0.799208, 0.455923, 0.847912, 0.496985, 0.819923, 0.497423, 0.83327, 0.455923])
        nbuf = Vector.<Number>([0.249423, -0.951288, -0.181217, 0.095271, -0.951288, -0.293214, 0.474753, -0.809713, -0.344928, 0.474753, -0.809713, -0.344928, 0.095271, -0.951288, -0.293214, 0.181339, -0.809713, -0.558105, 0.095271, -0.951288, -0.293214, -0.095271, -0.951288, -0.293214, 0.181339, -0.809713, -0.558105, 0.181339, -0.809713, -0.558105, -0.095271, -0.951288, -0.293214, -0.181339, -0.809713, -0.558105, -0.095271, -0.951288, -0.293214, -0.249423, -0.951288, -0.181217, -0.181339, -0.809713, -0.558105, -0.181339, -0.809713, -0.558105, -0.249423, -0.951288, -0.181217, -0.474753, -0.809713, -0.344928, -0.249423, -0.951288, -0.181217, -0.3103, -0.950628, 0.004404, -0.474753, -0.809713, -0.344928, -0.474753, -0.809713, -0.344928, -0.3103, -0.950628, 0.004404, -0.582197, -0.812998, 0.009019, -0.3103, -0.950628, 0.004404, -0.286096, -0.949407, 0.12952, -0.582197, -0.812998, 0.009019, -0.582197, -0.812998, 0.009019, -0.286096, -0.949407, 0.12952, -0.497841, -0.811839, 0.305076, -0.286096, -0.949407, 0.12952, -0.452513, -0.868567, -0.202048, -0.497841, -0.811839, 0.305076, -0.497841, -0.811839, 0.305076, -0.452513, -0.868567, -0.202048, -0.514522, -0.493428, 0.701281, 0.286096, -0.949407, 0.129521, 0.497841, -0.811839, 0.305076, 0.452513, -0.868567, -0.202047, 0.452513, -0.868567, -0.202047, 0.497841, -0.811839, 0.305076, 0.514522, -0.493428, 0.701281, 0.3103, -0.950628, 0.004404, 0.582197, -0.812998, 0.009019, 0.286096, -0.949407, 0.129521, 0.286096, -0.949407, 0.129521, 0.582197, -0.812998, 0.009019, 0.497841, -0.811839, 0.305076, 0.3103, -0.950628, 0.004404, 0.249423, -0.951288, -0.181217, 0.582197, -0.812998, 0.009019, 0.582197, -0.812998, 0.009019, 0.249423, -0.951288, -0.181217, 0.474753, -0.809713, -0.344928, 0.474753, -0.809713, -0.344928, 0.181339, -0.809713, -0.558105, 0.653961, -0.588715, -0.47513, 0.653961, -0.588715, -0.47513, 0.181339, -0.809713, -0.558105, 0.249791, -0.588715, -0.768777, 0.181339, -0.809713, -0.558105, -0.181339, -0.809713, -0.558105, 0.249791, -0.588715, -0.768777, 0.249791, -0.588715, -0.768777, -0.181339, -0.809713, -0.558105, -0.249791, -0.588715, -0.768778, -0.181339, -0.809713, -0.558105, -0.474753, -0.809713, -0.344928, -0.249791, -0.588715, -0.768778, -0.249791, -0.588715, -0.768778, -0.474753, -0.809713, -0.344928, -0.653961, -0.588715, -0.475131, -0.474753, -0.809713, -0.344928, -0.582197, -0.812998, 0.009019, -0.653961, -0.588715, -0.475131, -0.653961, -0.588715, -0.475131, -0.582197, -0.812998, 0.009019, -0.798247, -0.602277, 0.008036, -0.497841, -0.811839, 0.305076, -0.652891, -0.598364, 0.464428, -0.582197, -0.812998, 0.009019, -0.582197, -0.812998, 0.009019, -0.652891, -0.598364, 0.464428, -0.798247, -0.602277, 0.008036, -0.514522, -0.493428, 0.701281, -0.267796, -0.572971, 0.77459, -0.497841, -0.811839, 0.305076, -0.497841, -0.811839, 0.305076, -0.267796, -0.572971, 0.77459, -0.652891, -0.598364, 0.464428, -0.514522, -0.493428, 0.701281, 0.514522, -0.493428, 0.701281, -0.267796, -0.572971, 0.77459, -0.267796, -0.572971, 0.77459, 0.514522, -0.493428, 0.701281, 0.267796, -0.572971, 0.77459, 0.514522, -0.493428, 0.701281, 0.497841, -0.811839, 0.305076, 0.267796, -0.572971, 0.77459, 0.267796, -0.572971, 0.77459, 0.497841, -0.811839, 0.305076, 0.652891, -0.598364, 0.464428, 0.497841, -0.811839, 0.305076, 0.582197, -0.812998, 0.009019, 0.652891, -0.598364, 0.464428, 0.652891, -0.598364, 0.464428, 0.582197, -0.812998, 0.009019, 0.798247, -0.602277, 0.008035, 0.582197, -0.812998, 0.009019, 0.474753, -0.809713, -0.344928, 0.798247, -0.602277, 0.008035, 0.798247, -0.602277, 0.008035, 0.474753, -0.809713, -0.344928, 0.653961, -0.588715, -0.47513, 0.653961, -0.588715, -0.47513, 0.249791, -0.588715, -0.768777, 0.769247, -0.309677, -0.558891, 0.769247, -0.309677, -0.558891, 0.249791, -0.588715, -0.768777, 0.293826, -0.309677, -0.904304, 0.249791, -0.588715, -0.768777, -0.249791, -0.588715, -0.768778, 0.293826, -0.309677, -0.904304, 0.293826, -0.309677, -0.904304, -0.249791, -0.588715, -0.768778, -0.293826, -0.309677, -0.904304, -0.249791, -0.588715, -0.768778, -0.653961, -0.588715, -0.475131, -0.293826, -0.309677, -0.904304, -0.293826, -0.309677, -0.904304, -0.653961, -0.588715, -0.475131, -0.769247, -0.309677, -0.558891, -0.653961, -0.588715, -0.475131, -0.798247, -0.602277, 0.008036, -0.769247, -0.309677, -0.558891, -0.769247, -0.309677, -0.558891, -0.798247, -0.602277, 0.008036, -0.948051, -0.318101, 0.003437, -0.652891, -0.598364, 0.464428, -0.766141, -0.316579, 0.559291, -0.798247, -0.602277, 0.008036, -0.798247, -0.602277, 0.008036, -0.766141, -0.316579, 0.559291, -0.948051, -0.318101, 0.003437, -0.267796, -0.572971, 0.77459, -0.296954, -0.296001, 0.907856, -0.652891, -0.598364, 0.464428, -0.652891, -0.598364, 0.464428, -0.296954, -0.296001, 0.907856, -0.766141, -0.316579, 0.559291, -0.267796, -0.572971, 0.77459, 0.267796, -0.572971, 0.77459, -0.296954, -0.296001, 0.907856, -0.296954, -0.296001, 0.907856, 0.267796, -0.572971, 0.77459, 0.296955, -0.296001, 0.907855, 0.267796, -0.572971, 0.77459, 0.652891, -0.598364, 0.464428, 0.296955, -0.296001, 0.907855, 0.296955, -0.296001, 0.907855, 0.652891, -0.598364, 0.464428, 0.766141, -0.316579, 0.559291, 0.652891, -0.598364, 0.464428, 0.798247, -0.602277, 0.008035, 0.766141, -0.316579, 0.559291, 0.766141, -0.316579, 0.559291, 0.798247, -0.602277, 0.008035, 0.948051, -0.318101, 0.003437, 0.798247, -0.602277, 0.008035, 0.653961, -0.588715, -0.47513, 0.948051, -0.318101, 0.003437, 0.948051, -0.318101, 0.003437, 0.653961, -0.588715, -0.47513, 0.769247, -0.309677, -0.558891, 0.769247, -0.309677, -0.558891, 0.293826, -0.309677, -0.904304, 0.809017, 0, -0.587785, 0.809017, 0, -0.587785, 0.293826, -0.309677, -0.904304, 0.309017, 0, -0.951057, 0.293826, -0.309677, -0.904304, -0.293826, -0.309677, -0.904304, 0.309017, 0, -0.951057, 0.309017, 0, -0.951057, -0.293826, -0.309677, -0.904304, -0.309017, 0, -0.951056, -0.293826, -0.309677, -0.904304, -0.769247, -0.309677, -0.558891, -0.309017, 0, -0.951056, -0.309017, 0, -0.951056, -0.769247, -0.309677, -0.558891, -0.809017, 0, -0.587785, -0.769247, -0.309677, -0.558891, -0.948051, -0.318101, 0.003437, -0.809017, 0, -0.587785, -0.809017, 0, -0.587785, -0.948051, -0.318101, 0.003437, -1, 0, 0, -0.948051, -0.318101, 0.003437, -0.766141, -0.316579, 0.559291, -1, 0, 0, -1, 0, 0, -0.766141, -0.316579, 0.559291, -0.809017, 0, 0.587785, -0.766141, -0.316579, 0.559291, -0.296954, -0.296001, 0.907856, -0.809017, 0, 0.587785, -0.809017, 0, 0.587785, -0.296954, -0.296001, 0.907856, -0.309017, 0, 0.951057, -0.296954, -0.296001, 0.907856, 0.296955, -0.296001, 0.907855, -0.309017, 0, 0.951057, -0.309017, 0, 0.951057, 0.296955, -0.296001, 0.907855, 0.309017, 0, 0.951057, 0.296955, -0.296001, 0.907855, 0.766141, -0.316579, 0.559291, 0.309017, 0, 0.951057, 0.309017, 0, 0.951057, 0.766141, -0.316579, 0.559291, 0.809017, 0, 0.587785, 0.766141, -0.316579, 0.559291, 0.948051, -0.318101, 0.003437, 0.809017, 0, 0.587785, 0.809017, 0, 0.587785, 0.948051, -0.318101, 0.003437, 1, 0, 0, 0.948051, -0.318101, 0.003437, 0.769247, -0.309677, -0.558891, 1, 0, 0, 1, 0, 0, 0.769247, -0.309677, -0.558891, 0.809017, 0, -0.587785, 0.809017, 0, -0.587785, 0.309017, 0, -0.951057, 0.769247, 0.309678, -0.558891, 0.769247, 0.309678, -0.558891, 0.309017, 0, -0.951057, 0.293826, 0.309678, -0.904304, 0.309017, 0, -0.951057, -0.309017, 0, -0.951056, 0.293826, 0.309678, -0.904304, 0.293826, 0.309678, -0.904304, -0.309017, 0, -0.951056, -0.293826, 0.309678, -0.904304, -0.309017, 0, -0.951056, -0.809017, 0, -0.587785, -0.293826, 0.309678, -0.904304, -0.293826, 0.309678, -0.904304, -0.809017, 0, -0.587785, -0.769247, 0.309678, -0.558891, -0.809017, 0, -0.587785, -1, 0, 0, -0.769247, 0.309678, -0.558891, -0.769247, 0.309678, -0.558891, -1, 0, 0, -0.950842, 0.309678, 0, -1, 0, 0, -0.809017, 0, 0.587785, -0.950842, 0.309678, 0, -0.950842, 0.309678, 0, -0.809017, 0, 0.587785, -0.769247, 0.309678, 0.558891, -0.809017, 0, 0.587785, -0.309017, 0, 0.951057, -0.769247, 0.309678, 0.558891, -0.769247, 0.309678, 0.558891, -0.309017, 0, 0.951057, -0.293826, 0.309678, 0.904304, -0.309017, 0, 0.951057, 0.309017, 0, 0.951057, -0.293826, 0.309678, 0.904304, -0.293826, 0.309678, 0.904304, 0.309017, 0, 0.951057, 0.293826, 0.309678, 0.904304, 0.309017, 0, 0.951057, 0.809017, 0, 0.587785, 0.293826, 0.309678, 0.904304, 0.293826, 0.309678, 0.904304, 0.809017, 0, 0.587785, 0.769247, 0.309678, 0.558891, 0.809017, 0, 0.587785, 1, 0, 0, 0.769247, 0.309678, 0.558891, 0.769247, 0.309678, 0.558891, 1, 0, 0, 0.950842, 0.309678, 0, 1, 0, 0, 0.809017, 0, -0.587785, 0.950842, 0.309678, 0, 0.950842, 0.309678, 0, 0.809017, 0, -0.587785, 0.769247, 0.309678, -0.558891, 0.769247, 0.309678, -0.558891, 0.293826, 0.309678, -0.904304, 0.700928, 0.5054, -0.50326, 0.700928, 0.5054, -0.50326, 0.293826, 0.309678, -0.904304, 0.245787, 0.57419, -0.780958, 0.293826, 0.309678, -0.904304, -0.293826, 0.309678, -0.904304, 0.245787, 0.57419, -0.780958, 0.245787, 0.57419, -0.780958, -0.293826, 0.309678, -0.904304, -0.245787, 0.57419, -0.780958, -0.293826, 0.309678, -0.904304, -0.769247, 0.309678, -0.558891, -0.245787, 0.57419, -0.780958, -0.245787, 0.57419, -0.780958, -0.769247, 0.309678, -0.558891, -0.700928, 0.5054, -0.503261, -0.769247, 0.309678, -0.558891, -0.950842, 0.309678, 0, -0.700928, 0.5054, -0.503261, -0.700928, 0.5054, -0.503261, -0.950842, 0.309678, 0, -0.871265, 0.490473, 0.018274, -0.950842, 0.309678, 0, -0.769247, 0.309678, 0.558891, -0.871265, 0.490473, 0.018274, -0.871265, 0.490473, 0.018274, -0.769247, 0.309678, 0.558891, -0.661798, 0.557716, 0.500975, -0.769247, 0.309678, 0.558891, -0.293826, 0.309678, 0.904304, -0.661798, 0.557716, 0.500975, -0.661798, 0.557716, 0.500975, -0.293826, 0.309678, 0.904304, -0.249791, 0.588715, 0.768778, -0.293826, 0.309678, 0.904304, 0.293826, 0.309678, 0.904304, -0.249791, 0.588715, 0.768778, -0.249791, 0.588715, 0.768778, 0.293826, 0.309678, 0.904304, 0.249791, 0.588715, 0.768778, 0.293826, 0.309678, 0.904304, 0.769247, 0.309678, 0.558891, 0.249791, 0.588715, 0.768778, 0.249791, 0.588715, 0.768778, 0.769247, 0.309678, 0.558891, 0.661798, 0.557716, 0.500975, 0.769247, 0.309678, 0.558891, 0.950842, 0.309678, 0, 0.661798, 0.557716, 0.500975, 0.661798, 0.557716, 0.500975, 0.950842, 0.309678, 0, 0.871265, 0.490473, 0.018274, 0.950842, 0.309678, 0, 0.769247, 0.309678, -0.558891, 0.871265, 0.490473, 0.018274, 0.871265, 0.490473, 0.018274, 0.769247, 0.309678, -0.558891, 0.700928, 0.5054, -0.50326, 0.245787, 0.57419, -0.780958, 0.15989, 0.783794, -0.600085, 0.700928, 0.5054, -0.50326, 0.700928, 0.5054, -0.50326, 0.15989, 0.783794, -0.600085, 0.564366, 0.461983, -0.684151, 0.245787, 0.57419, -0.780958, -0.245787, 0.57419, -0.780958, 0.15989, 0.783794, -0.600085, 0.15989, 0.783794, -0.600085, -0.245787, 0.57419, -0.780958, -0.15989, 0.783795, -0.600084, -0.245787, 0.57419, -0.780958, -0.700928, 0.5054, -0.503261, -0.15989, 0.783795, -0.600084, -0.15989, 0.783795, -0.600084, -0.700928, 0.5054, -0.503261, -0.564366, 0.461983, -0.684151, -0.700928, 0.5054, -0.503261, -0.871265, 0.490473, 0.018274, -0.564366, 0.461983, -0.684151, -0.564366, 0.461983, -0.684151, -0.871265, 0.490473, 0.018274, -0.846458, 0.448968, 0.286246, -0.871265, 0.490473, 0.018274, -0.661798, 0.557716, 0.500975, -0.846458, 0.448968, 0.286246, -0.846458, 0.448968, 0.286246, -0.661798, 0.557716, 0.500975, -0.477377, 0.763743, 0.43452, -0.661798, 0.557716, 0.500975, -0.249791, 0.588715, 0.768778, -0.477377, 0.763743, 0.43452, -0.477377, 0.763743, 0.43452, -0.249791, 0.588715, 0.768778, -0.18134, 0.809712, 0.558106, -0.249791, 0.588715, 0.768778, 0.249791, 0.588715, 0.768778, -0.18134, 0.809712, 0.558106, -0.18134, 0.809712, 0.558106, 0.249791, 0.588715, 0.768778, 0.18134, 0.809713, 0.558105, 0.249791, 0.588715, 0.768778, 0.661798, 0.557716, 0.500975, 0.18134, 0.809713, 0.558105, 0.18134, 0.809713, 0.558105, 0.661798, 0.557716, 0.500975, 0.477377, 0.763743, 0.43452, 0.871265, 0.490473, 0.018274, 0.846458, 0.448968, 0.286247, 0.661798, 0.557716, 0.500975, 0.661798, 0.557716, 0.500975, 0.846458, 0.448968, 0.286247, 0.477377, 0.763743, 0.43452, 0.700928, 0.5054, -0.50326, 0.564366, 0.461983, -0.684151, 0.871265, 0.490473, 0.018274, 0.871265, 0.490473, 0.018274, 0.564366, 0.461983, -0.684151, 0.846458, 0.448968, 0.286247, 0.564366, 0.461983, -0.684151, 0.15989, 0.783794, -0.600085, -0.183696, 0.913917, -0.361955, -0.183696, 0.913917, -0.361955, 0.15989, 0.783794, -0.600085, 0.061288, 0.942558, -0.328371, 0.15989, 0.783794, -0.600085, -0.15989, 0.783795, -0.600084, 0.061288, 0.942558, -0.328371, 0.061288, 0.942558, -0.328371, -0.15989, 0.783795, -0.600084, -0.061288, 0.942559, -0.32837, -0.564366, 0.461983, -0.684151, 0.183696, 0.913917, -0.361956, -0.15989, 0.783795, -0.600084, -0.15989, 0.783795, -0.600084, 0.183696, 0.913917, -0.361956, -0.061288, 0.942559, -0.32837, -0.846458, 0.448968, 0.286246, -0.477377, 0.763743, 0.43452, -0.041474, 0.905009, 0.423367, -0.041474, 0.905009, 0.423367, -0.477377, 0.763743, 0.43452, -0.224442, 0.936903, 0.268028, -0.477377, 0.763743, 0.43452, -0.18134, 0.809712, 0.558106, -0.224442, 0.936903, 0.268028, -0.224442, 0.936903, 0.268028, -0.18134, 0.809712, 0.558106, -0.095271, 0.951289, 0.293213, -0.18134, 0.809712, 0.558106, 0.18134, 0.809713, 0.558105, -0.095271, 0.951289, 0.293213, -0.095271, 0.951289, 0.293213, 0.18134, 0.809713, 0.558105, 0.095271, 0.951288, 0.293214, 0.18134, 0.809713, 0.558105, 0.477377, 0.763743, 0.43452, 0.095271, 0.951288, 0.293214, 0.095271, 0.951288, 0.293214, 0.477377, 0.763743, 0.43452, 0.224442, 0.936903, 0.268028, 0.846458, 0.448968, 0.286247, 0.041474, 0.905008, 0.423367, 0.477377, 0.763743, 0.43452, 0.477377, 0.763743, 0.43452, 0.041474, 0.905008, 0.423367, 0.224442, 0.936903, 0.268028, 0.095271, -0.951288, -0.293214, 0.249423, -0.951288, -0.181217, 0, -0.999715, -0.023869, -0.095271, -0.951288, -0.293214, 0.095271, -0.951288, -0.293214, 0, -0.999715, -0.023869, -0.249423, -0.951288, -0.181217, -0.095271, -0.951288, -0.293214, 0, -0.999715, -0.023869, -0.3103, -0.950628, 0.004404, -0.249423, -0.951288, -0.181217, 0, -0.999715, -0.023869, -0.286096, -0.949407, 0.12952, -0.3103, -0.950628, 0.004404, 0, -0.999715, -0.023869, -0.452513, -0.868567, -0.202048, -0.286096, -0.949407, 0.12952, 0, -0.999715, -0.023869, 0.452513, -0.868567, -0.202047, -0.452513, -0.868567, -0.202048, 0, -0.999715, -0.023869, 0.286096, -0.949407, 0.129521, 0.452513, -0.868567, -0.202047, 0, -0.999715, -0.023869, 0.3103, -0.950628, 0.004404, 0.286096, -0.949407, 0.129521, 0, -0.999715, -0.023869, 0.249423, -0.951288, -0.181217, 0.3103, -0.950628, 0.004404, 0, -0.999715, -0.023869, -0.183696, 0.913917, -0.361955, 0.061288, 0.942558, -0.328371, 0, 0.999824, 0.01875, 0.061288, 0.942558, -0.328371, -0.061288, 0.942559, -0.32837, 0, 0.999824, 0.01875, -0.061288, 0.942559, -0.32837, 0.183696, 0.913917, -0.361956, 0, 0.999824, 0.01875, 0.183696, 0.913917, -0.361956, -0.041474, 0.905009, 0.423367, 0, 0.999824, 0.01875, -0.041474, 0.905009, 0.423367, -0.224442, 0.936903, 0.268028, 0, 0.999824, 0.01875, -0.224442, 0.936903, 0.268028, -0.095271, 0.951289, 0.293213, 0, 0.999824, 0.01875, -0.095271, 0.951289, 0.293213, 0.095271, 0.951288, 0.293214, 0, 0.999824, 0.01875, 0.095271, 0.951288, 0.293214, 0.224442, 0.936903, 0.268028, 0, 0.999824, 0.01875, 0.224442, 0.936903, 0.268028, 0.041474, 0.905008, 0.423367, 0, 0.999824, 0.01875, 0.041474, 0.905008, 0.423367, -0.183696, 0.913917, -0.361955, 0, 0.999824, 0.01875, -0.299368, -0.543695, 0.784076, -0.338226, 0.076298, 0.937967, -0.824886, -0.322738, 0.464115, -0.824886, -0.322738, 0.464115, -0.338226, 0.076298, 0.937967, -0.889544, -0.020305, 0.456398, 0.299298, -0.539595, 0.78693, 0.828363, -0.321446, 0.458789, 0.34029, 0.087474, 0.936243, 0.34029, 0.087474, 0.936243, 0.828363, -0.321446, 0.458789, 0.889947, -0.012539, 0.455891, -0.889544, -0.020305, 0.456398, -0.338226, 0.076298, 0.937967, -0.877763, 0.212682, 0.4293, -0.877763, 0.212682, 0.4293, -0.338226, 0.076298, 0.937967, -0.313541, 0.19236, 0.929887, -0.338226, 0.076298, 0.937967, 0.34029, 0.087474, 0.936243, -0.313541, 0.19236, 0.929887, -0.313541, 0.19236, 0.929887, 0.34029, 0.087474, 0.936243, 0.325961, 0.1907, 0.92595, 0.34029, 0.087474, 0.936243, 0.889947, -0.012539, 0.455891, 0.325961, 0.1907, 0.92595, 0.325961, 0.1907, 0.92595, 0.889947, -0.012539, 0.455891, 0.874894, 0.213235, 0.434846, -0.877763, 0.212682, 0.4293, -0.313541, 0.19236, 0.929887, -0.860096, 0.307118, 0.407324, -0.860096, 0.307118, 0.407324, -0.313541, 0.19236, 0.929887, -0.331432, 0.278863, 0.901326, -0.313541, 0.19236, 0.929887, 0.325961, 0.1907, 0.92595, -0.331432, 0.278863, 0.901326, -0.331432, 0.278863, 0.901326, 0.325961, 0.1907, 0.92595, 0.33843, 0.274391, 0.900097, 0.874894, 0.213235, 0.434846, 0.859403, 0.304315, 0.410877, 0.325961, 0.1907, 0.92595, 0.325961, 0.1907, 0.92595, 0.859403, 0.304315, 0.410877, 0.33843, 0.274391, 0.900097, -0.331432, 0.278863, 0.901326, -0.354251, 0.292748, 0.888147, -0.860096, 0.307118, 0.407324, -0.860096, 0.307118, 0.407324, -0.354251, 0.292748, 0.888147, -0.618729, -0.066545, 0.782781, -0.331432, 0.278863, 0.901326, 0.33843, 0.274391, 0.900097, -0.354251, 0.292748, 0.888147, -0.354251, 0.292748, 0.888147, 0.33843, 0.274391, 0.900097, 0.354251, 0.292748, 0.888147, 0.33843, 0.274391, 0.900097, 0.859403, 0.304315, 0.410877, 0.354251, 0.292748, 0.888147, 0.354251, 0.292748, 0.888147, 0.859403, 0.304315, 0.410877, 0.618729, -0.066545, 0.782781, -0.618729, -0.066545, 0.782781, -0.354251, 0.292748, 0.888147, -0.421812, 0.690423, 0.5877, -0.421812, 0.690423, 0.5877, -0.354251, 0.292748, 0.888147, -0.598022, 0.474115, 0.646208, -0.354251, 0.292748, 0.888147, 0.354251, 0.292748, 0.888147, -0.598022, 0.474115, 0.646208, -0.598022, 0.474115, 0.646208, 0.354251, 0.292748, 0.888147, 0.598022, 0.474115, 0.646208, 0.618729, -0.066545, 0.782781, 0.421812, 0.690423, 0.5877, 0.354251, 0.292748, 0.888147, 0.354251, 0.292748, 0.888147, 0.421812, 0.690423, 0.5877, 0.598022, 0.474115, 0.646208, -0.421812, 0.690423, 0.5877, -0.598022, 0.474115, 0.646208, -0.411898, 0.697289, -0.586624, -0.411898, 0.697289, -0.586624, -0.598022, 0.474115, 0.646208, -0.587421, 0.355488, -0.727025, 0.421812, 0.690423, 0.5877, 0.411898, 0.697289, -0.586624, 0.598022, 0.474115, 0.646208, 0.598022, 0.474115, 0.646208, 0.411898, 0.697289, -0.586624, 0.587421, 0.355488, -0.727024, -0.587421, 0.355488, -0.727025, -0.30712, 0.354833, -0.883047, -0.411898, 0.697289, -0.586624, -0.411898, 0.697289, -0.586624, -0.30712, 0.354833, -0.883047, -0.605282, 0.020451, -0.795749, -0.587421, 0.355488, -0.727025, 0.587421, 0.355488, -0.727024, -0.30712, 0.354833, -0.883047, -0.30712, 0.354833, -0.883047, 0.587421, 0.355488, -0.727024, 0.30712, 0.354833, -0.883046, 0.587421, 0.355488, -0.727024, 0.411898, 0.697289, -0.586624, 0.30712, 0.354833, -0.883046, 0.30712, 0.354833, -0.883046, 0.411898, 0.697289, -0.586624, 0.605282, 0.020451, -0.795749, -0.605282, 0.020451, -0.795749, -0.30712, 0.354833, -0.883047, -0.838685, 0.351589, -0.415924, -0.838685, 0.351589, -0.415924, -0.30712, 0.354833, -0.883047, -0.290231, 0.350839, -0.890325, -0.30712, 0.354833, -0.883047, 0.30712, 0.354833, -0.883046, -0.290231, 0.350839, -0.890325, -0.290231, 0.350839, -0.890325, 0.30712, 0.354833, -0.883046, 0.290231, 0.350839, -0.890325, 0.605282, 0.020451, -0.795749, 0.838685, 0.351589, -0.415924, 0.30712, 0.354833, -0.883046, 0.30712, 0.354833, -0.883046, 0.838685, 0.351589, -0.415924, 0.290231, 0.350839, -0.890325, -0.290231, 0.350839, -0.890325, -0.304258, 0.178028, -0.935806, -0.838685, 0.351589, -0.415924, -0.838685, 0.351589, -0.415924, -0.304258, 0.178028, -0.935806, -0.873704, 0.204008, -0.441613, -0.290231, 0.350839, -0.890325, 0.290231, 0.350839, -0.890325, -0.304258, 0.178028, -0.935806, -0.304258, 0.178028, -0.935806, 0.290231, 0.350839, -0.890325, 0.304258, 0.178028, -0.935806, 0.290231, 0.350839, -0.890325, 0.838685, 0.351589, -0.415924, 0.304258, 0.178028, -0.935806, 0.304258, 0.178028, -0.935806, 0.838685, 0.351589, -0.415924, 0.873704, 0.204008, -0.441613, -0.304258, 0.178028, -0.935806, -0.308483, -0.125996, -0.942849, -0.873704, 0.204008, -0.441613, -0.873704, 0.204008, -0.441613, -0.308483, -0.125996, -0.942849, -0.890417, -0.091627, -0.445827, -0.304258, 0.178028, -0.935806, 0.304258, 0.178028, -0.935806, -0.308483, -0.125996, -0.942849, -0.308483, -0.125996, -0.942849, 0.304258, 0.178028, -0.935806, 0.308483, -0.125996, -0.942849, 0.304258, 0.178028, -0.935806, 0.873704, 0.204008, -0.441613, 0.308483, -0.125996, -0.942849, 0.308483, -0.125996, -0.942849, 0.873704, 0.204008, -0.441613, 0.890417, -0.091627, -0.445827, -0.308483, -0.125996, -0.942849, -0.222917, -0.546128, -0.807498, -0.890417, -0.091627, -0.445827, -0.890417, -0.091627, -0.445827, -0.222917, -0.546128, -0.807498, -0.813081, -0.389443, -0.432704, -0.308483, -0.125996, -0.942849, 0.308483, -0.125996, -0.942849, -0.222917, -0.546128, -0.807498, -0.222917, -0.546128, -0.807498, 0.308483, -0.125996, -0.942849, 0.222818, -0.546215, -0.807466, 0.308483, -0.125996, -0.942849, 0.890417, -0.091627, -0.445827, 0.222818, -0.546215, -0.807466, 0.222818, -0.546215, -0.807466, 0.890417, -0.091627, -0.445827, 0.813029, -0.389562, -0.432696, -0.695827, -0.376897, -0.61137, 0.674581, -0.346511, -0.651821, -0.590835, -0.548931, 0.59126, -0.590835, -0.548931, 0.59126, 0.674581, -0.346511, -0.651821, 0.591683, -0.535363, 0.602742, 0.695827, -0.376897, -0.61137, 0.590835, -0.548931, 0.59126, -0.674582, -0.34651, -0.651821, -0.674582, -0.34651, -0.651821, 0.590835, -0.548931, 0.59126, -0.591683, -0.535363, 0.602742, 0.828363, -0.321446, 0.458789, 0.813029, -0.389562, -0.432696, 0.889947, -0.012539, 0.455891, 0.889947, -0.012539, 0.455891, 0.813029, -0.389562, -0.432696, 0.890417, -0.091627, -0.445827, 0.889947, -0.012539, 0.455891, 0.890417, -0.091627, -0.445827, 0.874894, 0.213235, 0.434846, 0.874894, 0.213235, 0.434846, 0.890417, -0.091627, -0.445827, 0.873704, 0.204008, -0.441613, 0.873704, 0.204008, -0.441613, 0.838685, 0.351589, -0.415924, 0.874894, 0.213235, 0.434846, 0.874894, 0.213235, 0.434846, 0.838685, 0.351589, -0.415924, 0.859403, 0.304315, 0.410877, 0.838685, 0.351589, -0.415924, 0.605282, 0.020451, -0.795749, 0.859403, 0.304315, 0.410877, 0.859403, 0.304315, 0.410877, 0.605282, 0.020451, -0.795749, 0.618729, -0.066545, 0.782781, 0.788003, -0.442568, -0.428002, 0.702514, 0.439067, -0.560085, 0.817459, -0.447457, 0.362688, 0.817459, -0.447457, 0.362688, 0.702514, 0.439067, -0.560085, 0.790681, 0.367113, 0.489951, -0.824886, -0.322738, 0.464115, -0.889544, -0.020305, 0.456398, -0.813081, -0.389443, -0.432704, -0.813081, -0.389443, -0.432704, -0.889544, -0.020305, 0.456398, -0.890417, -0.091627, -0.445827, -0.889544, -0.020305, 0.456398, -0.877763, 0.212682, 0.4293, -0.890417, -0.091627, -0.445827, -0.890417, -0.091627, -0.445827, -0.877763, 0.212682, 0.4293, -0.873704, 0.204008, -0.441613, -0.873704, 0.204008, -0.441613, -0.877763, 0.212682, 0.4293, -0.838685, 0.351589, -0.415924, -0.838685, 0.351589, -0.415924, -0.877763, 0.212682, 0.4293, -0.860096, 0.307118, 0.407324, -0.838685, 0.351589, -0.415924, -0.860096, 0.307118, 0.407324, -0.605282, 0.020451, -0.795749, -0.605282, 0.020451, -0.795749, -0.860096, 0.307118, 0.407324, -0.618729, -0.066545, 0.782781, -0.788002, -0.442568, -0.428002, -0.817459, -0.447457, 0.362688, -0.702514, 0.439066, -0.560085, -0.702514, 0.439066, -0.560085, -0.817459, -0.447457, 0.362688, -0.790681, 0.367112, 0.489951, -0.598022, 0.474115, 0.646208, 0.598022, 0.474115, 0.646208, -0.514522, -0.493428, 0.701281, -0.514522, -0.493428, 0.701281, 0.598022, 0.474115, 0.646208, 0.514522, -0.493428, 0.701281, 0.598022, 0.474115, 0.646208, 0.587421, 0.355488, -0.727024, 0.514522, -0.493428, 0.701281, 0.514522, -0.493428, 0.701281, 0.587421, 0.355488, -0.727024, 0.452513, -0.868567, -0.202047, 0.587421, 0.355488, -0.727024, -0.587421, 0.355488, -0.727025, 0.452513, -0.868567, -0.202047, 0.452513, -0.868567, -0.202047, -0.587421, 0.355488, -0.727025, -0.452513, -0.868567, -0.202048, -0.598022, 0.474115, 0.646208, -0.514522, -0.493428, 0.701281, -0.587421, 0.355488, -0.727025, -0.587421, 0.355488, -0.727025, -0.514522, -0.493428, 0.701281, -0.452513, -0.868567, -0.202048, 0.605282, 0.020451, -0.795749, -0.172289, -0.67832, -0.714282, 0.618729, -0.066545, 0.782781, 0.618729, -0.066545, 0.782781, -0.172289, -0.67832, -0.714282, -0.202666, -0.701243, 0.683509, 0.411898, 0.697289, -0.586624, -0.038296, 0.719347, -0.693594, 0.605282, 0.020451, -0.795749, 0.605282, 0.020451, -0.795749, -0.038296, 0.719347, -0.693594, -0.172289, -0.67832, -0.714282, 0.411898, 0.697289, -0.586624, 0.421812, 0.690423, 0.5877, -0.038296, 0.719347, -0.693594, -0.038296, 0.719347, -0.693594, 0.421812, 0.690423, 0.5877, -0.078411, 0.69432, 0.715382, 0.421812, 0.690423, 0.5877, 0.618729, -0.066545, 0.782781, -0.078411, 0.69432, 0.715382, -0.078411, 0.69432, 0.715382, 0.618729, -0.066545, 0.782781, -0.202666, -0.701243, 0.683509, -0.605282, 0.020451, -0.795749, -0.618729, -0.066545, 0.782781, 0.172289, -0.67832, -0.714282, 0.172289, -0.67832, -0.714282, -0.618729, -0.066545, 0.782781, 0.202666, -0.701243, 0.683509, -0.421812, 0.690423, 0.5877, 0.078411, 0.69432, 0.715382, -0.618729, -0.066545, 0.782781, -0.618729, -0.066545, 0.782781, 0.078411, 0.69432, 0.715382, 0.202666, -0.701243, 0.683509, -0.411898, 0.697289, -0.586624, 0.038297, 0.719347, -0.693594, -0.421812, 0.690423, 0.5877, -0.421812, 0.690423, 0.5877, 0.038297, 0.719347, -0.693594, 0.078411, 0.69432, 0.715382, -0.411898, 0.697289, -0.586624, -0.605282, 0.020451, -0.795749, 0.038297, 0.719347, -0.693594, 0.038297, 0.719347, -0.693594, -0.605282, 0.020451, -0.795749, 0.172289, -0.67832, -0.714282, -0.202666, -0.701243, 0.683509, -0.172289, -0.67832, -0.714282, -0.197034, -0.703174, 0.683171, -0.197034, -0.703174, 0.683171, -0.172289, -0.67832, -0.714282, -0.197774, -0.688584, -0.697666, -0.172289, -0.67832, -0.714282, -0.038296, 0.719347, -0.693594, -0.197774, -0.688584, -0.697666, -0.197774, -0.688584, -0.697666, -0.038296, 0.719347, -0.693594, -0.053091, 0.703084, -0.709122, -0.038296, 0.719347, -0.693594, -0.078411, 0.69432, 0.715382, -0.053091, 0.703084, -0.709122, -0.053091, 0.703084, -0.709122, -0.078411, 0.69432, 0.715382, -0.057435, 0.688561, 0.722901, -0.202666, -0.701243, 0.683509, -0.197034, -0.703174, 0.683171, -0.078411, 0.69432, 0.715382, -0.078411, 0.69432, 0.715382, -0.197034, -0.703174, 0.683171, -0.057435, 0.688561, 0.722901, 0.202666, -0.701243, 0.683509, 0.207757, -0.703518, 0.679632, 0.172289, -0.67832, -0.714282, 0.172289, -0.67832, -0.714282, 0.207757, -0.703518, 0.679632, 0.203469, -0.682427, -0.702065, 0.202666, -0.701243, 0.683509, 0.078411, 0.69432, 0.715382, 0.207757, -0.703518, 0.679632, 0.207757, -0.703518, 0.679632, 0.078411, 0.69432, 0.715382, 0.05977, 0.690211, 0.721135, 0.078411, 0.69432, 0.715382, 0.038297, 0.719347, -0.693594, 0.05977, 0.690211, 0.721135, 0.05977, 0.690211, 0.721135, 0.038297, 0.719347, -0.693594, 0.053091, 0.703084, -0.709122, 0.172289, -0.67832, -0.714282, 0.203469, -0.682427, -0.702065, 0.038297, 0.719347, -0.693594, 0.038297, 0.719347, -0.693594, 0.203469, -0.682427, -0.702065, 0.053091, 0.703084, -0.709122, -0.197034, -0.703174, 0.683171, -0.197774, -0.688584, -0.697666, -0.216566, -0.699048, 0.681492, -0.216566, -0.699048, 0.681492, -0.197774, -0.688584, -0.697666, -0.217457, -0.680361, -0.699873, -0.197774, -0.688584, -0.697666, -0.053091, 0.703084, -0.709122, -0.217457, -0.680361, -0.699873, -0.217457, -0.680361, -0.699873, -0.053091, 0.703084, -0.709122, -0.055926, 0.707833, -0.704162, -0.053091, 0.703084, -0.709122, -0.057435, 0.688561, 0.722901, -0.055926, 0.707833, -0.704162, -0.055926, 0.707833, -0.704162, -0.057435, 0.688561, 0.722901, -0.062132, 0.689348, 0.721761, -0.197034, -0.703174, 0.683171, -0.216566, -0.699048, 0.681492, -0.057435, 0.688561, 0.722901, -0.057435, 0.688561, 0.722901, -0.216566, -0.699048, 0.681492, -0.062132, 0.689348, 0.721761, 0.207757, -0.703518, 0.679632, 0.221583, -0.703068, 0.675719, 0.203469, -0.682427, -0.702065, 0.203469, -0.682427, -0.702065, 0.221583, -0.703068, 0.675719, 0.216844, -0.672734, -0.707394, 0.207757, -0.703518, 0.679632, 0.05977, 0.690211, 0.721135, 0.221583, -0.703068, 0.675719, 0.221583, -0.703068, 0.675719, 0.05977, 0.690211, 0.721135, 0.062652, 0.691539, 0.719617, 0.053091, 0.703084, -0.709122, 0.055926, 0.707833, -0.704162, 0.05977, 0.690211, 0.721135, 0.05977, 0.690211, 0.721135, 0.055926, 0.707833, -0.704162, 0.062652, 0.691539, 0.719617, 0.203469, -0.682427, -0.702065, 0.216844, -0.672734, -0.707394, 0.053091, 0.703084, -0.709122, 0.053091, 0.703084, -0.709122, 0.216844, -0.672734, -0.707394, 0.055926, 0.707833, -0.704162, -0.216566, -0.699048, 0.681492, -0.217457, -0.680361, -0.699873, 0.265515, -0.69092, 0.672408, 0.265515, -0.69092, 0.672408, -0.217457, -0.680361, -0.699873, 0.194482, -0.659277, -0.726313, -0.217457, -0.680361, -0.699873, -0.055926, 0.707833, -0.704162, 0.194482, -0.659277, -0.726313, 0.194482, -0.659277, -0.726313, -0.055926, 0.707833, -0.704162, 0.066972, 0.702357, -0.708668, -0.055926, 0.707833, -0.704162, -0.062132, 0.689348, 0.721761, 0.066972, 0.702357, -0.708668, 0.066972, 0.702357, -0.708668, -0.062132, 0.689348, 0.721761, 0.153002, 0.682297, 0.714886, -0.216566, -0.699048, 0.681492, 0.265515, -0.69092, 0.672408, -0.062132, 0.689348, 0.721761, -0.062132, 0.689348, 0.721761, 0.265515, -0.69092, 0.672408, 0.153002, 0.682297, 0.714886, 0.221583, -0.703068, 0.675719, -0.273207, -0.692356, 0.667833, 0.216844, -0.672734, -0.707394, 0.216844, -0.672734, -0.707394, -0.273207, -0.692356, 0.667833, -0.198844, -0.65627, -0.727853, 0.221583, -0.703068, 0.675719, 0.062652, 0.691539, 0.719617, -0.273207, -0.692356, 0.667833, -0.273207, -0.692356, 0.667833, 0.062652, 0.691539, 0.719617, -0.154652, 0.682617, 0.714224, 0.062652, 0.691539, 0.719617, 0.055926, 0.707833, -0.704162, -0.154652, 0.682617, 0.714224, -0.154652, 0.682617, 0.714224, 0.055926, 0.707833, -0.704162, -0.066972, 0.702357, -0.708668, 0.216844, -0.672734, -0.707394, -0.198844, -0.65627, -0.727853, 0.055926, 0.707833, -0.704162, 0.055926, 0.707833, -0.704162, -0.198844, -0.65627, -0.727853, -0.066972, 0.702357, -0.708668, 0.265515, -0.69092, 0.672408, 0.194482, -0.659277, -0.726313, 0.817459, -0.447457, 0.362688, 0.817459, -0.447457, 0.362688, 0.194482, -0.659277, -0.726313, 0.788003, -0.442568, -0.428002, 0.194482, -0.659277, -0.726313, 0.066972, 0.702357, -0.708668, 0.788003, -0.442568, -0.428002, 0.788003, -0.442568, -0.428002, 0.066972, 0.702357, -0.708668, 0.702514, 0.439067, -0.560085, 0.153002, 0.682297, 0.714886, 0.790681, 0.367113, 0.489951, 0.066972, 0.702357, -0.708668, 0.066972, 0.702357, -0.708668, 0.790681, 0.367113, 0.489951, 0.702514, 0.439067, -0.560085, 0.265515, -0.69092, 0.672408, 0.817459, -0.447457, 0.362688, 0.153002, 0.682297, 0.714886, 0.153002, 0.682297, 0.714886, 0.817459, -0.447457, 0.362688, 0.790681, 0.367113, 0.489951, -0.273207, -0.692356, 0.667833, -0.817459, -0.447457, 0.362688, -0.198844, -0.65627, -0.727853, -0.198844, -0.65627, -0.727853, -0.817459, -0.447457, 0.362688, -0.788002, -0.442568, -0.428002, -0.273207, -0.692356, 0.667833, -0.154652, 0.682617, 0.714224, -0.817459, -0.447457, 0.362688, -0.817459, -0.447457, 0.362688, -0.154652, 0.682617, 0.714224, -0.790681, 0.367112, 0.489951, -0.154652, 0.682617, 0.714224, -0.066972, 0.702357, -0.708668, -0.790681, 0.367112, 0.489951, -0.790681, 0.367112, 0.489951, -0.066972, 0.702357, -0.708668, -0.702514, 0.439066, -0.560085, -0.198844, -0.65627, -0.727853, -0.788002, -0.442568, -0.428002, -0.066972, 0.702357, -0.708668, -0.066972, 0.702357, -0.708668, -0.788002, -0.442568, -0.428002, -0.702514, 0.439066, -0.560085, -0.222917, -0.546128, -0.807498, 0.174855, -0.750657, -0.637134, -0.813081, -0.389443, -0.432704, -0.813081, -0.389443, -0.432704, 0.174855, -0.750657, -0.637134, -0.762108, -0.330327, -0.556844, -0.299368, -0.543695, 0.784076, -0.824886, -0.322738, 0.464115, 0.149542, -0.75895, 0.633745, 0.149542, -0.75895, 0.633745, -0.824886, -0.322738, 0.464115, -0.759027, -0.362219, 0.540995, -0.824886, -0.322738, 0.464115, -0.813081, -0.389443, -0.432704, -0.759027, -0.362219, 0.540995, -0.759027, -0.362219, 0.540995, -0.813081, -0.389443, -0.432704, -0.762108, -0.330327, -0.556844, 0.222818, -0.546215, -0.807466, 0.813029, -0.389562, -0.432696, -0.174838, -0.750932, -0.636814, -0.174838, -0.750932, -0.636814, 0.813029, -0.389562, -0.432696, 0.762042, -0.330432, -0.556872, 0.828363, -0.321446, 0.458789, 0.759564, -0.365772, 0.537842, 0.813029, -0.389562, -0.432696, 0.813029, -0.389562, -0.432696, 0.759564, -0.365772, 0.537842, 0.762042, -0.330432, -0.556872, 0.299298, -0.539595, 0.78693, -0.148832, -0.761863, 0.630408, 0.828363, -0.321446, 0.458789, 0.828363, -0.321446, 0.458789, -0.148832, -0.761863, 0.630408, 0.759564, -0.365772, 0.537842, 0.174855, -0.750657, -0.637134, 0.683985, -0.082772, -0.724785, -0.762108, -0.330327, -0.556844, -0.762108, -0.330327, -0.556844, 0.683985, -0.082772, -0.724785, -0.72772, -0.028826, -0.685269, 0.149542, -0.75895, 0.633745, 0.682051, -0.15247, 0.715234, 0.174855, -0.750657, -0.637134, 0.174855, -0.750657, -0.637134, 0.682051, -0.15247, 0.715234, 0.683985, -0.082772, -0.724785, 0.149542, -0.75895, 0.633745, -0.759027, -0.362219, 0.540995, 0.682051, -0.15247, 0.715234, 0.682051, -0.15247, 0.715234, -0.759027, -0.362219, 0.540995, -0.733733, -0.093977, 0.672908, -0.759027, -0.362219, 0.540995, -0.762108, -0.330327, -0.556844, -0.733733, -0.093977, 0.672908, -0.733733, -0.093977, 0.672908, -0.762108, -0.330327, -0.556844, -0.72772, -0.028826, -0.685269, -0.174838, -0.750932, -0.636814, 0.762042, -0.330432, -0.556872, -0.683913, -0.083457, -0.724775, -0.683913, -0.083457, -0.724775, 0.762042, -0.330432, -0.556872, 0.727701, -0.028789, -0.68529, 0.759564, -0.365772, 0.537842, 0.733707, -0.093933, 0.672942, 0.762042, -0.330432, -0.556872, 0.762042, -0.330432, -0.556872, 0.733707, -0.093933, 0.672942, 0.727701, -0.028789, -0.68529, -0.148832, -0.761863, 0.630408, -0.681946, -0.153139, 0.715191, 0.759564, -0.365772, 0.537842, 0.759564, -0.365772, 0.537842, -0.681946, -0.153139, 0.715191, 0.733707, -0.093933, 0.672942, -0.148832, -0.761863, 0.630408, -0.174838, -0.750932, -0.636814, -0.681946, -0.153139, 0.715191, -0.681946, -0.153139, 0.715191, -0.174838, -0.750932, -0.636814, -0.683913, -0.083457, -0.724775, 0.149542, -0.75895, 0.633745, -0.148832, -0.761863, 0.630408, -0.299368, -0.543695, 0.784076, -0.299368, -0.543695, 0.784076, -0.148832, -0.761863, 0.630408, 0.299298, -0.539595, 0.78693, 0.174855, -0.750657, -0.637134, -0.222917, -0.546128, -0.807498, -0.174838, -0.750932, -0.636814, -0.174838, -0.750932, -0.636814, -0.222917, -0.546128, -0.807498, 0.222818, -0.546215, -0.807466, 0.149542, -0.75895, 0.633745, 0.174855, -0.750657, -0.637134, -0.148832, -0.761863, 0.630408, -0.148832, -0.761863, 0.630408, 0.174855, -0.750657, -0.637134, -0.174838, -0.750932, -0.636814, 0.683985, -0.082772, -0.724785, 0.69566, -0.010989, -0.718287, -0.72772, -0.028826, -0.685269, -0.72772, -0.028826, -0.685269, 0.69566, -0.010989, -0.718287, -0.716941, 0.043022, -0.695805, 0.682051, -0.15247, 0.715234, 0.705868, 0.013455, 0.708215, 0.683985, -0.082772, -0.724785, 0.683985, -0.082772, -0.724785, 0.705868, 0.013455, 0.708215, 0.69566, -0.010989, -0.718287, 0.682051, -0.15247, 0.715234, -0.733733, -0.093977, 0.672908, 0.705868, 0.013455, 0.708215, 0.705868, 0.013455, 0.708215, -0.733733, -0.093977, 0.672908, -0.705879, 0.067749, 0.705085, -0.733733, -0.093977, 0.672908, -0.72772, -0.028826, -0.685269, -0.705879, 0.067749, 0.705085, -0.705879, 0.067749, 0.705085, -0.72772, -0.028826, -0.685269, -0.716941, 0.043022, -0.695805, -0.683913, -0.083457, -0.724775, 0.727701, -0.028789, -0.68529, -0.69566, -0.010989, -0.718287, -0.69566, -0.010989, -0.718287, 0.727701, -0.028789, -0.68529, 0.716941, 0.043022, -0.695805, 0.733707, -0.093933, 0.672942, 0.705879, 0.067749, 0.705085, 0.727701, -0.028789, -0.68529, 0.727701, -0.028789, -0.68529, 0.705879, 0.067749, 0.705085, 0.716941, 0.043022, -0.695805, -0.681946, -0.153139, 0.715191, -0.705869, 0.013455, 0.708215, 0.733707, -0.093933, 0.672942, 0.733707, -0.093933, 0.672942, -0.705869, 0.013455, 0.708215, 0.705879, 0.067749, 0.705085, -0.681946, -0.153139, 0.715191, -0.683913, -0.083457, -0.724775, -0.705869, 0.013455, 0.708215, -0.705869, 0.013455, 0.708215, -0.683913, -0.083457, -0.724775, -0.69566, -0.010989, -0.718287, 0.69566, -0.010989, -0.718287, 0.689047, 0.000181, -0.724716, -0.716941, 0.043022, -0.695805, -0.716941, 0.043022, -0.695805, 0.689047, 0.000181, -0.724716, -0.722294, 0.045988, -0.690055, 0.69566, -0.010989, -0.718287, 0.705868, 0.013455, 0.708215, 0.689047, 0.000181, -0.724716, 0.689047, 0.000181, -0.724716, 0.705868, 0.013455, 0.708215, 0.701699, 0.102379, 0.70508, 0.705868, 0.013455, 0.708215, -0.705879, 0.067749, 0.705085, 0.701699, 0.102379, 0.70508, 0.701699, 0.102379, 0.70508, -0.705879, 0.067749, 0.705085, -0.704236, 0.14723, 0.694532, -0.716941, 0.043022, -0.695805, -0.722294, 0.045988, -0.690055, -0.705879, 0.067749, 0.705085, -0.705879, 0.067749, 0.705085, -0.722294, 0.045988, -0.690055, -0.704236, 0.14723, 0.694532, -0.69566, -0.010989, -0.718287, 0.716941, 0.043022, -0.695805, -0.689047, 0.000181, -0.724716, -0.689047, 0.000181, -0.724716, 0.716941, 0.043022, -0.695805, 0.722294, 0.045989, -0.690055, 0.716941, 0.043022, -0.695805, 0.705879, 0.067749, 0.705085, 0.722294, 0.045989, -0.690055, 0.722294, 0.045989, -0.690055, 0.705879, 0.067749, 0.705085, 0.704236, 0.14723, 0.694532, -0.705869, 0.013455, 0.708215, -0.701699, 0.102378, 0.70508, 0.705879, 0.067749, 0.705085, 0.705879, 0.067749, 0.705085, -0.701699, 0.102378, 0.70508, 0.704236, 0.14723, 0.694532, -0.69566, -0.010989, -0.718287, -0.689047, 0.000181, -0.724716, -0.705869, 0.013455, 0.708215, -0.705869, 0.013455, 0.708215, -0.689047, 0.000181, -0.724716, -0.701699, 0.102378, 0.70508, 0.689047, 0.000181, -0.724716, 0.690275, 0.031812, -0.722848, -0.722294, 0.045988, -0.690055, -0.722294, 0.045988, -0.690055, 0.690275, 0.031812, -0.722848, -0.720593, 0.04202, -0.692084, 0.689047, 0.000181, -0.724716, 0.701699, 0.102379, 0.70508, 0.690275, 0.031812, -0.722848, 0.690275, 0.031812, -0.722848, 0.701699, 0.102379, 0.70508, 0.696235, 0.153686, 0.701169, 0.701699, 0.102379, 0.70508, -0.704236, 0.14723, 0.694532, 0.696235, 0.153686, 0.701169, 0.696235, 0.153686, 0.701169, -0.704236, 0.14723, 0.694532, -0.705436, 0.162834, 0.689815, -0.722294, 0.045988, -0.690055, -0.720593, 0.04202, -0.692084, -0.704236, 0.14723, 0.694532, -0.704236, 0.14723, 0.694532, -0.720593, 0.04202, -0.692084, -0.705436, 0.162834, 0.689815, -0.689047, 0.000181, -0.724716, 0.722294, 0.045989, -0.690055, -0.690275, 0.031812, -0.722848, -0.690275, 0.031812, -0.722848, 0.722294, 0.045989, -0.690055, 0.720593, 0.04202, -0.692084, 0.722294, 0.045989, -0.690055, 0.704236, 0.14723, 0.694532, 0.720593, 0.04202, -0.692084, 0.720593, 0.04202, -0.692084, 0.704236, 0.14723, 0.694532, 0.705436, 0.162834, 0.689815, -0.701699, 0.102378, 0.70508, -0.696235, 0.153686, 0.701169, 0.704236, 0.14723, 0.694532, 0.704236, 0.14723, 0.694532, -0.696235, 0.153686, 0.701169, 0.705436, 0.162834, 0.689815, -0.689047, 0.000181, -0.724716, -0.690275, 0.031812, -0.722848, -0.701699, 0.102378, 0.70508, -0.701699, 0.102378, 0.70508, -0.690275, 0.031812, -0.722848, -0.696235, 0.153686, 0.701169, -0.720593, 0.04202, -0.692084, 0.690275, 0.031812, -0.722848, -0.72419, 0.173025, -0.667541, -0.72419, 0.173025, -0.667541, 0.690275, 0.031812, -0.722848, 0.690934, 0.203019, -0.693825, 0.690275, 0.031812, -0.722848, 0.696235, 0.153686, 0.701169, 0.690934, 0.203019, -0.693825, 0.690934, 0.203019, -0.693825, 0.696235, 0.153686, 0.701169, 0.69654, 0.114543, 0.708316, -0.705436, 0.162834, 0.689815, -0.70853, 0.087092, 0.700285, 0.696235, 0.153686, 0.701169, 0.696235, 0.153686, 0.701169, -0.70853, 0.087092, 0.700285, 0.69654, 0.114543, 0.708316, -0.720593, 0.04202, -0.692084, -0.72419, 0.173025, -0.667541, -0.705436, 0.162834, 0.689815, -0.705436, 0.162834, 0.689815, -0.72419, 0.173025, -0.667541, -0.70853, 0.087092, 0.700285, 0.720593, 0.04202, -0.692084, 0.72419, 0.173025, -0.667541, -0.690275, 0.031812, -0.722848, -0.690275, 0.031812, -0.722848, 0.72419, 0.173025, -0.667541, -0.690934, 0.203019, -0.693825, 0.720593, 0.04202, -0.692084, 0.705436, 0.162834, 0.689815, 0.72419, 0.173025, -0.667541, 0.72419, 0.173025, -0.667541, 0.705436, 0.162834, 0.689815, 0.708531, 0.087093, 0.700285, 0.705436, 0.162834, 0.689815, -0.696235, 0.153686, 0.701169, 0.708531, 0.087093, 0.700285, 0.708531, 0.087093, 0.700285, -0.696235, 0.153686, 0.701169, -0.69654, 0.114543, 0.708316, -0.690275, 0.031812, -0.722848, -0.690934, 0.203019, -0.693825, -0.696235, 0.153686, 0.701169, -0.696235, 0.153686, 0.701169, -0.690934, 0.203019, -0.693825, -0.69654, 0.114543, 0.708316, -0.72419, 0.173025, -0.667541, 0.690934, 0.203019, -0.693825, -0.695827, -0.376897, -0.61137, -0.695827, -0.376897, -0.61137, 0.690934, 0.203019, -0.693825, 0.674581, -0.346511, -0.651821, 0.69654, 0.114543, 0.708316, 0.591683, -0.535363, 0.602742, 0.690934, 0.203019, -0.693825, 0.690934, 0.203019, -0.693825, 0.591683, -0.535363, 0.602742, 0.674581, -0.346511, -0.651821, -0.70853, 0.087092, 0.700285, -0.590835, -0.548931, 0.59126, 0.69654, 0.114543, 0.708316, 0.69654, 0.114543, 0.708316, -0.590835, -0.548931, 0.59126, 0.591683, -0.535363, 0.602742, -0.70853, 0.087092, 0.700285, -0.72419, 0.173025, -0.667541, -0.590835, -0.548931, 0.59126, -0.590835, -0.548931, 0.59126, -0.72419, 0.173025, -0.667541, -0.695827, -0.376897, -0.61137, 0.72419, 0.173025, -0.667541, 0.695827, -0.376897, -0.61137, -0.690934, 0.203019, -0.693825, -0.690934, 0.203019, -0.693825, 0.695827, -0.376897, -0.61137, -0.674582, -0.34651, -0.651821, 0.708531, 0.087093, 0.700285, 0.590835, -0.548931, 0.59126, 0.72419, 0.173025, -0.667541, 0.72419, 0.173025, -0.667541, 0.590835, -0.548931, 0.59126, 0.695827, -0.376897, -0.61137, 0.708531, 0.087093, 0.700285, -0.69654, 0.114543, 0.708316, 0.590835, -0.548931, 0.59126, 0.590835, -0.548931, 0.59126, -0.69654, 0.114543, 0.708316, -0.591683, -0.535363, 0.602742, -0.69654, 0.114543, 0.708316, -0.690934, 0.203019, -0.693825, -0.591683, -0.535363, 0.602742, -0.591683, -0.535363, 0.602742, -0.690934, 0.203019, -0.693825, -0.674582, -0.34651, -0.651821, -0.846458, 0.448968, 0.286246, -0.899127, 0.011771, 0.43753, -0.564366, 0.461983, -0.684151, -0.564366, 0.461983, -0.684151, -0.899127, 0.011771, 0.43753, -0.504347, -0.025578, -0.863122, -0.846458, 0.448968, 0.286246, -0.041474, 0.905009, 0.423367, -0.899127, 0.011771, 0.43753, -0.899127, 0.011771, 0.43753, -0.041474, 0.905009, 0.423367, 0.270016, 0.577269, 0.770618, -0.041474, 0.905009, 0.423367, 0.183696, 0.913917, -0.361956, 0.270016, 0.577269, 0.770618, 0.270016, 0.577269, 0.770618, 0.183696, 0.913917, -0.361956, 0.679775, 0.544026, -0.491875, -0.564366, 0.461983, -0.684151, -0.504347, -0.025578, -0.863122, 0.183696, 0.913917, -0.361956, 0.183696, 0.913917, -0.361956, -0.504347, -0.025578, -0.863122, 0.679775, 0.544026, -0.491875, 0.846458, 0.448968, 0.286247, 0.564366, 0.461983, -0.684151, 0.899127, 0.011771, 0.43753, 0.899127, 0.011771, 0.43753, 0.564366, 0.461983, -0.684151, 0.504347, -0.025578, -0.863122, 0.564366, 0.461983, -0.684151, -0.183696, 0.913917, -0.361955, 0.504347, -0.025578, -0.863122, 0.504347, -0.025578, -0.863122, -0.183696, 0.913917, -0.361955, -0.679775, 0.544027, -0.491874, 0.041474, 0.905008, 0.423367, -0.270015, 0.577268, 0.770619, -0.183696, 0.913917, -0.361955, -0.183696, 0.913917, -0.361955, -0.270015, 0.577268, 0.770619, -0.679775, 0.544027, -0.491874, 0.846458, 0.448968, 0.286247, 0.899127, 0.011771, 0.43753, 0.041474, 0.905008, 0.423367, 0.041474, 0.905008, 0.423367, 0.899127, 0.011771, 0.43753, -0.270015, 0.577268, 0.770619, -0.504347, -0.025578, -0.863122, -0.899127, 0.011771, 0.43753, -0.379516, 0.919115, -0.105811, -0.899127, 0.011771, 0.43753, 0.270016, 0.577269, 0.770618, -0.379516, 0.919115, -0.105811, 0.270016, 0.577269, 0.770618, 0.679775, 0.544026, -0.491875, -0.379516, 0.919115, -0.105811, 0.679775, 0.544026, -0.491875, -0.504347, -0.025578, -0.863122, -0.379516, 0.919115, -0.105811, 0.899127, 0.011771, 0.43753, 0.504347, -0.025578, -0.863122, 0.379516, 0.919115, -0.105808, 0.504347, -0.025578, -0.863122, -0.679775, 0.544027, -0.491874, 0.379516, 0.919115, -0.105808, -0.679775, 0.544027, -0.491874, -0.270015, 0.577268, 0.770619, 0.379516, 0.919115, -0.105808, -0.270015, 0.577268, 0.770619, 0.899127, 0.011771, 0.43753, 0.379516, 0.919115, -0.105808, 0.299298, -0.539595, 0.78693, 0.503454, -0.705392, 0.498955, -0.299368, -0.543695, 0.784076, -0.299368, -0.543695, 0.784076, 0.503454, -0.705392, 0.498955, -0.499079, -0.718636, 0.484235, 0.34029, 0.087474, 0.936243, 0.523453, 0.4439, 0.727289, 0.299298, -0.539595, 0.78693, 0.299298, -0.539595, 0.78693, 0.523453, 0.4439, 0.727289, 0.503454, -0.705392, 0.498955, -0.338226, 0.076298, 0.937967, -0.536717, 0.419718, 0.731964, 0.34029, 0.087474, 0.936243, 0.34029, 0.087474, 0.936243, -0.536717, 0.419718, 0.731964, 0.523453, 0.4439, 0.727289, -0.338226, 0.076298, 0.937967, -0.299368, -0.543695, 0.784076, -0.536717, 0.419718, 0.731964, -0.536717, 0.419718, 0.731964, -0.299368, -0.543695, 0.784076, -0.499079, -0.718636, 0.484235, 0.503454, -0.705392, 0.498955, 0.690652, -0.7228, 0.023649, -0.499079, -0.718636, 0.484235, -0.499079, -0.718636, 0.484235, 0.690652, -0.7228, 0.023649, -0.67126, -0.740883, 0.022418, 0.503454, -0.705392, 0.498955, 0.523453, 0.4439, 0.727289, 0.690652, -0.7228, 0.023649, 0.690652, -0.7228, 0.023649, 0.523453, 0.4439, 0.727289, 0.722332, 0.690007, 0.046108, -0.536717, 0.419718, 0.731964, -0.740387, 0.670556, 0.046718, 0.523453, 0.4439, 0.727289, 0.523453, 0.4439, 0.727289, -0.740387, 0.670556, 0.046718, 0.722332, 0.690007, 0.046108, -0.536717, 0.419718, 0.731964, -0.499079, -0.718636, 0.484235, -0.740387, 0.670556, 0.046718, -0.740387, 0.670556, 0.046718, -0.499079, -0.718636, 0.484235, -0.67126, -0.740883, 0.022418, -0.67126, -0.740883, 0.022418, 0.690652, -0.7228, 0.023649, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006659, 0.690652, -0.7228, 0.023649, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006658, -0.671625, -0.740861, -0.006658, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006658, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006658, -0.671625, -0.740861, -0.006658, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006658, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006658, -0.671625, -0.740861, -0.006658, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006658, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006658, -0.671625, -0.740861, -0.006658, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006658, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, -0.671625, -0.740861, -0.006659, 0.691053, -0.722777, -0.006237, -0.55422, -0.596716, -0.580319, -0.55422, -0.596716, -0.580319, 0.691053, -0.722777, -0.006237, 0.564896, -0.576721, -0.590158, 0.690652, -0.7228, 0.023649, 0.722332, 0.690007, 0.046108, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722332, 0.690007, 0.046108, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015963, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015963, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015963, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, 0.691053, -0.722777, -0.006237, 0.722786, 0.690887, 0.015962, 0.564896, -0.576721, -0.590158, 0.564896, -0.576721, -0.590158, 0.722786, 0.690887, 0.015962, 0.580891, 0.569609, -0.581473, 0.722332, 0.690007, 0.046108, -0.740387, 0.670556, 0.046718, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, -0.740387, 0.670556, 0.046718, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015963, 0.722786, 0.690887, 0.015963, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015792, 0.722786, 0.690887, 0.015963, -0.740873, 0.671459, 0.015792, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015792, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, 0.722786, 0.690887, 0.015962, -0.740873, 0.671459, 0.015791, 0.580891, 0.569609, -0.581473, 0.580891, 0.569609, -0.581473, -0.740873, 0.671459, 0.015791, -0.590195, 0.548689, -0.592124, -0.740387, 0.670556, 0.046718, -0.67126, -0.740883, 0.022418, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, -0.67126, -0.740883, 0.022418, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006658, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006658, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006658, -0.671625, -0.740861, -0.006658, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006658, -0.740873, 0.671459, 0.015792, -0.740873, 0.671459, 0.015792, -0.671625, -0.740861, -0.006658, -0.671625, -0.740861, -0.006658, -0.740873, 0.671459, 0.015792, -0.671625, -0.740861, -0.006658, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006658, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006658, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006658, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006658, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.671625, -0.740861, -0.006659, -0.740873, 0.671459, 0.015791, -0.671625, -0.740861, -0.006659, -0.590195, 0.548689, -0.592124, -0.590195, 0.548689, -0.592124, -0.671625, -0.740861, -0.006659, -0.55422, -0.596716, -0.580319, -0.55422, -0.596716, -0.580319, 0.564896, -0.576721, -0.590158, -0.618271, -0.668823, -0.412815, -0.618271, -0.668823, -0.412815, 0.564896, -0.576721, -0.590158, 0.632895, -0.64954, -0.421357, 0.564896, -0.576721, -0.590158, 0.580891, 0.569609, -0.581473, 0.632895, -0.64954, -0.421357, 0.632895, -0.64954, -0.421357, 0.580891, 0.569609, -0.581473, 0.654256, 0.637675, -0.406596, 0.580891, 0.569609, -0.581473, -0.590195, 0.548689, -0.592124, 0.654256, 0.637675, -0.406596, 0.654256, 0.637675, -0.406596, -0.590195, 0.548689, -0.592124, -0.667964, 0.616834, -0.416341, -0.55422, -0.596716, -0.580319, -0.618271, -0.668823, -0.412815, -0.590195, 0.548689, -0.592124, -0.590195, 0.548689, -0.592124, -0.618271, -0.668823, -0.412815, -0.667964, 0.616834, -0.416341, -0.618271, -0.668823, -0.412815, 0.632895, -0.64954, -0.421357, 0.002504, -0.120573, 0.992701, 0.632895, -0.64954, -0.421357, 0.654256, 0.637675, -0.406596, 0.002504, -0.120573, 0.992701, 0.654256, 0.637675, -0.406596, -0.667964, 0.616834, -0.416341, 0.002504, -0.120573, 0.992701, -0.667964, 0.616834, -0.416341, -0.618271, -0.668823, -0.412815, 0.002504, -0.120573, 0.992701])
        ibuf = Vector.<uint>([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755, 756, 757, 758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 843, 844, 845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 903, 904, 905, 906, 907, 908, 909, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980, 981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404, 1405, 1406, 1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, 1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 1518, 1519, 1520, 1521, 1522, 1523, 1524, 1525, 1526, 1527, 1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535, 1536, 1537, 1538, 1539, 1540, 1541, 1542, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550, 1551, 1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564, 1565, 1566, 1567, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595, 1596, 1597, 1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624, 1625, 1626, 1627, 1628, 1629, 1630, 1631, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 1642, 1643, 1644, 1645, 1646, 1647, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1658, 1659, 1660, 1661, 1662, 1663, 1664, 1665, 1666, 1667, 1668, 1669, 1670, 1671, 1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680, 1681, 1682, 1683, 1684, 1685, 1686, 1687, 1688, 1689, 1690, 1691, 1692, 1693, 1694, 1695, 1696, 1697, 1698, 1699, 1700, 1701, 1702, 1703, 1704, 1705, 1706, 1707, 1708, 1709, 1710, 1711, 1712, 1713, 1714, 1715, 1716, 1717, 1718, 1719, 1720, 1721, 1722, 1723, 1724, 1725, 1726, 1727, 1728, 1729, 1730, 1731, 1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739, 1740, 1741, 1742, 1743, 1744, 1745, 1746, 1747, 1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755, 1756, 1757, 1758, 1759, 1760, 1761, 1762, 1763, 1764, 1765, 1766, 1767, 1768, 1769, 1770, 1771, 1772, 1773, 1774, 1775, 1776, 1777, 1778, 1779, 1780, 1781])
        cbuf = vbuf.concat()
    }
    
}

//}

//package  
//{
import flash.display.Sprite;
import flash.display3D.Context3D;
import flash.display3D.IndexBuffer3D;
import flash.display3D.Program3D;
import flash.display3D.VertexBuffer3D;
import flash.display3D.textures.Texture;
import flash.geom.Vector3D;
import flash.utils.getTimer;
import flash.display3D.Context3DStencilAction;
import flash.display3D.Context3DCompareMode;

/**
 * 평면에 그림자 렌더링하기
 * @author codeonwort
 */
internal class Study_ShadowOnPlane extends Study_Base 
{
    private var model:Model
    private var loader:Loader // to load texture
    private var texture:Texture
    
    private var vbuf:VertexBuffer3D
    private var cbuf:VertexBuffer3D
    private var nbuf:VertexBuffer3D
    private var tbuf:VertexBuffer3D
    private var ibuf:IndexBuffer3D
    
    private var shadowVolume:Geometry
    private var svbuf:VertexBuffer3D
    private var sibuf:IndexBuffer3D
    
    private var plane_n:Vector3D = new Vector3D(0, 1, 0)
    private var plane_r:Vector3D = new Vector3D(0, -3, 0)
    private var light_d:Vector3D = new Vector3D(0, -1, 0)
    
    private var shadowColor:Vector.<Number> = Vector.<Number>([0, 0, 0, 0.5])
    private var shadowProgram:Program3D
    //private var shadowProj:Vector.<Number>
    
    public function Study_ShadowOnPlane(document:Sprite, context:Context3D) 
    {
        super(document, context)
        
        model = new Model
        model.move(0, -3, 10)
        
        shadowVolume = new Geometry
        
        vbuf = context.createVertexBuffer(model.vbuf.length/3, 3)
        vbuf.uploadFromVector(model.vbuf, 0, model.vbuf.length/3)
        
        cbuf = context.createVertexBuffer(model.cbuf.length/3, 3)
        cbuf.uploadFromVector(model.cbuf, 0, model.cbuf.length/3)
        
        nbuf = context.createVertexBuffer(model.nbuf.length/3, 3)
        nbuf.uploadFromVector(model.nbuf, 0, model.nbuf.length/3)
        
        tbuf = context.createVertexBuffer(model.tbuf.length/2, 2)
        tbuf.uploadFromVector(model.tbuf, 0, model.tbuf.length/2)
        
        ibuf = context.createIndexBuffer(model.ibuf.length)
        ibuf.uploadFromVector(model.ibuf, 0, model.ibuf.length)
        
        model.prespinY(30)
        
        var rq:URLRequest = new URLRequest( "http://assets.wonderfl.net/images/related_images/b/b5/b572/b57278e18cbab96c3816b878becbe368fc636f61" )
        loader = new Loader
        loader.load( rq, new LoaderContext(true) )
        loader.contentLoaderInfo.addEventListener( Event.COMPLETE, textureLoaded )
        
/* 정점에 월드 - 원근 변환 적용
va0: vertex position
va1: vertex color
va2: vertex normal
va3: texture coord
vc0~3: world transform matrix
vc4~7: perspective transform matrix
vc12 : delta transform matrix
vc16 : light vector
*/
var vshader:String = <agal><![CDATA[
m44 vt0, va0, vc0
m44 op, vt0, vc4
mov v0, va1
m44 v1, va2, vc12
mov vt0, vc16
neg vt0, vt0
mov v2, vt0
neg vt1, va2
add vt2, vt1, vt0
nrm vt2.xyz, vt2.xyz
mov v3, vt2
mov v4, va3
]]></agal>
/* 픽셀 셰이더
v0: 버텍스 색
v1: 버텍스 노말
v2: 조명 벡터
v3: 하프 벡터
v4: 텍스쳐 좌표
fc0: 상수 - x:2, y:0.5, z:4
*/
var fshader:String = <agal><![CDATA[
dp3 ft0.x, v1, v2
sat ft0.x, ft0.x
div ft0.x, ft0.x, fc0.x
add ft0.x, ft0.x, fc0.y
pow ft0.x, ft0.x, fc0.z
mov ft2, v1
dp3 ft1.x, ft2, v3
sat ft1.x, ft1.x
pow ft1.x, ft1.x, fc0.x
mul ft2, v0, ft0.x
add oc, ft2, ft1.x
]]></agal>
        vsAsm.assemble('vertex', vshader)
        fsAsm.assemble('fragment', fshader)
        program.upload(vsAsm.agalcode, fsAsm.agalcode)
        
        context.setProgramConstantsFromMatrix('vertex', 4, perspectiveTransform, true)
        
/* 그림자 투영을 위한 정점 셰이더 (월드 -> 그림자 -> 원근 변환)
va0: vertex position
va1: vertex color
va2: vertex normal
va3: texture coord
vc0~3: world transform matrix
vc4~7: perspective transform matrix
*/
var vshader2:String = <agal><![CDATA[
m44 vt0, va0, vc0
m44 op, vt0, vc4
]]></agal>
/* 그림자를 위한 픽셀 셰이더
fc0: 그림자 색
*/
var fshader2:String = <agal><![CDATA[
mov oc, fc1
]]></agal>
        shadowProgram = context.createProgram()
        shadowProgram.upload(vsAsm.assemble('vertex', vshader2), fsAsm.assemble('fragment', fshader2))
        
        render()
        document.addEventListener('enterFrame', render)
    }
    
    private function textureLoaded( e:Event ):void
    {
        var textureData:BitmapData = new BitmapData( 1024, 1024, false )
        textureData.draw( loader.content )
        texture = context.createTexture( textureData.width, textureData.height, "bgra", true )
        texture.uploadFromBitmapData( textureData )
        context.setTextureAt( 0, texture )
/* 정점에 월드 - 원근 변환 적용
va0: vertex position
va1: vertex color
va2: vertex normal
va3: texture coord
vc0~3: world transform matrix
vc4~7: perspective transform matrix
vc12 : delta transform matrix
vc16 : light vector
*/
var vshader:String = <agal><![CDATA[
m44 vt0, va0, vc0
m44 op, vt0, vc4
mov v0, va1
m44 v1, va2, vc12
mov vt0, vc16
neg vt0, vt0
mov v2, vt0
neg vt1, va2
add vt2, vt1, vt0
nrm vt2.xyz, vt2.xyz
mov v3, vt2
mov v4, va3
]]></agal>
/* 픽셀 셰이더
v0: 버텍스 색
v1: 버텍스 노말
v2: 조명 벡터
v3: 하프 벡터
v4: 텍스쳐 좌표
fc0: 상수 - x:2, y:0.5, z:4
*/
var fshader:String = <agal><![CDATA[
dp3 ft0.x, v1, v2
sat ft0.x, ft0.x
div ft0.x, ft0.x, fc0.x
add ft0.x, ft0.x, fc0.y
pow ft0.x, ft0.x, fc0.z
mov ft2, v1
dp3 ft1.x, ft2, v3
sat ft1.x, ft1.x
pow ft1.x, ft1.x, fc0.x
tex ft3, v4, fs0 <2d,nomip,linear>
mul ft2, ft3, ft0.x
add oc, ft2, ft1.x
]]></agal>
        vsAsm.assemble('vertex', vshader)
        fsAsm.assemble('fragment', fshader)
        program.upload(vsAsm.agalcode, fsAsm.agalcode)
    }
    
    
    // 특정 평면에 대한 그림자 투영 행렬을 만든다.
    // n: 평면의 단위 법선 벡터
    // r: 평면이 포함하는 임의의 점
    // L: 빛의 단위 방향 벡터
    private function makeShadowProj(n:Vector3D, r:Vector3D, L:Vector3D):Vector.<Number> {
        n.normalize();
        L.normalize();
        var nL:Number = n.dotProduct(L)
        var nr:Number = n.dotProduct(r)
        var proj:Vector.<Number> = new Vector.<Number>
        proj.push(nL - n.x * L.x, -n.y * L.x, -n.z * L.x, nr * L.x)
        proj.push(-n.x * L.y, nL - n.y * L.y, -n.z * L.y, nr * L.y)
        proj.push(-n.x * L.z, -n.y * L.z, nL - n.z * L.z, nr * L.z)
        proj.push(0, 0, 0, nL)
        for (var i:int = 0 ; i < proj.length ; i++) {
            proj[i] /= nL
        }
        /*
        proj.push(nL - n.x * L.x, -n.y * L.x, -n.z * L.x, nr * L.x)
        proj.push(-n.x * L.y, nL - n.y * L.y, -n.z * L.y, nr * L.y)
        proj.push(-n.x * L.z, -n.y * L.z, nL - n.z * L.z, nr * L.z)
        proj.push(0, 0, 0, nL)
        */
        return proj
    }
    
    private function makeShadowVolume( geom:Geometry, shadowGeom:Geometry, light:Vector3D, extrusion:Number ):void
    {
        var sg:Geometry = shadowGeom;
        var transform:Matrix3D = sg.transform;
        
        var ib:Vector.<uint> = geom.ibuf;
        var vb:Vector.<Number> = geom.vbuf;
        
        var sib:Vector.<uint> = sg.ibuf = new Vector.<uint>;
        var svb:Vector.<Number> = sg.vbuf = new Vector.<Number>;
        
        var vertex1:Vector3D = new Vector3D;
        var vertex2:Vector3D = new Vector3D;
        var idx:uint;
        
        var ex:Vector3D = light.clone();
        ex.normalize();
        ex.scaleBy( extrusion );
        
        var ex1:Vector3D = new Vector3D;
        var ex2:Vector3D = new Vector3D;
        
        function extrude( tidx:uint, eidx:uint, v1:Vector3D, v2:Vector3D ):void
        {
            //tidx = triangle index
            //eidx = edge index( 0, 1, 2 )
            //edge0 = v0, v1
            //edge1 = v1, v2
            //edge2 = v2, v0
            ex1 = v1.clone();
            ex1.incrementBy( ex );
            ex2 = v2.clone();
            ex2.incrementBy( ex );
            svb.push(
                v1.x, v1.y, v1.z, //0
                ex1.x, ex1.y, ex1.z, //1
                v2.x, v2.y, v2.z, //2
                ex2.x, ex2.y, ex2.z //3
            );
            idx = ( tidx*3+eidx )*4;
            sib.push( idx, idx+2, idx+3, idx, idx+3, idx+1 );
        }
        
        for( var i:int=0; i<ib.length/3; ++i )
        {
            for( var j:int=0; j<3; ++j )
            {
                idx = i*3;
                switch( j )
                {
                    case 0: //0, 1
                        vertex1.x = vb[ ib[ idx ]*3 ];
                        vertex1.y = vb[ ib[ idx ]*3+1 ];
                        vertex1.z = vb[ ib[ idx ]*3+2 ];
                        vertex2.x = vb[ ib[ idx+1 ]*3 ];
                        vertex2.y = vb[ ib[ idx+1 ]*3+1 ];
                        vertex2.z = vb[ ib[ idx+1 ]*3+2 ];
                        break;
                    case 1: //1, 2
                        vertex1.x = vb[ ib[ idx+1 ]*3 ];
                        vertex1.y = vb[ ib[ idx+1 ]*3+1 ];
                        vertex1.z = vb[ ib[ idx+1 ]*3+2 ];
                        vertex2.x = vb[ ib[ idx+2 ]*3 ];
                        vertex2.y = vb[ ib[ idx+2 ]*3+1 ];
                        vertex2.z = vb[ ib[ idx+2 ]*3+2 ];
                        break;
                    case 2: //2, 0
                        vertex1.x = vb[ ib[ idx+2 ]*3 ];
                        vertex1.y = vb[ ib[ idx+2 ]*3+1 ];
                        vertex1.z = vb[ ib[ idx+2 ]*3+2 ];
                        vertex2.x = vb[ ib[ idx ]*3 ];
                        vertex2.y = vb[ ib[ idx ]*3+1 ];
                        vertex2.z = vb[ ib[ idx ]*3+2 ];
                        break;
                    default:
                        break;
                }
                vertex1 = transform.transformVector( vertex1 );
                vertex2 = transform.transformVector( vertex2 );
                extrude( i, j, vertex1, vertex2 );
            }
        }
    }
    
    protected override function setupContext():void {
        context.configureBackBuffer(stage.stageWidth, stage.stageHeight, 4, true)
        context.setDepthTest(true, 'less')
    }
    
    private function render($:Object=null):void {
        var time:Number = getTimer()/1000
        light_d.x = Math.sin(time)/2
        light_d.y = Math.sin(time*3)/2 - 0.5
        light_d.z = Math.cos(time)/2
        light_d.normalize()
        
        //shadowProj = makeShadowProj(plane_n, plane_r, light_d)
        var lightVec:Vector.<Number> = Vector.<Number>([light_d.x, light_d.y, light_d.z, light_d.w])
        var shaderConstV:Vector.<Number> = Vector.<Number>([1, 1, 1, 1])
        var shaderConstF:Vector.<Number> = Vector.<Number>([2, 0.5, 4, 0])
        context.setProgramConstantsFromVector('vertex', 16, lightVec)
        context.setProgramConstantsFromVector('vertex', 17, shaderConstV)
        context.setProgramConstantsFromVector('fragment', 0, shaderConstF)
        
        context.clear(.5, .5, .5, 1,
            1 /*depth*/,
            0 /*stencil*/)
        
        context.setCulling('back')
        
        context.setBlendFactors('one', 'zero')
        
        context.setVertexBufferAt(0, vbuf, 0, 'float3')
        context.setVertexBufferAt(1, cbuf, 0, 'float3')
        context.setVertexBufferAt(2, nbuf, 0, 'float3')
        context.setVertexBufferAt(3, tbuf, 0, 'float2')
        
        context.setProgram(program)
        context.setProgramConstantsFromMatrix('vertex', 0, model.transform, true)
        context.setProgramConstantsFromMatrix('vertex', 12, model.deltaTransform, true)
        context.setTextureAt( 0, texture )
        context.drawTriangles(ibuf, 0, model.ibuf.length/3)
        
        context.setTextureAt( 0, null )
        
        context.setVertexBufferAt(1, null)
        context.setVertexBufferAt(2, null)
        context.setVertexBufferAt(3, null)
        
        context.setBlendFactors('one', 'oneMinusSourceAlpha')
        context.setProgram(shadowProgram)
        context.setProgramConstantsFromVector('fragment', 1, shadowColor)
        //context.setProgramConstantsFromVector('vertex', 8, shadowProj, 4)
        
        makeShadowVolume( model, shadowVolume, light_d, 100000 );
        svbuf = context.createVertexBuffer( shadowVolume.vbuf.length/3, 3 );
        svbuf.uploadFromVector( shadowVolume.vbuf, 0, shadowVolume.vbuf.length/3 );
        sibuf = context.createIndexBuffer( shadowVolume.ibuf.length );
        sibuf.uploadFromVector( shadowVolume.ibuf, 0, shadowVolume.ibuf.length );
        context.setVertexBufferAt(0, svbuf, 0, 'float3')
        
        //context.setStencilActions( "front", "equal", "incrementSaturate" );
        //context.setStencilReferenceValue( 0 );
        
        context.drawTriangles(sibuf, 0, shadowVolume.ibuf.length/3)
        
        context.present()
        
        svbuf.dispose();
        sibuf.dispose();
    }
    
}

//}