/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w9mY
 */

/* Benchmark results collection tool -
To embed:

import flash.display.*;
import flash.net.*;
import flash.system.*;
class StatsCollectorLoader {
    private static const URL:String = "http://swf.wonderfl.net/swf/usercode/e/e1/e154/e154bcc18ae75cf6c70f29a108e6af3eba3055d6.swf";
    public static function init(stage:Stage, results:Object): void {
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener("complete", function(e:*):void { loader.content["init"](stage, results); });
        loader.load(new URLRequest(URL), new LoaderContext(true));
    }
}

Then somewhere in your code:
StatsCollectorLoader.init(stage, yourResultsObject);

*/

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import com.bit101.components.*;
    
    [SWF (backgroundColor = "0", width = "465", height = "465")]
    public class StatsCollector extends Sprite {
        private const baseURL:String = "http://zozuar.org/wonderfl/benchmarks/";
        //private const baseURL:String = "http://10.0.0.1/www-play/wonderbench/server/"; // debug
        private var so:SharedObject;
        private var cpu:InputText;
        private var cpuGHz:InputText;
        private var cpuCores:InputText;
        private var moreInfo:InputText;
        private var user:String;
        private var appId:String;
        private var status:Label;
        private var sendBtn:PushButton;
        private var results:Object;
        private var userName:String;
        private var window:Window;

        public function StatsCollector() {
            so = SharedObject.getLocal("yonatan-StatsCollector-v0", "/");
            if(stage) init(stage, {foo: "bar", hoge: "fuga"});
        }

        // Show dialog, and send statistics from results object to server.
        // Result propery names starting with a bang (!) character are reserved.
        public function init(stage:Stage, results:Object):Window {
            this.results = results;
            userName = stage.loaderInfo.parameters["viewer.displayName"];
            appId = stage.loaderInfo.parameters.appId || "test"; // debug

            stage.addChild(this);
            graphics.beginFill(0xffffff, 0.5);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();

            window = new Window(this, 0, 0, "Publish your results");
            window.setSize(450, 370);
            window.x = (width - window.width)/2;
            window.y = (height - window.height)/2;

            window.addEventListener(Event.CLOSE, onClose);
            window.hasCloseButton = true;
            var w:int = window.width-20;
            var h:int = window.height-20;
            var vb:VBox = new VBox(window.content, 10, 10);
            vb.setSize(w, h);

            var resultsString:String = "";
            for(var prop:String in results) resultsString += prop + ": " + results[prop] + "\n";
            resultsString += "---------------------------------------------";
            resultsString += "\nUser: " + userName;
            resultsString += ("\nflash.system.Capabilities.serverString:\n" + Capabilities.serverString.split("&").join("\n"));
            var resultsText:TextArea = new TextArea(vb, 0, 0, resultsString);
            resultsText.setSize(w, 150);
            resultsText.editable = false;

            new Label(vb, 0, 0, "Hardware specs (will be cached in a local SharedObject):");

            var hb1:HBox = new HBox(vb);
            hb1.setSize(w, 20);

            new Label(hb1, 0, 0, "CPU:");
            cpu = new InputText(hb1, 0, 0, so.data.cpu);

            new Label(hb1, 0, 0, "Speed (GHz):");
            cpuGHz = new InputText(hb1, 0, 0, so.data.cpuGHz);
            cpuGHz.restrict = "0-9.";
            cpuGHz.width = 40;

            new Label(hb1, 0, 0, "Cores:");
            cpuCores = new InputText(hb1, 0, 0, so.data.cpuCores);
            cpuCores.restrict = "0-9";
            cpuCores.width = 40;

            new Label(vb, 0, 0, "Anything else? Device type, model, GPU, ...?");
            moreInfo = new InputText(vb, 0, 0, so.data.moreInfo);
            moreInfo.width = w;

            var csvURL:String = baseURL + "results/" + appId + ".csv";
            var msg:Text = new Text(vb, 0, 0);
            msg.editable = false;
            msg.width = w;
            msg.html = true;
            msg.text = 
            "After pressing send the data above will be publicly displayed at <u><a href='" + csvURL + "' target='_blank'>" +csvURL + "</a></u>.\n\n" +
            "Note: Data may be deleted from the server at any time. Save a copy if you need it.";
            msg.height = 60;

            var hb2:HBox = new HBox(vb);
            hb2.setSize(w, 20);
            sendBtn = new PushButton(hb2, 0, 0, "SEND", send);
            status = new Label(hb2);

            return window;
        }

        private function onClose(e:Event):void {
            stage.removeChild(this);
        }
        
        private function send(e:Event):void {
            sendBtn.enabled = false;
            Security.loadPolicyFile("http://zozuar.org/wonderfl/benchmarks/crossdomain.xml");
            status.text = "Sending...";
            var uv:URLVariables = new URLVariables(Capabilities.serverString);
            uv["!appId"] = appId;
            uv["!user"] = userName;
            uv["!cpu"] = so.data.cpu = cpu.text;
            uv["!cpuCores"] = so.data.cpuCores = cpuCores.text;
            uv["!cpuGHz"] = so.data.cpuGHz = cpuGHz.text;
            uv["!moreInfo"] = so.data.moreInfo = moreInfo.text;
            so.flush();
            for(var prop:String in results) uv["!!"+prop] = results[prop];
            var req:URLRequest = new URLRequest(baseURL + "post.php");
            req.data = uv;
            req.method = URLRequestMethod.POST;
            var ldr:URLLoader = new URLLoader;
            ldr.addEventListener(Event.COMPLETE, function (e:Event):void { status.text = "Results sent."; });
            ldr.load(req);
        }
    }
}
