/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w9NS
 */

package  
{
	/**
	 * 参考
	 * 
	 * BONKURA BLOG - 跳ね返りと摩擦に関する公式
	 * http://blog.bonkura.jp/formula04.html
	 * 
	 * source-lab.note - brush study
	 * http://source-laboratory.net/blog/2009/04/brush-study.html
	 */
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	
	[SWF(width="465", height="465", frameRate="60", backgroundColor="0xffffff")]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends Sprite {
		
		// 点の数
		private const dotNum:int = 3;
		
		// 摩擦係数
		private const friction:Number = 0.1;
		
		// 点の半径
		private const dotRadius:uint = 10;
		
		
		
		
		
		// 点の配列
		private var dots:Array = new Array();
		
		/**
		 * コンストラクタ
		 */
		public function Main() {
			
			// ループカウンタ
			var i:int;
			
			// 点の作成
			for ( i = 0; i < dotNum; i++) {
				
				var dot:Point = new Point( mouseX, mouseY );
				dots.push( dot );
			}
			
			
			
			
			// フレームごとにループ
			addEventListener(Event.ENTER_FRAME, function( event:Event ):void {
					
					/** --------------------------------------------------
					 * 計算
					 */
					for (i = 0; i < dotNum; i++) {
						
						// 速度の算出
						var vx:Number;
						var vy:Number;
						
						if ( i == 0 ) {
							
							vx = ( mouseX - dots[ i ].x ) * friction;
							vy = ( mouseY - dots[ i ].y ) * friction;
							
						} else {
							
							vx = ( dots[ i - 1 ].x - dots[ i ].x ) * friction;
							vy = ( dots[ i - 1 ].y - dots[ i ].y ) * friction;
						}
						
						
						// 座標の算出
						dots[ i ].x += vx;
						dots[ i ].y += vy;
					}
					
					
					/** --------------------------------------------------
					 * 描画
					 */
					graphics.clear();
					graphics.beginFill( 0 );
					
					for (i = 0; i < dotNum; i++)
						graphics.drawCircle( dots[ i ].x, dots[ i ].y, dotRadius );
					
				} );
		}
	}
}