/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w8Ho
 */

package {
    //----------------------------------------------
    //Modeless/Modal window TEST
    // 　　試験用なのでモードレスで開いている時、
    //   モーダルボタンを押したときの動きはおかしい
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    import flash.text.TextFieldAutoSize;
    //import cls.*;

    public class  testWin extends Sprite {
        public var cWinH:clsWin=null;
        public var cWin1:clsWin=null;
        public var cWin2:clsWin=null;
        public var cWin3:clsWin=null;
        public var cWin4:clsWin=null;
        public var cWin1B:clsWin=null;
        public var cWin2B:clsWin=null;
        public var cWin3B:clsWin=null;
        public var cWin4B:clsWin = null;
        public var intWinXY:int;
        private var cMess3:clsText;
        private var cMess4:clsText;
        private var cMess3B:clsText;
        private var cMess4B:clsText;
        
        public function testWin() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //下の2行を加えるとHTMLで定義したサイズで表示
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            addChild(new clsButton("BTN-1","Modeless1" ,    5, 5, 80, 20 ,fncOpenWin));
            addChild(new clsButton("BTN-2","Modeless2" ,    90, 5, 80, 20 ,fncOpenWin));
            addChild(new clsButton("BTN-3","Modeless3" ,    175, 5, 80, 20 ,fncOpenWin));
            addChild(new clsButton("BTN-4","Modeless4" ,    260, 5, 80, 20 ,fncOpenWin));
            addChild(new clsButton("BTN-H","HELP" ,    350, 5, 40, 20 ,fncOpenWin));
            addChild(new clsButton("BTN-1B","Modal1" ,    5, 30, 80, 20 ,fncOpenWin));
            addChild(new clsButton("BTN-2B","Modal2" ,    90, 30, 80, 20 ,fncOpenWin));
            addChild(new clsButton("BTN-3B","Modal3" ,    175, 30, 80, 20 ,fncOpenWin));
            addChild(new clsButton("BTN-4B","Modal4" ,    260, 30, 80, 20 ,fncOpenWin));
            intWinXY = 20;
            cWinH = new clsWin("WIN-HELP", "HELP", intWinXY, intWinXY+40, 300, 140);
            addChild(cWinH);
            var tf:TextField = new TextField();
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = "ういんどうの使い方\n" +
                      " Modeless1～4のボタンでういんどうを開きます。\n"+
                      " Modal1～4のボタンでもーだるういんどうを開きます。\n"+
                      " ういんどうのタイトルで一番手前に表示、\n移動する事も出来ます。\n"+
                      " Xで閉じます。\n"+
                      " 再度ういんどう1～4のボタンでういんどうを開きます。";
            cWinH.Add(5, 5, tf);
        }
        private function fncCloseWin(win:clsWin):void {
            if (win.name == "WIN-1") { cWin1 = null; }
            else if (win.name == "WIN-2") { cWin2 = null; }
            else if (win.name == "WIN-3") { cWin3 = null; }
            else if (win.name == "WIN-4") { cWin4 = null; }
            else if (win.name == "WIN-1B") { cWin1B = null; }
            else if (win.name == "WIN-2B") { cWin2B = null; }
            else if (win.name == "WIN-3B") { cWin3B = null; }
            else if (win.name == "WIN-4B") { cWin4B = null; }
        }
        private function fncOpenWin(btn:clsButton):void {
            var s:String = btn.name;
            var ModalFlg:Boolean = false;
            switch(s) {
                case "BTN-1B":
                    ModalFlg = true;
                    if (cWin1B == null) {
                        intWinXY += 20;
                        cWin1B = new clsWin("WIN-1B", "ういんどう1：四角", intWinXY, intWinXY + 40, 300, 200,
                                fncCloseWin,ModalFlg);
                        addChild(cWin1B);
                        var sp1b:Sprite = new Sprite();
                        cWin1B.Add(10, 10, sp1b);
                        sp1b.graphics.lineStyle(1, 0x0000ff);
                        sp1b.graphics.beginFill(0xcccccc);
                        sp1b.graphics.drawRect(0, 0, 60, 60);
                        sp1b.graphics.drawRect(20, 20, 60, 60);
                        sp1b.graphics.drawRect(40, 40, 60, 60);
                        sp1b.graphics.drawRect(60, 60, 60, 60);
                        sp1b.graphics.drawRect(80, 80, 60, 60);
                        sp1b.graphics.drawRect(100, 100, 60, 60);
                        sp1b.graphics.endFill();
                    }
                    break;
                case "BTN-1":
                    if (cWin1 == null) {
                        intWinXY += 20;
                        cWin1 = new clsWin("WIN-1", "ういんどう1：四角", intWinXY, intWinXY + 40, 300, 200,
                                fncCloseWin,ModalFlg);
                        addChild(cWin1);
                        var sp1:Sprite = new Sprite();
                        cWin1.Add(10, 10, sp1);
                        sp1.graphics.lineStyle(1, 0x0000ff);
                        sp1.graphics.beginFill(0xcccccc);
                        sp1.graphics.drawRect(0, 0, 60, 60);
                        sp1.graphics.drawRect(20, 20, 60, 60);
                        sp1.graphics.drawRect(40, 40, 60, 60);
                        sp1.graphics.drawRect(60, 60, 60, 60);
                        sp1.graphics.drawRect(80, 80, 60, 60);
                        sp1.graphics.drawRect(100, 100, 60, 60);
                        sp1.graphics.endFill();
                    }
                    cWin1.MoveTop();
                    break;
                case "BTN-2B":
                    ModalFlg = true;
                    if (cWin2B == null) {
                        intWinXY += 20;
                        cWin2B = new clsWin("WIN-2B", "ういんどう2：円", intWinXY, intWinXY + 40, 300, 200,
                                fncCloseWin,ModalFlg);
                        addChild(cWin2B);
                        var sp2B:Sprite = new Sprite();
                        cWin2B.Add(10, 10, sp2B);
                        sp2B.graphics.lineStyle(1,0x00ff00);
                        sp2B.graphics.beginFill(0xffff00);
                        sp2B.graphics.drawCircle(100, 60, 50);
                        sp2B.graphics.drawCircle(80, 80, 50);
                        sp2B.graphics.drawCircle(120, 80, 50);
                        sp2B.graphics.endFill();
                    }
                    break;
                case "BTN-2":
                    if (cWin2 == null) {
                        intWinXY += 20;
                        cWin2 = new clsWin("WIN-2", "ういんどう2：円", intWinXY, intWinXY + 40, 300, 200,
                                fncCloseWin,ModalFlg);
                        addChild(cWin2);
                        var sp2:Sprite = new Sprite();
                        cWin2.Add(10, 10, sp2);
                        sp2.graphics.lineStyle(1,0x00ff00);
                        sp2.graphics.beginFill(0xffff00);
                        sp2.graphics.drawCircle(100, 60, 50);
                        sp2.graphics.drawCircle(80, 80, 50);
                        sp2.graphics.drawCircle(120, 80, 50);
                        sp2.graphics.endFill();
                    }
                    cWin2.MoveTop();
                    break;
                case "BTN-3B":
                    ModalFlg = true;
                    if (cWin3B == null) {
                        intWinXY += 20;
                        cWin3B = new clsWin("WIN-3B", "ういんどう3:ぼたんの試験", intWinXY, intWinXY + 40, 300, 120,
                                fncCloseWin,ModalFlg);
                        addChild(cWin3B);
                        cWin3B.Add(10, 10,new clsButton("BTN-31","ぼたん１" ,0, 0, 80, 20 ,fncOnBtnB));
                        cWin3B.Add(10, 40, new clsButton("BTN-32", "ぼたん2" , 0, 0, 80, 20 , fncOnBtnB));
                        cMess3B = new clsText("", 0, 0, 200, 20, true);
                        cWin3B.Add(10, 70, cMess3B);
                    }
                    break;
                case "BTN-3":
                    if (cWin3 == null) {
                        intWinXY += 20;
                        cWin3 = new clsWin("WIN-3", "ういんどう3:ぼたんの試験", intWinXY, intWinXY + 40, 300, 120,
                                fncCloseWin,ModalFlg);
                        addChild(cWin3);
                        cWin3.Add(10, 10,new clsButton("BTN-31","ぼたん１" ,0, 0, 80, 20 ,fncOnBtn));
                        cWin3.Add(10, 40, new clsButton("BTN-32", "ぼたん2" , 0, 0, 80, 20 , fncOnBtn));
                        cMess3 = new clsText("", 0, 0, 200, 20, true);
                        cWin3.Add(10, 70, cMess3);
                    }
                    cWin3.MoveTop();
                    break;
                case "BTN-4B":
                    ModalFlg = true;
                    if (cWin4B == null) {
                        intWinXY += 20;
                        cWin4B = new clsWin("WIN-4B", "ういんどう4:clsToolTipMark", intWinXY, intWinXY + 40, 300, 100,
                                fncCloseWin,ModalFlg);
                        addChild(cWin4B);
                        cWin4B.Add(20, 20,new clsToolTipMark("MK-1",  0, 0, 5, "MK-1:説明文", 0xff0000, fncTTClickB));
                        cWin4B.Add(120, 20,new clsToolTipMark("MK-2",  0, 0, 5, "MK-2:説明文", 0xff0000, fncTTClickB));
                        cMess4B = new clsText("", 0, 0, 200, 20, true);
                        cWin4B.Add(10, 40, cMess4B);
                    }
                    break;
                case "BTN-4":
                    if (cWin4 == null) {
                        intWinXY += 20;
                        cWin4 = new clsWin("WIN-4", "ういんどう4:clsToolTipMark", intWinXY, intWinXY + 40, 300, 100,
                                fncCloseWin,ModalFlg);
                        addChild(cWin4);
                        cWin4.Add(20, 20,new clsToolTipMark("MK-1",  0, 0, 5, "MK-1:説明文", 0xff0000, fncTTClick));
                        cWin4.Add(120, 20,new clsToolTipMark("MK-2",  0, 0, 5, "MK-2:説明文", 0xff0000, fncTTClick));
                        cMess4 = new clsText("", 0, 0, 200, 20, true);
                        cWin4.Add(10, 40, cMess4);
                    }
                    cWin4.MoveTop();
                    break;
                case "BTN-H":
                    cWinH.MoveTop();
                    break;
            }
            if (intWinXY > 100) { intWinXY = 20; }
        }
        private function fncOnBtn(btn:clsButton):void {
            cMess3.text = btn.text + "が押されました。";
        }
        private function fncTTClick(mk:clsToolTipMark):void {
            cMess4.text = mk.name + "をクリックしました";
        }
        private function fncOnBtnB(btn:clsButton):void {
            cMess3B.text = btn.text + "が押されました。";
        }
        private function fncTTClickB(mk:clsToolTipMark):void {
            cMess4B.text = mk.name + "をクリックしました";
        }
        
    }
    
}
//========================================
//package cls {
    //----------------------------------------------
    //ウインドクラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;

//    public class clsWin extends Sprite {
    class clsWin extends Sprite {
        private var spMain:Sprite;
        private var strTitl:String;
        private var intX0:int;
        private var intY0:int;
        private var intW:int;
        private var intH:int;
        private var blModalFlg:Boolean = false;
        private var fncCls:Function
        private var tfTitle:TextField;
        private var tfClose:TextField;
        private var spBody:Sprite;
        
        private var blMouseFlg:Boolean = false;
        private var intMouseX:int;
        private var intMouseY:int;
        //ウインドクラス
        //　nam:名称
        // titl:タイトル
        // x0,y0:表示位置
        // w,h:幅･高さ
        // cls:終了時、コールされる関数
        // mFlg:モーダルウインド(=true)/モードレスウインド(=false)
        public function clsWin(nam:String, titl:String, x0:int, y0:int, w:int, h:int, 
                    cls:Function = null,mFlg:Boolean=false) {
            strTitl=" "+titl;
            intX0=x0;
            intY0=y0;
            intW=w;
            intH=h;
            fncCls = cls;
            blModalFlg = mFlg;
            name = nam;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            if(blModalFlg==true) {    //モーダルウインド
                var spBack:Sprite=new Sprite();
                spBack.graphics.beginFill(0xffffff,0.5);
                spBack.graphics.lineStyle(1,0xffffff,0.5);
                spBack.graphics.drawRect(0, 0,  root.stage.stageWidth, root.stage.stageHeight);
                addChild(spBack);
            }
            spMain=new Sprite();
            addChild(spMain);
            if(fncCls!=null) {
                tfClose = fncText("X", intW-15, 0, 15);
                spMain.addChild(tfClose);
                tfClose.addEventListener(MouseEvent.CLICK,onClose);
                tfTitle = fncText(strTitl, 0, 0, intW-15,0xbbbbbb);
            } else {
                tfTitle = fncText(strTitl, 0, 0, intW,0xbbbbbb);
            }
            spMain.addChild(tfTitle);
            //MOUSE_DOWN以外はstageを付ける
            tfTitle.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            tfTitle.stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            tfTitle.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
            spBody = new Sprite();
            spBody.graphics.beginFill(0xffffff);
            spBody.graphics.lineStyle(1,0x00000);
            spBody.graphics.drawRect(0, 0, intW, intH - 20);
            spMain.addChild(spBody);
            spBody.y = 20;
            fncChkXY(intX0, intY0);
            spBody.addEventListener(MouseEvent.MOUSE_DOWN,onDownBody);
        }
        //固定文字文字列表示関数
        // sText:表示文字列
        // nSiz:文字サイズ
        // nx,ny:文字位置
        // uic:カラー
        // 戻り値:作成TextField    
        private function fncText(sText:String , nx:int,ny:int,w:int,ucol:uint=0xffffff):TextField {
            var tf:TextField = new TextField();
            tf.text = sText;
            tf.x = nx;
            tf.y = ny;
            tf.selectable = false;
            tf.border = true;
            tf.background = true;
            tf.backgroundColor = ucol;
            tf.width = w;
            tf.height = 20;
            return tf;
        }
        //重ねあわせを最前列にする
        public function MoveTop():void {
            parent.setChildIndex(this, parent.numChildren - 1);
        }
        //ウインドのドラッグ処理
        private function onClose(e:MouseEvent):void {
            parent.removeChild(this);
            if(fncCls!=null){fncCls(this);}
        }
        private function onDown(e:MouseEvent):void {
            MoveTop();
            blMouseFlg = true;
            intMouseX=parent.mouseX;
            intMouseY=parent.mouseY;
        }
        private function onDownBody(e:MouseEvent):void {
            MoveTop();
        }
        private function onMove(e:MouseEvent):void {
            if(e.buttonDown==false) {blMouseFlg = false;}
            if (blMouseFlg == true) {
                var x1:int = parent.mouseX;
                var y1:int = parent.mouseY;
                var x2:int=spMain.x + x1 - intMouseX ;
                var y2:int=spMain.y + y1 - intMouseY ;
                fncChkXY(x2,y2);
                intMouseX=x1;
                intMouseY = y1;
            }
        }
        private function onUp(e:MouseEvent):void {
            blMouseFlg = false;
        }
        //ウインドを領域の外に出さない
        private function fncChkXY(x1:int,y1:int):void {
            if (x1 > root.stage.stageWidth - intW-1) { x1 = root.stage.stageWidth - intW-1; }
            if (y1 > root.stage.stageHeight - intH-1) { y1 = root.stage.stageHeight - intH-1; }
            if (x1 < 0) { x1 = 0; }
            if (y1 < 0) { y1 = 0; }
            spMain.x=x1;
            spMain.y=y1;
        }
        //ウインド上にオブジェクトを配置する
        // x1,y1:位置
        // obj:オブジェクト
        public  function Add(x1:int, y1:int, obj:DisplayObject):void {
            spBody.addChild(obj);
            obj.x = x1;
            obj.y = y1;
        }
    }
//}
//========================================
//package cls {
    //----------------------------------------------
    //ボタンクラス:TextFieldをボタンのように使う
    //   長押し(LongPress)の対応
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.ui.MouseCursor;
    import flash.ui.Mouse;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.getTimer;
    
//    public class  clsButton extends TextField {
    class  clsButton extends TextField {
        private var tfFormat:TextFormat;
        private var fncChkFnc:Function;
        private var fncLongPress:Function;
        private var intTim:int;
        
        //ボタンクラス:TextFieldをボタンのように使う
        // nam:ボタンの名称（ボタンを区別するために使用）
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:ボタンのサイズ
        // fChk:クリックしたときの関数「fChk(b:clsButton):void」
        // fLongPress:ボタンの長押ししたときの関数「fLongPress(b:clsButton):void」
        // bItalic：ボタンの文字をItalicにするか？
        public function clsButton(nam:String,sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number , fChk:Function=null,
                fLongPress:Function = null, bItalic:Boolean = false) {
                    
            name = nam;
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = true;
            this.borderColor = 0x000000;
            this.background = true;
            this.backgroundColor = 0xcccccc;
            this.textColor = 0x000000;
            this.selectable = false;    //ボタンの表示文字は選択不可
            tfFormat = new TextFormat();
            tfFormat.align = TextFormatAlign.CENTER;
            tfFormat.italic = bItalic;
            this.setTextFormat(tfFormat);
            //マウスがのった時の色の変更
            this.addEventListener(MouseEvent.ROLL_OVER, onOver);
            this.addEventListener(MouseEvent.ROLL_OUT, onOut);
            //クリック時の処理
            fncChkFnc = fChk;
            if(fncChk!=null) {this.addEventListener(MouseEvent.CLICK, fncChk);}
            //長押し時の処理
            fncLongPress = fLongPress;
            if (fncLongPress != null) {
                this.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
                this.addEventListener(MouseEvent.MOUSE_UP, onUp);
            }
            this.enable(true);    //ボタンを有効に
        }
        //表示文字の変更
        // sText:表示する文字
        public function setText(sText:String):void {
            this.text = sText;
            this.setTextFormat(tfFormat);
        }
        //ボタンの有効(bflg=true)･無効(bflg=false)
        public function enable(bflg:Boolean):void {
            this.mouseEnabled = bflg;
            if (bflg == true) { this.alpha = 1.0; }
            else {this.alpha = 0.5;}
        }
        //マウスオーバー処理（ボタンらしく見せる）
        public function onOver(e:MouseEvent):void {
            e.target.backgroundColor = 0xaaaaaa;
            //Mouse.cursor=flash.ui.MouseCursor.HAND;
        }
        public function onOut(e:MouseEvent):void {
            e.target.backgroundColor = 0xcccccc;
            //Mouse.cursor=flash.ui.MouseCursor.ARROW;
        }
        //長押し(LongPress)の対応
        public function onDown(e:MouseEvent):void {
            intTim = getTimer();
            this.addEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onUp(e:MouseEvent):void {
            this.removeEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onLongPress(e:Event):void {
            //ボタンを押し続けて0.5秒以上たったら長押し
            if (intTim < getTimer() - 500) { fncLongPress(this); }
        }
        //クリック
        public function fncChk(e:Event):void {
            fncChkFnc(this);
        }
    }
//}
//=================================================
//package cls {
    //----------------------------------------------
    //ツールチップつきマーク
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.geom.Point;

//    public class clsToolTipMark extends Sprite {
    class clsToolTipMark extends Sprite {
        public var strTip:String;
        public var intX0:int;
        public var intY0:int;
        public var intR:int;
        public var uinCol:uint;
        public var fncClick:Function;
        public var tfTip:TextField;
        
        //ツールチップつきマーククラス
        //　nam:名称
        // x0,y0:表示位置
        // r:マーク半径
        // sTip:ツールチップ文字列
        // uCol:マークのカラー
        // fClick:クリックしたときコールされる関数
        public function clsToolTipMark(nam:String,  x0:int, y0:int, r:int
                    ,sTip:String, uCol:uint=0xff0000,fClick:Function = null) {
            name = nam;
            strTip=sTip;
            intX0=x0;
            intY0=y0;
            intR=r;
            uinCol=uCol;
            fncClick=fClick;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // 円を描く (中を塗りつぶす)
            graphics.lineStyle(1, uinCol);
            graphics.beginFill(uinCol);
            graphics.drawCircle(intX0, intY0, intR);
            graphics.endFill();
            tfTip = fncText(strTip, intX0, intY0);
            addChild(tfTip);
            
            tfTip.visible = false;
            this.addEventListener(MouseEvent.CLICK, onClick);
            this.addEventListener(MouseEvent.MOUSE_OVER,onOver);
            this.addEventListener(MouseEvent.MOUSE_OUT,onOut);
        }
        // 固定文字文字列表示関数
        // sText:表示文字列
        //  nx,ny:文字位置
        //  戻り値:作成TextField
        private function fncText(sText:String , nx:int, ny:int):TextField {
            var tf:TextField = new TextField();
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = sText;
            tf.x = nx+5;
            tf.y = ny+5;
            tf.selectable = false;
            tf.border = true;
            tf.borderColor = 0xbbbbbb;
            tf.background = true;
            tf.backgroundColor = 0xdddddd;
            return tf;
        }
        //クリック時
        private function onClick(e:MouseEvent):void {
            if(fncClick!=null){fncClick(this);}
        }
        // ツールチップの表示
        private function onOver(e:MouseEvent):void {
            var l_pos : Point = new Point(intX0,intY0);
            var g_pos : Point = this.localToGlobal(l_pos);
            var intX:int = g_pos.x;
            var intY:int = g_pos.y;
            
            //一番前に表示
            parent.setChildIndex(this, parent.numChildren - 1);
            //ツールチップを領域外にならないように表示
            if (intX + intR + 5 + tfTip.width > root.stage.stageWidth) {
                intX = intX - intR - 5 - tfTip.width;
            } else {
                intX = intX + intR + 5;
            }
            if (intY + intR + 5 + tfTip.height > root.stage.stageHeight) {
                intY = intY - intR - 5 - tfTip.height; 
            } else {
                intY = intY + intR + 5; 
            }
            g_pos.x = intX;
            g_pos.y = intY;
            l_pos = this.globalToLocal(g_pos);
            tfTip.x = l_pos.x;
            tfTip.y = l_pos.y;
            
            tfTip.visible = true;
            
        }
        private function onOut(e:MouseEvent):void {
            tfTip.visible = false;
        }
    }
//}
//=========================================
//package cls {
    //----------------------------------------------
    //テキストの表示クラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.text.TextField;
    
//    public class  clsText extends TextField {
    class  clsText extends TextField {
        //テキストの表示クラス
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:表示するサイズ
        // bBorder：外枠の有無
        public function clsText(sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number ,bBorder:Boolean=false) {
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = bBorder;
            this.background = bBorder;
        }
    }
//}