/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w88Y
 */

// forked from John_Blackburne's Accessor performance test
// forked from John_Blackburne's flash on 2011-12-16
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        
        public const kNumTrials:int    = 5000000;

        public var aDataA:Vector.<Vec2Da>;
        public var aDataB:Vector.<Vec2Db>;


       
        public var tf:TextField;

        public function FlashTest() {
            var iTime:int;
            
            InitText();
            InitData();
            
            iTime = getTimer();
            Test1();
            tf.appendText("\nTest 1: " + String(getTimer() - iTime));

            iTime = getTimer();
            Test2();
            tf.appendText("\nTest 2: " + String(getTimer() - iTime));
            
            tf.appendText("\nDone");
            
        }
        
        public function InitText():void {
            tf = new TextField();
            tf.text = "Initialised";
            addChild(tf);
        }

        public function InitData():void {
            var iIndex:int;
            
            aDataA = new Vector.<Vec2Da>();
            aDataB = new Vector.<Vec2Db>();
            
            for (iIndex = 0; iIndex < kNumTrials; iIndex++) {
                aDataA.push(new Vec2Da(iIndex % 7, iIndex % 11));
                aDataB.push(new Vec2Db(iIndex % 7, iIndex % 11));
            }
        }

        public function Test1():void {
            var iTrial:int, iSum:Number, v:Vec2Da;
            iSum = 0;

            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aDataA[iTrial];
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
            }
        }

        public function Test2():void {
            var iTrial:int, iSum:Number, v:Vec2Db;
            iSum = 0;

            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aDataB[iTrial];
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
            }
        }
    }
}


class Vec2D {
 public var iX:int;
 public var iY:int;
 
 public function Vec2D(x:int, y:int) {iX = x; iY = y;}
 public function X():int {return iX;}
 public function Y():int {return iY;}
}

class Vec2Da {
 public var iX:int;
 public var iY:int;
 
 public function Vec2Da(x:int, y:int) {iX = x; iY = y;}
}

class Vec2Db {
 private var _X:int;
 private var _Y:int;
 
 public function Vec2Db(x:int, y:int) {_X = x; _Y = y;}
 public function get iX():int {return _X;}
 public function get iY():int {return _Y;}
 public function set iX(x:int):void {_X = x;}
 public function set iY(y:int):void {_Y = y;}
}
