/**
 * Copyright nika ( http://wonderfl.net/user/nika )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w7Qg
 */

package {
 
  import flash.display.*;
  import flash.text.*;
  import flash.events.*;
  import flash.utils.*;
  import flash.media.*;
  import flash.net.*;
 
  public class main extends Sprite{
 
    private var canvas:Sprite;
    private var beatCanvas:Sprite;
    private var percussions:Array=["HiHat","SnareDrum","BassDrum"];
 
    private var percNameWidth:int=100;
    private var cellSize:int=16;
    private var beatLampHeight:int=16;
    private var beatLampRadius:int=4;
 
    private var sequence:Array;
    private var cBeat:int;
 
    private var sequenceButton:TextField;
 
    private var status:TextField;
 
    private var myTimer:Timer = new Timer(100,0);
 
    private var hh:Sound;
    private var sd:Sound;
    private var bd:Sound;
 
    public function main(){
      init();
    }
 
    private function init():void{
 
      cBeat=-1;
 
      // media
      hh=new Sound(new URLRequest("hh.mp3"));
      sd=new Sound(new URLRequest("sd.mp3"));
      bd=new Sound(new URLRequest("bd.mp3"));
 
      // status text field
      status=new TextField();
      status.x=0;
      status.y=200;
      status.text="text";
      addChild(status);
 
      // sequence and percussion label initialize
      sequence=new Array();
 
      for(var idx:int=0;idx<percussions.length;++idx){
        var tf:TextField=new TextField();
        tf.text=percussions[idx];
        tf.x=0;
        tf.y=beatLampHeight+cellSize*idx;
        addChild(tf);
 
        sequence[idx]=new Array();
 
        for(var beat:int=0;beat<16;++beat){
          sequence[idx][beat]=1;
        }
      }
 
      sequence[0][0]=2;
      sequence[0][2]=2;
      sequence[0][4]=2;
      sequence[0][6]=2;
      sequence[0][8]=2;
      sequence[0][10]=2;
      sequence[0][12]=2;
      sequence[0][14]=2;
 
      sequence[1][4]=2;
      sequence[1][12]=2;
 
      sequence[2][0]=2;
      sequence[2][6]=2;
      sequence[2][8]=2;
 
      canvas=new Sprite();
      canvas.x=percNameWidth;
      canvas.y=beatLampHeight;
      canvas.addEventListener(flash.events.MouseEvent.MOUSE_DOWN,swapStatus);
      addChild(canvas);
      redrawCanvas();
 
      // beatCanvas initialize
      beatCanvas=new Sprite();
      beatCanvas.x=percNameWidth;
      beatCanvas.y=0;
      redrawBeatCanvas();
      addChild(beatCanvas);
 
      sequenceButton=new TextField();
      sequenceButton.x=0;
      sequenceButton.y=beatLampHeight+cellSize*percussions.length+10;
      sequenceButton.height=20;
      sequenceButton.width=100;
      sequenceButton.background=true;
      sequenceButton.backgroundColor=0xcccccc;
      sequenceButton.text="start/stop";
 
      sequenceButton.addEventListener(flash.events.MouseEvent.MOUSE_DOWN,stepSequence);
      addChild(sequenceButton);
 
      myTimer.addEventListener(TimerEvent.TIMER, timerHandler);
 
    }
 
    private function redrawCanvas():void{
 
      canvas.graphics.clear();
 
      for(var idx:int=0;idx<percussions.length;++idx){
        for(var beat:int=0;beat<16;++beat){
 
          if(sequence[idx][beat]==2){
            canvas.graphics.beginFill(0x7799ff);
          } else {
            canvas.graphics.beginFill(0xdddddd);
          }
 
          canvas.graphics.lineStyle(1, 0xbbbbbb);
 
          canvas.graphics.drawRect(beat*cellSize,idx*cellSize,16,16);
          canvas.graphics.endFill();
        }
      }
    }
 
    private function redrawBeatCanvas():void{
 
      beatCanvas.graphics.clear();
 
      for(var beat:int=0;beat<16;++beat){
        beatCanvas.graphics.lineStyle(1, 0x333333);
 
        if(beat==cBeat){
          beatCanvas.graphics.beginFill(0x33cc33);
        } else {
          beatCanvas.graphics.beginFill(0x113311);
        }
        beatCanvas.graphics.drawCircle(beat*cellSize + cellSize/2 , beatLampHeight/2, beatLampRadius);
        beatCanvas.graphics.endFill();
      }
    }
 
    private function swapStatus(event:MouseEvent):void{
      var idx:int=Math.floor(canvas.mouseY/cellSize);
      var beat:int=Math.floor(canvas.mouseX/cellSize);
 
      sequence[idx][beat]=3-sequence[idx][beat];
 
      redrawCanvas();
    }
 
    private function stepSequence(event:MouseEvent):void{
      if(cBeat>0){
        myTimer.stop();
        cBeat=-1;
        redrawBeatCanvas();
      } else {
        myTimer.start();
      }
    }
 
    private function timerHandler(e:TimerEvent):void{
      cBeat=(cBeat+1)%16;
 
      // hh
      if(sequence[0][cBeat]==2){
        hh.play();
      }
      // sd
      if(sequence[1][cBeat]==2){
        sd.play();
      }
 
      // bd
      if(sequence[2][cBeat]==2){
        bd.play();
      }
 
      status.text=(Math.floor(cBeat/4)+1)+":"+(cBeat%4+1);
      redrawBeatCanvas();
    }
  }
}