/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w6mv
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.events.MouseEvent;
	/**
	 * Main
	 * メインクラス.
	 */
	public class Main extends Sprite {
		private var ball:Ball;
		private var lines:Array;
		private var numLines:uint = 5;
		private var gravity:Number = 0.3;
		private var bounce:Number = -0.6;
		private var oldX:Number;
		private var oldY:Number;
		/**
		 * コンストラクタ.
		 */
		public function Main() {
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void {
			//ボール生成
			ball = new Ball(20);
			//表示
			addChild(ball);
			//ボールを初期位置にセット
			ball.x = 50;
			ball.y = 50;
			// ライン生成
			lines = new Array();
			for (var i:uint = 0; i < numLines; i++) {
				var line:Sprite = new Sprite();
				line.graphics.lineStyle(1);
				line.graphics.moveTo(-100, 0);
				line.graphics.lineTo(100, 0);
				addChild(line);
				lines.push(line);
			}
			//ラインを指定位置にセット
			lines[0].x = 100;
			lines[0].y = 100;
			lines[0].rotation = 10;
			//
			lines[1].x = 250;
			lines[1].y = 180;
			lines[1].rotation = -10;
			//
			lines[2].x = 150;
			lines[2].y = 230;
			lines[2].rotation = 20;
			//
			lines[3].x = 300;
			lines[3].y = 300;
			lines[3].rotation = -20;
			//
			lines[4].x = 200;
			lines[4].y = 430;
			lines[4].rotation = 30;

			//ENTER_FRAMEをリスナーに追加
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			//MOUSE_DOWNをリスナーに追加
			ball.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void {
			//重力
			ball.vy += gravity;
			//加速
			ball.x += ball.vx;
			ball.y += ball.vy;
			//壁ではね返る
			if (ball.x + ball.radius > stage.stageWidth) {
				ball.x = stage.stageWidth - ball.radius;
				ball.vx *= bounce;
			} else if (ball.x - ball.radius < 0) {
				ball.x = ball.radius;
				ball.vx *= bounce;
			}
			if (ball.y + ball.radius > stage.stageHeight) {
				ball.y = stage.stageHeight - ball.radius;
				ball.vy *= bounce;
			} else if (ball.y - ball.radius < 0) {
				ball.y = ball.radius;
				ball.vy *= bounce;
			}
			//ラインとのぶつかりをチェックする
			for (var i:uint = 0; i < numLines; i++) {
				checkLine(lines[i]);
			}
		}
		/**
		 * checkLine.
		 */
		private function checkLine(line:Sprite):void {
			// ラインの表示領域を取得
			var bounds:Rectangle = line.getBounds(this);
			if (ball.x > bounds.left && ball.x < bounds.right) {
				// ラインの角度を取得
				var angle:Number = line.rotation * Math.PI / 180;
				//cos値取得
				var cos:Number = Math.cos(angle);
				//sin値取得
				var sin:Number = Math.sin(angle);
				// ボールとラインの各座標系の距離
				var x1:Number = ball.x - line.x;
				var y1:Number = ball.y - line.y;
				// y方向の距離を回転
				var y2:Number = cos * y1 - sin * x1;
				// y方向の加速度を回転
				var vy1:Number = cos * ball.vy - sin * ball.vx;
				// ラインよりボールが下に来たら弾ませる
				if (y2 > -ball.height / 2 && y2 < vy1) {
					// x方向の距離を回転
					var x2:Number = cos * x1 + sin * y1;
					// x方向の加速度を回転
					var vx1:Number = cos * ball.vx + sin * ball.vy;
					//ボールの底の座標
					y2 = -ball.height / 2;
					//加速を逆方向へ
					vy1 *= bounce;
					// 回転させた座標を元に戻す
					x1 = cos * x2 - sin * y2;
					y1 = cos * y2 + sin * x2;
					//加速度も座標系を戻す
					ball.vx = cos * vx1 - sin * vy1;
					ball.vy = cos * vy1 + sin * vx1;
					//ボールの座標に適応
					ball.x = line.x + x1;
					ball.y = line.y + y1;
				}
			}
		}
		/**
		 * onMouseDown.
		 */
		private function onMouseDown(event:MouseEvent):void {
			//現状のボールの位置を記憶
			oldX = ball.x;
			oldY = ball.y;
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			ball.startDrag();
			//onEnterFrame削除
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			//初速度設定
			addEventListener(Event.ENTER_FRAME, trackVelocity);
		}
		/**
		 * onMouseUp.
		 */
		private function onMouseUp(event:MouseEvent):void {
			stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			ball.stopDrag();
			//初速度設定削除
			removeEventListener(Event.ENTER_FRAME, trackVelocity);
			//onEnterFrame復帰
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		/**
		 * trackVelocity.
		 */
		private function trackVelocity(event:Event):void {
			//直前のボールの位置と比べて加速度を決める
			ball.vx = ball.x - oldX;
			ball.vy = ball.y - oldY;
			//位置情報を更新する
			oldX = ball.x;
			oldY = ball.y;
		}
	}
}

/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}