/**
 * Copyright Loth2012 ( http://wonderfl.net/user/Loth2012 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w6m4
 */

package {
    import away3d.lights.shadowmaps.NearDirectionalShadowMapper;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.materials.methods.FilteredShadowMapMethod;
    import away3d.materials.methods.NearShadowMapMethod;
    import away3d.materials.methods.FogMethod;
    import away3d.core.managers.Stage3DManager;
    import away3d.core.managers.Stage3DProxy;
    import away3d.filters.BloomFilter3D;
    import away3d.events.Stage3DEvent;
    import away3d.lights.DirectionalLight;
    import away3d.primitives.SphereGeometry;
    import away3d.primitives.CubeGeometry;
    import away3d.primitives.PlaneGeometry;
    import away3d.materials.ColorMaterial;
    import away3d.core.base.Geometry;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.entities.Mesh;
    
    import flash.system.ApplicationDomain;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.setTimeout;
    import flash.system.SecurityDomain;
    import flash.system.Security;
    import flash.geom.Vector3D;
    import flash.system.ApplicationDomain;
import flash.system.LoaderContext;
import flash.events.ProgressEvent;
import flash.display.LoaderInfo;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.net.URLLoaderDataFormat;
import flash.display.Loader;
import flash.events.Event;
import flash.system.SecurityDomain;
import flash.system.Security;

    [SWF(backgroundColor="#FF8000", frameRate="60", width="465",height="465")]
    
    /**
    * away3d imported physics engine
    * @author loth
    */
    public class Physical extends Sprite {
        private var _view:View3D;
        private var _scene:Scene3D;
        private var _manager:Stage3DManager;
        private var _stage3DProxy:Stage3DProxy;
        private var _shadow:NearShadowMapMethod;
        private var _fog:FogMethod;
        private var _sun:DirectionalLight;
        private var _lightPicker:StaticLightPicker;
        
        public var _physic:Object;
        private var _clip:Sprite;
        private var _txt:TextField;
        
        private var _i:int;
        private var _id:int;
        private var _target:Object;
        private var _className:Array;
        
        public function Physical(){
            
            Security.allowDomain("3dflashlo.free.fr");
            if(stage)init(null);
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event):void {
            stage.align = 'TL';
            stage.scaleMode = 'noScale';
            stage.quality = 'low';
            stage.color = 0xFF8001;
            add3DView()
            
        }
        
        public function loadPhysic():void {
            _clip = new Sprite();
            addChild(_clip);
            _clip.graphics.beginFill(0xff0000);
            _clip.graphics.drawRect(0,20,465,10);
            _clip.graphics.endFill();
            
            _txt = new TextField();
            _txt.width = 200;
            addChild(_txt);
            
            _txt.text = "Load 3d engine";
            // swf("http://3dflashlo.free.fr/Away3d_409.swf", ["Away3d_409"])
    
            swf("http://3dflashlo.free.fr/Physics_1a.swf", ["Physics_1a"])
          //  _load.swf("http://3dflashlo.free.fr/wonderfl/AwayPhysics.swf", ["AwayPhysics"], obj)
        }
public function engineoaded(V:*=null):void {
    _txt.text = "Load physic engine";
           // swf("http://3dflashlo.free.fr/Physics_1a.swf", ["Physics_1a"])
    
    }
          
        public function physicLoaded(V:*=null):void {
          
           // _txt.text = 'cool';
            _physic = new (V[0])() as Object;
            addChild(Sprite(_physic));
           /*   if(_physic){
            _txt.text = 'AWAYPHYSICS in place';
            _clip.graphics.clear();
            removeChild(_txt);
            removeChild(_clip);
            //
            }  */
            setTimeout(afterPhysicCreation, 100);
             // _physic.init();
        }
        
        public function afterPhysicCreation():void {
            basic({type: "ground", y: -550, w: 10000, d: 10000, color: 0x323333, mass: 0, phyType: 'collision', specular: 1, ambient: 1, gloss: 30});
            for (_i = 0; _i < 200; _i++) {
                basic({type: "cube", y: _i * 51, w: 50, h: 50, d: 50, bright: 50, x: -150 + (Math.random() * 300), z: -150 + (Math.random() * 300), mass: 1});
                basic({type: "sphere", r: 30, y: _i * 31, gloss: 10, bright: 50, x: -150 + (Math.random() * 300), z: -150 + (Math.random() * 300), mass: 5});
            }
            
        }

        
        /**
         * Create primitive object with physique if active
         */
        public function basic(O:Object):void {
            var o:Object = O || new Object();
            var type:String = o.type || "cube";
            var obj:Mesh;
            var mat:ColorMaterial = new ColorMaterial( 0xFFFFFF * Math.random());
            
            mat.gloss = o.gloss || 30;
            mat.specular = o.specular || 1;
            mat.ambient = o.ambient || 1;
            mat.lightPicker = _lightPicker;
            
            mat.shadowMethod = _shadow;
            
            switch (type) {
                case 'sphere': 
                    obj = new Mesh(new SphereGeometry(o.r || 50, o.q1 || 16, o.q2 || 12), mat);
                    break;
                case 'cube': 
                    obj = new Mesh(new CubeGeometry(o.w || 100, o.h || 100, o.d || 100, o.q1 || 1, o.q2 || 1, o.q3 || 1), mat);
                    break;
                case 'plane': 
                    obj = new Mesh(new PlaneGeometry(o.w || 100, o.d || 100, o.q1 || 1, o.q2 || 1), mat);
                    break;
                case 'ground': 
                    obj = new Mesh(new PlaneGeometry(o.w || 100, o.d || 100, o.q1 || 1, o.q2 || 1), mat);
                    break;
            }
            _scene.addChild(obj);
            if (_physic != null)
                _physic.addObject(obj, o);
            else
                obj.position = new Vector3D(o.x || 0, o.y || 0, o.z || 0);
        }
        private function add3DView():void {
            _manager = Stage3DManager.getInstance(stage);
            _stage3DProxy = _manager.getFreeStage3DProxy();
            _stage3DProxy.addEventListener(Stage3DEvent.CONTEXT3D_CREATED, onContextCreated);
        }
        private function onContextCreated(e:Stage3DEvent):void{
            _stage3DProxy.color = 0x05af56;
            _stage3DProxy.antiAlias = 0;
            _stage3DProxy.width = stage.stageWidth;
            _stage3DProxy.height = stage.stageHeight;
            _view = new View3D();
            _scene = new Scene3D();
            _view.scene = _scene;
            _view.stage3DProxy = _stage3DProxy;
            _view.shareContext = true;
            _view.camera.lens.far = 2500;
            _view.camera.z = -2000;
            addChild(_view);
            
            _sun = new DirectionalLight();
            _sun.castsShadows = true;
            _sun.shadowMapper = new NearDirectionalShadowMapper(.3);
            _scene.addChild(_sun);
            _sun.ambient=0.3;
            _sun.specular = 1;
            _lightPicker = new StaticLightPicker([_sun]);
            
            _shadow = new NearShadowMapMethod(new FilteredShadowMapMethod(_sun));
            _shadow.epsilon = .0007;
            //_fog = new FogMethod(10, 1000, _stage3DProxy.color);
            
            
            createObject();
           }
           
           private function createObject():void{
                var matConstruct:ColorMaterial = new ColorMaterial(0x908888);
                matConstruct.lightPicker = _lightPicker;
                matConstruct.shadowMethod = _shadow;
                //matConstruct.addMethod(_fog);
                matConstruct.gloss=30;
           
               var boxRef:Mesh = new Mesh(new CubeGeometry(100, 100, 100), matConstruct);
               _scene.addChild(boxRef);
               
               
               _stage3DProxy.addEventListener(Event.ENTER_FRAME, onEnterFrame);
               loadPhysic();
           }
           private function onEnterFrame(e:Event):void{
               if(_physic!=null){
                   _physic.updateWorld(-1);
                   _txt.text = 'physics in a place ?!'
                   
               }
               _view.render();
            //　★ wonderfl capture
           // if (_capture) _stage3DProxy.context3D.drawToBitmapData(_capture.bitmapData);
        }



// ---------------------------------------------LOADER SIDE
 private var loader:Loader
        public function swf(link:String, className:Array, target:Object=null):void {
            loader = new Loader();
            _className = className;
            loader.name = getFileName(link);
           // var context:LoaderContext = new LoaderContext(true);
            var context:LoaderContext = new LoaderContext(false, ApplicationDomain.currentDomain);
            //var context:LoaderContext = new LoaderContext(true, null, SecurityDomain.currentDomain);
            
            //context.applicationDomain = ApplicationDomain.currentDomain;
            context.securityDomain = SecurityDomain.currentDomain;
            //context.checkPolicyFile = true;
           // loader.load(new URLRequest( link + "?uniq=" +(Math.random()*1000) ), context);
            
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, swfFinish, false, 0, true);
            loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loadProgress, false, 0, true);
            loader.load(new URLRequest( link ), context);
        }
        
        /**  swf complete */
        public function swfFinish(e:Event):void {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, swfFinish);
            loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, loadProgress);
            var type:Vector.<String>;
            var vectorClass:Vector.<Class> = new Vector.<Class>();
            var myClass:Class= ApplicationDomain.currentDomain.getDefinition(_className[0]) as Class;;
          //  for (_i = 0; _i < _className.length; _i++) {
              // myClass = _target.domain.getDefinition(_className[_i]) as Class;
              //  myClass = _domain.getDefinition(_className[_i]) as Class;
              // myClass = _domain.getDefinition(_className[_i]) as Class;
             //  myClass = ApplicationDomain.currentDomain.getDefinition(_className[_i]) as Class;
  //             myClass = loader.contentLoaderInfo.applicationDomain.getDefinition(_className[_i]) as Class;
             //  vectorClass.push(myClass);
        //   }
           _txt.text = "Load physic engine";
           // swf("http://3dflashlo.free.fr/Physics_1a.swf", ["Physics_1a"])
           // _physic = Object(e.target.content); 
            // _physic = myClass(e.target.content); 
           //  _physic
           //  var tt:Class = getClass(_className[0])//new (vectorClass[0])() as Object; 
          // physicLoaded(vectorClass);
        }
        public function getClass(className:String):Class {
        try {
            return loader.contentLoaderInfo.applicationDomain.getDefinition(className)  as  Class;
           //return ApplicationDomain.currentDomain.getDefinition(className)  as  Class;
        } catch (e:Error) {
            _txt.text = "no way"
           // throw new IllegalOperationError(className + " definition not found in " + swfLib);
        }
        return null;
    }
        /**  swf progress */
        private function loadProgress(e:ProgressEvent):void {
            var p:int = int(e.bytesLoaded / e.bytesTotal * 100);
            var ko:int = int((e.bytesLoaded / 1024) << 0);
            _clip.width = 465*(p/100);
            _txt.text = 'Loading '+ loader.name+ " "  + p+'% '+ ko+'ko';
        }
        
        /**  get file name */
        private function getFileName(fullPath:String):String {
            var fSlash:int = fullPath.lastIndexOf("/");
            var bSlash:int = fullPath.lastIndexOf("\\");
            var slashIndex:int = fSlash > bSlash ? fSlash : bSlash;
            return fullPath.substr(slashIndex + 1);
        }
    
    }
}