/**
 * Copyright tora ( http://wonderfl.net/user/tora )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w6aW
 */

// forked from nayu's forked from: forked from: ButtonTest06:　複数問クイズ形式に正答率計算機能を追加 
// forked from yoshihiroKATO's forked from: ButtonTest06:　複数問クイズ形式に正答率計算機能を追加 
// forked from hacker_7daxapax's ButtonTest06:　複数問クイズ形式に正答率計算機能を追加 
//あいかわらず、
//[error]connection closed, something wrong, please reload and try again
//[error]couldnt connect with server, try again later!
//というエラーが出続けてwonderflにうまく接続できず。。。
//タイトルは変更できましたが、あいかわらず肝心のコンパイルはできない。。。
//→コンパイルできるようになりました
//しばらくローカル環境でJREとSDKで作業してました。　自分のWonderflへの依存度の高さがわかった。。。
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;

    [SWF(width="500", height="500", backgroundColor="#FFFFFF")]
    public class ButtonTest extends Sprite {
        
        private var button01 : SimpleButton;//ボタン1 
        private var button02 : SimpleButton;//ボタン2
        private var button03 : SimpleButton;//ボタン3
        private var nextBtn : SimpleButton;//「次の問題へ」ボタン
                
        private var question : TextField;//問題文テキスト
        private var questionFormat : TextFormat;//問題文テキストフォーマット
        private var judge : TextField;//判定文テキスト
        private var judgeFormat : TextFormat;//判定文テキストフォーマット
        
        private var target : CustomButton;//マウスイベントでターゲット情報取得用
        private var questionNo : int = 0;//問題番号
        private var questionArray : Array = new Array();//問題保持用配列 
        private var answerArray : Array = new Array();//解答保持用配列   

        private var answerCnt : int = 0;//解答回数
        private var atariCnt : int = 0;//当たり回数
        private var hazureCnt : int = 0;//ハズレ回数
        private var atariLock : Boolean = false;//「当たり」ボタン連続押下による当たり回数アップを禁止　「ハズレ」は何回でも可

        public function ButtonTest() {
            questionArray.push("RGBカラーのRとは？\n１、赤色\n２、黄色\n３、紫色\n");
            answerArray.push(1);
            questionArray.push("RGBカラーのGとは？\n１、黄色\n２、緑色\n３、紫色\n");
            answerArray.push(2);
            questionArray.push("RGBカラーのBとは？\n１、黄色\n２、紫色\n３、青色\n");
            answerArray.push(3);

            //問題文表示用のテキストを設定
            question = new TextField;
            question.text = "";
            question.x = 10;
            question.y = 10;
            question.width = 300;
            question.height = 170;
            question.multiline = true;
            addChild(question); 

            initQuestion();//問題を初期化

            //解答判定文表示用のテキストを設定
            judge = new TextField;
            judge.x = 55;
            judge.y = 170;
            judge.width = 400;
            judge.height = 200;
            judge.multiline = true;
            judge.text = "";           
            addChild(judge);  
                      
            //解答ボタン設定
            button01 = new CustomButton("１",1);
            button01.x = 350;
            button01.y = 50;
            button02 = new CustomButton("２",2);
            button02.x = 350;
            button02.y = 80;
            button03 = new CustomButton("３",3);
            button03.x = 350;
            button03.y = 110;

            button01.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            button02.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            button03.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            
            button01.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            button02.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            button03.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            
            addChild(button01);
            addChild(button02);
            addChild(button03);
            
            //「次の問題へ」ボタン設定
            nextBtn = new CustomButton("次の問題へ",1);
            nextBtn.x = 350;
            nextBtn.y = 150;
            nextBtn.addEventListener(MouseEvent.MOUSE_DOWN,onNextBtnDown);
            addChild(nextBtn);
        }

        //配列から問題を取り出して問題を初期化
        private function initQuestion():void {
            //問題文テキスト設定
            question.text = "問題　" + (questionNo+1) + "\n"
                          + "\n" 
                          + questionArray[questionNo];
            //問題文テキスト用フォーマット設定
            questionFormat = new TextFormat();
            questionFormat.font = "Courier New";
            questionFormat.bold = true;
            questionFormat.size = 13;
            question.setTextFormat(questionFormat);

            atariLock = false;//次問題のために当たり回数カウントアップができるようにする
        }

        //マウスダウンイベントの処理
        private function onMouseDown(evt:MouseEvent):void {
            if (questionNo > (questionArray.length-1)) return;//全問終了後は処理を行わない
            target = CustomButton(evt.currentTarget);
            //当たりボタンは1問につき1回しかカウントされない
            if (target.getBtnNo() == answerArray[questionNo]) {
                judge.text = "当たり";
                if (atariLock == false) {//同一問題の「当たり」ボタン連続押下時の当たり回数カウントアップを禁止
                    answerCnt++;//解答回数をカウントアップ
                    atariCnt++;//当たり回数をカウントアップ
                    atariLock = true;
                }
            //ハズレボタンは何度でもカウントされる
            } else {
                answerCnt++;//解答回数をカウントアップ
                judge.text = "ハズレ";
                hazureCnt++;//ハズレ回数をカウントアップ
            }
            //判定文テキスト用フォーマット設定
            judgeFormat = new TextFormat();
            judgeFormat.font = "Courier New";
            judgeFormat.bold = true;
            judgeFormat.size = 150;
            judge.setTextFormat(judgeFormat);
        }

        //「次の問題へ」ボタンのマウスダウンイベントの処理
        private function onNextBtnDown(evt:MouseEvent):void {
            if (questionNo < (questionArray.length-1)) {
                questionNo++; //次問題へ遷移するためにカウントアップ
                question.text = "";
                judge.text = "";
                initQuestion();            
            } else {
                questionNo++; //終了処理のためにカウントアップ
                question.text = "";
                endQuestion();
            }
        }

        //マウスアップイベントの処理
        private function onMouseUp(evt:MouseEvent):void {
            //judge.text = "";
        } 

        //全問終了後の処理
        private function endQuestion():void {
            //全問終了後メッセージ設定
            
            //正答率を計算
            var rate : int = 0;
            if ((answerCnt != 0) && (atariCnt != 0)) {//解答回数と当たり回数がどちらも0でない場合のみ計算
                rate = atariCnt/answerCnt*100;
            }

            question.text = "\n解答結果\n\n"//問題文テキストへ解答結果を設定
                          + "解答回数：　" + answerCnt + "回\n"
                          + "当たり回数：　" + atariCnt + "回\n"
                          + "ハズレ回数：　" + hazureCnt + "回\n"
                          + "正答率：　" + rate + "％\n";
            //問題文テキスト用フォーマット設定
            questionFormat = new TextFormat();
            questionFormat.font = "Courier New";
            questionFormat.bold = true;
            questionFormat.size = 13;
            question.setTextFormat(questionFormat);

            judge.text = "クイズ終了です\nお疲れ様でした\n";//判定文テキストへ設定
            //判定文テキスト用フォーマット設定
            judgeFormat = new TextFormat();
            judgeFormat.font = "Courier New";
            judgeFormat.bold = true;
            judgeFormat.size = 50;
            judge.setTextFormat(judgeFormat);
        }       
    }
}

import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
        private var btnName : String = "";//ボタン名
        private var btnNo : int = 0;//ボタン番号
        //コンストラクタ    
        public function CustomButton(label:String="",no:int=0) {
            btnName = label;
            btnNo = no;
            //状態
            upState = makeSprite(label,0x00FF00);
            overState = upState;
            downState = makeSprite(label,0x0000FF);
            hitTestState = upState;
        }
        
        public function getBtnName():String {
            return btnName;
        }
        public function getBtnNo():int {
            return btnNo;
        }
                
        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;

            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);

            return sp;
        }    
}



